/*************************************************************************
 *
 *  $RCSfile: inetslot.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: as $ $Date: 2000/11/08 14:25:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#if SUPD<613//MUSTINI
#ifndef _SFXINIMGR_HXX //autogen
#include <svtools/iniman.hxx>
#endif
#endif

#include <tools/urlobj.hxx>
#include <svtools/urihelper.hxx>

#pragma hdrstop

#if SUPD<613//MUSTINI
#include "inimgr.hxx"
#endif
#include "app.hxx"
#include "request.hxx"
#include "picklist.hxx"
#include "inettbc.hxx"
#include "viewfrm.hxx"
#include "dispatch.hxx"
#include "appdata.hxx"
#include "objsh.hxx"
#include "docfac.hxx"
#include "docfile.hxx"
#include "sfxtypes.hxx"
#include "statcach.hxx"
#include "arrdecl.hxx"
#include "sfxsids.hrc"

//***************************************************************************

void SfxApplication::INetExecute_Impl( SfxRequest& rRequest )
/*
	[Beschreibung]
	Slothandler fuer Executeevents im INetbereich
*/
{
	SfxPickList_Impl* pPickList = SfxPickList_Impl::Get();
	switch( rRequest.GetSlot() )
	{
		case SID_BROWSE_STOP:
		{
			if ( rRequest.GetModifier() & KEY_MOD1 )
			{
				SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
				for( USHORT nPos = rArr.Count(); nPos--; )
					rArr[ nPos ]->GetCancelManager()->Cancel( TRUE );
				GetCancelManager()->Cancel( TRUE );
			}
			else
			{
				// jobs in current task canceln
				SfxViewFrame *pFrm = SfxViewFrame::Current();
				SfxCancelManager *pCancelMgr = SfxViewFrame::Current()
						? SfxViewFrame::Current()->GetCancelManager()
						: GetCancelManager();
				if ( pCancelMgr )
					pCancelMgr->Cancel( TRUE );

				// jobs in hidden tasks canceln
				SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
				for( USHORT nPos = rArr.Count(); nPos--; )
				{
					SfxFrame *pFrame = rArr[ nPos ];
					if ( TRUE || !pFrame->GetCurrentViewFrame() )
						pFrame->GetCancelManager()->Cancel( TRUE );
				}
			}
			break;
		}

		case SID_CLEARMEMCACHE:
		{
			pPickList->ClearMemCache();
			break;
		}

		case SID_FOCUSURLBOX:
		{
			SfxStateCache *pCache = SfxViewFrame::Current()->GetBindings().GetAnyStateCache_Impl( SID_OPENURL );
			if( pCache )
			{
				SfxControllerItem* pCtrl = pCache->GetItemLink();
				while( pCtrl )
				{
					pCtrl->StateChanged(
						SID_FOCUSURLBOX, SFX_ITEM_UNKNOWN, 0 );
					pCtrl = pCtrl->GetItemLink();
				}
			}
		}
	}

	// Recording
	rRequest.Done();
}

//***************************************************************************

StopButtonTimer_Impl::StopButtonTimer_Impl()
	: bState( FALSE )
{
	SetTimeout( 200 );
}

void StopButtonTimer_Impl::SetButtonState( BOOL bStateP )
{
	if( bStateP )
	{
		bState = TRUE;
		Stop();
	}
	else if( bState )
		Start();
}

void StopButtonTimer_Impl::Timeout()
{
	bState = FALSE;
	SFX_APP()->Invalidate( SID_BROWSE_STOP );
}

void SfxApplication::INetState_Impl( SfxItemSet& rItemSet )
/*
	[Beschreibung]
	Slothandler fuer Statusevents im INetbereich
*/
{
	SfxPickList_Impl* pPickList = SfxPickList_Impl::Get();
	DBG_ASSERT( pPickList, "Pickliste ist invalid" );

	StopButtonTimer_Impl*& pTimer = SFX_APP()->Get_Impl()->pStopButtonTimer;
	if ( !pTimer )
		pTimer = new StopButtonTimer_Impl;
	SfxFrameArr_Impl& rArr = *SFX_APP()->Get_Impl()->pTopFrames;
	USHORT nPos;
	for( nPos = rArr.Count(); nPos--; )
		if( rArr[ nPos ]->GetCancelManager()->CanCancel() )
			break;
	pTimer->SetButtonState(
		nPos != USHRT_MAX || SFX_APP()->GetCancelManager()->CanCancel());
	if ( !pTimer->GetButtonState() )
		rItemSet.DisableItem( SID_BROWSE_STOP );
}

//-------------------------------------------------------------------------

SfxCancelManager *SfxApplication::GetCancelManager() const
{
	if ( !pAppData_Impl->pCancelMgr )
	{
		pAppData_Impl->pCancelMgr = new SfxCancelManager;
		pAppData_Impl->StartListening( *pAppData_Impl->pCancelMgr );
	}
	return pAppData_Impl->pCancelMgr;
}


