/*************************************************************************
 *
 *  $RCSfile: stbmgr.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/09/06 08:47:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <vcl/wrkwin.hxx>

#pragma hdrstop

#include "stbmgr.hxx"
#include "minarray.hxx"
#include "stbitem.hxx"
#include "bindings.hxx"
#include "msgpool.hxx"
#include "sfxtypes.hxx"
#include "sfxresid.hxx"
#include "app.hxx"
#include "objsh.hxx"
#include "progress.hxx"
#include "workwin.hxx"
#include "objface.hxx"
#include "sfx.hrc"
#include "statbar.hrc"
#include "helpid.hrc"

using namespace framework;

static const USHORT nVersion = 5;

struct SfxStatusItemInf_Impl
{
	USHORT				nId;
	StatusBarItemBits	aBits;
	long				nWidth;
	long				nOffset;

	SfxStatusItemInf_Impl (USHORT n, long nW, StatusBarItemBits aSBits, long nOffs) :
		nId(n),
		aBits(aSBits),
		nWidth(nW),
		nOffset(nOffs)
	{}
};

//====================================================================

DECL_PTRARRAY(SfxStatusItemArr_Impl, SfxStatusBarControl*, 2, 2 );
DECL_PTRARRAY(SfxStatusItemInfArr_Impl, SfxStatusItemInf_Impl*, 4, 4 );

SfxStatusItemInf_Impl* FindItem(SfxStatusItemInfArr_Impl, USHORT);

//==================================================================

SfxStatusItemInf_Impl* FindItem(SfxStatusItemInfArr_Impl *pArr, USHORT nID)
{
	for (USHORT n=0; n<pArr->Count(); n++)
	{
		SfxStatusItemInf_Impl *pItem=(*pArr)[n];
		if (pItem->nId == nID) return pItem;
	}

	return 0;
}


//====================================================================

class SfxStatusBar_Impl: public StatusBar
{
	SfxStatusBarManager*	pMgr;
	Rectangle				aLastItemRect;
	Rectangle				aTrackingRect;
	SfxStatusBarControl*	pLastControl;
	USHORT                  nLastItemId;
	BOOL					bCaptured;
	USHORT					nMoveId;
	USHORT					nLastItemPos;
	long					nMovePos;
	Pointer 				aOldPointer;
	BOOL					bMoving;
	BOOL					bCapt;
	BOOL					bShow;
	Window*					pLastFocusWin;

friend class SfxStatusBarManager;

private:
	SfxStatusBarControl* GetItemAt( const MouseEvent &rEvt );

protected:
	virtual void    Click();
	virtual void    DoubleClick();
	virtual void	Command( const CommandEvent &rEvt );
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseMove( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void	UserDraw( const UserDrawEvent& rUDEvt);
	virtual void	KeyInput( const KeyEvent& rKEvent );

public:
					SfxStatusBar_Impl( Window* pParent,
									   SfxStatusBarManager& rMgr );
	void			Init( SfxStatusBarManager* rMgr );

	void			CaptureMouse( SfxStatusBarControl &rCtrl );
	void			ReleaseMouse( SfxStatusBarControl &rCtrl );
};

//--------------------------------------------------------------------

SfxStatusBar_Impl::SfxStatusBar_Impl( Window* pParent,
									  SfxStatusBarManager& rMgr )
:	StatusBar( pParent, WinBits( WB_LEFT | WB_3DLOOK ) ),
	pMgr( &rMgr ),
	nLastItemId( 0 ),
	pLastControl( 0 ),
	bCaptured(FALSE),
	bMoving(FALSE),
	nMoveId(0),
	nLastItemPos(STATUSBAR_ITEM_NOTFOUND),
	nMovePos(0),
	bCapt(FALSE),
	bShow(TRUE),
	pLastFocusWin(0)
{
	SetUniqueId( HID_STATUSBAR );
}

void SfxStatusBar_Impl::Init( SfxStatusBarManager* p  )
{
	pMgr = p;
	nLastItemId = 0;
	pLastControl = 0;
	bCaptured = FALSE;
	bMoving = FALSE;
	nMoveId = 0;
	nMovePos = 0;
	bCapt = FALSE;
	bShow = TRUE;
	nLastItemPos = STATUSBAR_ITEM_NOTFOUND;
	pLastFocusWin = 0;
}

//--------------------------------------------------------------------

SfxStatusBarControl* SfxStatusBar_Impl::GetItemAt( const MouseEvent &rEvt )
{
	Point aMousePos = rEvt.GetPosPixel();
	if ( pLastControl && ( bCaptured || aLastItemRect.IsInside(aMousePos) ) )
		return pLastControl;

	pLastControl = 0;
	nLastItemId = 0;

	// Item suchen, das geklickt wurde
	USHORT nPos = 0;
	while ( nPos < GetItemCount() )
	{
		USHORT nId = GetItemId( nPos );

		// Ist es dieses Item
		Rectangle aItemRect( GetItemRect( nId ) );
		if ( aItemRect.IsInside( aMousePos ) )
		{
			aLastItemRect = aItemRect;
			nLastItemId = nId;
			pLastControl = pMgr->FindControl_Impl( nId );
			return pLastControl;
		}

		++nPos;
	}

	return 0;
}

void SfxStatusBar_Impl::CaptureMouse( SfxStatusBarControl &rCtrl )
{
	nLastItemId = rCtrl.GetId();
	pLastControl = &rCtrl;
	bCaptured = TRUE;
}

void SfxStatusBar_Impl::ReleaseMouse( SfxStatusBarControl &rCtrl )
{
	if ( pLastControl == &rCtrl )
	{
		bCaptured = FALSE;
		nLastItemId = 0;
		pLastControl = 0;
	}
}

void SfxStatusBar_Impl::Command( const CommandEvent& rCEvt )
{
	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
		return;

	MouseEvent aMEvt( rCEvt.GetMousePosPixel(), 1, 0, MOUSE_RIGHT, 0 );
	SfxStatusBarControl *pStbCtrl = GetItemAt(aMEvt);
	if ( pStbCtrl )
		pStbCtrl->Command(rCEvt);
}

void SfxStatusBar_Impl::KeyInput( const KeyEvent& rKEvt )
{
	if ( bMoving && rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE )
	{
		HideTracking();
		nMoveId = 0;
		bMoving = FALSE;
		Window::ReleaseMouse();
		if ( pLastFocusWin )
			pLastFocusWin->GrabFocus();
	}
	else
		StatusBar::KeyInput( rKEvt );
}

void SfxStatusBar_Impl::MouseButtonDown( const MouseEvent& rEvt )
{
	if ( nMoveId )
	{
		// ButtonDown ueber Zwischenraum
		if ( rEvt.GetMode() & MOUSE_SELECT )
		{
			// Position + Id festhalten
			bMoving = TRUE;
			nMovePos = rEvt.GetPosPixel().X();
			aTrackingRect = GetItemRect( nMoveId );
			Window::CaptureMouse();
			pLastFocusWin = Application::GetFocusWindow();
			GrabFocus();
		}

		StatusBar::MouseButtonDown(rEvt);
	}
	else
	{
		SfxStatusBarControl *pStbCtrl = GetItemAt(rEvt);
		if (!pStbCtrl || !pStbCtrl->MouseButtonDown(rEvt) )
			StatusBar::MouseButtonDown(rEvt);
	}
}

void SfxStatusBar_Impl::MouseMove( const MouseEvent& rEvt )
{
	StatusBar::MouseMove(rEvt);
}

void SfxStatusBar_Impl::MouseButtonUp( const MouseEvent& rEvt )
{
	if ( bMoving )
	{
		// Es wurde verschoben
		HideTracking();
		pMgr->SetItemWidth( nMoveId, aTrackingRect.GetWidth() );

		// Nach Loslassen wieder zurueck
		nMoveId = 0;
		bMoving = FALSE;
		Window::ReleaseMouse();
		StatusBar::MouseButtonUp(rEvt);
		if ( pLastFocusWin )
			pLastFocusWin->GrabFocus();
	}
	else
	{
		SfxStatusBarControl *pStbCtrl = GetItemAt(rEvt);
		if ( !pStbCtrl || !pStbCtrl->MouseButtonUp(rEvt) )
			StatusBar::MouseButtonUp(rEvt);
	}

	if ( bCapt )
	{
		SetPointer( aOldPointer );
		bCapt = FALSE;
	}
}

void SfxStatusBar_Impl::Click()
{
	if ( GetCurItemId() )
		pMgr->FindControl_Impl( GetCurItemId() )->Click();
}

void SfxStatusBar_Impl::DoubleClick()
{
	if ( GetCurItemId() )
		pMgr->FindControl_Impl( GetCurItemId() )->DoubleClick();
}

//--------------------------------------------------------------------

void SfxStatusBar_Impl::UserDraw(const UserDrawEvent& rUDEvt)
{
	// MI/#31218#: da kam ein Paint als keine Items gebunden waren, warum?
	DBG_ASSERT( pMgr, "StatusBar: UserDraw without StatusBarManager" );
	SfxStatusBarControl *pCtrl = pMgr
							? pMgr->FindControl_Impl( rUDEvt.GetItemId() )
							: 0;
	DBG_ASSERT( !pMgr->GetBindings_Impl() || pCtrl, "StatusBar: unknown UserDraw (no items bound)" );
	if ( pCtrl )
		pCtrl->Paint( rUDEvt );
}

//--------------------------------------------------------------------

void SfxStatusBarManager::UseDefault()
{
	pBindings->ENTERREGISTRATIONS();

	if ( pBar->GetItemCount() )
		// Falls neu initialisiert wird
		Clear_Impl();

	pShell->FillStatusBar( *pBar );

	// Visible-Status merken
    ((SfxStatusBar_Impl*)pBar)->bShow = TRUE;

	// Controller erzeugen
	Construct();

	pBindings->LEAVEREGISTRATIONS();

	// Die Daten der vorhandenen Items merken
	for (USHORT n=0; n<pItems->Count(); n++)
		delete (*pItems)[n];
	pItems->Clear();
	for ( USHORT nItem = 0; nItem < pBar->GetItemCount(); ++nItem )
	{
		USHORT nId = pBar->GetItemId(nItem);
		long nWidth = pBar->GetItemWidth(nId);
		StatusBarItemBits aBits = pBar->GetItemBits(nId);
		long nOffs = pBar->GetItemOffset(nId);
		SfxStatusItemInf_Impl* pItem = new SfxStatusItemInf_Impl(nId, nWidth, aBits, nOffs);
		pItems->Append(pItem);
	}

    SetDefault( TRUE );
}


//--------------------------------------------------------------------

void SfxStatusBarManager::Construct()
{
	DBG_MEMTEST();
	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");

	pBoundItems = new SfxStatusItemArr_Impl;

	Font aFont( pBar->GetFont() );
	aFont.SetWeight( WEIGHT_NORMAL );
	pBar->SetFont( aFont );

	for ( USHORT nItem = 0; nItem < pBar->GetItemCount(); ++nItem )
	{
		USHORT nId = pBar->GetItemId( nItem );
#ifdef DBG_UTIL
		const SfxSlot *pSlot = SFX_SLOTPOOL().GetSlot( nId );
		if ( pSlot && !pSlot->IsMode( SFX_SLOT_STATUSBARCONFIG ) )
		{
			ByteString aStr( "Slot " );
			aStr += ByteString::CreateFromInt32( nId );
			aStr += ByteString( " : StatusbarConfig fehlt!" );
			DBG_ERROR( aStr.GetBuffer() );
		}
#endif
		pBoundItems->Append( SfxStatusBarControl::CreateControl(
				nId, pBar, *pBindings, pShell->GetInterface()->GetModule() ) );
		pBar->SetHelpId( nId, nId );
	}

    // Immer anzeigen, Statuszeile wird "uber #Taskbar ein/ausgeschaltet
	pBar->Show();
}

void SfxStatusBarManager::Clear_Impl()
{
	if ( pBar )
	{
		((SfxStatusBar_Impl*)pBar)->Init( this );
		pBar->Clear();
	}

	// alte items freigeben
	if ( pBoundItems )
	{
		for ( USHORT nItem = 0; nItem < pBoundItems->Count(); ++nItem )
			delete pBoundItems->GetObject( nItem );
		delete pBoundItems;
	}
}

//--------------------------------------------------------------------

SfxStatusBarManager::SfxStatusBarManager(Window* pParent, SfxBindings &rBindings,
						SfxShell *pSh, SfxConfigManager* pMgr, USHORT nId, StatusBar *p) :
    SfxConfigItem( nId, pMgr ),
	pBar( p ),
	pBoundItems( 0 ),
	pShell(pSh),
	pBindings(&rBindings)
{
	DBG_MEMTEST();

	if ( pBar )
		((SfxStatusBar_Impl*)pBar)->Init( this );
	else
		pBar = new SfxStatusBar_Impl( pParent, *this );

	pItems = new SfxStatusItemInfArr_Impl;
	StartListening(rBindings);
	Initialize();
}

SfxStatusBarManager::SfxStatusBarManager( Window* pParent, const SfxStatusBarManager& rOther, SfxConfigManager* pMgr )
    : SfxConfigItem( rOther.GetType(), pMgr ),
    pBar( NULL ),
	pBoundItems( 0 ),
    pShell( rOther.pShell ),
    pBindings( rOther.pBindings )
{
	DBG_MEMTEST();

    pBar = new SfxStatusBar_Impl( pParent, *this );
	pItems = new SfxStatusItemInfArr_Impl;
    StartListening( *pBindings );
	Initialize();
}

//--------------------------------------------------------------------

SfxStatusBarManager::~SfxStatusBarManager()
{
	DBG_MEMTEST();

	((SfxStatusBar_Impl*)pBar)->pMgr = 0;

    // allen SfxProgress bescheid geben; auch nicht sichtbare Dokumente knnen einen Progress laufen haben,
    // nmlich in einer anderen View, wenn sie gerade geladen werden!
    for ( SfxObjectShell* pObjSh = SfxObjectShell::GetFirst( 0, sal_False );
		  pObjSh;
          pObjSh = SfxObjectShell::GetNext( *pObjSh, 0, sal_False ) )
		if ( pObjSh->GetProgress() &&
			 pObjSh->GetProgress()->StatusBarManagerGone_Impl(this) )
			break;

	if (pBindings)
	{
		pBindings->ENTERREGISTRATIONS();
		for ( USHORT n = pBoundItems->Count(); n > 0; --n )
			delete pBoundItems->GetObject(n-1);
		pBindings->LEAVEREGISTRATIONS();
		EndListening(*pBindings);
		pBindings = 0;
	}

	delete pBoundItems;

	for (USHORT n=0; n<pItems->Count(); n++)
		delete (*pItems)[n];

	delete pItems;
}


//--------------------------------------------------------------------

BOOL SfxStatusBarManager::AddItem( USHORT nItemId, long nWidth,
								   USHORT nOffset, USHORT nPos )
{
	DBG_MEMTEST();
	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");

	SfxStatusItemInf_Impl* pItem = FindItem(pItems, nItemId);
	StatusBarItemBits aBits = SIB_CENTER | SIB_IN | SIB_USERDRAW | SIB_AUTOSIZE;

	if (pItem)
	{
		nWidth = pItem->nWidth;
		nOffset = (USHORT) pItem->nOffset;
		aBits = pItem->aBits;
	}
	else
	{
		pItem = new SfxStatusItemInf_Impl(nItemId, nWidth, aBits, nOffset);
		pItems->Append(pItem);
	}

	pBar->InsertItem( nItemId, nWidth, aBits, nOffset, nPos );
	pBar->SetHelpId( nItemId, nItemId );

	pBindings->ENTERREGISTRATIONS();
	pBoundItems->Append( SfxStatusBarControl::CreateControl(
		nItemId, pBar, *pBindings, pShell->GetInterface()->GetModule() ) );
	pBindings->LEAVEREGISTRATIONS();
	SetDefault(FALSE);
	return TRUE;
}


//--------------------------------------------------------------------

void SfxStatusBarManager::RemoveItem( USHORT nItemId)
{
	DBG_MEMTEST();
	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");

	pBar->RemoveItem(nItemId);
	pBindings->ENTERREGISTRATIONS();

	SfxStatusBarControl* pControl = FindControl_Impl(nItemId);
	pBoundItems->Remove(pControl);
	delete pControl;

	pBindings->LEAVEREGISTRATIONS();
	SetDefault(FALSE);
}


//--------------------------------------------------------------------

void SfxStatusBarManager::Show()
{
	HACK(soll ggf. nicht in Config durchschlagen - aber was InPlace)
    ((SfxStatusBar_Impl*)pBar)->bShow = TRUE;
	pBar->Show();
}

//--------------------------------------------------------------------

void SfxStatusBarManager::Hide()
{
	HACK(soll ggf. nicht in Config durchschlagen - aber was InPlace)
    ((SfxStatusBar_Impl*)pBar)->bShow = FALSE;
	pBar->Hide();
}

// ------------------------------------------------------------------------

String SfxStatusBarManager::GetStreamName() const
{
    return SfxConfigItem::GetStreamName( GetType() );
}
//--------------------------------------------------------------------

// Beginn Fortschrittsanzeige

void    SfxStatusBarManager::StartProgressMode(
	const String &rText,		// Text, der waehrend der Forrtschrittsanzeige in der Statuszeile erscheint
	ULONG nMax)					// Maximalwert (100 %)
{
	nMaxProgress = nMax;
	pBar->StartProgressMode(rText);
}

//--------------------------------------------------------------------

// Status Fortschrittsanzeige

void SfxStatusBarManager::SetProgressState
(
	ULONG nPosition	// Status relativ zum initial "ubergebenen Maximalwert
)
{
	DBG_ASSERT( nPosition < ULONG_MAX / 100, "ULONG overflow" );
	USHORT nVal = nMaxProgress ? (USHORT)(nPosition * 100L / nMaxProgress) : 0;
	pBar->SetProgressValue( nVal );
}

//--------------------------------------------------------------------

// Ende Fortschrittsanzeige

void    SfxStatusBarManager::EndProgressMode()
{
	pBar->EndProgressMode();
}

//--------------------------------------------------------------------

// Hilfetext anzeigen

void    SfxStatusBarManager::ShowHelpText( const String &rText )
{
	pBar->HideItems();
	pBar->SetText(rText);
}

//--------------------------------------------------------------------

SfxStatusBarControl* SfxStatusBarManager::FindControl_Impl( USHORT nId ) const
{
	DBG_ASSERT( pBoundItems, "StatusBar: no items bound" );
	if ( !pBoundItems )
		return 0;

	for ( USHORT nPos = 0; nPos < pBoundItems->Count(); ++nPos )
		if ( pBoundItems->GetObject(nPos)->GetId() == nId )
			return pBoundItems->GetObject(nPos);
	return 0;
}

void SfxStatusBarControl::CaptureMouse()
{
	( (SfxStatusBar_Impl*) pBar )->CaptureMouse(*this);
}

void SfxStatusBarControl::ReleaseMouse()
{
	( (SfxStatusBar_Impl*) pBar )->ReleaseMouse(*this);
}

//--------------------------------------------------------------------

void SfxStatusBarManager::Clear()
{
	DBG_MEMTEST();
	DBG_ASSERT(pBindings, "Statuszeile ohne Bindings!");

	pBar->Clear();
	pBindings->ENTERREGISTRATIONS();
	for ( USHORT n = pBoundItems->Count(); n > 0; --n )
		delete pBoundItems->GetObject(n-1);
	pBoundItems->Clear();
	pBindings->LEAVEREGISTRATIONS();
	SetDefault(FALSE);
}


//--------------------------------------------------------------------

void SfxStatusBarManager::SetItemWidth(USHORT nId, long nWidth)
{
	USHORT nPos = pBar->GetItemPos(nId);
	StatusBarItemBits aBits = pBar->GetItemBits(nId);
	long nOffset = pBar->GetItemOffset(nId);

	String aText = pBar->GetItemText(nId);
	pBar->RemoveItem (nId);
	pBar->InsertItem(nId, nWidth, aBits, nOffset, nPos);
	pBar->SetItemText(nId, aText);

	SfxStatusItemInf_Impl* pItem = FindItem(pItems, nId);
	pItem->nWidth = nWidth;
	SetDefault(FALSE);
}


//--------------------------------------------------------------------

void SfxStatusBarManager::DestroyingBindings(SfxBindings *pBind)
{
	if (pBind == pBindings)
	{
		pBoundItems->Clear();			// Bindings haben Controller zerstoert
		pBindings = 0;					// Bindings werden ungueltig
	}
}

//--------------------------------------------------------------------

void SfxStatusBarManager::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
	{
		switch( ( (SfxSimpleHint&) rHint ).GetId() )
		{
			case SFX_HINT_DYING:
				if ( rBC.IsA(TYPE(SfxBindings)) )
					DestroyingBindings(PTR_CAST(SfxBindings,&rBC));
				break;
		}
	}
}


int SfxStatusBarManager::Load( SotStorage& rStorage )
{
    SotStorageStreamRef xStream = rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READ );
    if ( xStream->GetError() )
        return SfxConfigItem::ERR_READ;

	pBindings->ENTERREGISTRATIONS();

	if ( pBar->GetItemCount() )
		Clear_Impl();

	StatusBarDescriptor aItems;
    int nRet = ERR_OK;
    if ( !::framework::StatusBarConfiguration::LoadStatusBar( *xStream, aItems ) )
	{
		pBindings->LEAVEREGISTRATIONS();
        return ERR_READ;
	}

	USHORT nCount = aItems.Count();
	USHORT n;
	for (n=0; n<nCount; n++)
	{
		StatusBarItemDescriptor *pItem = aItems[n];
        if ( pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
        {
            USHORT nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
            pItem->aURL.Erase();
			pBar->InsertItem( nId, pItem->nWidth, pItem->nItemBits, pItem->nOffset );
		}
		else
			DBG_ERROR("Invalid statusbar configuration!");
	}

	for ( n=0; n<pItems->Count(); n++ )
		delete (*pItems)[n];

	pItems->Clear();
	for ( USHORT nItem = 0; nItem < pBar->GetItemCount(); ++nItem )
	{
		USHORT nId = pBar->GetItemId(nItem);
		long nWidth = pBar->GetItemWidth(nId);
		StatusBarItemBits aBits = pBar->GetItemBits(nId);
		long nOffs = pBar->GetItemOffset(nId);
		SfxStatusItemInf_Impl* pItem = new SfxStatusItemInf_Impl(nId, nWidth, aBits, nOffs);
		pItems->Append(pItem);
	}

	Construct();
	pBindings->LEAVEREGISTRATIONS();
	SetDefault( FALSE );

	return SfxConfigItem::ERR_OK;
	return ERR_OK;

}

BOOL SfxStatusBarManager::Store( SotStorage& rStorage )
{
    SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxStatusBarManager::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
    if ( xStream->GetError() )
        return FALSE;

	StatusBarDescriptor aItems;
	USHORT nPos, nCount = pBar->GetItemCount();
	for ( nPos = 0; nPos < nCount; ++nPos )
	{
		StatusBarItemDescriptor* pItem = new StatusBarItemDescriptor;
		aItems.Insert( pItem, aItems.Count() );

		USHORT nId = pBar->GetItemId( nPos );
        pItem->aURL = String::CreateFromAscii( "slot:" );
        pItem->aURL += String::CreateFromInt32( nId );
		pItem->nItemBits = pBar->GetItemBits( nId );
        pItem->nWidth = pBar->GetItemWidth( nId );
        pItem->nOffset = pBar->GetItemOffset( nId );
	}

	return ::framework::StatusBarConfiguration::StoreStatusBar( *xStream, aItems );
}

BOOL SfxStatusBarManager::Import( SvStream& rInStream, SvStream& rOutStream )
{
	USHORT nFileVersion, nCount, nId, nBits;
	long nWidth, nOffs;

	rInStream >> nFileVersion;

	if ( nFileVersion < 4 )
		return FALSE;

	BOOL bVisible = TRUE;
	if ( nFileVersion >= 5 )
		rInStream >> bVisible;

	rInStream >> nCount;
	USHORT n;
	StatusBarDescriptor aItems;
	for (n=0; n<nCount; n++)
	{
		StatusBarItemDescriptor* pItem = new StatusBarItemDescriptor;
		aItems.Insert( pItem, aItems.Count() );
		rInStream >> nId >> nWidth >> nBits >> nOffs;
        pItem->aURL = String::CreateFromAscii("slot:");
        pItem->aURL += String::CreateFromInt32( nId );
		pItem->nWidth = nWidth;
		pItem->nItemBits = nBits;
		pItem->nOffset = nOffs;
	}

	return ::framework::StatusBarConfiguration::StoreStatusBar( rOutStream, aItems );
}

BOOL SfxStatusBarManager::Export( SvStream& rInStream, SvStream& rOutStream )
{
	StatusBarDescriptor aItems;
    if ( !::framework::StatusBarConfiguration::LoadStatusBar( rInStream, aItems ) )
		return FALSE;

	rOutStream << nVersion
			<< (BOOL) TRUE
			<< aItems.Count();

	USHORT n;
	for (n=0; n<aItems.Count(); n++)
	{
		StatusBarItemDescriptor *pItem = aItems[n];
		USHORT nId=0;
        if ( pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
            nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
		rOutStream << nId
				<< pItem->nWidth
				<< (USHORT) pItem->nItemBits
				<< pItem->nOffset;
	}

	rOutStream << (USHORT) 0;
	return TRUE;
}
