/*************************************************************************
 *
 *  $RCSfile: tbxcust.cxx,v $
 *
 *  $Revision: 1.8.6.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 11:08:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ***************************************************************

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen wg. InfoBox
#include <vcl/msgbox.hxx>
#endif
#include <tools/urlobj.hxx>
#include <svtools/pathoptions.hxx>
#include <svtools/miscopt.hxx>

#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include "cfgmgr.hxx"
#include "msg.hxx"
#include "msgpool.hxx"
#include "resmgr.hxx"
#include "tbxmgr.hxx"
#include "tbxcust.hxx"
#include "tbxcust.hrc"
#include "dispatch.hxx"
#include "sfxresid.hxx"
#include "macrconf.hxx"
#include "tbxctrl.hxx"
#include "bindings.hxx"
#include "sfxtypes.hxx"
#include "helper.hxx"	// SfxContentHelper::...
#include "workwin.hxx"

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;

// wegen IBM CSet++
//#define LOW_USHORT(l) ((USHORT)(ULONG)(l))

//==========================================================================
//  ctor. Es wird in den customize mode geschaltet.

SfxCustomizeToolBox::SfxCustomizeToolBox( Window* pParent, SfxBindings* pBind, const ResId& rId)
    : ToolBox (pParent, rId), bHelpInitialized( FALSE ), pBindings( pBind )
{
	EnableCustomize();
}

DECL_PTRARRAY(SfxTbxControlArr_Impl, SfxToolBoxControl*, 8, 8 );

class TbxAccess_Impl : public ToolBox
{
public :

	TbxAccess_Impl ( Window *pParent, WinBits nBits )
      : ToolBox(pParent,(USHORT)nBits)
	{}

	inline void CustomizeToolBox (const ToolBoxCustomizeEvent& rCEvt)
		{ Customize(rCEvt); }

};

// **************************************************************************
//  Ueberschreibt den entsprechenden Toolbox-Handler. Wenn aus dieser Toolbox
//  heraus ein Item in eine andere Toolbox gedraggt wurde, wird der Customize-
//  Handler dieser Toolbox gerufen.

void SfxCustomizeToolBox::Customize( const ToolBoxCustomizeEvent& rCEvt )
{
	USHORT nSourcePos = GetItemPos( rCEvt.GetSourceId() );
	USHORT nTargetPos = rCEvt.GetTargetPos();

	if ( rCEvt.GetTargetBox() == NULL )
	{
		return;                         // nicht auf eine Toolbox gedraggt
	}
	else if ( rCEvt.GetTargetBox() == this )
	{
		return;                         // in diese Toolbox hinein gedraggt
	}
	else
	{
		ToolBox* pTarget = rCEvt.GetTargetBox();
		if ( pTarget )
		{
			USHORT nId = rCEvt.GetSourceId();
			if ( SfxMacroConfig::IsMacroSlot( nId ) )
			{
				ToolBoxCustomizeEvent aEvnt (pTarget, nId, nTargetPos, this);
				((TbxAccess_Impl*)pTarget)->CustomizeToolBox(aEvnt);
				pTarget->SetItemText(nId, GetItemText(nId));
				pTarget->SetHelpText(nId, GetHelpText(nId));
			}
			else
			{
//!MBA  : must be tested !!
                pBindings->GetImageManager()->LockImage(nId, this);
				ToolBoxCustomizeEvent aEvnt (pTarget, nId, nTargetPos, this);
				((TbxAccess_Impl*)pTarget)->CustomizeToolBox(aEvnt);
			}
		}

		return;
	}
}

// **************************************************************************
//  ctor des Dialogs. Das floating window wird zentriert, alle Toolboxen im
//  System sowie der ImageManager werden in den customize mode geschaltet.

SfxToolboxCustomizer::SfxToolboxCustomizer( SfxBindings *pBindings,
		SfxChildWindow *pMgr, Window * pParent, const ResId& rResId) :
	SfxFloatingWindow ( pBindings, pMgr, pParent, rResId ),
    aTbFunctionTb( this, pBindings, ResId( TB_TB_FUNCTION ) ),
	aTbSymbolBtn( this, ResId( BTN_TB_SYMBOL ) ),
	aTbHelpBtn( this, ResId( BTN_TB_HELP) ),
	aTbDefaultBtn( this, ResId( BTN_TB_DEFAULT) ),
	aTbCancelBtn( this, ResId( BTN_TB_CANCEL ) ),
	aTbRegionFt( this, ResId( FT_TB_REGION ) ),
	aTbRegionLb( this, ResId( LB_TB_REGION ), SFX_SLOT_TOOLBOXCONFIG ),
	aTbFunctionFt( this, ResId( FT_TB_FUNCTION ) ),
	aTbFunctionLb( this, ResId( LB_TB_FUNCTION ) ),
	aTbFunctionGb( this, ResId( GB_TB_FUNCTION ) ),
	aTbFunctionsGb( this, ResId( GB_TB_FUNCTIONS ) ),
	pBmpDlg(0)
{
	FreeResource();

    SfxImageManager *pImgMgr = pBindings->GetImageManager();
	pImgMgr->RegisterToolBox(&aTbFunctionTb);

	Size aSize = pParent->GetOutputSizePixel();
	Point aPos = pParent->GetPosPixel();
	aPos.X() += (aSize.Width() - GetSizePixel().Width()) / 2;
	aPos.Y() += (aSize.Height() - GetSizePixel().Height()) / 2;

	if (aPos.X() < 0) aPos.X() = 0;
	if (aPos.Y() < 0) aPos.Y() = 0;

	SetPosPixel(aPos);               // Dialog zentrieren

    SvtMiscOptions aOpt;
    nSymbolSet = aOpt.GetSymbolSet();
    aOpt.AddListener( LINK(this,SfxToolboxCustomizer,SymbolsetChanged));

	aTbRegionLb.SetSelectHdl( LINK(this,SfxToolboxCustomizer, SelectGroup));
	aTbFunctionTb.SetHighlightHdl(LINK(this,SfxToolboxCustomizer, SelectButton));
	aTbFunctionLb.SetSelectHdl(LINK(this,SfxToolboxCustomizer, SelectFunction));
	aTbSymbolBtn.SetClickHdl(LINK(this,SfxToolboxCustomizer, UserdefSymbols));
	aTbDefaultBtn.SetClickHdl(LINK(this,SfxToolboxCustomizer, ButtonDefaultHdl));
    pBindings->GetWorkWindow_Impl()->SetObjectBarCustomizeMode_Impl( TRUE );

    pBindings->ENTERREGISTRATIONS();

	pControls = new SfxTbxControlArr_Impl;

	Init();                             // Listen fuellen
	aTbRegionLb.SetFunctionListBox( &aTbFunctionLb );
	aTbRegionLb.Init();
	aTbRegionLb.Select( aTbRegionLb.GetEntry( 0,0 ) );
	SelectGroup(&aTbRegionLb);
	aTbRegionLb.GrabFocus();

    aTbFunctionTb.SetCustomizeMode( TRUE );

    pBindings->GetDispatcher()->Lock(TRUE);
}

// **************************************************************************
//  dtor des Dialogs. Fuer alle Toolboxen im System sowie den ImageManager
//  wird der customize mode ausgeschaltet.

SfxToolboxCustomizer::~SfxToolboxCustomizer()
{
    SvtMiscOptions aOpt;
    aOpt.RemoveListener( LINK(this,SfxToolboxCustomizer,SymbolsetChanged));

    SfxImageManager *pImgMgr = GetBindings().GetImageManager();
	if (pImgMgr)
		pImgMgr->ReleaseToolBox(&aTbFunctionTb);

    GetBindings().GetWorkWindow_Impl()->SetObjectBarCustomizeMode_Impl( FALSE );

	if (pBmpDlg)
		delete pBmpDlg;

	ClearToolbox();
	delete pControls;

    // all other configurations are saved with their documents
    SFX_APP()->GetConfigManager_Impl()->StoreConfiguration();

    GetBindings().GetDispatcher()->Lock(FALSE);
    GetBindings().LEAVEREGISTRATIONS();
}

// **************************************************************************
//  Es wurde ein Toolbox-Button selektiert.

IMPL_LINK( SfxToolboxCustomizer, SelectButton, ToolBox *, pBox )
{
	USHORT nId = aTbFunctionTb.GetCurItemId();
	if ( nId != TOOLBOX_ITEM_NOTFOUND )
	{
		// Funktion bzw. Macro in Listbox selektieren
		SvLBoxEntry *pEntry = aTbFunctionLb.GetEntry( 0, aTbFunctionTb.GetItemPos( nId ) );
		aTbFunctionLb.Select( pEntry );
		aTbFunctionLb.MakeVisible( pEntry );

		// selektierten Button highlighten
		USHORT nCount = aTbFunctionTb.GetItemCount();
		for (USHORT n=0; n<nCount; n++)
		{
			USHORT nId = aTbFunctionTb.GetItemId(n);
			if (  aTbFunctionTb.IsItemChecked(nId) )
				aTbFunctionTb.CheckItem(nId, FALSE);
		}

		aTbFunctionTb.CheckItem( nId );
		BOOL bEnable = ( aTbFunctionTb.GetItemWindow( nId ) == 0 );
		aTbSymbolBtn.Enable( bEnable );
		aTbDefaultBtn.Enable( bEnable );
	}
	return 0;
}

// **************************************************************************
//  Es wurde ein Funktionsname selektiert.

IMPL_LINK( SfxToolboxCustomizer, SelectFunction, Control*, pBox )
{
	aTbFunctionLb.FunctionSelected();

	// Alle Buttons deselektieren
	USHORT nCount = aTbFunctionTb.GetItemCount();
	for ( USHORT n=0; n<nCount; n++ )
	{
		USHORT nId = aTbFunctionTb.GetItemId( n );
		if ( aTbFunctionTb.IsItemChecked(nId) )
			aTbFunctionTb.CheckItem( nId, FALSE );
	}

	// ID besorgen
	USHORT nId = aTbFunctionLb.GetCurId();
	BOOL bEnable = ( aTbFunctionTb.GetItemWindow( nId ) == 0 );
	aTbSymbolBtn.Enable( bEnable );
	aTbDefaultBtn.Enable( bEnable );

	// passenden Button highlighten
	aTbFunctionTb.CheckItem( nId );
	return 0;
}

// **************************************************************************
//  Die Gruppen-Listbox werden gefuellt und die erste verfuegbare Funktionsgruppe
//  selektiert.

void SfxToolboxCustomizer::Init()
{
}

// **************************************************************************
//  Es wurde eine Funktionsgruppe selektiert. Alle zugehoerigen Funktionen
//  werden geholt und als Name und Toolbox-Button angezeigt.

IMPL_LINK( SfxToolboxCustomizer, SelectGroup, Control*, pBox )
{
	aTbRegionLb.GroupSelected();
	aTbDefaultBtn.Disable();
	aTbSymbolBtn.Disable();
	SfxBindings& rBindings = GetBindings();
    SfxImageManager *pImgMgr = GetBindings().GetImageManager();
	ClearToolbox();

	SvLBoxEntry *pEntry = aTbFunctionLb.First();
	USHORT nPos = 0;
	while ( pEntry  )
	{
		// Funktionsname und HelpText holen
		USHORT nId = aTbFunctionLb.GetId( pEntry );
		String aName = aTbFunctionLb.GetEntryText( pEntry );

		// Toolbox-Button eintragen
		aTbFunctionTb.InsertItem( nId, aName, 0, nPos );
		aTbFunctionTb.SetItemImage( nId, pImgMgr->SeekImage(nId));
		aTbFunctionTb.SetHelpText( nId, aTbFunctionLb.GetHelpText( pEntry ) );

		SfxToolBoxControl *pControl = SfxToolBoxControl::CreateControl
					( nId, &aTbFunctionTb, rBindings, NULL );
		if ( SfxMacroConfig::IsMacroSlot( nId ) )
            SFX_APP()->GetMacroConfig()->RegisterSlotId( nId );

		pControl->UnBind();
		pControls->Append( pControl );
		Window *pItemWin = pControl->CreateItemWindow(&aTbFunctionTb);
		if ( pItemWin )
			aTbFunctionTb.SetItemWindow( nId, pItemWin );
		nPos++;
		pEntry = aTbFunctionLb.Next( pEntry );
	}

	if ( aTbFunctionLb.GetEntryCount() )
		SelectFunction( &aTbFunctionLb );
	return 0;
}

void SfxToolboxCustomizer::ClearToolbox()
{
	if ( pControls->Count() )
	{
		// Toolbox enth"alt Funktionen, also evtl. ItemWindows
		for (USHORT n=0; n<pControls->Count(); ++n )
		{

			SfxToolBoxControl *pControl = pControls->GetObject(n);
			USHORT nId = pControl->GetId();
			Window *pItemWin = aTbFunctionTb.GetItemWindow(nId);
			if ( pItemWin )
			{
				aTbFunctionTb.SetItemWindow( nId, 0 );
				delete pItemWin;
			}

			delete pControl;
		}

		pControls->Clear();
	}

	aTbFunctionTb.Clear();
}

// **************************************************************************
//  CloseHandler des Dialogfensters. Der Dialog wird ueber den Dispatcher
//  beendet und zerstoert.

BOOL SfxToolboxCustomizer::Close()
{
	SfxApplication *pSfxApp = SFX_APP();
    GetBindings().GetDispatcher()->Lock(FALSE);
    GetBindings().GetWorkWindow_Impl()->SetObjectBarCustomizeMode_Impl( FALSE );
	return SfxFloatingWindow::Close();
}


long SfxToolboxCustomizer::Notify( NotifyEvent& rEvt )
{
	// Da per default Notify nur bis zu einem SystemWindow geht
//	return GetParent()->Notify( rEvt );
	long	nRet = SfxFloatingWindow::Notify( rEvt );
	if( !nRet )
		nRet = GetParent()->Notify( rEvt );

	return nRet;
}

// **************************************************************************
//  Es wurde bei geoeffnetem floating window das SymbolSet ausgetauscht.

IMPL_LINK( SfxToolboxCustomizer, SymbolsetChanged, void*, pVoid )
{
    SvtMiscOptions aOpt;
    if ( nSymbolSet != aOpt.GetSymbolSet() )
	{
        SfxImageManager* pImgMgr = GetBindings().GetImageManager();
        nSymbolSet = aOpt.GetSymbolSet();
		USHORT nCount = aTbFunctionTb.GetItemCount();
		for ( USHORT nPos = 0; nPos < nCount; ++nPos )
		{
			USHORT nId = aTbFunctionTb.GetItemId(nPos);
			if (aTbFunctionTb.GetItemType(nPos) == TOOLBOXITEM_BUTTON)
				aTbFunctionTb.SetItemImage(nId, pImgMgr->SeekImage(nId));
		}
	}

    return 0L;
}

IMPL_LINK( SfxToolboxCustomizer, UserdefSymbols, Button *, pButton )
{
	USHORT nId = aTbFunctionLb.GetCurId();
	ConnectUserBitmapDialog_Impl(nId, aTbFunctionTb);
	if ( pBmpDlg )
		pBmpDlg->Execute();
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, ButtonDefaultHdl, Button *, pButton )
{
	USHORT nId = aTbFunctionLb.GetCurId();
    SfxImageManager *pImgMgr = GetBindings().GetImageManager();
	pImgMgr->ReplaceImage(nId);
	aTbFunctionTb.SetItemImage(nId, pImgMgr->GetImage(nId));
//	  SFX_IMAGEMANAGER()->ExchangeItemImage(nId, aTbFunctionTb.GetItemImage(nId));
//	  SFX_APPWINDOW->ShowObjectBars();
//    GetBindings().GetDispatcher()->GetFrame()->ShowObjectBars();
	return 0;
}

UINT32 getBitmapCount_Impl( const String& rFolder )
{
	const String aBitmapExt( DEFINE_CONST_UNICODE( "bmp" ) );
	Sequence< ::rtl::OUString > aFiles = SfxContentHelper::GetFolderContents( rFolder, sal_False );
	const ::rtl::OUString* pFiles  = aFiles.getConstArray();
	UINT32 i, nBitmapCount = 0, nCount = aFiles.getLength();
	for ( i = 0; i < nCount; i++ )
	{
		if ( aBitmapExt == INetURLObject( pFiles[i] ).getExtension() )
			nBitmapCount++;
	}
	return nBitmapCount;
}

SfxUserBitmapDialog_Impl* SfxToolboxCustomizer::ConnectUserBitmapDialog_Impl
(
	USHORT nId,
	ToolBox& rTbx,
	SfxToolBoxManager* pMgr
)
{
	// the count of bitmaps of the bitmap directory
	String aInName = SvtPathOptions().GetBitmapPath();
	UINT32 nCount = getBitmapCount_Impl( aInName );

	// Ist es leer ?
	if ( !nCount )
	{
        // Dann PathDialog anzeigen
        rtl::OUString aService( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ui.dialogs.FolderPicker" ) );
        Reference< XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );

        Reference < XFolderPicker > xFolderDlg( xFactory->createInstance( aService ), UNO_QUERY );

        xFolderDlg->setTitle( String( SfxResId( STR_TBXCUST_BMPDIR ) ) );
        if ( xFolderDlg->execute() == ExecutableDialogResults::OK )
        {
			// Selektiertes Directory checken
			aInName = xFolderDlg->getDirectory();
			nCount = getBitmapCount_Impl( aInName );

			// Wenn nicht leer, auf jeden Fall neu einlesen
			if ( nCount )
				DELETEZ( pBmpDlg );
		}
		else
			return NULL;
	}

	if ( !nCount )
	{
		// Selektierter Pfad ist leer
		String aString( SfxResId( STR_TBXCUST_BITMAPS ) );
		String aBmpDir = SvtPathOptions().GetBitmapPath();
		aString.SearchAndReplaceAscii( "$PATH$", aBmpDir );
		InfoBox( this, aString ).Execute();
//		return 0;
	}

	if ( pBmpDlg )
	{
		// Wenn inzwischen die Symbolgr"osse oder der Bitmap-Path
		// ge"andert wurde, muss neu eingelesen werden
        if ( pBmpDlg->aSymbolTb.GetItemImage(1).GetSizePixel() != GetBindings().GetImageManager()->GetImageSize() ||
			 pBmpDlg->aDirName != aInName )
			DELETEZ(pBmpDlg);
	}

    SfxImageManager* pImgMgr = GetBindings().GetImageManager();
    if ( !pBmpDlg )
        pBmpDlg = new SfxUserBitmapDialog_Impl( this, aInName, rTbx, nId, pMgr, pImgMgr );
	else
	{
		pBmpDlg->SetFunctionId( nId );
		pBmpDlg->SetToolBox( rTbx );
	}

	return pBmpDlg;
}

SfxUserBitmapDialog_Impl::SfxUserBitmapDialog_Impl
(
	Window *pParent,
	const String& rBmpDirName,
	ToolBox& rTbx,
	USHORT nID,
    SfxToolBoxManager* pTbxMgr,
    SfxImageManager* pImgMgr
)
 :  ModalDialog  (pParent, SfxResId(RID_USERDEFBMP)),
	aSymbolTb       (this, ResId(TB_BITMAP)),
	aDescLabelFt    (this, ResId(FT_DESC_LABEL)),
	aDescEdit       (this, ResId(FT_DESC)),
	aOKButton       (this, ResId(BTN_OK)),
	aCancelButton   (this, ResId(BTN_CANCEL)),
	aHelpBtn        (this, ResId(BTN_HELP)),
	aFunctionGb     (this, ResId(GB_FUNCTION)),
	nFuncId 		(nID),
	aDirName		(rBmpDirName),
	pToolBox		(&rTbx),
    pMgr            (pTbxMgr),
    pImageMgr       (pImgMgr)
{
	Color aColor( SfxResId( IMAGE_BTN_COLOR ) );
	FreeResource();

	aDescEdit.SetText( pToolBox->GetItemText( nFuncId ) );
    EnterWait();

	VirtualDevice aDev;
    Size aSize = pImageMgr->GetImageSize();
	aDev.SetOutputSizePixel(aSize);

	// Das angegebene Verzeichnis nach Bitmaps durchsuchen
	const String aBitmapExt( DEFINE_CONST_UNICODE( "bmp" ) );
	Sequence< ::rtl::OUString > aFiles = SfxContentHelper::GetFolderContents( aDirName, sal_False );
	const ::rtl::OUString* pFiles  = aFiles.getConstArray();
    USHORT i, nCount = (USHORT) aFiles.getLength();
	for ( i = 0; i < nCount; ++i )
	{
		String aURL( pFiles[i] );
		INetURLObject aObj( aURL );
		if ( aBitmapExt == aObj.getExtension() )
		{
			SvFileStream aStr( aURL, STREAM_STD_READ );
			Bitmap* pBmp = new Bitmap;
			aStr >> *pBmp;
			aBmpList.Insert( pBmp, LIST_APPEND );
			USHORT nItem = i + 1;
			String aBmpName = aObj.getName();
			if ( pBmp->GetSizePixel() == aSize )
			{
				Image aImage( *pBmp, aColor );
				aSymbolTb.InsertItem( nItem, aBmpName );
				aSymbolTb.SetItemImage( nItem, aImage );
			}
			else
			{
				aDev.DrawBitmap( Point(), aSize, *pBmp );
				Image aImage( aDev.GetBitmap( Point(), aSize ), aColor );
				aSymbolTb.InsertItem( nItem, aBmpName );
				aSymbolTb.SetItemImage( nItem, aImage );
			}
		}
	}

    LeaveWait();
/*
	// Einen Button f"ur reine Textbuttons einf"ugen
	aSymbolTb.InsertItem(nCount+1, "Text");
	aSymbolTb.SetItemImage(nCount+1, Image());
*/
	aOKButton.SetClickHdl( LINK(this,SfxUserBitmapDialog_Impl, OKHdl));
	aSymbolTb.SetSelectHdl(LINK(this,SfxUserBitmapDialog_Impl, SelectHdl));
}

SfxUserBitmapDialog_Impl::~SfxUserBitmapDialog_Impl()
{
	for (USHORT n=0; n<aBmpList.Count(); n++)
		delete (Bitmap*) aBmpList.GetObject(n);
}

IMPL_LINK( SfxUserBitmapDialog_Impl, OKHdl, OKButton *, pButton )
{
	USHORT nId=0;

	// Nachsehen, welche Bitmaps selektiert wurde
	USHORT n;
	for (n=0; n<aSymbolTb.GetItemCount(); n++)
	{
		nId = aSymbolTb.GetItemId(n);
		if (aSymbolTb.IsItemChecked(nId)) break;
	}

	if (nId == 0)
		return 0;

	Bitmap *pBmp = (Bitmap*) aBmpList.GetObject(n);
    pImageMgr->ReplaceImage(nFuncId, pBmp);

	// Text nur an der "ubergebenen ToolBox "andern
	if ( pMgr )
		pMgr->SetItemText(nFuncId, aDescEdit.GetText());
	else
		pToolBox->SetItemText(nFuncId, aDescEdit.GetText());

	EndDialog(1);
	return 0;
}

IMPL_LINK( SfxUserBitmapDialog_Impl, SelectHdl, ToolBox *, pToolBox )
{
	USHORT nCount = aSymbolTb.GetItemCount();
	for (USHORT n=0; n<nCount; n++)
	{
		USHORT nId = aSymbolTb.GetItemId(n);
		if (aSymbolTb.IsItemChecked(nId))
			aSymbolTb.CheckItem(nId, FALSE);
	}

	USHORT nId = aSymbolTb.GetCurItemId();
	aSymbolTb.CheckItem(nId);
	return 0;
}

void SfxUserBitmapDialog_Impl::SetFunctionId(USHORT nID)
{
	nFuncId = nID;
	aDescEdit.SetText(pToolBox->GetItemText(nFuncId));
}

void SfxUserBitmapDialog_Impl::SetToolBox(ToolBox& rTbx)
{
	pToolBox = &rTbx;
	aDescEdit.SetText(pToolBox->GetItemText(nFuncId));
}


SFX_IMPL_FLOATINGWINDOW(SfxToolboxCustomWindow, SID_CUSTOMIZETOOLBOX)

SfxToolboxCustomWindow::SfxToolboxCustomWindow(Window *pParent,
	USHORT nId, SfxBindings *pBindings, SfxChildWinInfo* pInfo) :
	SfxChildWindow(pParent, nId)
{
	pWindow = new SfxToolboxCustomizer( pBindings, this, pParent,
										 SfxResId(RID_TOOLBOXCUSTOMIZE));
	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
	((SfxFloatingWindow*)pWindow)->Initialize( pInfo );
}

void SfxToolboxCustomizer::FillInfo( SfxChildWinInfo& rInfo ) const
{
	rInfo.bVisible = FALSE;
}


