/*************************************************************************
 *
 *  $RCSfile: ipenv.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kz $ $Date: 2001/11/06 10:15:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <so3/iface.hxx>
#ifndef _IPMENU_HXX //autogen
#include <so3/ipmenu.hxx>
#endif
#ifndef _IPWIN_HXX //autogen
#include <so3/ipwin.hxx>
#endif
#include <svtools/menuoptions.hxx>
#pragma hdrstop

#include "virtmenu.hxx"
#include "dispatch.hxx"
#include "ipfrm.hxx"
#include "viewsh.hxx"
#include "accmgr.hxx"
#include "mnumgr.hxx"
#include "cfgmgr.hxx"
#include "interno.hxx"
#include "docfac.hxx"
#include "ipenv.hxx"

// SFX_INIMANAGER()
#if SUPD<613//MUSTINI
#include "inimgr.hxx"
#endif

//=========================================================================

#define SVIPWINDOW(p) ((SvInPlaceWindow&)p->GetWindow())

//--------------------------------------------------------------------

SfxInPlaceEnv_Impl::~SfxInPlaceEnv_Impl()
{
	DeleteWindows();
	delete pMenuBar;
}

//--------------------------------------------------------------------

MenuBar* SfxInPlaceEnv_Impl::QueryMenu( USHORT * nCount0, USHORT * nCount1,
										USHORT * nCount2 )
{
	SfxObjectFactory &rObjFactory = pFrame->GetObjectShell()->GetFactory();

	if( !pMenuBar )
	{
        SfxMenuBarManager* pMenuMgr = pFrame->GetViewShell()->GetMenuBar_Impl();
		pFrame->GetDispatcher()->UpdateObjectMenus_Impl(pMenuMgr);

		SfxVirtualMenu *pAppMenu = pMenuMgr->GetMenu();
		MenuBar *pAppBar = (MenuBar*) pAppMenu->GetSVMenu();

		// Bereich 1: hinter dem Datei-Menue und vor dem 2.Containermenue;
		// da wir dieses nicht haben: vor dem Fenstermenue
		USHORT nPos = pAppBar->GetItemPos(SID_MDIWINDOWLIST);

		// Die Menue-Konfiguration mu\s sicherstellen, da\s vor dem Dateimenue
		// nichts steht und da\s Datei - und Fenstermenue nicht wegkonfiguriert
		// werden k"onnen !
		DBG_ASSERT( nPos != MENU_ITEM_NOTFOUND, "Wer hat das MDI-Menue geklaut ?!");

		USHORT nStart1 = 1, nCount1 = nPos - 1;

		// Bereich 2: hinter dem 2.Containermenue
		USHORT nStart2 = 0, nCount2 = 0;

		// Bereich 3: hinter dem Fenster-Menue; das ist in der Regel nur das
		// Hilfe-Menue
		USHORT 	nStart3 = nPos + 1,
				nCount3 = pAppBar->GetItemCount() - nStart3;
		pMenuBar = new SvInPlaceMenuBar( pAppBar,
										 nStart1, nCount1,
										 nStart2, nCount2,
										 nStart3, nCount3 );
#if SUPD<613//MUSTINI
		if ( !SFX_INIMANAGER()->IsDontHideDisabledEntries() )
#else
		if( SvtMenuOptions().IsEntryHidingEnabled() == sal_False )
#endif
			pMenuBar->SetMenuFlags( pMenuBar->GetMenuFlags() | MENU_FLAG_HIDEDISABLEDENTRIES );

		// Die einschl"agigen Menu-Handler m"ussen gesetzt werden, damit ein
		// TRUE returniert werdenn kann, um SV daran zu hindern, an das AppMenue
		// zu gehen und dort seinen Aufruf loszuwerden, was InPlace garantiert
		// nicht richtig sein kann!
		Link aLink = LINK( this, SfxInPlaceEnv_Impl, DummyMenuHdl );
		pMenuBar->SetHighlightHdl( aLink );
		pMenuBar->SetActivateHdl( aLink );
		pMenuBar->SetDeactivateHdl( aLink );
	}

	return pMenuBar->GetBlocks( nCount0, nCount1, nCount2 );
}

//-------------------------------------------------------------------------

SfxInPlaceEnv_Impl::SfxInPlaceEnv_Impl
(
	SfxInPlaceObject*	pObj,
	SfxInPlaceFrame*	pIPFrame
)
:	SvInPlaceEnvironment( pObj->GetIPClient()->GetEnv(), pObj ),
	pFrame( pIPFrame ),
    pMenuBar( 0 )
{
	SfxObjectShell *pObjShell = pFrame->GetObjectShell();

    pIPFrame->GetFrame()->SetWorkWindow_Impl(  new SfxIPWorkWin_Impl( GetContainerEnv()->GetTopWin(),
                            pFrame->GetBindings(), this ) );
	MakeWindows();

	// StatusUpdates gehen erst los, wenn UITools angezeigt werden
	pFrame->GetBindings().ENTERREGISTRATIONS();
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::TopWinResize()
{
	if ( IsShowUITools())
	{
		// TopWinResize kann auch kommen, wenn die Tools nicht angezeigt
		// werden, weil das Dokumentfenster nicht aktiv ist.
        SfxWorkWindow* pWorkWin = pFrame->GetFrame()->GetWorkWindow_Impl();
		pWorkWin->ArrangeChilds_Impl();
		pWorkWin->ShowChilds_Impl();
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::RectsChangedPixel( const Rectangle & rObjRect,
											const Rectangle & rClipRect )
{
	DBG_ASSERT( pFrame, "no pFrame in RectsChangedPixel" );

	SvInPlaceEnvironment::RectsChangedPixel( rObjRect, rClipRect );

	// View skalieren
	SfxInPlaceObject* pObj = (SfxInPlaceObject*) GetIPObj();
	if ( !pObj->IsViewScalingDisabled() )
		MakeScale( GetIPObj()->GetVisArea().GetSize(),
				   GetIPObj()->GetMapUnit(), rObjRect.GetSize() );

	// View resizen
	Size aHatch( GetBorderWin()->GetHatchBorderPixel() );
	Point aPos( aHatch.Width(), aHatch.Height() );
	pFrame->DoAdjustPosSizePixel( pFrame->GetViewShell(),
					aPos, rObjRect.GetSize() ); //! +/-1 Problem
}

//-------------------------------------------------------------------------

BOOL SfxInPlaceEnv_Impl::DispatchAccel(const KeyCode &rKeyCode)
{
	if (!pFrame->GetViewShell()->GetWindow()->HasFocus())
		return FALSE;

	return pFrame->GetViewShell()->KeyInput( KeyEvent(0, rKeyCode) );
}

//-------------------------------------------------------------------------

void SfxInPlaceEnv_Impl::TopWinActivate( BOOL bActivate )
{
/*
	if( bActivate )
	{
		ActivateConfig();
	}
 */
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::UIActivate( BOOL bActivate )
{
    SfxWorkWindow* pWorkWin = pFrame->GetFrame()->GetWorkWindow_Impl();
	if ( bActivate )
	{
		pFrame->GetViewShell()->GetWindow()->GrabFocus();
		pWorkWin->ArrangeChilds_Impl();
		pWorkWin->ShowChilds_Impl();
	}
	else
	{
		pWorkWin->ResetObjectBars_Impl();
		pWorkWin->UpdateObjectBars_Impl();
		pWorkWin->Close_Impl();
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::DocWinActivate( BOOL bActivate )
{
	if( bActivate )
	{
//        ActivateConfig();

		// Da bei internem Inplace die Objekte und der Container einen Teil
		// des Environments gemeinsam haben, m"ussen "Anderungen upgedatet
		// werden, wenn von einem zum anderen gewechselt wird (z.B. der Status
		// der Objektleiste u.a.).
		if ( GetContainerEnv()->GetIPClient()->Owner() )
			pFrame->GetBindings().InvalidateAll( FALSE );
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::ShowUITools( BOOL bShow )
{
    SfxWorkWindow* pWorkWin = pFrame->GetFrame()->GetWorkWindow_Impl();
	if ( bShow )
	{
		// Wenn nach letztem ShowUITools(FALSE) TopWin-Groesse veraendert
		// wurde, muss neu arrangiert werden
		pFrame->GetBindings().LEAVEREGISTRATIONS();
        pWorkWin->ArrangeChilds_Impl();
        pWorkWin->ShowChilds_Impl();
		pFrame->GetBindings().HidePopups(FALSE);
	}
	else
	{
        pWorkWin->HideChilds_Impl();
		pFrame->GetBindings().HidePopups(TRUE);
		pFrame->GetBindings().ENTERREGISTRATIONS();
	}
}

//--------------------------------------------------------------------

void SfxInPlaceEnv_Impl::QueryObjAreaPixel( Rectangle& rRect ) const
{
	pFrame->GetViewShell()->QueryObjAreaPixel(rRect);
}


//--------------------------------------------------------------------
/*
void SfxInPlaceEnv_Impl::ActivateConfig()
{
	SfxConfigManager *pMgr = pFrame->GetObjectShell()->GetConfigManager();
	if ( pMgr )
		SFX_APP()->SetConfigManager_Impl( pMgr );
	else
		SFX_APP()->SetConfigManager_Impl( pCfgMgr);
}
*/
//--------------------------------------------------------------------

IMPL_LINK( SfxInPlaceEnv_Impl, DummyMenuHdl, Menu *, pMenu )
{
	return TRUE;
}

BOOL SfxInPlaceEnv_Impl::IsInternalInPlace() const
{
	return TRUE;
}


