/*************************************************************************
 *
 *  $RCSfile: persist.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: mba $ $Date: 2001/11/01 18:10:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PERSIST_HXX
#define _PERSIST_HXX

#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#include <so2ref.hxx>
#include <iface.hxx>


/*************************************************************************
*************************************************************************/
#ifndef SO2_DECL_SVSTORAGE_DEFINED
#define SO2_DECL_SVSTORAGE_DEFINED
SO2_DECL_REF(SvStorage)
#endif

class  ImpPersistStorage;
class  ImpPersistFile;
class  ImpItemContainer;
class  SvFactory;
class  SvStorage;

/*************************************************************************
*************************************************************************/


//=========================================================================
class SvObjectContainer : virtual public SvObject
/*	[Beschreibung]

	Diese Klasse stellt die Schnittstelle zur Verf"ugung, um auf
	Unter-Objekte, Pseudo-Objekte, Bereiche ... zuzugreifen.
	Diese Objekte werden erst auf Anforderung erzeugt. Sie m"ussen
	also nicht beim "offnen des Dokumentes angelegt werden.

*/
{
friend ImpItemContainer;
friend SvFactory;
protected:
					~SvObjectContainer();
public:
					SvObjectContainer();
					SO2_DECL_STANDARD_CLASS_DLL(SvObjectContainer,SOAPP)

};
#ifndef SO2_DECL_SVOBJECTCONTAINER_DEFINED
#define SO2_DECL_SVOBJECTCONTAINER_DEFINED
SO2_DECL_REF(SvObjectContainer)
#endif
SO2_IMPL_REF(SvObjectContainer)

/*************************************************************************
*************************************************************************/
class SvInfoObjectMemberList;
class SvInfoObject;

#ifndef SO2_DECL_SVPERSIST_DEFINED
#define SO2_DECL_SVPERSIST_DEFINED
SO2_DECL_REF(SvPersist)
#endif

#define SVEXT_PERSIST_STREAM "\002OlePres000"

class SvPersist : public SvObjectContainer
{
friend SvInfoObject;
friend ImpPersistStorage;
friend ImpPersistFile;
friend ImpItemContainer;
friend SvFactory;
	BOOL            bIsModified:1,
					bIsInit:1,
					bOpSave:1,
					bOpSaveAs:1,
					bSaveExtern:1,  // Kein SetClassName
					bOpHandsOff:1,  // Fuer Debug, ob SaveCompleted korrekt ist
					bCreateTempStor:1, // TRUE nach InitNew(0)
					bSaveFailed:1, 	// TRUE nach InitNew(0)
					bEnableSetModified:1,
					bDummy0:1,
					bDummy1:1;
	USHORT          nModifyCount;
	SvStorageRef    aStorage;
/*  SvAdviseSinkRef aAdvSink;      Benachrichtigung von externen Obj, fuer Modify */
	SvPersist *     pParent;    // fuer hierarchische Persist-Objekte
private:
	SvInfoObjectMemberList * pChildList;
	Time            aModifiedTime;
	String			aFileName;	// nur fuer das IPersistFile-Interface

	SvInfoObjectMemberList *GetInfoList();
	void            CountModified( BOOL bDirection );
	void            dtorClear();
    BOOL            SaveElement( SvStorage*, SvInfoObject* );
    SvPersistRef    CreateObjectFromStorage( SvInfoObject*, const SvStorageRef& );
protected:
	void            InitMembers( SvStorage * );
					~SvPersist();
#ifdef DBG_UTIL
#define ASSERT_INIT()     AssertInit();
#else
#define ASSERT_INIT()
#endif
	void            AssertInit() const;
	void			SetSaveFailed( BOOL bFail = TRUE )
					{ bSaveFailed = bFail; }
	BOOL    		GetSaveFailed() const { return bSaveFailed; }

	virtual void    ModifyChanged();

	virtual BOOL    InitNew( SvStorage * );         // Rekursiv
	virtual BOOL    Load( SvStorage * );            // Rekursiv
	virtual BOOL    Save();                         // Rekursiv
	virtual BOOL    SaveAs( SvStorage * pNewStg );  // Rekursiv
	virtual void    HandsOff();                     // Rekursiv
	virtual BOOL    SaveCompleted( SvStorage * );   // Rekursiv

	BOOL            DoLoadContent( SvStorage *, BOOL bOwner );
	virtual void    LoadContent( SvStream & rStm, BOOL bOwner );
	BOOL            DoSaveContent( SvStorage *, BOOL bOwner );
	virtual void    SaveContent( SvStream & rStm, BOOL bOwner );

	BOOL            LoadChilds();                       // Rekursiv
	BOOL            SaveChilds();                       // Rekursiv
	BOOL            SaveAsChilds( SvStorage * pNewStg );// Rekursiv
	BOOL            SaveCompletedChilds( SvStorage * ); // Rekursiv
	BOOL			HasStorage() const { return aStorage.Is(); }
public:
					SvPersist();
					SO2_DECL_STANDARD_CLASS_DLL(SvPersist,SOAPP)
	SvStorage *     GetStorage() const;
	SvPersist *     GetParent() const { return pParent; }
	void            SetupStorage( SvStorage * pStor ) const;

	virtual void    FillClass( SvGlobalName * pClassName,
							   ULONG * pFormat,
							   String * pAppName,
							   String * pFullTypeName,
							   String * pShortTypeName,
                               long nFileFormat = SOFFICE_FILEFORMAT_CURRENT ) const;

	SvGlobalName    GetClassName() const;
	ULONG           GetFileFormat() const;
	String			GetFullTypeName() const;

					// automatische Objektverwaltung um zu speichern
	BOOL            Insert  ( SvInfoObject * pInfoObj );
    BOOL            Move    ( SvInfoObject * pInfoObj, const String & rStorName, BOOL bCopyStorage=FALSE );
	BOOL			Copy	( const String & rNewObjName, const String & rNewStorName,
							  SvInfoObject * pSrcInfoObj, SvPersist * pSrc );

					// call DoClose( pEle ) and unload the child
					// TRUE, element is unloaded. FALSE cannot unload,
					// Refcount != 0 or modified.
	BOOL			Unload	( SvInfoObject * pInfoObj );
	BOOL			Unload	( SvPersist * pEle );

	void            Remove  ( const String & rEleName );
	void            Remove  ( SvPersist * pEle );
	void            Remove  ( SvInfoObject * pInfoObj );
	void            Clear   ();
	SvInfoObject *  Find    ( const String & rEleName ) const;
	SvInfoObject *  Find    ( const SvPersist * pEle ) const;
	const SvInfoObjectMemberList * GetObjectList() const
					{ return pChildList; }

					// altes Interface
	BOOL    		HasObject( const String & rObjName );
	SvPersistRef 	GetObject( const String & rObjName );
	SvStorageRef 	GetObjectStorage( const String & rObjName );
    SvStorageRef    GetObjectStorage( SvInfoObject* pEle );


					// lokale Namensgebung
	BOOL            IsRoot() const;
					// eigentliche Funktionalitaet
	void			EnableSetModified( BOOL bEnable = TRUE );
	BOOL			IsEnableSetModified() const
					{ return bEnableSetModified; }
	virtual void    SetModified( BOOL = TRUE );
	BOOL            IsModified();                   // Rekursiv

	SvPersistRef    CopyObject( SvStorage * );
    SvPersistRef    CopyObject( const String& rObjName, const String& rNewName, SvPersist * pSrc );

	virtual BOOL    DoInitNew( SvStorage * );
	const String &	GetFileName() const { return aFileName; }
	void			SetFileName( const String & rFileName )
					{ aFileName = rFileName; }
	virtual BOOL    DoLoad( const String & rFileName, StreamMode,
							short nStorMode );
	virtual BOOL    DoLoad( SvStorage * );
	BOOL			DoOwnerLoad( SvStorage * );
	virtual BOOL    DoSave();
	virtual BOOL    DoSaveAs( SvStorage * pNewStg );
	virtual void    DoHandsOff();
	virtual BOOL    DoSaveCompleted( SvStorage * = NULL );
	void            CleanUp(BOOL bRecurse=FALSE); //Rekursiv

	const Time &    GetModifyTime() const { return aModifiedTime; }
	void			SetModifyTime( const Time & rTime )
					{ aModifiedTime = rTime; }
	BOOL            IsHandsOff() const { return bOpHandsOff; }
    void            StartActivation( SvPersist* pObj );
};
SO2_IMPL_REF(SvPersist)

/*************************************************************************
*************************************************************************/

SV_DECL_REF(SvInfoObject)
class SvInfoObject_Impl;
class SvInfoObject : public SvPersistBase
{
friend SvPersist;
	SvPersistRef    aObj;
    String          aObjName;           // object and substorage name
    String          aStorName;          // optional real storage name
    SvGlobalName    aSvClassName;       // name of corresponding SV class
    SvInfoObject_Impl* pImp;
	BOOL            bDeleted;

protected:
					~SvInfoObject();
	virtual void	Assign( const SvInfoObject * pObj );
    void            SetRealStorageName( const String & rName );
	void            SetStorageName( const String & rName )
					{ aStorName = rName; }
public:
					SV_DECL_PERSIST1(SvInfoObject,SvPersistBase,1)
					SvInfoObject();
					SvInfoObject( SvPersist * );
					SvInfoObject( SvPersist *, const String & rObjName );
					SvInfoObject( const String& rObjName,
							   	  const SvGlobalName& rClassName );
	SvInfoObjectRef CreateCopy() const;

	virtual void    SetObj( SvPersist * );

	SvObject  *     GetObj() const { return &aObj; }
	SvPersist *     GetPersist() const { return aObj; }

	void            SetObjName( const String & rName )
					{ aObjName = rName; }
	String          GetObjName() const;

                    // GetStorageName() is the same as GetObjName()
	String          GetStorageName() const;

                    // If object is stored elsewhere, the RealStorageName is not empty
    String          GetRealStorageName() const;
	SvGlobalName    GetClassName() const;
	BOOL            IsDeleted() const
					{ return bDeleted; }
    void            SetDeleted( BOOL bDel=TRUE );
};

SV_IMPL_REF(SvInfoObject)
SV_DECL_IMPL_PERSIST_LIST(SvInfoObject,SvInfoObject*)

#endif // _PERSIST_HXX
