:
eval 'exec perl -wS $0 ${1+"$@"}'
    if 0;
#*************************************************************************
#
#   $RCSfile: z_ooo.pl,v $
#
#   $Revision: 1.4.2.1 $
#
#   last change: $Author: khendricks $ $Date: 2003/01/07 15:21:52 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

#
# z - zet the the file (OpenOffice version) 
#

use Cwd;
use lib ("$ENV{SRC_ROOT}/solenv/bin/modules"); # !!ATTENTION!! CHANGE TO ABSOLUT PATH!!!
use Cvs;
use GenInfoParser;

if ($ENV{GUI} eq "UNX") {
	use Cwd 'chdir';
};

#### script id #####

( $script_name = $0 ) =~ s/^.*\b(\w+)\.pl$/$1/; 

$id_str = ' $Revision: 1.4.2.1 $ ';
$id_str =~ /Revision:\s+(\S+)\s+\$/
  ? ($script_rev = $1) : ($script_rev = "-");

print "$script_name -- version: $script_rev\n";
print "Multi Platform Enabled Edition\n";

#### main ####

#########################
#                       #
#   Globale Variablen   #
#                       #
#########################
$is_debug       = 0;
#$UP_TO_DATE = 'Up-to-date';
$LOCALLY_MODIFIED = 'Locally Modified';
$Z_FILE = 'z.lst';
%files = ();
$revision = '';
$stand = '';
$comment = '';
$cvsexe = '';
#&get_environment;
$start_dir = cwd();
$prj_dir = &get_prj_dir;
$commiter_email = &get_commiter_name . '@openoffice.org';
&get_options;
@z_lst_text = ();
if ($stand) {
	&check_stand ($stand); 
};
@files_to_z = keys %files; 
foreach $file (@files_to_z) {
	&write_z_text($file);
};
&commit_z_lst;
print "\nFile(s) " . "@files_to_z " . "is (are) successfully zetted\n";
exit(0);

#### end of the main procedure ####

#########################
#                       #
#      Procedures       #
#                       #
#########################

#
# procedure retrieves cvs binary path
#
sub get_environment {
	my $buildtools = $ENV{BUILD_TOOLS};
	my $gui        = $ENV{GUI};

	if ( ($gui eq "WNT") || ($gui eq "WIN") || ($gui eq "OS2")) {
		$buildtoolpath  = $buildtools ? $buildtools : "r:\\util\\nt";
        $needsbackslash = 1;
		$cvsexe = "$buildtoolpath\\cvsclt2.exe";
		return;
	};
	if ( $gui eq "UNX" ) {
		$buildtoolpath  = $buildtools ? $buildtools : "/usr/solar/bin";
        $needsbackslash = 0;
		$cvsexe = "$buildtoolpath/cvs.clt2";
		return;
	}
	$cvsexe = 'cvs';
	$needsbackslash = 1;
};

#
# procedure return path to the prj directory
#
sub get_prj_dir {
	my $path;
	do {
		$path = cwd();
		if (stat('prj') && (-d _)) {
			return $path;
		} elsif (&is_root_dir($path)) {
			&print_error ("Found no prj folder for $file");
		};
	} while (chdir '..');
};

#
# procedure stores a z line for z.lst
#
sub write_z_text {
	my $file = shift;
	chdir $start_dir;
	cwd();
	&print_error ('No such file') if (!(stat ($file)));
	my ($file_path, $file_revision);
	if ($file =~ /[\/ | \\]+([\w | \s | \- | \.]+)$/) {
		$file = $1;
		chdir $`;
	};
	$file_path = cwd().'/'.$file;
	$file_revision = &check_status($file);
	my @loc_file_path = split $prj_dir, $file_path, 2;
	$loc_file_path[1] =~ /^[\\ | \/]+/;
	$file_path = $';
	push(@z_lst_text, &get_file_z_string($file_path, $file_revision));
	return;
};

#
# procedure checks if the file is ready to be zetted
#
sub check_status {
	my $file = shift;
	my $archive = Cvs->new();
	open(CVSSTATUS, "$archive->{CVS_BINARY} status $file |");
	while (<CVSSTATUS>) {
		chomp;
		if (/Status: /) {
			my $status = $';
			if ($status eq $LOCALLY_MODIFIED) {	# $UP_TO_DATE
				close CVSSTATUS;
				&print_error ("Unable to z file $file!\nIt has status $status");
			} else {
				if ($revision) {
					close CVSSTATUS;
					return $revision;
				} else { next; };
			};
		};
		if (/^\s+Repository revision:\s+(\S+)\s+\S+/) {
			close CVSSTATUS;
			return $1;
		};
	};
	close CVSSTATUS;
	&print_error ("Unable to get info from CVS server!\nCheck if you have correct cvs binaries");	
};

#
# Procedure prooves if current stand is a legal one	
#
sub check_stand {
	my ($stand, $stand_parser, @avail_stands, $entry);
	$stand = uc shift;
	$stand_parser = GenInfoParser->new();
	$stand_parser->load_list($ENV{SRC_ROOT}.'/solenv/config/stand.lst');
	@avail_stands = $stand_parser->get_keys();
	foreach $entry (@avail_stands) {
		return if ($entry eq $stand);
	};
	&print_error("There is no stand $stand");	
};

#
# procedure returns the complete sting ready for z.lst
#
sub get_file_z_string {
	my $file = shift;
	my $rev = '';
	if (!$revision) {
		$rev = shift;
	} else {
		$rev = $revision;
	};
	my $z_line = 'z';
	$z_line .= " -b $commiter_email";
	$stand = $ENV{WORK_STAMP} if (!$stand); 
	$z_line .= " -u $stand";
	$z_line .= " -c \"$comment\"" 	if ($comment);
	$z_line .= " -r $rev";
	return $z_line . " $file\n";
};

#
# Procedure commits z.lst with new file(s) information	
#
sub commit_z_lst {
	chdir $prj_dir.'/prj';
	cwd();
	my $cvs_add = '';

	my $archive = Cvs->new();
    $cvsexe = $archive->cvs_binary();
	$archive->name($Z_FILE);
	if (($archive->get_head())) {
		&cvs_get($Z_FILE);
	} else {
		 $cvs_add = '1';
	};
	open (Z_LST, ">>./$Z_FILE") || &print_error("Cannot create $Z_FILE");
	foreach (@z_lst_text) {
		print Z_LST $_;
	};
	close Z_LST;
	system("$cvsexe add $Z_FILE") if ($cvs_add);
	open(CVSLOG, "$cvsexe commit -m\"Autogenerated\" $Z_FILE |");
	while (<CVSLOG>) {
		chomp;
		if (/Up-to-date check failed/) {
			close CVSLOG;
			&cvs_get($Z_FILE);
			open (Z_LST, ">>./$Z_FILE") || &print_error("Cannot create $Z_FILE");
			foreach (@z_lst_text) {
				print Z_LST $_;
			};
			close Z_LST;
			open(CVSLOG, "$cvsexe commit -m\"Autogenerated\" $Z_FILE |");
		};
	};
	close CVSLOG;
};

#
# Procedure prooves if current dir is a root dir of the drive	
#
sub is_root_dir {
	my ($dir);
	$dir = shift;
	if (		(($ENV{GUI} eq 'UNX') ||
				 ($ENV{GUI} eq 'MACOSX')) && 
				($dir eq '/')) {
		return 1;
	} elsif (	(($ENV{GUI} eq 'WNT') || 
				 ($ENV{GUI} eq 'WIN') || 
				 ($ENV{GUI} eq 'OS2')) &&
				($dir =~ /\S:\/$/)) {
		return 1;
	} else {
		return 0;
	};
};

#
# procedure retrieves commiter name
#
sub get_commiter_name {
    return $ENV{VCSID} if (defined $ENV{VCSID});
	if (open(CVSROOT, 'CVS/Root')) {
		my @string = <CVSROOT>;
		close CVSROOT;
		if ($string[0] =~ /^:\S+:([\w | \. | -]+)@/) {
			return $1;
		};
	};
	&print_error ('No CVS alias found');
};


sub print_error {
    my $message = shift;
    print STDERR "\nERROR: $message\n";
	exit (1);
};

sub get_options {
	my ($arg);
	&usage() && exit(0) if ($#ARGV == -1);
	while ($arg = shift @ARGV) {
		$arg =~ /^-u$/	and $stand = shift @ARGV			and next;
		$arg =~ /^-r$/	and $revision = shift @ARGV			and next;
		$arg =~ /^-c$/	and $comment = shift @ARGV and next;
		$arg =~ /^--help$/	and $usage and exit(0);
		$files{$arg}++
	};
	print STDERR "You better supply commentary!!\n" if (!$comment);
	print STDERR "Z top level revision\n" if (!$revision);
};

sub usage {
	print STDERR "z [options] file1 file2 ... filen \@fileliste\n";
	print STDERR "options:\n";
	print STDERR "   -c comment            The zed files will get a comment\n";
	print STDERR "   -r Revision           z given revision of file\n";
	print STDERR "   -u Version            z file for given workspace\n";
	print STDERR "example:\n";
	print STDERR "   z -u SRC516 -r 1.2 test.cxx\n";
};

#
# implementation of get option from cvs wrapper
#
sub cvs_get {
    my $file = shift;
    chmod(0644, $file);
    unlink($file);
    execute_system("$cvsexe update -A $file");
};

sub execute_system {
    my (@command_args) = @_;
    
    if ( $is_debug ) {
        my $command;
        $command = join(" ", @command_args);
        print STDERR "TRACE_SYSTEM: $command\n";
    }
    system(@command_args);
}
