/*************************************************************************
 *
 *  $RCSfile: filepicker.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/26 08:55:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef INCLUDED_SVT_FILEPICKER_HXX
#define INCLUDED_SVT_FILEPICKER_HXX

#ifndef  _CPPUHELPER_IMPLBASE7_HXX_
#include <cppuhelper/implbase7.hxx>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERCONTROLACCESS_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerControlAccess.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERLISTENER_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerListener.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPICKERNOTIFIER_HPP_
#include <com/sun/star/ui/dialogs/XFilePickerNotifier.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILEPREVIEW_HPP_
#include <com/sun/star/ui/dialogs/XFilePreview.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFILTERMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XFILTERGROUPMANAGER_HPP_
#include <com/sun/star/ui/dialogs/XFilterGroupManager.hpp>
#endif

#ifndef  _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef  _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef  _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COMPHELPER_PROPERTYCONTAINER_HXX_ 
#include <comphelper/propertycontainer.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_ARRAY_HELPER_HXX_
#include <comphelper/proparrhlp.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#include "svtuno.hxx"

// class SvtFilePicker ---------------------------------------------------

typedef ::cppu::WeakImplHelper7	<	::com::sun::star::ui::dialogs::XFilePickerControlAccess
								,	::com::sun::star::ui::dialogs::XFilePickerNotifier
								,	::com::sun::star::ui::dialogs::XFilePreview
								,	::com::sun::star::ui::dialogs::XFilterManager
								,	::com::sun::star::ui::dialogs::XFilterGroupManager
								,	::com::sun::star::lang::XInitialization
								,	::com::sun::star::lang::XServiceInfo
								>	SvtFilePicker_Base;

class SvtFilePicker
					:public SvtFilePicker_Base
					,public ::comphelper::OMutexAndBroadcastHelper
					,public ::comphelper::OPropertyContainer
					,public ::comphelper::OPropertyArrayUsageHelper< SvtFilePicker >
{
private:
	friend class SvtFilePicker_Impl;

	SvtFilePicker_Impl*				m_pImpl;

    //------------------------------------------------------------------------------------
    // misc. helpers
	//------------------------------------------------------------------------------------

    static sal_Bool    HasSystemFilePicker( const UNOREFERENCE < ::com::sun::star::lang::XMultiServiceFactory> xFactory );
    static sal_Bool    UseSystemFilePicker();

public:
                       SvtFilePicker( const UNOREFERENCE < ::com::sun::star::lang::XMultiServiceFactory >& xFactory );
    virtual           ~SvtFilePicker();

	//------------------------------------------------------------------------------------
	// disambiguate XInterface
	//------------------------------------------------------------------------------------
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw (::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL acquire(  ) throw ();
	virtual void SAL_CALL release(  ) throw ();

	//------------------------------------------------------------------------------------
	// disambiguate XTypeProvider
	//------------------------------------------------------------------------------------
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes(  ) throw (::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL getImplementationId(  ) throw (::com::sun::star::uno::RuntimeException);

	//------------------------------------------------------------------------------------
	// XExecutableDialog functions
	//------------------------------------------------------------------------------------

	virtual void SAL_CALL 			setTitle( const UNOOUSTRING& aTitle ) throw( UNORUNTIMEEXCEPTION );
	virtual sal_Int16 SAL_CALL 		execute() throw( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XFilePicker functions
	//------------------------------------------------------------------------------------

	virtual void SAL_CALL 			setMultiSelectionMode( sal_Bool bMode ) throw( UNORUNTIMEEXCEPTION );
	virtual void SAL_CALL			setDefaultName( const UNOOUSTRING& aName ) throw( UNORUNTIMEEXCEPTION );
	virtual void SAL_CALL			setDisplayDirectory( const UNOOUSTRING& aDirectory ) throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION );
	virtual UNOOUSTRING SAL_CALL	getDisplayDirectory() throw( UNORUNTIMEEXCEPTION );
	virtual UNOSEQUENCE< UNOOUSTRING > SAL_CALL getFiles() throw( UNORUNTIMEEXCEPTION );

    //------------------------------------------------------------------------------------
	// XFilePickerControlAccess functions
	//------------------------------------------------------------------------------------

	virtual void SAL_CALL			setValue( sal_Int16 ElementID, sal_Int16 ControlAction, const UNOANY& value ) throw( UNORUNTIMEEXCEPTION );
	virtual UNOANY SAL_CALL			getValue( sal_Int16 ElementID, sal_Int16 ControlAction ) throw( UNORUNTIMEEXCEPTION );
    virtual void SAL_CALL			setLabel( sal_Int16 ElementID, const UNOOUSTRING& aValue ) throw ( UNORUNTIMEEXCEPTION );
    virtual UNOOUSTRING SAL_CALL	getLabel( sal_Int16 ElementID ) throw ( UNORUNTIMEEXCEPTION );
	virtual void SAL_CALL			enableControl( sal_Int16 ElementID, sal_Bool bEnable ) throw( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XFilePickerNotifier functions
	//------------------------------------------------------------------------------------

    virtual void SAL_CALL           addFilePickerListener( const UNOREFERENCE< ::com::sun::star::ui::dialogs::XFilePickerListener >& xListener ) throw ( UNORUNTIMEEXCEPTION );
    virtual void SAL_CALL           removeFilePickerListener( const UNOREFERENCE< ::com::sun::star::ui::dialogs::XFilePickerListener >& xListener ) throw ( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XFilePreview functions
	//------------------------------------------------------------------------------------

    virtual UNOSEQUENCE< sal_Int16 > SAL_CALL getSupportedImageFormats() throw ( UNORUNTIMEEXCEPTION );
    virtual sal_Int32 SAL_CALL      getTargetColorDepth() throw ( UNORUNTIMEEXCEPTION );
    virtual sal_Int32 SAL_CALL      getAvailableWidth() throw ( UNORUNTIMEEXCEPTION );
    virtual sal_Int32 SAL_CALL      getAvailableHeight() throw ( UNORUNTIMEEXCEPTION );
    virtual void SAL_CALL           setImage( sal_Int16 aImageFormat, const UNOANY& aImage ) throw ( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION );
    virtual sal_Bool SAL_CALL       setShowState( sal_Bool bShowState ) throw ( UNORUNTIMEEXCEPTION );
    virtual sal_Bool SAL_CALL       getShowState() throw ( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XFilterManager functions
	//------------------------------------------------------------------------------------

	virtual void SAL_CALL 			appendFilter( const UNOOUSTRING& aTitle, const UNOOUSTRING& aFilter ) throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION );
	virtual void SAL_CALL			setCurrentFilter( const UNOOUSTRING& aTitle ) throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION );
	virtual UNOOUSTRING SAL_CALL	getCurrentFilter() throw( UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XFilterGroupManager functions
	//------------------------------------------------------------------------------------
    virtual void SAL_CALL			appendFilterGroup( const UNOOUSTRING& sGroupTitle, const UNOSEQUENCE< UNOSTRINGPAIR >& aFilters ) throw (UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION);

	//------------------------------------------------------------------------------------
	// XInitialization functions
	//------------------------------------------------------------------------------------

    virtual void SAL_CALL			initialize( const UNOSEQUENCE< UNOANY >& aArguments ) throw ( UNOEXCEPTION, UNORUNTIMEEXCEPTION );

	//------------------------------------------------------------------------------------
	// XServiceInfo functions
	//------------------------------------------------------------------------------------

	/* XServiceInfo */
    virtual UNOOUSTRING SAL_CALL	getImplementationName() throw( UNORUNTIMEEXCEPTION );
    virtual sal_Bool SAL_CALL		supportsService( const UNOOUSTRING& sServiceName ) throw( UNORUNTIMEEXCEPTION );
    virtual UNOSEQUENCE< UNOOUSTRING > SAL_CALL
									getSupportedServiceNames() throw( UNORUNTIMEEXCEPTION );

	/* Helper for XServiceInfo */
	static UNOSEQUENCE< UNOOUSTRING >
									impl_getStaticSupportedServiceNames();
	static UNOOUSTRING				impl_getStaticImplementationName();

    /* Helper for registry */
	static UNOREFERENCE< UNOXINTERFACE > SAL_CALL
									impl_createInstance( const UNOREFERENCE< UNOXMULTISERVICEFACTORY >& xServiceManager ) throw( UNOEXCEPTION );

private:
	//------------------------------------------------------------------------------------
	// property set related methods
	//------------------------------------------------------------------------------------

	// XPropertySet pure methods
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException);
	// OPropertySetHelper pure methods
	virtual ::cppu::IPropertyArrayHelper& SAL_CALL getInfoHelper();
	// OPropertyArrayUsageHelper pure methods
	virtual ::cppu::IPropertyArrayHelper* createArrayHelper( ) const;

	// OPropertySetHelper overridden methods
	virtual void SAL_CALL setFastPropertyValue_NoBroadcast(
			sal_Int32 _nHandle, const ::com::sun::star::uno::Any& _rValue ) throw (::com::sun::star::uno::Exception);
};

#endif // INCLUDED_SVT_FILEPICKER_HXX

