/*************************************************************************
 *
 *  $RCSfile: fltcall.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sj $ $Date: 2001/03/07 19:53:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FLTCALL_HXX
#define _FLTCALL_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#include <vcl/field.hxx>

class FilterConfigItem;
class SvStream;
class Graphic;
class Window;

struct FltCallDialogParameter
{
	Window*		pWindow;
	ResMgr*		pResMgr;
	FieldUnit	eFieldUnit;
	String		aFilterExt;

	FltCallDialogParameter( Window* pW, ResMgr* pRsMgr, FieldUnit eFiUni ) :
		pWindow			( pW ),
		pResMgr			( pRsMgr ),
		eFieldUnit		( eFiUni ) {};
};

typedef BOOL (*PFilterCallback) (void *, USHORT);
	// Eine solche Funktion wird von einem Filter immer wieder aufgerufen.
	// Uebergeben wird der Zeiger pCallerData der Filterfunktion und wieviel Prozent
	// der Konvertierung bereits geschafft ist.
	// Sie liefert TRUE, wenn der Benutzer die Sache abbrechen moechte.
	// Innerhalb der Funktion koennte auch ein pApp->Reschedule() aufgerufen
	// werden (das macht der Filter nicht).

typedef BOOL (*PFilterCall)(SvStream & rStream, Graphic & rGraphic,
							PFilterCallback pCallback, void * pCallerData,
								FilterConfigItem* pConfigItem, sal_Bool bPrefDialog);
	// Von diesem Typ sind sowohl Export-Filter-Funktionen als auch Import-Filter-Funktionen.
	// rFileName ist der komplette Pfadname der zu importierenden bzw. zu exportierenden Datei.
	// pCallBack darf auch NULL sein. pCallerData wird der Callback-Funktion uebergeben.
	// pOptionsConfig darf NULL sein. Anderenfalls ist die Gruppe des Config schon gesetzt
	// und darf von dem Filter nicht geaendert werden!
	// Wenn bPrefDialog==TRUE gilt, wird ggf. ein Preferences-Dialog durchgefuehrt.

typedef BOOL ( *PFilterDlgCall )( FltCallDialogParameter& );
	// Von diesem Typ sind sowohl Export-Filter-Funktionen als auch Import-Filter-Funktionen.
	// Uebergeben wird ein Pointer auf ein Parent-Fenster und auf die Options-Config.
	// pOptions und pWindow duerfen NULL sein, in diesem Fall wird FALSE zurueckgeliefert.
	// Anderenfalls ist die Gruppe der Config schon gesetzt
	// und darf von dem Filter nicht geaendert werden!


#endif
