/*************************************************************************
 *
 *  $RCSfile: nranges.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hjs $ $Date: 2001/01/11 12:13:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef MACOSX
// We need an empty block in here. Otherwise, if the #ifndef _SFXNRANGES_HXX
// line is the first line, the Mac OS X version of the gcc preprocessor will
// incorrectly optimize the inclusion process and will never include this file
// a second time
#endif

#ifndef _SFXNRANGES_HXX

#ifndef NUMTYPE

#define NUMTYPE	USHORT
#define SfxNumRanges SfxUShortRanges
#include "nranges.hxx"

#undef NUMTYPE
#define NUMTYPE	ULONG
#define SfxNumRanges SfxULongRanges
#include "nranges.hxx"

#define _SFXNRANGES_HXX

#else

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

//========================================================================

#if SUPD<=383

#if defined MAC || ( defined SOLARIS && defined X86 ) || ( defined SINIX && defined GCC ) || defined SCO
#define NUMTYPE_ARG	int
#else
#define NUMTYPE_ARG	NUMTYPE
#endif

#else

#define NUMTYPE_ARG	int

#endif

class SfxNumRanges
{
	NUMTYPE*                 	_pRanges; // 0-terminated array of NUMTYPE-pairs

public:
								SfxNumRanges() : _pRanges( 0 ) {}
								SfxNumRanges( const SfxNumRanges &rOrig );
								SfxNumRanges( NUMTYPE nWhich1, NUMTYPE nWhich2 );
								SfxNumRanges( NUMTYPE_ARG nWh1, NUMTYPE_ARG nWh2, NUMTYPE_ARG nNull, ... );
								SfxNumRanges( const NUMTYPE* nNumTable );
								~SfxNumRanges()
								{ delete _pRanges; }

	BOOL						operator == ( const SfxNumRanges & ) const;
	BOOL						operator != ( const SfxNumRanges & rRanges ) const
								{ return !( *this == rRanges ); }

	SfxNumRanges&				operator = ( const SfxNumRanges & );

	SfxNumRanges&				operator += ( const SfxNumRanges & );
	SfxNumRanges&				operator -= ( const SfxNumRanges & );
	SfxNumRanges&				operator /= ( const SfxNumRanges & );

	NUMTYPE 					Count() const;
	BOOL						IsEmpty() const
								{ return !_pRanges || 0 == *_pRanges; }
	BOOL						Contains( NUMTYPE n ) const;
	BOOL						Intersects( const SfxNumRanges & ) const;

								operator const NUMTYPE* () const
								{ return _pRanges; }
};

#undef NUMTYPE
#undef SfxNumRanges

#endif

#endif
