/*************************************************************************
 *
 *  $RCSfile: tfrmitem.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _TFRMITEM_HXX
#define _TFRMITEM_HXX

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif

#include "poolitem.hxx"

class SvStream;

enum SfxOpenMode
{
	SfxOpenSelect		= 0,     // selected in view
	SfxOpenOpen			= 1,     // doubleclicked or <enter>
	SfxOpenAddTask		= 2,     // doubleclicked or <enter> with Ctrl-Modifier
	SfxOpenDontKnow		= 3,
	SfxOpenReserved1	= 4,
	SfxOpenReserved2	= 5,
	SfxOpenModeLast		= 5
};

DBG_NAMEEX(SfxTargetFrameItem);

// class SfxTargetFrameItem -------------------------------------------------

class SfxTargetFrameItem : public SfxPoolItem
{
private:
			String			_aFrames[ (USHORT)SfxOpenModeLast+1 ];
public:
			TYPEINFO();

			SfxTargetFrameItem( const SfxTargetFrameItem& rCpy );
			SfxTargetFrameItem( USHORT nWhich );
			SfxTargetFrameItem(
				USHORT nWhich,
				const String& rOpenSelectFrame,
				const String& rOpenOpenFrame,
				const String& rOpenAddTaskFrame );
			~SfxTargetFrameItem();

	virtual	int				operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Create( SvStream&, USHORT nItemVersion ) const;
	virtual SvStream&		Store( SvStream&, USHORT nItemVersion ) const;
	virtual SfxPoolItem*	Clone( SfxItemPool* pPool = 0 ) const;

	virtual	BOOL 			QueryValue( com::sun::star::uno::Any& rVal,
							 			BYTE nMemberId = 0 ) const;
	virtual	BOOL 			PutValue  ( const com::sun::star::uno::Any& rVal,
						     			BYTE nMemberId = 0 );
	/*
		Framebezeichner im Sfx:
		_browser : Beamerview
		_document : Desktopview
		_blank : new task
		"" : do nothing
	*/
	String					GetTargetFrame( SfxOpenMode eMode ) const;
};

////////////////////////////////////////////////////////////////////////////////
/*
 $Log: tfrmitem.hxx,v $
 Revision 1.1.1.1  2000/09/18 16:58:54  hr
 initial import

 Revision 1.14  2000/09/18 14:13:17  willem.vandorp
 OpenOffice header added.

 Revision 1.13  2000/08/31 13:41:15  willem.vandorp
 Header and footer replaced

 Revision 1.12  2000/03/22 11:47:48  kso
 Removed: SmartUno leftovers.

 Revision 1.11  2000/02/21 09:36:12  kso
 #68274# - Added: [Put|QueryValue( ... com::sun::star::uno::Any ... )

 Revision 1.10  1999/06/17 03:37:00  mh
 chg: Syntax in Kommentar wg. cvs

 Revision 1.9  1999/02/18 20:09:26  HJS
 kein komma hinter letztem enum


	  Rev 1.8   18 Feb 1999 21:09:26   HJS
   kein komma hinter letztem enum

	  Rev 1.7   18 Feb 1999 10:08:58   OV
   #61077# Open-Modi erweitert

	  Rev 1.6   15 Feb 1999 14:38:12   HJS
   syntax

	  Rev 1.5   15 Feb 1999 12:51:36   OV
   #61077# OpenModeLast auf alten Wert gesetzt

	  Rev 1.4   15 Feb 1999 09:39:30   OV
   #61077# Neu: SfxOpenDontKnow

	  Rev 1.3   07 Jun 1998 14:46:08   DV
   QueryValue und PutValue neu

	  Rev 1.2   08 Apr 1998 14:10:42   OV
   Doku hinzugefuegt

	  Rev 1.1   08 Apr 1998 13:51:38   OV
   Array war zu klein

	  Rev 1.0   08 Apr 1998 09:18:20   OV
   Initial revision.

*/

#endif

