/*************************************************************************
 *
 *  $RCSfile: clearer.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_CONFIG_HXX //autogen
#include <vcl/config.hxx>
#endif
#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SV_MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif
#ifndef _DATE_HXX //autogen
#include <tools/date.hxx>
#endif
#ifndef _SV_SYSTEM_HXX //autogen
#include <vcl/system.hxx>
#endif
#ifndef _SVEDIT_HXX //autogen
#include <svtools/svmedit.hxx>
#endif
#ifndef _VOS_PROFILE_HXX_ //autogen
#include <vos/profile.hxx>
#endif
#ifndef _VOS_SECURITY_HXX_ //autogen
#include <vos/security.hxx>
#endif

// no more password-crypting , IS 25.07.00
/*

//gecryptete Passwoerter fuer die naechsten Jahre
#define MAX_QUARTER 7
const char* __FAR_DATA aPassWords[] =
	{
	 "\x0A\x8B\xB1\x1C\x3D",		//deiek 	die erde ist eine kugel
	 "\x0A\x9C\xAB\x0A",            //drss		die renten sind sicher
	 "\x07\x81\xBF\x1D\x25\x6c",    //iogdsa    im osten geht die sonne auf
	 "\x0A\x86\xAE\x1D\x3F\x6F",  	//dhvdib 	die hauptstadt von deutschland ist berlin
	 "\x0A\x8B\xB1\x1C\x21",        //deiew		der euro ist eine waehrung
	 "\x0A\x85\xBF\x17\x25",        //dkgns		das kann gar nicht sein
	 "\x0B\x98\xB0\x0F\x33",        //evhve		ein viereck hat vier ecken
	 "\x0A\x99\xB0\x4C\x3d"         //dwh5k		die welt hat 5 kontinente
	};
*/

const char* __FAR_DATA sVersionGroup_Impl	= "Versions";
const char* __FAR_DATA sVerFileName_Impl	= "sversion";
const char* __FAR_DATA sInvalidPath_Impl	= "Path invalid: ";
const char* __FAR_DATA sConfig_Impl			= "config";
const char* __FAR_DATA sNoSVersionIni_Impl	= "StarOffice is not installed!";
const char* __FAR_DATA sNoEntryError_Impl	= "The file \"sversion.ini\" does not contain any StarOffice installations!";
const char* __FAR_DATA sNotClearedError_Impl = "No StarOffice installation could be found in the directory specified.\nPlease specify the path correctly and try again.\n\nIMPORTANT NOTE: StarOffice must not be delivered without the product being finally modified with the Clearer.\nIn this case the end user would not be able to use StarOffice at all.\n";
const char* __FAR_DATA sUser_Impl			= "User";
const char* __FAR_DATA sUserId_Impl			= "User-Id";
const char* __FAR_DATA sUserName_Impl 		= "User-Name";
const char* __FAR_DATA sUserFirstName_Impl	= "User-FirstName";
const char* __FAR_DATA sUserAddress_Impl	= "User-Adress";
const char* __FAR_DATA sFileNotFound_Impl	= "This file does not exist: ";
const char* __FAR_DATA sPreload_Impl		= "Preload" ;
const char* __FAR_DATA sKeys_Impl			= "Keys";
const char* __FAR_DATA sDbtDllName			= "so5dbt.dll";
const char* __FAR_DATA sSoDbtDll			= "16653699:soffice:3:30:0:0:0\n21952306:TestVersion:3:30:0:0:0\n";
const char* __FAR_DATA sExpiredError_Impl	= " - License expired";
const char* __FAR_DATA sQarters[]			= {"I","II","III","IV"};


#ifdef UNX
#define STAROFFICE_INI		"sofficerc"
// #define AUTH_INI                        "authrc"
#else
#define STAROFFICE_INI		"soffice.ini"
// #define AUTH_INI                        "auth.ini"
#endif

/* -----------------05.01.99 12:47-------------------
 *
 * --------------------------------------------------*/
class ClearerApp : public Application
{
	BOOL ClearKeysInPath(const UniString& rInstPath);
public:
    virtual void Main( );
	DECL_LINK(MenuHdl, Menu*);

};
/* -----------------05.01.99 15:36-------------------
 *
 * --------------------------------------------------*/

// No more password-dialog, IS, 25.07.00
/*
class PasswordDialog : public ModalDialog
{
	GroupBox		aGroup;
	OKButton 		aOk;
	CancelButton 	aCancel;
	FixedText 		aText;
	Edit			aPassWd;
	public:
		PasswordDialog(Window* pWin);

		UniString 	GetPassword() const {return aPassWd.GetText();}
};
*/

/* -----------------07.01.99 13:15-------------------
 *
 * --------------------------------------------------*/
class InfoDialog : public ModalDialog
{
	OKButton 		aClose;
	MultiLineEdit 	aInfoED;
public:
	InfoDialog(Window* pParent);
};
/* -----------------07.01.99 13:15-------------------
 *
 * --------------------------------------------------*/

// no more crypter, IS, 25.07.00
/*
#define PASSWDLEN 16

class Crypter
{
	BYTE cPasswd[ PASSWDLEN ];
public:
	Crypter( const UniString& rPasswd );
	short GetMaxPasswdLen() const { return PASSWDLEN; }
	short GetMinPasswdLen() const { return 5; 		  }

	void Encrypt( UniString& rTxt ) const;
	void Decrypt( UniString& rTxt ) const;
};
*/

/* -----------------05.01.99 15:39-------------------
 *
 * --------------------------------------------------*/

// No more password-dialog, IS 25.07.00
/*
PasswordDialog::PasswordDialog(Window* pParent) :
	ModalDialog(pParent, WB_STDMODAL),
	aText(this),
	aPassWd(this, WB_PASSWORD|WB_BORDER),
	aOk(this, WB_DEFBUTTON),
	aCancel(this),
	aGroup(this)
{
	SetText("Enter Password");

	Size aSz(191, 43);
	aSz = LogicToPixel(aSz, MAP_APPFONT);
	SetOutputSizePixel(aSz);

	Point aPos(12, 12);
	aPos = LogicToPixel(aPos, MAP_APPFONT);
	aSz = Size(60, 10);
	aSz = LogicToPixel(aSz, MAP_APPFONT);
	aText.SetPosSizePixel(aPos, aSz);
	aText.SetText("Password");
	aText.Show();

	aPos = Point(70, 12);
	aPos = LogicToPixel(aPos, MAP_APPFONT);
	aSz = Size(60, 10);
	aSz = LogicToPixel(aSz, MAP_APPFONT);
	aPassWd.SetPosSizePixel(aPos, aSz);
	aPassWd.Show();

	aPos = Point(6, 6);
	aPos = LogicToPixel(aPos, MAP_APPFONT);
	aSz = Size(127, 19);
	aSz = LogicToPixel(aSz, MAP_APPFONT);
	aGroup.SetPosSizePixel(aPos, aSz);
	aGroup.Show();

	aSz = Size(50, 14);
	aSz = LogicToPixel(aSz, MAP_APPFONT);
	aPos = Point(138, 6);
	aPos = LogicToPixel(aPos, MAP_APPFONT);
	aOk.SetPosSizePixel(aPos, aSz);
	aOk.Show();

	aPos = Point(138, 26);
	aPos = LogicToPixel(aPos, MAP_APPFONT);
	aCancel.SetPosSizePixel(aPos, aSz);
	aCancel.Show();

	aPassWd.GrabFocus();
}

*/
/* -----------------07.01.99 13:17-------------------
 *
 * --------------------------------------------------*/
InfoDialog::InfoDialog(Window* pParent) :
	ModalDialog(pParent, WB_STDMODAL),
	aClose(this, 0),
	aInfoED(this, WB_BORDER)
{
	Size aSz(300, 200);
	aSz = LogicToPixel(aSz, MAP_APPFONT);
	SetOutputSizePixel(aSz);

	Size aButtonSz = Size(50, 14);
	aButtonSz = LogicToPixel(aButtonSz, MAP_APPFONT);
	long nButtonPos = aSz.Height() - aButtonSz.Height() - 10;
	Point aPos(aSz.Width()/2 - aButtonSz.Width()/2, nButtonPos);
	aClose.SetPosSizePixel(aPos, aButtonSz);
	aClose.SetText(UniString("Close", osl_getThreadTextEncoding()));
	aClose.Show();

	aPos = Point(3,3);
	aPos = LogicToPixel(aPos, MAP_APPFONT);
	aSz.Height() = nButtonPos;
	aSz.Height() -= 10;
	aSz.Width() -= (2* aPos.X());
	aInfoED.SetPosSizePixel(aPos, aSz);
	aInfoED.SetReadOnly(TRUE);
	aInfoED.Show();

	DirEntry aReadme("readme.txt");

	if(FileStat(aReadme).IsKind(FSYS_KIND_FILE))
	{
		SvFileStream aFile(aReadme.GetFull(), STREAM_STD_READ);
		UniString aText;
		while(!aFile.IsEof())
		{
			ByteString aTemp;
			aFile.ReadLine( aTemp );

			aText += UniString( aTemp, osl_getThreadTextEncoding() );
			aText += UniString( "\n", osl_getThreadTextEncoding() );
		}
		aInfoED.SetText(aText);

		aFile.Close();
	}
	else
		aInfoED.SetText(UniString("Error: \"readme.txt\" missing!", osl_getThreadTextEncoding()));
}

/* -----------------05.01.99 13:06-------------------
 *
 * --------------------------------------------------*/
class ClearWindow : public WorkWindow
{
	public:
		ClearWindow();
		void ClearRegistration();
};
/* -----------------05.01.99 13:07-------------------
 *
 * --------------------------------------------------*/
ClearWindow::ClearWindow() :
	WorkWindow(NULL, WinBits( WB_APP | WB_STDWORK))
{
	UniString sTitle( "StarOffice OEM Clearer ", osl_getThreadTextEncoding() );
	SetText( sTitle );
}
/* -----------------06.01.99 08:05-------------------
 * Hier wird fuer einen Pfad das dort enthaltene Office
 * deregistriert.
 * - die Userdaten in der soffice.ini werden geloescht
 * - die so5dbt.dll wird neu geschrieben (30 Tage ab Start)
 * - die auth.ini wird geloescht und dort ein Preload=1 eingetragen
 * --------------------------------------------------*/
BOOL ClearerApp::ClearKeysInPath(const UniString& rInstPath)
{
	BOOL bRet = TRUE;
	DirEntry aInstDir(rInstPath);

	if(FileStat(aInstDir).IsKind(FSYS_KIND_DIR))
	{
		DirEntry aOfficeIni( rInstPath );
		aOfficeIni += UniString( "user", osl_getThreadTextEncoding() );
		aOfficeIni += UniString( STAROFFICE_INI, osl_getThreadTextEncoding() );

		if(FileStat(aOfficeIni).IsKind(FSYS_KIND_FILE))
		{
			Config aOfficeIniConfig( aOfficeIni.GetFull() );

			aOfficeIniConfig.SetGroup	( sUser_Impl			);
			aOfficeIniConfig.DeleteKey	( sUserId_Impl			);
			aOfficeIniConfig.DeleteKey	( sUserName_Impl		);
                        aOfficeIniConfig.DeleteKey      ( sUserFirstName_Impl           );
			aOfficeIniConfig.DeleteKey	( sUserAddress_Impl		);

                        aOfficeIniConfig.SetGroup       ( "common"                      );
			aOfficeIniConfig.WriteKey	( sPreload_Impl, ByteString::CreateFromInt32(1) );
		}
		else
		{
			UniString sMsg( sFileNotFound_Impl, osl_getThreadTextEncoding() );
			sMsg += aOfficeIni.GetFull();

			Window* pTmpWin = Application::GetAppWindow();
			ErrorBox(pTmpWin, WB_OK, sMsg).Execute();
			bRet = FALSE;
		}

		/*****
		 *
		 *
		 *

		String sAuthIniPath(rInstPath);
		sAuthIniPath += DirEntry::GetAccessDelimiter();
		sAuthIniPath += sConfig_Impl;
		sAuthIniPath += DirEntry::GetAccessDelimiter();
		sAuthIniPath += AUTH_INI;
		DirEntry aAuthIni(sAuthIniPath);
		if(FileStat(aAuthIni).IsKind(FSYS_KIND_FILE))
		{
			Config aOfficeIniConfig(aAuthIni.GetFull());
			if(aOfficeIniConfig.HasGroup( sKeys_Impl ))
			{
				aOfficeIniConfig.DeleteGroup(sKeys_Impl);
				aOfficeIniConfig.SetGroup(sKeys_Impl);
				aOfficeIniConfig.WriteKey(sPreload_Impl, 1);
				bRet = TRUE;
			}
			else
			{
				//hier werden die SYSTEM_IDs abgeklappert (in solar.h)
				// bis 50 sollte fuer ein paar Versionen ausreichen
				for(USHORT i = 1; i < 50; i++)
				{
					String sGroupName(sKeys_Impl);
					sGroupName += '_';
					if(i < 10)
						sGroupName += '0';
					sGroupName += i;
					if(aOfficeIniConfig.HasGroup( sGroupName ))
					{
						aOfficeIniConfig.DeleteGroup(sGroupName);
						aOfficeIniConfig.SetGroup(sGroupName);
						aOfficeIniConfig.WriteKey(sPreload_Impl, 1);
						bRet = TRUE;
						break;
					}
				}

			}
		}
		else
		{
			String sMsg(sFileNotFound_Impl);
			sMsg += sAuthIniPath;
			Window* pWin = Application::GetAppWindow();
			ErrorBox(pWin, WB_OK, sMsg).Execute();
		}

                UniString sDbtPath(rInstPath);
		sDbtPath += DirEntry::GetAccessDelimiter();
		sDbtPath += sDbtDllName;
		SvFileStream aDbtDll(sDbtPath, STREAM_STD_WRITE|STREAM_TRUNC);
		aDbtDll << sSoDbtDll;
		aDbtDll.Close();

                *
		*
		*
		*****/
	}
	else
	{
		UniString sMsg(sInvalidPath_Impl, osl_getThreadTextEncoding());
		sMsg += rInstPath;
		Window* pWin = Application::GetAppWindow();
		ErrorBox(pWin, WB_OK, sMsg).Execute();
                bRet = FALSE;
	}
	return bRet;
}

/* -----------------05.01.99 13:09-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(ClearerApp, MenuHdl, Menu*, pMenu)
{
	switch(pMenu->GetCurItemId())
  	{
		case 1:
		{
// IS, 25.07.00, no more password control
/*
                       PasswordDialog aDlg(0);
			if(RET_OK != aDlg.Execute())
				return 0;
			else
			{
				Date aCurDate;
				if(aCurDate.GetDate() < 19990101)
					return 0;
				Crypter aCrypt("5728954759");
				// Quartal 0 == 1/99
				USHORT nQuarter = (aCurDate.GetMonth() - 1)/3;
				nQuarter += aCurDate.GetYear() - 1999;
				if(nQuarter <= MAX_QUARTER)
				{
					String sDlgPasswd(aDlg.GetPassword());
					String sCheck(sDlgPasswd);
					aCrypt.Encrypt(sCheck);
        #ifdef DEBUG
		String sTest(sDlgPasswd);
		aCrypt.Encrypt(sTest);
		sTest.Insert("\n", 0);
		sTest.Insert(sDlgPasswd, 0);
		sTest.Insert("\n", 0);
		sTest.Insert(sCheck, 0);
		sTest.Insert("\n", 0);
		sTest.Insert(aPassWords[nQuarter], 0);
		InfoBox(0, sTest).Execute();
        #endif
					if(sCheck != aPassWords[nQuarter])
					{
						ErrorBox(0, WB_OK, "Wrong password").Execute();
						return 0;
					}
				}
			}
*/
			// sversion.ini suchen
			UniString sOfficePath;

			USHORT nRemoveCount = 0;
			::rtl::OUString aSVerIniName;
			::rtl::OUString aTemp = ::rtl::OUString::createFromAscii( sVerFileName_Impl );

			NAMESPACE_VOS( OProfile )::getProfileName(
						aSVerIniName,
						aTemp,
						UniString("", osl_getThreadTextEncoding())
						);

#ifdef DEBUG
			InfoBox(0, aSVerIniName).Execute();
#endif
			DirEntry aSVerIni(aSVerIniName);
			BOOL bSVersionIniFound = FileStat(aSVerIni).IsKind(FSYS_KIND_FILE);
			if(!bSVersionIniFound)
			{
				NAMESPACE_VOS( OProfile )::getProfileName(
							aSVerIniName,
							aTemp,
							UniString( "?$", osl_getThreadTextEncoding() )
							);
				aSVerIni = DirEntry(aSVerIniName);
			}
#ifdef DEBUG
			InfoBox(0, aSVerIniName).Execute();
#endif
			bSVersionIniFound = FileStat(aSVerIni).IsKind(FSYS_KIND_FILE);
			if( !bSVersionIniFound )
			{
				PathDialog aPathDlg(Application::GetAppWindow());
				UniString sMsg("The file # could not be found.\nEnter path of the StarOffice installation", osl_getThreadTextEncoding() );
				sMsg.SearchAndReplaceAscii( "#", aSVerIniName );

				Window* pWin = Application::GetAppWindow();
				ErrorBox(pWin, WB_OK, sMsg).Execute();

				if(RET_OK == aPathDlg.Execute())
				{
					sOfficePath = aPathDlg.GetPath();
					if(ClearKeysInPath(sOfficePath))
						nRemoveCount++;
				}
			}
			else
			{
				// userspezifische Gruppe bestimmen
                                Config aSVerConfig( aSVerIniName );
				ByteString aVerGroup( sVersionGroup_Impl );
				aSVerConfig.SetGroup( aVerGroup );

                                // alle 'StarOffice' suchen
				USHORT nOfficeKeyCount = aSVerConfig.GetKeyCount();
				if(!nOfficeKeyCount)
				{
					Window* pWin = Application::GetAppWindow();
					ErrorBox(pWin, WB_OK, UniString(sNoEntryError_Impl, osl_getThreadTextEncoding())).Execute();
				}
				else
				{
					for(USHORT i = 0; i < nOfficeKeyCount; i++)
					{
						UniString sInstPath = UniString(aSVerConfig.ReadKey(i), osl_getThreadTextEncoding());
						if(ClearKeysInPath(sInstPath))
							nRemoveCount++;
					}
				}
			}
			if(nRemoveCount)
			{
				UniString sMsg( "Registration information of # StarOffice installation(s) has been cleared",
								osl_getThreadTextEncoding() );
				sMsg.SearchAndReplaceAscii("#", UniString::CreateFromInt32(nRemoveCount) );

				Window* pWin = Application::GetAppWindow();
				InfoBox(pWin, sMsg).Execute();
				pMenu->EnableItem(1, FALSE);
			}
			else
			{
				Window* pWin = Application::GetAppWindow();
				ErrorBox(pWin, WB_OK, UniString(sNotClearedError_Impl, osl_getThreadTextEncoding())).Execute();
			}
		}
		break;
		case 2:
			Quit();
		break;
		case 11:
		{
			//Info laden
			Window* pWin = Application::GetAppWindow();
			InfoDialog aDlg(pWin);
			aDlg.Execute();
		}
		break;
	}

	return 0;
}
// --- ClearerApp::Main() -----------------------------------------------

void ClearerApp::Main( )
{
	MenuBar		aMB;
	PopupMenu	aPop;
	PopupMenu	aHelp;

	aMB.InsertItem		(1, UniString("~Clearer", osl_getThreadTextEncoding()));
	aMB.InsertItem		(2, UniString("~Help", osl_getThreadTextEncoding()));
	aPop.InsertItem		(1, UniString("~Clear Registrations", osl_getThreadTextEncoding()));
	aPop.InsertSeparator();
	aPop.InsertItem		(2, UniString("~Exit", osl_getThreadTextEncoding()));
	aHelp.InsertItem	(11, UniString("~Info", osl_getThreadTextEncoding()));
	aMB.SetPopupMenu	(1, &aPop);
	aMB.SetPopupMenu	(2, &aHelp);

	aMB.SetSelectHdl( LINK(this, ClearerApp, MenuHdl) );

	ClearWindow* pClearWin = new ClearWindow;
	pClearWin->SetMenuBar( &aMB );
	pClearWin->Show();

/*	Date aCurDate;
	ULONG nCompare = YEAR*10000;
	nCompare += 31;
	nCompare += 300 * (QUARTER + 1);
	if(aCurDate.GetDate() > nCompare)
	{
		String sTitle = pClearWin->GetText();
		sTitle += sExpiredError_Impl;
		pClearWin->SetText(sTitle);
		aPop.EnableItem(1, FALSE);
	}*/

	Execute();

	pClearWin->SetMenuBar(NULL);
	delete pClearWin;
}

// IS 25.07.00, no more Class Crypter

/*
Crypter::Crypter( const UniString& r )
{
	// Dies sind Randomwerte, die konstant zur Verschluesselung
	// des Passworts verwendet werden. Durch die Verwendung eines
	// verschluesselten Passworts wird vermieden, dass das Passwort
	// im RAM gehalten wird.
	static const BYTE cEncode[] =
	{ 0x5B, 0x9E, 0x64, 0x90, 0x73, 0x53, 0x9b, 0x39,
	  0xD7, 0x5e, 0xc3, 0x91, 0x2e, 0x55, 0x18, 0x0c };

	USHORT nLen = r.Len();
	if( nLen > PASSWDLEN ) nLen = PASSWDLEN;
	String aPasswd( r );
	if( nLen > PASSWDLEN )
		aPasswd.Erase( nLen );
	else
		aPasswd.Expand( PASSWDLEN, ' ' );
	memcpy( cPasswd, cEncode, PASSWDLEN );
	Encrypt( aPasswd );
	memcpy( cPasswd, (const char*) aPasswd, PASSWDLEN );
}



void Crypter::Encrypt( UniString& r ) const
{
	USHORT nLen = r.Len();
	if( !nLen )
		return ;

	USHORT nCryptPtr = 0;
	BYTE cBuf[ PASSWDLEN ];
	memcpy( cBuf, cPasswd, PASSWDLEN );
    BYTE* pSrc = (BYTE*)r.GetCharStr();
	BYTE* p = cBuf;

	while( nLen-- )
	{
		*pSrc = *pSrc ^ ( *p ^ (BYTE) ( cBuf[ 0 ] * nCryptPtr ) );
		*p += ( nCryptPtr < (PASSWDLEN-1) ) ? *(p+1) : cBuf[ 0 ];
		if( !*p ) *p += 1;
		p++;
		if( ++nCryptPtr >= PASSWDLEN ) nCryptPtr = 0, p = cBuf;
		pSrc++;
	}
}


void Crypter::Decrypt( UniString& r ) const
{
	Encrypt( r );
}

*/

// --- aClearerApp ------------------------------------------------------

ClearerApp aApp;

