/*************************************************************************
 *
 *  $RCSfile: filearch.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <filearch.hxx>
#include <filearc2.hxx>

#include <tools/new.hxx>

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#include <tools/urlobj.hxx>
#include <ucbhelper/content.hxx>
#include <com/sun/star/ucb/CommandAbortedException.hpp>
using namespace ucb;

static const char __FAR_DATA szDirExt[] = "dir";
static const char __FAR_DATA szDataExt[] = "dat";

SV_IMPL_PTRARR( FileEntries, FileEntry* )


FileEntry::FileEntry( const String& rURL, ULONG nPos, ULONG nLen, USHORT nOps )
	: aURL( rURL )
{
	nFilePos = nPos;
	nFileLen = nLen;
	nOptions = nOps;
}

FileEntry::~FileEntry()
{
}


BOOL SortedFileEntries::SeekEntry( const String& rURL, USHORT* pP )
{
	// Algorithmus aus svmem.hxx, aber dieses Array wird nicht benutzt,
	// weil das initial erzeugte Archive bereits sortiert ist.
	// => fuer normale binaere Suche unguenstigster Fall, also gleich
	// vorweg das erste Element vergleichen

	register USHORT nU = 0, nO = Count(), nM;
	if( nO > 0 )
	{
		nO--;

		// vorweg mit dem letzten Element vergleichen, falls ich eine
		// sortierte Liste erhalte...
		FileEntry const * const pLastEntry = GetObject( nO );
		const StringCompare eCompare = pLastEntry->GetURL().CompareIgnoreCaseToAscii( rURL );
		if( eCompare == COMPARE_GREATER )
		{
			if( pP ) *pP = nO+1;
			return FALSE;
		}

		while( nU <= nO )
		{
			nM = nU + ( nO - nU ) / 2;
			FileEntry const * const pEntry = GetObject( nM );
			const StringCompare eCompare = pEntry->GetURL().CompareIgnoreCaseToAscii( rURL );
			if( eCompare == COMPARE_EQUAL )
			{
				if( pP ) *pP = nM;
				return TRUE;
			}
			else if( eCompare == COMPARE_GREATER )
				nU = nM + 1;
			else if( nM == 0 )
			{
				if( pP ) *pP = nU;
				return FALSE;
			}
			else
				nO = nM - 1;
		}
	}
	if( pP ) *pP = nU;
	return FALSE;
}

BOOL SortedFileEntries::InsertEntry( const FileEntry* pEntry )
{
	USHORT nP;
	BOOL bExist;
	if( ! ( bExist = SeekEntry( pEntry->GetURL(), &nP ) ) )
		Insert( pEntry, nP );\
	return !bExist;
}

FileEntry* SortedFileEntries::FindEntry( const String& rURL )
{
	USHORT nP;
	BOOL bExist = SeekEntry( rURL, &nP );
	return bExist ? GetObject( nP ) : 0;
}

void SortedFileEntries::RemoveEntry( const FileEntry* pEntry )
{
	// SeekEntry mit bin. Suche schneller als GetPos( pEntry) ?
	USHORT nPos;
	if ( SeekEntry( pEntry->GetURL(), &nPos ) )
		Remove( nPos, 1 );
}


/*
 Aufbau des DIR-Files:
 <USHORT> nFiles
 <FileEntries...>

 FileEntry:
 <String> 	aURL
 <ULONG>	nFilePos
 <ULONG>	nFileLen
 <USHORT	nOptions
*/

SimpleFileArchive::SimpleFileArchive( const String& rFilename, USHORT nOpenMode )
{
	pFiles = new SortedFileEntries;
	INetURLObject aObj( rFilename, INET_PROT_FILE );
	aObj.removeExtension();
	aArchiveName = aObj.GetMainURL();
    aObj.setExtension( String::CreateFromAscii( szDirExt ) );
	aDirStream.Open( aObj.PathToFileName(), nOpenMode );
    aObj.setExtension( String::CreateFromAscii( szDataExt ) );
	aDataStream.Open( aObj.PathToFileName(), nOpenMode );
	ImpReadIndex();
}

SimpleFileArchive::~SimpleFileArchive()
{
	delete pFiles;
}

void SimpleFileArchive::ImpReadIndex()
{
	USHORT nFiles;
	pFiles->Reset();
	aDirStream.Seek( 0 );
	aDirStream >> nFiles;
	if ( !aDirStream.GetError() && !aDirStream.IsEof() )
	{
		for ( USHORT n = 0; n < nFiles; n++ )
		{
			String aURL;
            aDirStream.ReadByteString( aURL );

			ULONG nFilePos;
			aDirStream >> nFilePos;

			ULONG nFileLen;
			aDirStream >> nFileLen;

			USHORT nOptions;
			aDirStream >> nOptions;

			FileEntry* pEntry = new FileEntry( aURL, nFilePos, nFileLen, nOptions );
			if ( !pFiles->InsertEntry( pEntry ) )
			{
				DBG_ERROR( "Doppelter Eintrag im Archiv!" );
				delete pEntry;
			}
		}

		DBG_ASSERT( !aDirStream.GetError(), "Fehler im DirStream!" );
		DBG_ASSERT( aDirStream.Tell() == aDirStream.Seek( 0xFFFFFFFF ), "DirStream enthaelt noch Daten!" );
	}
}

BOOL SimpleFileArchive::HasFile( const String& rURL ) const
{
	return pFiles->FindEntry( rURL ) ? TRUE : FALSE;
}

USHORT SimpleFileArchive::GetFileCount() const
{
	return pFiles->Count();
}

String SimpleFileArchive::GetFileName( USHORT nFile ) const
{
	String aName;
	FileEntry* pEntry = pFiles->GetEntry( nFile );
	if ( pEntry )
		aName = pEntry->GetURL();
	return aName;
}

void SimpleFileArchive::ChangeFileName( const String& rOldName, const String& rNewName )
{
	FileEntry* pEntry = pFiles->FindEntry( rOldName );
	if ( pEntry )
	{
		// Nicht einfach nur umbenennen, der Entry muss auch neu einsortiert
		// werden:
		pFiles->RemoveEntry( pEntry );
		pEntry->SetURL( rNewName );
		pFiles->InsertEntry( pEntry );
	}
}

SvStream* SimpleFileArchive::ImpGetFile( const FileEntry* pEntry )
{
	SvMemoryStream* pStream = 0;
	if ( pEntry )
	{
		void* pData = SvMemAlloc( pEntry->GetFileLen() );
		if ( pData )
		{
			aDataStream.ResetError();
			aDataStream.Seek( pEntry->GetFilePos() );
			aDataStream.Read( pData, pEntry->GetFileLen() );
			if ( !aDataStream.GetError() )
			{
				pStream = new SvMemoryStream( (char*)pData, pEntry->GetFileLen(), STREAM_READ );
				pStream->ObjectOwnsMemory( TRUE );
			}
			else
			{
				SvMemFree( pData );
			}
		}
	}
	return pStream;
}

BOOL SimpleFileArchive::ImpDelFile( FileEntry* pEntry, BOOL bWriteIndex )
{
	// Die Daten im Data-Stream werden nicht angefasst!
	// => Irgendwann mal Reorganize rufen...

	BOOL bDone = FALSE;
	if ( pEntry )
	{
		pFiles->RemoveEntry( pEntry );
		delete pEntry;
		bDone = TRUE;

		if ( bWriteIndex )
			WriteIndex();
	}
	return bDone;
}


SvStream* SimpleFileArchive::GetFile( USHORT nFile )
{
	FileEntry* pEntry = pFiles->GetEntry( nFile );
	return ImpGetFile( pEntry );;
}

SvStream* SimpleFileArchive::GetFile( const String& rURL )
{
	FileEntry* pEntry = pFiles->FindEntry( rURL );
	return ImpGetFile( pEntry );;
}

BOOL SimpleFileArchive::AddFile( SvStream& rStream, const String& rName, BOOL bWriteIndex )
{
	BOOL bDone = FALSE;
	if ( !HasFile( rName ) && !rStream.GetError() )
	{
		ULONG nFilePos = aDataStream.Seek( STREAM_SEEK_TO_END );
		aDataStream << rStream;
		ULONG nEndPos = aDataStream.Tell();

		if ( !aDataStream.GetError() && !rStream.GetError() )
		{
			ULONG nFileLen = nEndPos-nFilePos;
			FileEntry* pNewEntry = new FileEntry( rName, nFilePos, nFileLen, 0 );
			pFiles->InsertEntry( pNewEntry );

			if ( bWriteIndex )
			{
				aDirStream.Seek( STREAM_SEEK_TO_BEGIN );
				aDirStream << pFiles->Count();
				aDirStream.Seek( STREAM_SEEK_TO_END );
				ImpWriteEntry( pNewEntry );
			}

			bDone = TRUE;
		}
	}
	return bDone;
}

/*
BOOL SimpleFileArchive::AddFile( const String& rURL, BOOL bWriteIndex )
{
	BOOL bDone = FALSE;
	if ( !HasFile( rURL ) )
	{
		SvFileStream aNewFile( rURL, STREAM_READ );
		if ( !aNewFile.GetError() )
		{
			aNewFile.Seek( 0 );
			bDone = AddFile( aNewFile, rURL, bWriteIndex );
		}
	}
	return bDone;
}
*/

BOOL SimpleFileArchive::AddArchive( SimpleFileArchive& rArchive, BOOL bWriteIndex )
{
	BOOL bError = FALSE;

	USHORT nFiles = rArchive.GetFileCount();
	for ( USHORT nFile = 0; nFile < nFiles; nFile++ )
	{
		String aFileName = rArchive.GetFileName( nFile );
		if ( !HasFile( aFileName ) )
		{
			SvStream* pStream = rArchive.GetFile( nFile );
			DBG_ASSERT( aFileName.Len() && pStream, "AddArchiv: Kaputtes Archiv?" );
			if ( pStream )
			{
				pStream->Seek( 0 );
				// FALSE: Nicht jedesmal den Index schreiben...
				AddFile( *pStream, rArchive.GetFileName( nFile ), FALSE );
				delete pStream;
			}
			else
				bError = TRUE;
		}
	}

	if ( bWriteIndex )
		WriteIndex();

	return ( bError || aDataStream.GetError() || aDirStream.GetError() ) ? FALSE : TRUE;
}

BOOL SimpleFileArchive::DelFile( const String& rURL, BOOL bWriteIndex )
{
	// Die Daten im Data-Stream werden nicht angefasst!
	// => Vielleicht mal das Reorganize implementieren...

	BOOL bDone = FALSE;
	FileEntry* pEntry = pFiles->FindEntry( rURL );
	if ( pEntry )
		bDone = ImpDelFile( pEntry, bWriteIndex );
	return bDone;
}

BOOL SimpleFileArchive::DelFile( USHORT nFile, BOOL bWriteIndex )
{
	BOOL bDone = FALSE;
	FileEntry* pEntry = pFiles->GetEntry( nFile );
	if ( pEntry )
		bDone = ImpDelFile( pEntry, bWriteIndex );
	return bDone;
}

BOOL SimpleFileArchive::WriteIndex()
{
	USHORT nFiles = pFiles->Count();
	aDirStream.SetStreamSize( 0 );
	aDirStream.Seek( STREAM_SEEK_TO_BEGIN );
	aDirStream << nFiles;
	for ( USHORT n = 0; n < nFiles; n++ )
	{
		FileEntry* pEntry = pFiles->GetEntry( n );
		ImpWriteEntry( pEntry );
	}
	return aDirStream.GetError() ? FALSE : TRUE;
}

BOOL SimpleFileArchive::ReOrganize()
{
	// Einfach das Data-File anhand des Index nochmal schreiben...
	// Die Loecher durch geloeschte Dateien gehen dann verloren.
	// Aber nur, wenn das aktuelle DataFile zum schreiben geoeffnet war.

	BOOL bDone = FALSE;
	if ( !aDataStream.GetError() && aDataStream.IsWritable() )
	{
		INetURLObject aObj( aArchiveName );
        aObj.setName( String::CreateFromAscii( "a_reorg" ) );
		SimpleFileArchive aNewArchive( aObj.PathToFileName(), STREAM_READWRITE );
		bDone = aNewArchive.AddArchive( *this, TRUE );
		if ( bDone )
		{
			// Wenn das geklappt hat einfache die Streams aus der Kopie
			// in die eigenen kopieren und den Index neu lesen...
			aDataStream.SetStreamSize( 0 );
			aDataStream.Seek( 0 );
			aNewArchive.aDataStream.Flush();
			aNewArchive.aDataStream.Seek( 0 );
			aDataStream << aNewArchive.aDataStream;

			aDirStream.SetStreamSize( 0 );
			aDirStream.Seek( 0 );
			aNewArchive.aDirStream.Flush();
			aNewArchive.aDirStream.Seek( 0 );
			aDirStream << aNewArchive.aDirStream;

			ImpReadIndex();

		}

		// Die Dateien des temp. Archives l"oschen...
		aNewArchive.aDirStream.Close();
		aNewArchive.aDataStream.Close();
		::com::sun::star::uno::Reference< ::com::sun::star::ucb::XCommandEnvironment > xCmdEnv;
		rtl::OUString aCmdStr = rtl::OUString::createFromAscii( "delete" );
		::com::sun::star::uno::Any bNoTrash = ::com::sun::star::uno::makeAny( sal_Bool( sal_True ) );

		aObj.setExtension( String::CreateFromAscii( szDirExt ) );
		try
		{
			Content aCnt( aObj.GetMainURL(), xCmdEnv );
			aCnt.executeCommand( aCmdStr, bNoTrash );
		}
		catch( ::com::sun::star::ucb::CommandAbortedException& )
		{
			DBG_ERRORFILE( "CommandAbortedException" );
		}
		catch( ... )
		{
			DBG_ERRORFILE( "Any other exception" );
		}

		aObj.setExtension( String::CreateFromAscii( szDataExt ) );
		try
		{
			Content aCnt( aObj.GetMainURL(), xCmdEnv );
			aCnt.executeCommand( aCmdStr, bNoTrash );
		}
		catch( ::com::sun::star::ucb::CommandAbortedException& )
		{
			DBG_ERRORFILE( "CommandAbortedException" );
		}
		catch( ... )
		{
			DBG_ERRORFILE( "Any other exception" );
		}
	}
	return bDone;
}

void SimpleFileArchive::ImpWriteEntry( const FileEntry* pEntry )
{
    aDirStream.WriteByteString( pEntry->GetURL() );
	aDirStream << pEntry->GetFilePos();
	aDirStream << pEntry->GetFileLen();
	aDirStream << pEntry->GetOptions();
}


