/*************************************************************************
 *
 *  $RCSfile: sbxint.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#include "sbx.hxx"
#include "sbxconv.hxx"

double ImpRound( double d )
{
	return d + ( d < 0 ? -0.5 : 0.5 );
}

INT16 ImpGetInteger( const SbxValues* p )
{
	SbxValues aTmp;
	INT16 nRes;
start:
	switch( p->eType )
	{
		case SbxNULL:
			SbxBase::SetError( SbxERR_CONVERSION );
		case SbxEMPTY:
			nRes = 0; break;
		case SbxCHAR:
			nRes = p->nChar; break;
		case SbxBYTE:
			nRes = p->nByte; break;
		case SbxINTEGER:
		case SbxBOOL:
			nRes = p->nInteger; break;
		case SbxERROR:
		case SbxUSHORT:
			if( p->nUShort > (USHORT) SbxMAXINT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMAXINT;
			}
			else
				nRes = (INT16) p->nUShort;
			break;
		case SbxLONG:
			if( p->nLong > SbxMAXINT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMAXINT;
			}
			else if( p->nLong < SbxMININT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMININT;
			}
			else
				nRes = (INT16) p->nLong;
			break;
		case SbxULONG:
			if( p->nULong > SbxMAXINT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMAXINT;
			}
			else
				nRes = (INT16) p->nULong;
			break;
		case SbxSINGLE:
			if( p->nSingle > SbxMAXINT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMAXINT;
			}
			else if( p->nSingle < SbxMININT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMININT;
			}
			else
				nRes = (INT16) ImpRound( p->nSingle );
			break;
		case SbxDATE:
		case SbxDOUBLE:
		case SbxLONG64:
		case SbxULONG64:
		case SbxCURRENCY:
			{
			double dVal;
			if( p->eType ==	SbxCURRENCY )
				dVal = ImpCurrencyToDouble( p->nLong64 );
			else if( p->eType == SbxLONG64 )
				dVal = ImpINT64ToDouble( p->nLong64 );
			else if( p->eType == SbxULONG64 )
				dVal = ImpUINT64ToDouble( p->nULong64 );
			else
				dVal = p->nDouble;

			if( dVal > SbxMAXINT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMAXINT;
			}
			else if( dVal < SbxMININT )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMININT;
			}
			else
				nRes = (INT16) ImpRound( dVal );
			break;
			}
		case SbxLPSTR:
		case SbxSTRING:
		case SbxBYREF | SbxSTRING:
			if( !p->pString )
				nRes = 0;
			else
			{
				double d;
				SbxDataType t;
				if( ImpScan( *p->pString, d, t, NULL ) != SbxERR_OK )
					nRes = 0;
				else if( d > SbxMAXINT )
				{
					SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMAXINT;
				}
				else if( d < SbxMININT )
				{
					SbxBase::SetError( SbxERR_OVERFLOW ); nRes = SbxMININT;
				}
				else
					nRes = (INT16) ImpRound( d );
			}
			break;
		case SbxOBJECT:
		{
			SbxValue* pVal = PTR_CAST(SbxValue,p->pObj);
			if( pVal )
				nRes = pVal->GetInteger();
			else
			{
				SbxBase::SetError( SbxERR_NO_OBJECT ); nRes = 0;
			}
			break;
		}

		case SbxBYREF | SbxCHAR:
			nRes = *p->pChar; break;
		case SbxBYREF | SbxBYTE:
			nRes = *p->pByte; break;
		case SbxBYREF | SbxINTEGER:
		case SbxBYREF | SbxBOOL:
			nRes = *p->pInteger; break;

		// ab hier muss getestet werden
		case SbxBYREF | SbxLONG:
			aTmp.nLong = *p->pLong; goto ref;
		case SbxBYREF | SbxULONG:
			aTmp.nULong = *p->pULong; goto ref;
		case SbxBYREF | SbxERROR:
		case SbxBYREF | SbxUSHORT:
			aTmp.nUShort = *p->pUShort; goto ref;
		case SbxBYREF | SbxSINGLE:
			aTmp.nSingle = *p->pSingle; goto ref;
		case SbxBYREF | SbxDATE:
		case SbxBYREF | SbxDOUBLE:
			aTmp.nDouble = *p->pDouble; goto ref;
		case SbxBYREF | SbxULONG64:
			aTmp.nULong64 = *p->pULong64; goto ref;
		case SbxBYREF | SbxLONG64:
		case SbxBYREF | SbxCURRENCY:
			aTmp.nLong64 = *p->pLong64; goto ref;
		ref:
			aTmp.eType = SbxDataType( p->eType & 0x0FFF );
			p = &aTmp; goto start;

		default:
			SbxBase::SetError( SbxERR_CONVERSION ); nRes = 0;
	}
	return nRes;
}

void ImpPutInteger( SbxValues* p, INT16 n )
{
	SbxValues aTmp;
start:
	switch( p->eType )
	{
		// hier muss getestet werden
		case SbxCHAR:
			aTmp.pChar = &p->nChar; goto direct;
		case SbxBYTE:
			aTmp.pByte = &p->nByte; goto direct;
		case SbxULONG:
			aTmp.pULong = &p->nULong; goto direct;
		case SbxERROR:
		case SbxUSHORT:
			aTmp.pUShort = &p->nUShort;
		direct:
			aTmp.eType = SbxDataType( p->eType | SbxBYREF );
			p = &aTmp; goto start;

		// ab hier nicht mehr
		case SbxINTEGER:
		case SbxBOOL:
			p->nInteger = n; break;
		case SbxLONG:
			p->nLong = n; break;
		case SbxSINGLE:
			p->nSingle = n; break;
		case SbxDATE:
		case SbxDOUBLE:
			p->nDouble = n; break;
		case SbxULONG64:
			p->nULong64 = ImpDoubleToUINT64( (double)n ); break;
		case SbxLONG64:
			p->nLong64 = ImpDoubleToINT64( (double)n ); break;
		case SbxCURRENCY:
			p->nLong64 = ImpDoubleToCurrency( (double)n ); break;

		case SbxLPSTR:
		case SbxSTRING:
		case SbxBYREF | SbxSTRING:
			if( !p->pString )
				p->pString = new XubString;
			ImpCvtNum( (double) n, 0, *p->pString );
			break;
		case SbxOBJECT:
		{
			SbxValue* pVal = PTR_CAST(SbxValue,p->pObj);
			if( pVal )
				pVal->PutInteger( n );
			else
				SbxBase::SetError( SbxERR_NO_OBJECT );
			break;
		}
		case SbxBYREF | SbxCHAR:
			if( n > SbxMAXCHAR )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); n = SbxMAXCHAR;
			}
			else if( n < SbxMINCHAR )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); n = SbxMINCHAR;
			}
			*p->pChar = (char) n; break;
		case SbxBYREF | SbxBYTE:
			if( n > SbxMAXBYTE )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); n = SbxMAXBYTE;
			}
			else if( n < 0 )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); n = 0;
			}
			*p->pByte = (BYTE) n; break;
		case SbxBYREF | SbxINTEGER:
		case SbxBYREF | SbxBOOL:
			*p->pInteger = n; break;
		case SbxBYREF | SbxERROR:
		case SbxBYREF | SbxUSHORT:
			if( n < 0 )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); n = 0;
			}
			*p->pUShort = (UINT16) n; break;
		case SbxBYREF | SbxLONG:
			*p->pLong = (INT32) n; break;
		case SbxBYREF | SbxULONG:
			if( n < 0 )
			{
				SbxBase::SetError( SbxERR_OVERFLOW ); n = 0;
			}
			*p->pULong = (UINT32) n; break;
		case SbxBYREF | SbxSINGLE:
			*p->pSingle = (float) n; break;
		case SbxBYREF | SbxDATE:
		case SbxBYREF | SbxDOUBLE:
			*p->pDouble = (double) n; break;
		case SbxBYREF | SbxULONG64:
			*p->pULong64 = ImpDoubleToUINT64( (double)n ); break;
		case SbxBYREF | SbxLONG64:
			*p->pLong64 = ImpDoubleToINT64( (double)n ); break;
		case SbxBYREF | SbxCURRENCY:
			*p->pLong64 = ImpDoubleToCurrency( (double)n ); break;

		default:
			SbxBase::SetError( SbxERR_CONVERSION );
	}
}

