/*************************************************************************
 *
 *  $RCSfile: charmap.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hdu $ $Date: 2001/08/14 17:25:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_CHARMAP_HXX
#define _SVX_CHARMAP_HXX

// include ---------------------------------------------------------------

#ifndef _SV_CTRL_HXX
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_METRIC_HXX
#include <vcl/metric.hxx>
#endif
#ifndef _SV_SCRBAR_HXX
#include <vcl/scrbar.hxx>
#endif

#ifndef _BASEDLGS_HXX
#include <sfx2/basedlgs.hxx>
#endif

class SubsetMap;
class SvxCharMapData;

// define ----------------------------------------------------------------

#ifdef MAC
#define CHARMAP_MAXLEN  28
#define COLUMN_COUNT    28
#define ROW_COUNT        8
#else
#define CHARMAP_MAXLEN  32
#define COLUMN_COUNT    16
#define ROW_COUNT        8
#endif

// class SvxShowCharSet --------------------------------------------------

class SvxShowCharSet : public Control
{
public:
					SvxShowCharSet( Window* pParent, const ResId& rResId );
					~SvxShowCharSet();

	void            SetFont( const Font& rFont );

	void            SelectCharacter( sal_Unicode cNew, BOOL bFocus = FALSE );
	sal_Unicode     GetSelectCharacter() const;

	Link            GetDoubleClickHdl() const { return aDoubleClkHdl; }
	void			SetDoubleClickHdl( const Link& rLink ) { aDoubleClkHdl = rLink; }
	Link            GetSelectHdl() const { return aSelectHdl; }
	void            SetSelectHdl( const Link& rHdl ) { aSelectHdl = rHdl; }
	Link            GetHighlightHdl() const { return aHighHdl; }
	void            SetHighlightHdl( const Link& rHdl )	{ aHighHdl = rHdl; }
	Link            GetPreSelectHdl() const { return aHighHdl; }
	void            SetPreSelectHdl( const Link& rHdl )	{ aPreSelectHdl = rHdl; }
protected:
	virtual void    Paint( const Rectangle& );
	virtual void    MouseButtonDown( const MouseEvent& rMEvt );
	virtual void    MouseButtonUp( const MouseEvent& rMEvt );
	virtual void    MouseMove( const MouseEvent& rMEvt );
	virtual void    Command( const CommandEvent& rCEvt );
	virtual void    KeyInput( const KeyEvent& rKEvt );
	virtual void    GetFocus();
	virtual void    LoseFocus();
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );

private:
	Link            aDoubleClkHdl;
	Link            aSelectHdl;
	Link            aHighHdl;
	Link			aPreSelectHdl;
	long	        nX;
	long			nY;
	BOOL            bDrag;

	static long		nSelectedIndex;     // TODO: remove "static" at next incompatible build

    FontCharMap     maFontCharMap;
    ScrollBar       aVscrollSB;
    Size            aOrigSize;
    Point           aOrigPos;

private:
    void            DrawChars_Impl( int n1, int n2);
    void            InitSettings( BOOL bForeground, BOOL bBackground);

    void            SelectIndex( int index, BOOL bFocus = FALSE );

    // abstraction layers are: Unicode<->MapIndex<->Pixel
    Point           MapIndexToPixel( int) const;
    int             PixelToMapIndex( const Point) const;

    int             FirstInView( void) const;
    int             LastInView( void) const;

#if _SOLAR__PRIVATE
	DECL_LINK( VscrollHdl, ScrollBar* );
#endif
};

// class SvxCharacterMap -------------------------------------------------
// the main purpose of this dialog is to enable the use of characters
// that are not easily accesible from the keyboard

class SvxCharacterMap : public SfxModalDialog
{
private:
    SvxCharMapData* const mpCharMapData;

public:
                    SvxCharacterMap( Window* pParent, BOOL bOne = TRUE );
                    ~SvxCharacterMap();

    void            DisableFontSelection();

    const Font&     GetCharFont() const;
    void            SetCharFont( const Font& rFont );
    void            SetFont( const Font& rFont ) { SetCharFont( rFont ); } //! irgendwann entfernen

    void            SetChar( sal_Unicode c );
    sal_Unicode     GetChar() const;

    String          GetCharacters() const;
};

#endif

