/*************************************************************************
 *
 *  $RCSfile: ctrdial.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pb $ $Date: 2001/07/10 10:27:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <math.h>
#pragma hdrstop

#include "ctrdial.hxx"

#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#ifndef _SV_SYSTEM_HXX
#include <vcl/system.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

void SvxCtrDialBmp::DrawBackground( BOOL bEnabled )
{
    SetLineColor();
    SetFillColor( aBgColor );
    DrawRect( aDrawRect );
}

void SvxCtrDialBmp::DrawShadow( BOOL bEnabled )
{
    SetLineColor();

    BYTE nDiff = bEnabled ? 0x18 : 0x10;
    Color aColor( aBgColor );
    aColor.DecreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.BottomCenter(), aDrawRect.TopRight() );

    aColor.DecreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.BottomRight(), aDrawRect.RightCenter() );

    aColor = aBgColor;
    aColor.IncreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.TopCenter(), aDrawRect.BottomLeft() );

    aColor.IncreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.TopLeft(), aDrawRect.LeftCenter() );
}

void SvxCtrDialBmp::DrawCalibration( BOOL bEnabled )
{
    Point aStartPos( nCenterX, nCenterY );
    Point aPos;
    BYTE nDiff = bEnabled ? 0x18 : 0x10;
    BYTE nStart = bEnabled ? 0x70 : 0x90;
    double fAlpha;
    short nX, nY;

    for( short nAng = 0; nAng < 360; nAng += 15 )
	{
        if( !bEnabled || (nAng % 45) )
        {
            BYTE nComp = (BYTE)((180 - Abs( 158 - nAng )) * nDiff / 45 + nStart);
            SetLineColor( Color( nComp, nComp, nComp ) );
        }
        else
            SetLineColor( Color( COL_BLACK ) );
        fAlpha = nAng * F_PI180;
        nX = (short)( -nCenterX * cos( fAlpha ) );
        nY = (short)( nCenterY * sin( fAlpha ) );
        if( nY > 0 ) nY++;
        aPos = Point( nCenterX - nX, nCenterY - nY );
        DrawLine( aStartPos, aPos );
	}

    Rectangle a4Rect( aDrawRect.Left() + 8, aDrawRect.Top() + 8,
                      aDrawRect.Right() - 8, aDrawRect.Bottom() - 8);
    SetLineColor();
    SetFillColor( aBgColor );
    DrawEllipse( a4Rect );

    SetFillColor();
    SetLineColor( Color( bEnabled ? COL_WHITE : RGB_COLORDATA( 0xF0, 0xF0, 0xF0 ) ) );
    DrawArc( a4Rect, a4Rect.BottomLeft(), a4Rect.TopRight() );
    DrawArc( aDrawRect, aDrawRect.TopRight(), aDrawRect.BottomLeft() );
    SetLineColor( Color( bEnabled ? COL_BLACK : COL_GRAY ) );
    DrawArc( a4Rect, a4Rect.TopRight(), a4Rect.BottomLeft() );
    DrawArc( aDrawRect, aDrawRect.BottomLeft(), aDrawRect.TopRight() );
}

void SvxCtrDialBmp::InitBitmap( const Size& rSize, const Color& rBackgr )
{
    aDrawRect.SetPos( Point() );
    aDrawRect.SetSize( rSize );
    aBgColor = rBackgr;
    nCenterX = rSize.Width() / 2;
    nCenterY = rSize.Height() / 2;
    SetOutputSize( rSize );
    SetBackground();
    SetFillColor( aBgColor );
}

void SvxCtrDialBmp::InitBitmap( const Size& rSize, const Color& rBackgr, const Font& rFont )
{
    InitBitmap( rSize, rBackgr );
    SetFont( rFont );
}

void SvxCtrDialBmp::DrawBackgrBitmap( const Size& rSize, const Color& rBackgr, BOOL bEnabled )
{
    InitBitmap( rSize, rBackgr );
    DrawBackground( bEnabled );
    DrawShadow( bEnabled );
    DrawCalibration( bEnabled );
}

void SvxCtrDialBmp::DrawBackgrBitmap( const SvxCtrDialBmp& rSrc )
{
    DrawBitmap( Point(), rSrc.GetBitmap( Point(), aDrawRect.GetSize() ) );
}

void SvxCtrDialBmp::DrawElements( const String& rText, short nDelta, BOOL bEnabled )
{
    Font aFont = GetFont();
    aFont.SetColor( Color( bEnabled ? COL_BLUE : COL_GRAY ) );
    aFont.SetOrientation( nDelta );
    SetFont( aFont );

    double fAlpha = nDelta * F_PI1800;
    double fWidth = GetTextWidth( rText ) / 2;
    double fHeight = GetTextHeight() / 2;
    Point aPos( (short)(nCenterX - fWidth * cos( fAlpha ) - fHeight * sin( fAlpha )),
                (short)(nCenterY + fWidth * sin( fAlpha ) - fHeight * cos( fAlpha )) );
    DrawText( aPos, rText );

    short nX = (short)((4 - nCenterX) * cos( fAlpha ));
    short nY = (short)((nCenterY - 4) * sin( fAlpha ));
    aPos.X() = nCenterX - nX;
    aPos.Y() = nCenterY - nY;
    short nSize = (nDelta % 450) ? 2 : 3;
    SetLineColor( Color( bEnabled ? COL_BLACK : COL_GRAY ) );
    SetFillColor( Color( bEnabled ? ((nDelta % 450) ? COL_BLUE : COL_YELLOW ) : COL_GRAY ) );
    DrawEllipse( Rectangle( aPos.X() - nSize, aPos.Y() - nSize,
                            aPos.X() + nSize, aPos.Y() + nSize ) );
}


/*************************************************************************
#*	Member:		SvxCtrDial										Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Konstruktor der Klasse SvxCtrDial
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

SvxCtrDial::SvxCtrDial( Window* pParent,Size aSize, WinBits nWinStyle) :
                        Control( pParent, nWinStyle )
{
    aWinSize = aSize;
    if( pParent )
	{
        aRotFont = pParent->GetFont();
        aBgColor = pParent->GetBackground().GetColor();
	}
    Init();
}

/*************************************************************************
#*	Member:		SvxCtrDial									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Konstruktor der Klasse SvxCtrDial
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

SvxCtrDial::SvxCtrDial( Window* pParent,Size aSize, Font aFont, WinBits nWinStyle) :
                    Control( pParent, nWinStyle )
{
    aWinSize = aSize;
    aRotFont = aFont;
    if( pParent )
        aBgColor = pParent->GetBackground().GetColor();
    Init();
}

/*************************************************************************
#*	Member:		SvxCtrDial									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		MD_Test
#*
#*  Funktion:	Konstruktor der Klasse SvxCtrDial
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

SvxCtrDial::SvxCtrDial( Window* pParent, const ResId& rResId) :
                    Control( pParent, rResId )
{
    aWinSize = GetOutputSizePixel();
    aRotFont = OutputDevice::GetDefaultFont(
		DEFAULTFONT_UI_SANS, Application::GetSettings().GetUILanguage(), DEFAULTFONT_FLAGS_ONLYONE );
    if( pParent )
		aBgColor = pParent->GetBackground().GetColor();
    Init();
}

/*************************************************************************
#*  Member:     Init                                        Datum:16.05.01
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:   common constructor instructions
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::Init()
{
	nDelta = 0;
    aRotFont.SetTransparent( TRUE );
    SetOutputSizePixel( aWinSize );
    nCenterX = aWinSize.Width() / 2;
    nCenterY = aWinSize.Height() / 2;
    SetBackground();
    aEnabledBmp.DrawBackgrBitmap( aWinSize, aBgColor, TRUE );
    aDisabledBmp.DrawBackgrBitmap( aWinSize, aBgColor, FALSE );
    aBufferBmp.InitBitmap( aWinSize, aBgColor, aRotFont );
}

/*************************************************************************
#*	Member:		Paint										Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Aktualisiert den Control und zeichnet den
#*				gedrehten Text.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::Paint( const Rectangle& aRect )
{
    DrawBitmap( Point(), aBufferBmp.GetBitmap( Point(), aWinSize ) );
}

/*************************************************************************
#*  Member:     Invalidate                                  Datum:16.05.01
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Aktualisiert den Control und zeichnet den
#*				gedrehten Text.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::Invalidate()
{
    aBufferBmp.DrawBackgrBitmap( IsEnabled() ? aEnabledBmp : aDisabledBmp );
    aBufferBmp.DrawElements( GetText(), nDelta, IsEnabled() );
    Control::Invalidate();
}

/*************************************************************************
#*	Member:		KeyInput									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert auf die Tasten '+' und '-'. Dadurch
#*				kann der Text gradweise gedreht werden.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::KeyInput( const KeyEvent& rKeyEvt )
{
	Size aSize(10,10);

	switch( rKeyEvt.GetCharCode() )
	{

		case '+':

				nDelta+=10;
				if(nDelta>3590) nDelta=0;
				break;

		case '-':

				nDelta-=10;
				if(nDelta<0) nDelta=3590;
				break;

		default:

		Control::KeyInput( rKeyEvt );
		return;
		break;
	}
	Invalidate();
	Update();

}

/*************************************************************************
#*	Member:		MouseButtonDown								Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert auf einen einzelnen Mouse-Event. Hierbei
#*				wird die aktuelle Maus- Koordinate ermittelt und
#*				der entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::MouseButtonDown( const MouseEvent& rMEvt )
{
	double x;
	double y;
	double h,h1;
	double nAlpha;
	Point aPos=rMEvt.GetPosPixel();

	CaptureMouse();

	if(rMEvt.IsLeft())
	{
		x=aPos.X()-nCenterX;
		y=nCenterY-aPos.Y();

		h=sqrt(x*x+y*y);

		if(h!=0)
		{
            h1 = acos( x / h );
            nAlpha = h1 / F_PI1800;
			if(y>=0)
			{
				nDelta=(short) (150.*floor(nAlpha/150.+0.5));
			}
			else
			{
				nDelta=(short) (150.*floor((3600-nAlpha)/150.+0.5));
			}
			if(nDelta==3600) nDelta=0;
		}

		Invalidate();
		Update();
		CtrModified();
	}
	Control::MouseButtonDown(rMEvt );
}

/*************************************************************************
#*	Member:		MouseButtonUp								Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Ende einer Benutzeraktion mit der Maus. Es werden
#*				die aktuelle Maus- Koordinate ermittelt und der
#*				entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::MouseButtonUp( const MouseEvent& rMEvt )
{
	ReleaseMouse();

	Control::MouseButtonUp(rMEvt );
	CtrMouseUp();
}

/*************************************************************************
#*	Member:		MouseMove									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert kontinuierlich auf Mausbewegungen. Hierbei
#*				wird die aktuelle Maus- Koordinate ermittelt und
#*				der entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::MouseMove( const MouseEvent& rMEvt )
{
	double x;
	double y;
	double h,h1;
	double nAlpha;
	Point aPos=rMEvt.GetPosPixel();

	if(rMEvt.IsLeft() && IsMouseCaptured())
	{
		x=aPos.X()-nCenterX;
		y=nCenterY-aPos.Y();

		h=sqrt(x*x+y*y);

		if(h!=0)
		{
			h1=acos(x/h);
            nAlpha= h1 / F_PI1800;
			if(y>=0)
			{
				nDelta=(short) floor(nAlpha+0.5);
			}
			else
			{
				nDelta=(short) floor(3600.5-nAlpha);
			}
			if(nDelta==3600) nDelta=0;
		}
		Invalidate();
		Update();
		CtrModified();
	}
	Control::MouseMove(rMEvt );

}

/*************************************************************************
#*	Member:		MouseMove									Datum:09.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert kontinuierlich auf Mausbewegungen. Hierbei
#*				wird die aktuelle Maus- Koordinate ermittelt und
#*				der entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
USHORT SvxCtrDial::GetOrientation()
{
	return (USHORT ) nDelta/10;
}

/*************************************************************************
#*	Member:		MouseMove									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert kontinuierlich auf Mausbewegungen. Hierbei
#*				wird die aktuelle Maus- Koordinate ermittelt und
#*				der entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void SvxCtrDial::SetOrientation(short nAlpha)
{
	if(nAlpha>360)
	{
		nAlpha=nAlpha % 360;
	}
	else if(nAlpha<0)
	{
		nAlpha=nAlpha % 360;
		nAlpha=360+nAlpha;
	}

	nDelta=nAlpha*10;
	Invalidate();
	Update();
}

/*************************************************************************
#*	Member:		CtrModified									Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				eine Veraenderung eingetreten ist.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void SvxCtrDial::CtrModified()
{
	aCtrModifiedLink.Call( this );
}

/*************************************************************************
#*	Member:		CtrModified									Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus losgelassen wurde.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void SvxCtrDial::CtrMouseUp()
{
	aMouseUpLink.Call( this );
}


