/*************************************************************************
 *
 *  $RCSfile: nforient.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop
#include "nforient.hxx"

#define ORIENT_SPIN 1

/*************************************************************************
#*	Member:		SvxOrientationField							Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Konstruktor der Klasse SvxOrientationField
#*
#*  Input:		Parent-Window, WinBits, min. Winkel, max. Winkel
#*
#*	Output:		---
#*
#************************************************************************/

SvxOrientationField::SvxOrientationField( Window* pParent, WinBits nWinStyle,
									short nMin, short nMax)
:NumericField(pParent,nWinStyle)
{
	SetStrictFormat(TRUE);
	nDelta=0;
	nLastDelta=0;
	SetSpinSize(ORIENT_SPIN);
	nSpSize=ORIENT_SPIN;
	nCount=0;
	fDirection=0;
	nMinDelta=nMin;
	nMaxDelta=nMax;
	SetFirst(nMinDelta);
	SetLast(nMaxDelta);
}

/*************************************************************************
#*	Member:		SvxOrientationField							Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Konstruktor der Klasse SvxOrientationField
#*
#*  Input:		Parent-Window, Resource, min. Winkel, max. Winkel
#*
#*	Output:		---
#*
#************************************************************************/

SvxOrientationField::SvxOrientationField( Window* pWindow, const ResId& rResId,
									short nMin, short nMax)
:NumericField(pWindow,rResId)
{
	SetStrictFormat(TRUE);
	nDelta=0;
	nLastDelta=0;
	SetSpinSize(ORIENT_SPIN);
	nSpSize=ORIENT_SPIN;
	nCount=0;
	fDirection=0;
	nMinDelta=nMin;
	nMaxDelta=nMax;
	SetFirst(nMinDelta);
	SetLast(nMaxDelta);
}

/*************************************************************************
#*	Member:		Up											Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Funktion, die aufgerufen wird, wenn der Spin-Button 'Up'
#*				ausgeloest wird. Sorgt fuer das dynamische Zaehlverhalten.
#*				Wenn der Max- Wert ueberschritten wird, so wird der Min-
#*				Wert eingestellt.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxOrientationField::Up()
{
	if(nCount>10)
	{
		nCount=10;
		SetSpinSize(nSpSize*10);
	}

	NumericField::Up();

	if(nDelta>nMaxDelta)
	{
		SetSpinSize(nSpSize);
		nDelta=nMinDelta;
		SetText( UniString::CreateFromInt32( sal_Int32( nDelta ) ) );
		nCount=0;
	}

	fDirection=1;
	nCount++;
	CtrPrivatModify();
}

/*************************************************************************
#*	Member:		Down										Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Funktion, die aufgerufen wird, wenn der Spin-Button 'Down'
#*				ausgeloest wird. Sorgt fuer das dynamische Zaehlverhalten.
#*				Wenn der Min- Wert unterschritten wird, so wird der Max-
#*				Wert eingestellt.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxOrientationField::Down()
{
	if(nCount>10)
	{
		nCount=10;
		SetSpinSize(nSpSize*10);
	}

	NumericField::Down();

	if(nDelta==nMinDelta && nDelta==nLastDelta)
	{
		nCount=0;
		SetSpinSize(nSpSize);
		nDelta=nMaxDelta;
		SetText( UniString::CreateFromInt32( sal_Int32( nDelta ) ) );
	}

	fDirection=-1;
	nCount++;
	CtrPrivatModify();

}


/*************************************************************************
#*	Member:		MouseButtonUp								Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Funktion, die aufgerufen wird, wenn der Mouse-Button los-
#*				gelasssen wird. Sorgt dafuer, dass wieder in Einer-Schritten
#*				gezaehlt wird.
#*
#*  Input:		MouseEvent
#*
#*	Output:		---
#*
#************************************************************************/

void SvxOrientationField::MouseButtonUp( const MouseEvent& rMEvt )
{
	SetSpinSize(nSpSize);
	if(nCount>10)
	{
		nCount=0;
		if(fDirection==1)
		{
			Down();
		}
		else
		{
			if(fDirection==-1)
			{
				Up();
			}
		}
		fDirection=0;
	}
	NumericField::MouseButtonUp(rMEvt);
}


/*************************************************************************
#*	Member:		KeyInput									Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Funktion, die aufgerufen wird, wenn eine Taste gedrueckt
#*				wurde. Sorgt dafuer, dass wieder in Einer-Schritten
#*				gezaehlt wird.
#*
#*  Input:		KeyEvent
#*
#*	Output:		---
#*
#************************************************************************/

void SvxOrientationField::KeyInput( const KeyEvent& rKEvt )
{
	nCount=0;
	SetSpinSize(nSpSize);

	NumericField::KeyInput(rKEvt);
}

/*************************************************************************
#*	Member:		Modify										Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Wird aufgerufen, wenn das Editfeld geaendert wurde.
#*				Es werden die letzten beiden Werte gespeichert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxOrientationField::Modify()
{
	NumericField::Modify();
	nLastDelta=nDelta;
	nDelta=(short)GetText().ToInt32();
	CtrPrivatModify();
}


/*************************************************************************
#*	Member:		GetOrientation								Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Liefert den angezeigten Zahlenwert zurueck.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

short SvxOrientationField::GetOrientation()
{
	short retval;
	String aNumString=GetText();
	retval=(short)aNumString.ToInt32();

	return retval;
}


/*************************************************************************
#*	Member:		SetOrientation								Datum:10.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxOrientationField
#*
#*  Funktion:	Stellt den Zahlenwert ein.
#*
#*  Input:		Zahlenwert
#*
#*	Output:		---
#*
#************************************************************************/

void SvxOrientationField::SetOrientation(short nAlpha)
{
	SetText( UniString::CreateFromInt32( sal_Int32( nAlpha ) ) );
}



/*************************************************************************
#*	Member:		CtrModified									Datum:20.10.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				eine Veraenderung eingetreten ist.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void SvxOrientationField::CtrPrivatModify()
{
	aPrivModifyLink.Call( this );
}


