/*************************************************************************
 *
 *  $RCSfile: paractrl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------
#include "segmentc.hxx"
#pragma hdrstop

#include "paractrl.hxx"
#include "paragrph.hxx"

SEG_EOFGLOBALS()

// class SvxParagraphControllerItem --------------------------------------
#pragma SEG_SEGCLASS(paractrl_SEG,paractrl_CODE)


SvxParagraphControllerItem::SvxParagraphControllerItem( USHORT nId,
											SvxExtParagraphTabPage& rPage ) :
	SfxControllerItem( nId ),
	rParaPage( rPage )
{
}

// -----------------------------------------------------------------------

void SvxParagraphControllerItem::StateChanged( USHORT nSID, SfxItemState,
											   const SfxPoolItem* )
{
	if ( pState->Which() == nSID )
	{
		SfxObjectShell* pShell = SfxObjectShell::Current();
		if ( pShell && pShell->GetStyleSheetPool() )
			rParaPage.StylesheetsChanged( *pShell->GetStyleSheetPool() );
	}
}

/*************************************************************************

	  Source Code Control System - Update

	  $Log: paractrl.cxx,v $
	  Revision 1.1.1.1  2000/09/18 17:01:10  hr
	  initial import
	
	  Revision 1.7  2000/09/18 12:42:11  willem.vandorp
	  OpenOffice header added.
	
	  Revision 1.6  2000/08/31 08:51:13  willem.vandorp
	  Header and footer replaced
	
	  Revision 1.5  1995/11/17 09:39:02  MI
	  StateChanged
	

	  Rev 1.4   17 Nov 1995 10:39:02   MI
   StateChanged

	  Rev 1.3   06 Nov 1995 20:27:10   MH
   301-Anpassungen

	  Rev 1.2   08 Sep 1995 19:34:26   OG
   hart_segmentiert

	  Rev 1.1   18 Aug 1995 20:28:16   HJS
   anpassungen fuer die 254

	  Rev 1.0   03 Feb 1995 19:06:52   PB
   Initial revision.

*************************************************************************/

#pragma SEG_EOFMODULE

