/*************************************************************************
 *
 *  $RCSfile: worient.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dr $ $Date: 2001/05/16 11:52:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop
#include "worient.hxx"

/*************************************************************************
#*	Member:		SvxWinOrientation							Datum:12.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Konstruktor der Klasse SvxWinOrientation
#*
#*  Input:		Parent- Window, Resourcen
#*
#*	Output:		---
#*
#************************************************************************/

SvxWinOrientation::SvxWinOrientation( Window * pParent,
					const ResId & rResIdForCtrDial,
					const ResId & rResIdForImageButton,
					const ResId & rResIdForFixedText,
					const ResId & rResIdForOrientField,
					const ResId & rResIdForVSLockModeLabel,
					const ResId & rResIdForVSLockMode,
                    const ResId & rResIdForFixedLine)
	: Link(),
	aCtrDial( pParent,rResIdForCtrDial),
	aOrientFieldLabel( pParent, rResIdForFixedText),
	aOrientField(pParent, rResIdForOrientField),
	aBtnTxtStacked	( pParent, rResIdForImageButton),
	aVSLockModeLabel( pParent, rResIdForVSLockModeLabel),
	aVSLockMode( pParent, rResIdForVSLockMode),
    aFlAlign( pParent, rResIdForFixedLine)

{
	bFlagEnabled=TRUE;
	Link aLink=LINK( this, SvxWinOrientation, OrientModifyHdl );
	Link a2Link=LINK( this, SvxWinOrientation, LostActiveHdl );
	// Mit Handler verbinden
	aCtrDial.SetCtrModifiedHdl( aLink);
	aCtrDial.SetMouseUpHdl(a2Link);
	aOrientField.SetPrivatModifyHdl( aLink);
	aOrientField.SetLoseFocusHdl(a2Link);
	aBtnTxtStacked.SetClickHdl( aLink);

	OrientModifyHdl( NULL );
}


/*************************************************************************
#*	Member:		Enable										Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Aktivieren der Controls
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxWinOrientation::Enable()
{
	if(bFlagEnabled!=TRUE)
	{
		bFlagEnabled=TRUE;
		aCtrDial.Enable();
		aCtrDial.Invalidate();
		aBtnTxtStacked.Enable();
		aOrientFieldLabel.Enable();
		aOrientField.Enable();
		aVSLockModeLabel.Enable();
		aVSLockMode.Enable();
        aFlAlign.Enable();
	}
}

/*************************************************************************
#*	Member:		Disable										Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Aktivieren der Controls
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxWinOrientation::Disable()
{
	if(bFlagEnabled!=FALSE)
	{
		bFlagEnabled=FALSE;
		aCtrDial.Disable();
		aCtrDial.Invalidate();
		aBtnTxtStacked.Disable();
		aOrientFieldLabel.Disable();
		aOrientField.Disable();
		aVSLockModeLabel.Disable();
		aVSLockMode.Disable();
        aFlAlign.Disable();
	}
}

/*************************************************************************
#*	Member:		Disable										Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Liefert den Status der Controls zurueck.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

BOOL SvxWinOrientation::IsEnabled()
{
	return bFlagEnabled;
}

/*************************************************************************
#*	Member:		IsStackedTxt								Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Liefert zurueck, ob der Anwender den
#*				Stacked-Text-Button eingeschaltet hat
#*
#*  Input:		---
#*
#*	Output:		On or Off
#*
#************************************************************************/

BOOL SvxWinOrientation::IsStackedTxt()
{
	return aBtnTxtStacked.IsChecked();
}

/*************************************************************************
#*	Member:		SetStackedTxt								Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion kann die Schaltflaeche
#*				fuer Stacked - Text ein oder aus geschaltet
#*				werden.
#*
#*  Input:		On or Off
#*
#*	Output:		---
#*
#************************************************************************/

void SvxWinOrientation::SetStackedTxt(BOOL bOnOff)
{
	aBtnTxtStacked.Check(bOnOff);
	if(bOnOff==TRUE || !aBtnTxtStacked.IsEnabled())
	{
		aCtrDial.Disable();
		aCtrDial.Invalidate();
		aOrientFieldLabel.Disable();
		aOrientField.Disable();
		aVSLockModeLabel.Disable();
		aVSLockMode.Disable();
	}
	else
	{
		aCtrDial.Enable();
		aCtrDial.Invalidate();
		aOrientFieldLabel.Enable();
		aOrientField.Enable();
		aVSLockModeLabel.Enable();
		aVSLockMode.Enable();
	}


}

/*************************************************************************
#*	Member:		SetDegrees									Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion kann der Drehwinkel
#*				eingestellt werden.
#*
#*  Input:		Winkel
#*
#*	Output:		---
#*
#************************************************************************/

void SvxWinOrientation::SetDegrees(short alpha)
{
	aCtrDial.SetOrientation(alpha);
	aOrientField.SetText( UniString::CreateFromInt32( alpha ) );
}

/*************************************************************************
#*	Member:		GetDegrees									Datum:15.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion kann der Drehwinkel
#*				ausgelesen werden.
#*
#*  Input:		---
#*
#*	Output:		Winkel
#*
#************************************************************************/

short SvxWinOrientation::GetDegrees()
{
	return aCtrDial.GetOrientation();
}

/*************************************************************************
#*	Member:		GetRotateMode								Datum:16.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion kann die Bezugskante
#*				ausgelesen werden.
#*
#*  Input:		---
#*
#*	Output:		Winkel
#*
#************************************************************************/
SvxRotateMode SvxWinOrientation::GetRotateMode()
{
	SvxRotateMode nRetVal;
	USHORT	nSelId	= aVSLockMode.GetSelectItemId();

	switch(nSelId)
	{
		case 1:		nRetVal=SVX_ROTATE_MODE_BOTTOM; break;
		case 2:		nRetVal=SVX_ROTATE_MODE_TOP; break;
		default:	nRetVal=SVX_ROTATE_MODE_STANDARD; break;
	}
	return nRetVal;
}

/*************************************************************************
#*	Member:		SetRotateMode								Datum:16.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion kann die Bezugskante
#*				eingestellt werden.
#*
#*  Input:		---
#*
#*	Output:		Winkel
#*
#************************************************************************/
void SvxWinOrientation::SetRotateMode(SvxRotateMode nVal)
{
	short nItem;

	switch(nVal)
	{
		case SVX_ROTATE_MODE_BOTTOM:	nItem=1; break;
		case SVX_ROTATE_MODE_TOP:		nItem=2; break;
		default:						nItem=3; break;
	}
	aVSLockMode.SelectItem( nItem );
}

/*************************************************************************
#*	Member:		GetDegrees									Datum:16.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion wird die Klasse aVSLockMode
#*				nach aussen gereicht, um Manipulationsmoeglichkeiten
#*				zu geben.
#*
#*  Input:		---
#*
#*	Output:		Klasse aVSLockMode
#*
#************************************************************************/

ValueSet& SvxWinOrientation::GetVSLockMode()
{
	return aVSLockMode;
}

/*************************************************************************
#*	Member:		IsSelRotateMode								Datum:16.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Mit dieser Funktion wird getestet, ob in aVSLockMode
#*				ein Feld ausgewaehlt ist.
#*
#*  Input:		---
#*
#*	Output:		Klasse aVSLockMode
#*
#************************************************************************/

BOOL SvxWinOrientation::IsSelRotateMode()
{
	return !aVSLockMode.IsNoSelection();
}

/*************************************************************************
#*	Handler:	MyModifyHdl									Datum:12.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Modify- Handler fuer SvxWinOrientation
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( SvxWinOrientation, OrientModifyHdl, void *, ctrPtr)
{
	short rot;
	if(ctrPtr!=NULL)
	{
		if(	&aCtrDial==ctrPtr)
		{
			aOrientField.SetText( UniString::CreateFromInt32( aCtrDial.GetOrientation() ) );
		}
		else
		{
			if(	&aOrientField==ctrPtr)
			{
				rot=aOrientField.GetText().ToInt32();
				aCtrDial.SetOrientation(rot);
				aCtrDial.Invalidate();
				aCtrDial.Update();
			}
			else
			{
				if(ctrPtr==&aBtnTxtStacked)
				{
					if ( aBtnTxtStacked.IsChecked() )
					{
						aBtnTxtStacked.Check( FALSE );
						aCtrDial.Enable();
						aCtrDial.Invalidate();
						aOrientFieldLabel.Enable();
						aOrientField.Enable();
						aVSLockModeLabel.Enable();
						aVSLockMode.Enable();
					}
					else
					{
						aBtnTxtStacked.Check();
						aCtrDial.Disable();
						aCtrDial.Invalidate();
						aOrientFieldLabel.Disable();
						aOrientField.Disable();
						aVSLockModeLabel.Disable();
						aVSLockMode.Disable();
					}
				}
			}
		}
	}
	return( 0L );
}

/*************************************************************************
#*	Handler:	MyModifyHdl									Datum:12.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Lose- Handler fuer SvxWinOrientation
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( SvxWinOrientation, LostActiveHdl, void *, ctrPtr)
{
	if((SvxCtrDial *)ctrPtr==&aCtrDial)
	{
		aOrientField.GrabFocus();
	}
	else if((SvxOrientationField *)ctrPtr==&aOrientField)
	{
		aOrientField.SetText( UniString::CreateFromInt32( aCtrDial.GetOrientation() ) );
	}
	return( 0L );
}


