/*************************************************************************
 *
 *  $RCSfile: tbxdraw.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2001/07/11 13:27:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#pragma hdrstop

#include "tbxdraw.hxx"
#include "tbxctl.hxx"
#include "tbxdraw.hrc"

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::Ctor()
|*
\************************************************************************/

SvxPopupWindowTbxMgr::SvxPopupWindowTbxMgr
(
	USHORT nId,
	SfxToolBoxControl* pTbxCtl,
	ResId aRIdWin,
	ResId aRIdTbx,
	SfxBindings& rBindings
) :

	SfxPopupWindow( nId, aRIdWin, rBindings ),

	aTbx		( this, GetBindings(), aRIdTbx ),
	aRIdWinTemp	( aRIdWin ),
	aRIdTbxTemp	( aRIdTbx )

{
	aTbx.UseDefault();
	FreeResource();

	if ( pTbxCtl && pTbxCtl->GetToolBox().IsHorizontal() )
	{
	   aTbx.GetToolBox().SetAlign( WINDOWALIGN_LEFT );
	   SetText( String() );
	}

	Size aSize = aTbx.CalcWindowSizePixel();
	aTbx.SetPosSizePixel( Point(), aSize );
	SetOutputSizePixel( aSize );
	aTbx.GetToolBox().SetSelectHdl(
		LINK( this, SvxPopupWindowTbxMgr, TbxSelectHdl ) );
	aTbxClickHdl = aTbx.GetToolBox().GetClickHdl();
	aTbx.GetToolBox().SetClickHdl(
		LINK( this, SvxPopupWindowTbxMgr, TbxClickHdl ) );
}

// -----------------------------------------------------------------------

SvxPopupWindowTbxMgr::SvxPopupWindowTbxMgr
(
	USHORT nId,
	WindowAlign eAlign,
	ResId aRIdWin,
	ResId aRIdTbx,
	SfxBindings& rBindings
) :

	SfxPopupWindow( nId, aRIdWin, rBindings),

	aTbx		( this, GetBindings(), aRIdTbx ),
	aRIdWinTemp	( aRIdWin ),
	aRIdTbxTemp	( aRIdTbx )

{
	aTbx.UseDefault();
	FreeResource();

	aTbx.GetToolBox().SetAlign( eAlign );
	if ( eAlign == WINDOWALIGN_LEFT )
	   SetText( String() );

	Size aSize = aTbx.CalcWindowSizePixel();
	aTbx.SetPosSizePixel( Point(), aSize );
	SetOutputSizePixel( aSize );
	aTbx.GetToolBox().SetSelectHdl(
		LINK( this, SvxPopupWindowTbxMgr, TbxSelectHdl ) );
	aTbxClickHdl = aTbx.GetToolBox().GetClickHdl();
	aTbx.GetToolBox().SetClickHdl(
		LINK( this, SvxPopupWindowTbxMgr, TbxClickHdl ) );
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::Dtor()
|*
\************************************************************************/

SvxPopupWindowTbxMgr::~SvxPopupWindowTbxMgr()
{
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::Clone()
|*
\************************************************************************/

SfxPopupWindow* SvxPopupWindowTbxMgr::Clone() const
{
	return new SvxPopupWindowTbxMgr( GetId(),
									 aTbx.GetToolBox().GetAlign(),
									 aRIdWinTemp,
									 aRIdTbxTemp,
									 (SfxBindings&)GetBindings() );
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::PopupModeEnd()
|*
\************************************************************************/

void SvxPopupWindowTbxMgr::PopupModeEnd()
{
	aTbx.GetToolBox().EndSelection();
	SfxPopupWindow::PopupModeEnd();
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::StartSelection()
|*
\************************************************************************/

void SvxPopupWindowTbxMgr::StartSelection()
{
	aTbx.GetToolBox().StartSelection();
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::TbxSelectHdl()
|*
\************************************************************************/

IMPL_LINK( SvxPopupWindowTbxMgr, TbxSelectHdl, ToolBox*, pBox )
{
    USHORT nLastSlotId = pBox->GetCurItemId();
    UserEvent(SVX_EVENT_COLUM_WINDOW_EXECUTE, (void*)nLastSlotId);

	if ( IsInPopupMode() )
		EndPopupMode();

	GetBindings().GetDispatcher()->Execute( nLastSlotId );
	return 0;
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::TbxClickHdl()
|*
\************************************************************************/

IMPL_LINK( SvxPopupWindowTbxMgr, TbxClickHdl, ToolBox*, pBox )
{
    USHORT nCurId = pBox->GetCurItemId();
    UserEvent(SVX_EVENT_COLUM_WINDOW_EXECUTE, (void*)nCurId);
    if ( aTbxClickHdl.IsSet() )
		aTbxClickHdl.Call( pBox );
	return 0;
}

/*************************************************************************
|*
|*	SvxPopupWindowTbxMgr::StateChanged()
|*
\************************************************************************/

void SvxPopupWindowTbxMgr::StateChanged( USHORT nSID, SfxItemState eState,
										 const SfxPoolItem* pState )
{
	if ( nSID == SID_INSERT_DRAW )
	{
		USHORT nActive = 0;

		if ( eState == SFX_ITEM_AVAILABLE )
			nActive = ((SfxEnumItem*)pState)->GetValue();

		ToolBox& rBox = aTbx.GetToolBox();
		USHORT nCount = rBox.GetItemCount();
		BOOL bEnable = eState != SFX_ITEM_DISABLED;

		for ( USHORT i = 0; i < nCount; i++ )
		{
			USHORT nId = rBox.GetItemId(i);
			rBox.CheckItem( nId, ( nId == nActive ) );
			rBox.EnableItem( nId, bEnable );
		}
	}
	SfxPopupWindow::StateChanged( nSID, eState, pState );
}
/* -----------------------------05.07.01 15:24--------------------------------

 ---------------------------------------------------------------------------*/
void  SvxPopupWindowTbxMgr::UserEvent( ULONG nEvent, void* pEventData )
{
    // Der Align- und Bezier-Controller tauscht das Image nicht aus
    USHORT nId = GetId();
    if ( nId != SID_OBJECT_ALIGN && nId != SID_INSERT_DRAW )
	{
        USHORT nCurrentId = (USHORT)(ULONG)pEventData;
        SfxUInt16Item aItem( nId, nCurrentId );
		GetBindings().GetDispatcher()->Execute( nId, SFX_CALLMODE_SYNCHRON, &aItem, 0L );
	}
}
