/*************************************************************************
 *
 *  $RCSfile: atrhndl.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: fme $ $Date: 2001/12/14 12:02:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ATRHNDL_HXX
#define _ATRHNDL_HXX

#define INITIAL_NUM_ATTR 4
#define NUM_ATTRIBUTE_STACKS 37

#ifndef _TXATBASE_HXX
#include <txatbase.hxx>
#endif
#ifndef _SWFNTCCH_HXX
#include <swfntcch.hxx>
#endif

class SwAttrSet;
class SwDoc;
class SfxPoolItem;
extern const BYTE StackPos[];

/*************************************************************************
 *                      class SwAttrHandler
 *
 * Used by Attribute Iterators to organize attributes on stacks to
 * find the valid attribute in each category
 *************************************************************************/

class SwAttrHandler
{
private:

    /*************************************************************************
     *                      class SwAttrStack
     *
     * Container for SwTxtAttr Objects
     *************************************************************************/

    class SwAttrStack
    {
    private:
        SwTxtAttr* pInitialArray[ INITIAL_NUM_ATTR ];
        SwTxtAttr** pArray;
        USHORT nCount; // number of elements on stack
        USHORT nSize;    // number of positions in Array

    public:
        // Ctor, Dtor
        inline SwAttrStack();
        inline ~SwAttrStack() {
            if ( nSize > INITIAL_NUM_ATTR ) delete [] pArray; }

        // reset stack
        inline void Reset() { nCount = 0; };

        // insert on top
        inline void Push( const SwTxtAttr& rAttr ) { Insert( rAttr, nCount ); };
        // insert at specified position, take care for not inserting behind
        // the value returned by Count()
        void Insert( const SwTxtAttr& rAttr, const USHORT nPos );

        // remove specified attribute
        void Remove( const SwTxtAttr& rAttr );

        // get attribute from top if exists, otherwise 0
        const SwTxtAttr* Top() const;

        // number of elements on stack
        inline USHORT Count() const { return nCount; };

        // returns position of rAttr on Stack if found, otherwise USHRT_MAX
        // can be used for Remove of an attribute
        USHORT Pos( const SwTxtAttr& rAttr ) const;
    };

    SwAttrStack aAttrStack[ NUM_ATTRIBUTE_STACKS ]; // stack collection
    const SfxPoolItem* pDefaultArray[ NUM_DEFAULT_VALUES ];
    const SwDoc* pDoc;
#ifdef VERTICAL_LAYOUT
    sal_Bool bVertLayout;
#endif

    // This is the base font for the paragraph. It is stored in order to have
    // a template, if we have to restart the attribute evaluation
    SwFont* pFnt;

    // change font according to pool item
    void FontChg(const SfxPoolItem& rItem, SwFont& rFnt, sal_Bool bPush );

    // push attribute to specified stack, returns true, if attribute has
    // been pushed on top of stack (important for stacks containing different
    // attributes with different priority and redlining)
    sal_Bool Push( const SwTxtAttr& rAttr, const SfxPoolItem& rItem, SwFont& rFnt );

    // apply top attribute on stack to font
    void ActivateTop( SwFont& rFnt, USHORT nStackPos );

public:
    // Ctor
    SwAttrHandler();
    ~SwAttrHandler();

    // set default attributes to values in rAttrSet or from cache
    void Init( const SwAttrSet& rAttrSet, const SwDoc& rDoc );
#ifdef VERTICAL_LAYOUT
    void Init( const SfxPoolItem** pPoolItem, const SwAttrSet* pAttrSet,
               const SwDoc& rDoc, SwFont& rFnt, sal_Bool bVertLayout );
#else
    void Init( const SfxPoolItem** pPoolItem, const SwAttrSet& rAttrSet,
               const SwDoc& rDoc, SwFont& rFnt, sal_Bool bAttrSet );
#endif

    // remove everything from internal stacks, keep default data
    void Reset( );

    // insert specified attribute and change font
    void PushAndChg( const SwTxtAttr& rAttr, SwFont& rFnt );

    // remove specified attribute and reset font
    void PopAndChg( const SwTxtAttr& rAttr, SwFont& rFnt );
    void Pop( const SwTxtAttr& rAttr );

    // apply script dependent attributes
//    void ChangeScript( SwFont& rFnt, const BYTE nScr );

    // returns the default value for stack nStack
    inline const SfxPoolItem& GetDefault( const USHORT nAttribID ) const;
    // do not call these if you only used the small init function
    inline void ResetFont( SwFont& rFnt ) const;
    inline const SwFont* GetFont() const;
};

inline const SfxPoolItem& SwAttrHandler::GetDefault( const USHORT nAttribID ) const
{
    ASSERT( 0 <= nAttribID && nAttribID < RES_TXTATR_END,
            "this attrib does not ex."
            );
    ASSERT( pDefaultArray[ StackPos[ nAttribID ] ], "array not initialized" );
    return *pDefaultArray[ StackPos[ nAttribID ] ];
}

inline void SwAttrHandler::ResetFont( SwFont& rFnt ) const
{
    ASSERT( pFnt, "ResetFont without a font" );
    if ( pFnt )
        rFnt = *pFnt;
};

inline const SwFont* SwAttrHandler::GetFont() const
{
    return pFnt;
};

#endif
