/*************************************************************************
 *
 *  $RCSfile: sw3imp.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: mib $ $Date: 2001/10/17 08:05:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#include <stdio.h>

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#if !defined _SVSTDARR_USHORTS_DECL || !defined _SVSTDARR_STRINGSDTOR_DECL
#define _SVSTDARR_STRINGSDTOR
#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _MyEDITENG_HXX //autogen
#include <svx/editeng.hxx>
#endif
#ifndef _SVDPOOL_HXX //autogen
#include <svx/svdpool.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _HTMLKYWD_HXX
#include <svtools/htmlkywd.hxx>
#endif
#ifndef _SFXDOCINF_HXX //autogen
#include <sfx2/docinf.hxx>
#endif
#ifndef _TOOLS_TENCCVT_HXX //autogen
#include <tools/tenccvt.hxx>
#endif

#ifndef _COM_SUN_STAR_FORM_XFORMSSUPPLIER_HPP_
#include <com/sun/star/form/XFormsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORM_HPP_
#include <com/sun/star/form/XForm.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XIMAGEPRODUCERSUPPLIER_HPP_
#include <com/sun/star/form/XImageProducerSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORMCONTROLLER_HPP_
#include <com/sun/star/form/XFormController.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORMCOMPONENT_HPP_
#include <com/sun/star/form/XFormComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORMCONTROLLERLISTENER_HPP_
#include <com/sun/star/form/XFormControllerListener.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGESUPPLIER_HPP_
#include <com/sun/star/drawing/XDrawPageSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HPP_
#include <com/sun/star/container/XIndexContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HPP_
#include <com/sun/star/container/XContainerListener.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HPP_
#include <com/sun/star/container/ContainerEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HPP_
#include <com/sun/star/container/XIndexReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _FMTFLD_HXX //autogen
#include <fmtfld.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#ifndef _HINTS_HXX
#include <hints.hxx>
#endif
#ifndef _DOCTXM_HXX
#include <doctxm.hxx>
#endif
#ifndef _SWMODULE_HXX //autogen
#include <swmodule.hxx>
#endif
#ifndef _DCONTACT_HXX //autogen
#include <dcontact.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _DFLYOBJ_HXX
#include <dflyobj.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
#ifndef _SW3IO_HXX
#include <sw3io.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _SW3IDS_HXX
#include <sw3ids.hxx>
#endif
#ifndef _SW3MARKS_HXX
#include <sw3marks.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _CRYPTER_HXX
#include <crypter.hxx>
#endif
#ifndef _DBFLD_HXX
#include <dbfld.hxx>
#endif
#ifndef _EXPFLD_HXX
#include <expfld.hxx>
#endif
#ifndef _NDOLE_HXX
#include <ndole.hxx>
#endif
#ifndef _DRAWDOC_HXX
#include <drawdoc.hxx>
#endif

#ifndef _SWDOCSH_HXX //autogen wg. SwDocShell
#include <docsh.hxx>
#endif
#ifndef _SWFLTOPT_HXX
#include <swfltopt.hxx>
#endif

#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
#ifndef _STATSTR_HRC
#include <statstr.hrc>
#endif
#ifndef _POOLFMT_HRC
#include <poolfmt.hrc>
#endif
#ifndef _FMTINFMT_HXX
#include <fmtinfmt.hxx>
#endif
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

static Sw3IoImp* pCurIosys;					// fuer non-poolable Attrs

// Zugriff auf die INI-Datei, um interne Flags zu setzen

#define FLTF_NO_DRAWINGS	0x00000001L

#define MAX_SMALL_RECSIZE	0xfffffeUL
#define LONG_RECSIZE 		0xffffffUL

static sal_uInt32 nFltFlags = 0;


sal_Char __FAR_DATA SW3HEADER[] = "SW3HDR";		// 3.0/3.1 Header
sal_Char __FAR_DATA SW4HEADER[] = "SW4HDR";		// 4.0 Header
sal_Char __FAR_DATA SW5HEADER[] = "SW5HDR";		// 5.0 Header

// TODOs fuer 6.0-FF
// - Record-Laengen > 16MB richtig handeln.
// - while( BytesLeft() )-Schleifen elemenieren

SV_IMPL_PTRARR(Sw3Strings, String*)
SV_IMPL_VARARR(Sw3ULongs, sal_uInt32)
SV_IMPL_VARARR(Sw3Bytes, sal_uInt8)

class Sw3RecordSizeTable: private Table
{
public:
	Table::Count;
	Table::SearchKey;
	Table::GetObjectKey;

	Sw3RecordSizeTable() :
		Table()
	{}

	sal_Bool Insert( sal_uInt32 nKey, sal_uInt32 p )
	{
		return Table::Insert( nKey, (void*)p );
	}

	sal_uInt32 GetObject( sal_uInt32 nPos ) const
	{
		return (sal_Int32)Table::GetObject( nPos );
	}
};


//////////////////////////////////////////////////////////////////////////////

/*  */

Sw3ExportInfo::~Sw3ExportInfo()
{
	delete pTblLineBoxFmtNames40;
}

/*  */


Sw3IoImp::Sw3IoImp( Sw3Io& r )
		: rIo( r ), pDoc( NULL ),
		aDefWordDelim( SW_MOD()->GetDocStatWordDelim() ),
		N_DOC( String::CreateFromAscii( "StarWriterDocument" ) ),
		N_PAGESTYLES( String::CreateFromAscii( "SwPageStyleSheets" ) ),
		N_NUMRULES( String::CreateFromAscii( "SwNumRules" ) ),
		N_DRAWING( String::CreateFromAscii( DRAWING_STREAM_NAME ) ),
		N_PICTURES( String::CreateFromAscii( "EmbeddedPictures" ) ),
		N_BLOCKDIR( String::CreateFromAscii( "DocumentList" ) ),
		sStarSymbol( "StarSymbol", sizeof("StarSymbol")-1, RTL_TEXTENCODING_ASCII_US ),
		sOpenSymbol( "OpenSymbol", sizeof("OpenSymbol")-1, RTL_TEXTENCODING_ASCII_US ),
		sStarBats( "StarBats", sizeof("StarBats")-1, RTL_TEXTENCODING_ASCII_US ),
		sStarMath( "StarMath", sizeof("StarMath")-1, RTL_TEXTENCODING_ASCII_US )
{
	bNormal		= sal_True;
	bTxtColls 	=
	bCharFmts	=
	bFrmFmts	=
	bPageDescs	=
	bNumRules	=
	bAdditive	=
	bBlock	    =
	bSw31Export	=
	bOrganizer	=
	bInsIntoHdrFtr = sal_False;
	pFlyFrms    = NULL;
	pExportInfo = NULL;
	pCrypter    = NULL;
	pTOXs       = NULL;
	pRedlines	= NULL;
	pRedlineMarks = NULL;
	pMarks	    = NULL;
	pBookmarks  = NULL;
	p30OLENodes = NULL;
	pTblLineBoxFmts = NULL;
	pSectionDepths = 0;
	pRecSizes = NULL;
	pAuthorityMap = 0;
	pConvToSymbolFmts = 0;
#ifndef PRODUCT
	pRefSdrObjects = 0;
#endif
	hBatsFontConv = 0;
	Reset();

	{
		const sal_Char* aNames[1] = { "Writer/SW3Imp" };
		sal_uInt32 aVal[1];
		SwFilterOptions aOpt( 1, aNames, aVal );
		nFltFlags = aVal[ 0 ];
	}
	nCntntBkmkStart = 0;
	nCntntRedlineStart = 0;
}

Sw3IoImp::~Sw3IoImp()
{
	if( pDoc && !pDoc->RemoveLink() )
		delete pDoc;
}

void Sw3IoImp::SetDoc( SwDoc& r )
{
	if( pDoc && !pDoc->RemoveLink() )
		delete pDoc;
	pDoc = &r;
	r.AddLink();
}

Sw3IoImp* Sw3IoImp::GetCurrentIo()
{
	return pCurIosys;
}

// Allgemeine Initialisierungen

void Sw3IoImp::Reset()
{
	Date aDate;
	Time aTime;
	// die folgenden beiden Felder werden auch zum Passwort-Check benutzt
	nDate		= aDate.GetDate();
	nTime		= aTime.GetTime();
	bInsert		=
	bNoDrawings = sal_False;
	bSaveAll    = sal_True;
	bSpellAllAgain = bSpellWrongAgain = sal_True;
	nCurBlk		= 0;
	nRes 		= 0;
	nWarn		= 0;
	nCurPercent =
	nEndPercent = 0;
	nZOrderOff  = 0;
	nHiddenDrawObjs = ULONG_MAX;
	pBlkList	= NULL;
	bInsIntoHdrFtr = sal_False;
	bSw31Export = sal_False;
	FreeFlyFrms();
	aBlkName.Erase();
	pStrm = 0;	// wg. Assert in IsSw.*Export
	Reset2();
	nGblFlags	= SW3F_NODRAWING;

#ifndef PRODUCT
	delete pRefSdrObjects;
	pRefSdrObjects = 0;
#endif
	delete pConvToSymbolFmts;
	pConvToSymbolFmts = 0;
}

// Initialisierung aller Daten vor dem Lesen/Schreiben eines Docs

void Sw3IoImp::Reset2()
{
	bOut		  =
	bConvertNoNum = sal_False;
	nCurMark	=
	nFlyLevel	=
	nFileFlags  = 0;
	nSizeDivFac	= 1;
	nFlagRecEnd = 0;
	pCurTbl		= NULL;
	pCurNumRule = NULL;
	pCurPaM		=
	pCurNumRange= NULL;
	eSrcSet		= gsl_getSystemTextEncoding();
	if( pStrm )
		eSrcSet = GetSOStoreTextEncoding( eSrcSet, pStrm->GetVersion() );
	else if( pRoot.Is() )
		eSrcSet = GetSOStoreTextEncoding( eSrcSet, pRoot->GetVersion() );
	nVersion	= SWG_VERSION;

	aRecTypes.Remove( 0, aRecTypes.Count() );
	aRecSizes.Remove( 0, aRecSizes.Count() );
	aValPositions.Remove( 0, aValPositions.Count() );
	eStartNodeType = SwNormalStartNode;

	aINetFldText.Erase();
	pFmtINetFmt = 0;
	bDrawFmtSkipped = sal_False;

	memset( cPasswd, 0, 16 );
	aStringPool.Clear();
	if( pExportInfo && pExportInfo->pTblLineBoxFmtNames40 )
	{
		delete pExportInfo->pTblLineBoxFmtNames40;
		pExportInfo->pTblLineBoxFmtNames40 = 0;
	}
	// Hier ggf das Passwort neu setzen
	SetPasswd();

	delete pRecSizes;
	pRecSizes = 0;

	delete pAuthorityMap;
	pAuthorityMap = 0;

	delete pSectionDepths;
	pSectionDepths = 0;

	if( hBatsFontConv )
	{
		DestroyFontToSubsFontConverter( hBatsFontConv );
		hBatsFontConv = 0;
	}
	if( hMathFontConv )
	{
		DestroyFontToSubsFontConverter( hMathFontConv );
		hMathFontConv = 0;
	}
}

#ifndef PRODUCT
sal_Bool Sw3IoImp::IsSw40Export() const
{
	ASSERT( !pStrm || pStrm->GetVersion()==pRoot->GetVersion(),
			"Fileformat-Version am Stream stimmt nicht." );
	return pRoot->GetVersion() == SOFFICE_FILEFORMAT_40;
}

sal_Bool Sw3IoImp::IsSw31Or40Export() const
{
	ASSERT( !pStrm || pStrm->GetVersion()==pRoot->GetVersion(),
			"Fileformat-Version am Stream stimmt nicht." );
	return pRoot->GetVersion() <= SOFFICE_FILEFORMAT_40;
}
#endif

void Sw3IoImp::Error( sal_uInt32 nCode )
{
	nRes = nCode ? nCode : ERR_SWG_FILE_FORMAT_ERROR;
}

void Sw3IoImp::Warning( sal_uInt32 nCode )
{
	nWarn = nCode ? nCode : WARN_SWG_FEATURES_LOST;
}

/*************************************************************************
*
*		Einlese-Optionen
*
*************************************************************************/

void Sw3IoImp::SetReadOptions( const SwgReaderOption& rOpt, sal_Bool bOverwrite )
{
	bTxtColls 	=
	bCharFmts	=
	bFrmFmts	=
	bPageDescs	=
	bNumRules 	= sal_False;	// fix #27376#: sonst sind alle sal_True
	if( rOpt.IsFrmFmts() )
		bFrmFmts = sal_True;
	if( rOpt.IsTxtFmts() )
		bCharFmts = bTxtColls = sal_True;
	if( rOpt.IsPageDescs() )
		bPageDescs = sal_True;
	if( rOpt.IsNumRules() )
		bNumRules = sal_True;
	bNormal = sal_Bool( !( bTxtColls | bCharFmts | bFrmFmts | bPageDescs | bNumRules ) );
	bAdditive = bNormal ? !bOverwrite : rOpt.IsMerge();
}

void Sw3IoImp::InsertHiddenDrawObjs()
{
	if( !pDoc->GetDrawModel() )
		return;

	const SwSpzFrmFmts* pFlys = pDoc->GetSpzFrmFmts();
	sal_uInt16 nArrLen = pFlys->Count();
	if( !nArrLen )
		return;

	SdrPage *pPage = pDoc->GetDrawModel()->GetPage( 0 );
	nHiddenDrawObjs = pPage->GetObjCount();
	for( sal_uInt16 i=0; i<nArrLen; i++ )
	{
		const SwFrmFmt* pFmt = (*pFlys)[ i ];
		if( RES_DRAWFRMFMT != pFmt->Which() )
			continue;

		SwClientIter aIter( *(SwFrmFmt*)pFmt );
		if( aIter.First( TYPE(SwDrawContact) ) )
		{
			SdrObject *pObj = ((SwDrawContact*)aIter())->GetMaster();
			if( !pObj->GetPage() )
				pPage->InsertObject( pObj );
		}
	}
}

void Sw3IoImp::RemoveHiddenDrawObjs()
{
	if( nHiddenDrawObjs == ULONG_MAX || !pDoc->GetDrawModel() )
		return;

	SdrPage *pPage = pDoc->GetDrawModel()->GetPage( 0 );
	sal_uInt32 nPos = pPage->GetObjCount();
	while( nPos > nHiddenDrawObjs )
		pPage->RemoveObject( --nPos );

	nHiddenDrawObjs = ULONG_MAX;
}

/*************************************************************************
*
*		Stream-Verwaltung
*
*************************************************************************/

// Does the drawing layer contain some objects or forms?

sal_Bool lcl_sw3io_doesDrawingLayerNeedSaving( SwDoc& rDoc )
{
	if( !rDoc.GetDrawModel() )
		return sal_False;

	const SdrPage *pPage = rDoc.GetDrawModel()->GetPage( 0 );
	for ( sal_uInt32 i = 0; i < pPage->GetObjCount(); i++ )
	{
		SdrObject *pObj = pPage->GetObj( i );
		if ( !pObj->IsWriterFlyFrame() &&
			 !pObj->ISA(SwFlyDrawObj) )
			return sal_True;
	}

	SwDocShell *pDocSh = rDoc.GetDocShell();
	if( !pDocSh )
		return sal_False;

	Reference< drawing::XDrawPageSupplier > xDPSupp( pDocSh->GetBaseModel(),
													 UNO_QUERY );
	ASSERT( xDPSupp.is(), "XDrawPageSupplier missing" );

	Reference< drawing::XDrawPage >  xDrawPage = xDPSupp->getDrawPage();
	ASSERT( xDrawPage.is(), "XDrawPage missing" );
	if( !xDrawPage.is() )
		return sal_False;

	Reference< form::XFormsSupplier > xFormsSupplier( xDrawPage, UNO_QUERY );
	ASSERT( xFormsSupplier.is(), "XFormsSupplier missing" );

	Reference< container::XNameContainer > xForms = xFormsSupplier->getForms();
	ASSERT( xForms.is(), "XForms missing" );

	return xForms->hasElements();
}

// Alle Streams neu oeffnen. Der Root-Storage ist bereits gesetzt.
// Der Storage fuer die Grafiken wird in In/OutGrfNode() geoeffnet.
// Das Element StarWriterDocument kann entweder ein Storage oder
// ein Stream sein.
// Der Drawing Layer-Stream wird nur dann geoeffnet, wenn der Stream
// da ist (beim Lesen) oder wenn der Layer Zeichenobjekte enthaelt
// (Schreiben). Beim Schreiben wird er, falls vorhanden und nicht
// verwendet, weggeputzt!

sal_Bool Sw3IoImp::OpenStreams( sal_Bool bRdWr, sal_Bool bUseDrawStream )
{
	sal_uInt16 nMode = STREAM_READ | STREAM_SHARE_DENYWRITE;
	if( bRdWr )
		nMode |= STREAM_WRITE;
	else
		nMode |= STREAM_NOCREATE;
	Reset();

	pCurIosys = this;

	if( !pRoot.Is() || pRoot->GetError() != SVSTREAM_OK )
		return sal_False;

	// Der Doc-Teil kann Storage oder Stream sein!
	// Der DocStream fehlt natuerlich auch bei Textbausteinen
	if( !bBlock )
	{
		ASSERT( !pRoot->IsContained( N_DOC ) || pRoot->IsStream( N_DOC ), "Beta1-Docs werden nicht unterstuetzt" );
		if( pRoot->IsStorage( N_DOC ) )
		{
			nRes = ERR_SWG_READ_ERROR;
			return sal_False;
		}
	}

	long nFFVersion = pRoot->GetVersion();
	ASSERT( nFFVersion == SOFFICE_FILEFORMAT_31 ||
			nFFVersion == SOFFICE_FILEFORMAT_40 ||
			nFFVersion == SOFFICE_FILEFORMAT_50,
			"Am Root-Storage ist keine FF-Version gesetzt!" );

	// Solange wie noch ein Flag fuer den 3.1-Export haben, muessen wir
	// es auch noch setzen. Der Sw3Writer macht das nicht mehr fuer uns.
	if( bRdWr && nFFVersion == SOFFICE_FILEFORMAT_31 )
		SetSw31Export( sal_True );

	// Wenn eine 3.1-Clipboard-ID gesetzt ist, die Fileformat-Version
	// auf 3.1 setzten.
	if( SOT_FORMATSTR_ID_STARWRITER_30 == pRoot->GetFormat() &&
		nFFVersion != SOFFICE_FILEFORMAT_31 )
	{
		ASSERT( nFFVersion == SOFFICE_FILEFORMAT_31,
				"Fileformat-Version auf 3.1 umgesetzt" );
		pRoot->SetVersion( SOFFICE_FILEFORMAT_31 );
		nFFVersion = SOFFICE_FILEFORMAT_31;
	}
	else if( ( SOT_FORMATSTR_ID_STARWRITER_40 == pRoot->GetFormat() ||
			   SOT_FORMATSTR_ID_STARWRITERGLOB_40 == pRoot->GetFormat() ||
			   SOT_FORMATSTR_ID_STARWRITERWEB_40 == pRoot->GetFormat() ) &&
			 nFFVersion != SOFFICE_FILEFORMAT_40 )
	{
		ASSERT( nFFVersion == SOFFICE_FILEFORMAT_40,
				"Fileformat-Version auf 4.0 umgesetzt" );
		pRoot->SetVersion( SOFFICE_FILEFORMAT_40 );
		nFFVersion = SOFFICE_FILEFORMAT_40;
	}
	else if( ( SOT_FORMATSTR_ID_STARWRITER_50 == pRoot->GetFormat() ||
			   SOT_FORMATSTR_ID_STARWRITERGLOB_50 == pRoot->GetFormat() ||
			   SOT_FORMATSTR_ID_STARWRITERWEB_50 == pRoot->GetFormat() ) &&
			 nFFVersion != SOFFICE_FILEFORMAT_50 )
	{
		ASSERT( nFFVersion == SOFFICE_FILEFORMAT_50,
				"Fileformat-Version auf 5.0 umgesetzt" );
		pRoot->SetVersion( SOFFICE_FILEFORMAT_50 );
		nFFVersion = SOFFICE_FILEFORMAT_50;
	}


	// The drawing layer stream will be opened for reading if it exists only
	// and for writing if it contains some (non virtual) objects or forms.
	sal_Bool bDraw = bRdWr && bUseDrawStream && pDoc->GetDrawModel() &&
				 lcl_sw3io_doesDrawingLayerNeedSaving( *pDoc );

	sal_Bool bPresent = pRoot->IsStream( N_DRAWING );
	if( bDraw || ( !bRdWr && bPresent ) )
	{
		if( bRdWr || !( nFltFlags & FLTF_NO_DRAWINGS ) )
			pDrawing = pRoot->OpenStream( N_DRAWING, nMode );
	}
	else
	{
		if( bPresent && bUseDrawStream )
			pRoot->Remove( N_DRAWING );
		pDrawing.Clear();
	}

	// Absatzvorlagen
	if( bRdWr || pRoot->IsStream( SfxStyleSheetBasePool::GetStreamName() ) )
		pStyles = pRoot->OpenStream
						( SfxStyleSheetBasePool::GetStreamName(), nMode );
	else
		pStyles.Clear();
	// Numerierungs-Regeln
	if( nFFVersion > SOFFICE_FILEFORMAT_40 )
	{
		if( bRdWr || pRoot->IsStream( N_NUMRULES ) )
			pNumRules = pRoot->OpenStream( N_NUMRULES, nMode );
		else
			pNumRules.Clear();
	}
	// Seitenvorlagen
	if( bRdWr || pRoot->IsStream( N_PAGESTYLES ) )
		pPageStyles = pRoot->OpenStream( N_PAGESTYLES, nMode );
	else
		pPageStyles.Clear();
	// Inhalt
	if( bRdWr || pRoot->IsStream( N_DOC ) )
		pContents = pRoot->OpenStream( N_DOC, nMode );
	else
		pContents.Clear();
	if( CheckStreams() )
	{
		// Versions-Nummer vom Storage an die Streams uebernehmen
		// Setting the char set is in fact only required for
		// saving files.
		if( pDrawing.Is() )
			pDrawing->SetVersion( nFFVersion );

		pStyles->SetVersion( nFFVersion );
		if( pNumRules.Is() )
		{
			pNumRules->SetVersion( nFFVersion );
			pNumRules->SetStreamCharSet( eSrcSet );
		}

		pPageStyles->SetVersion( nFFVersion );
		pPageStyles->SetStreamCharSet( eSrcSet );

		pContents->SetVersion( nFFVersion );
		pContents->SetStreamCharSet( eSrcSet );

		if( bRdWr )
		{
			sal_uInt16 nComprMode = COMPRESSMODE_NONE;
			if( SOFFICE_FILEFORMAT_40 <= pRoot->GetVersion() &&
				pDoc->GetInfo()->IsSaveGraphicsCompressed() )
				nComprMode |= COMPRESSMODE_ZBITMAP;
			if( SOFFICE_FILEFORMAT_40 < pRoot->GetVersion() &&
				pDoc->GetInfo()->IsSaveOriginalGraphics() )
				nComprMode |= COMPRESSMODE_NATIVE;
			if( COMPRESSMODE_NONE != nComprMode )
			{
				if( pDrawing.Is() )
					pDrawing->SetCompressMode( nComprMode );
				pStyles->SetCompressMode( nComprMode );
				if( pNumRules.Is() )
					pNumRules->SetCompressMode( nComprMode );
				pPageStyles->SetCompressMode( nComprMode );
				pContents->SetCompressMode( nComprMode );
			}
		}

		// Exort-Information anlegen
		delete pExportInfo;
		if( bRdWr && nFFVersion <= SOFFICE_FILEFORMAT_40 )
			pExportInfo = new Sw3ExportInfo;
		// Falls noch keine Marks gesammelt wurden, ist jetzt die Zeit!
		// MIB 11.12.96: Es werden jetzt text::Bookmarks gesammelt, wenn sie
		// benoetigt werden und auch nur noch die, die benoetigt werden.
		// Das ist sauberer!
//		if( !pMarks && bRdWr )
//			CollectMarks( NULL, sal_False );
		bOut = bRdWr;
		return sal_True;
	}
	else
	{
		CloseStreams();
		return sal_False;
	}
}

// Alle offenen Streams freigeben. Die Root bleibt so, wie sie war.

void Sw3IoImp::CloseStreams()
{
	pCurIosys = NULL;
	pStrm 	  = NULL;
	pContents.Clear();
	pDrawing.Clear();
	pStyles.Clear();
	pPageStyles.Clear();
	pNumRules.Clear();
	// Sicherheitshalber
	pBlkDir.Clear();
	// Nach dem Einlesen alle nicht benutzten Marks loeschen
	// (kann auch nach dem Schreiben passieren, ist egal)
	CleanupMarks();

	// Brauchen wir nicht mehr
	delete pExportInfo; pExportInfo = NULL;
	delete pTOXs; pTOXs = NULL;
	delete pRedlines; pRedlines = NULL;
	delete pRedlineMarks; pRedlineMarks = NULL;
	delete pMarks; pMarks = NULL;
	delete pBookmarks; pBookmarks = NULL;
	delete p30OLENodes; p30OLENodes = NULL;
	delete pTblLineBoxFmts; pTblLineBoxFmts = NULL;

	// der Returncode sollte so bleiben, wie er ist
	sal_uInt32 n = nRes;
	Reset();
	nRes = n;
}

// Sind alle Streams auch da?

sal_Bool Sw3IoImp::CheckStreams()
{
	sal_uInt16 n = pRoot.Is() && ( pRoot->GetError() == SVSTREAM_OK )
		   && pPageStyles.Is() && ( pPageStyles->GetError() == SVSTREAM_OK )
		   && pStyles.Is() && ( pStyles->GetError() == SVSTREAM_OK )
		   && pContents.Is() && ( pContents->GetError() == SVSTREAM_OK );
	if( n && pRoot->GetVersion() > SOFFICE_FILEFORMAT_40 )
		n = n && pNumRules.Is() && ( pNumRules->GetError() == SVSTREAM_OK );
	return sal_Bool( n );
}

// Record oeffnen

sal_Bool Sw3IoImp::OpenRec( sal_uInt8 cType )
{
	sal_Bool bRes = sal_True;
	sal_uInt16 nLvl = aRecTypes.Count();
	ASSERT( nLvl == aRecSizes.Count(), "OpenRec: falscher Level" );
	sal_uInt32 nPos = pStrm->Tell();
	if( bOut )
	{
		if( nLvl >= 31 && (!pRoot.Is() || IsSw31Or40Export())  )
			Error( ERR_SWG_LARGE_DOC_ERROR );
		aRecTypes.Insert( cType, nLvl );
		aRecSizes.Insert( nPos, nLvl );
		*pStrm << (sal_uInt32) 0;
	}
	else
	{
		sal_uInt32 nVal;
		*pStrm >> nVal;
		sal_uInt8 cRecTyp = (sal_uInt8)nVal;
		aRecTypes.Insert( cRecTyp, nLvl );
		sal_uInt32 nSize = nVal >> 8;
		if( LONG_RECSIZE == nSize && IsVersion( SWG_LONGRECS ) )
		{
			sal_uInt32 nTmp = GetRecordSize( nPos );
			if( nTmp != ULONG_MAX )
				nSize = nTmp;
		}

		aRecSizes.Insert( nPos + nSize, nLvl );
		if( !nVal || cRecTyp != cType )
		{
			// Bei Fehlern wird ein EOF-Record erzeugt
			// fix #24089#: Ein 0-Record-Header ist in jedem Fall
			// ein Formatfehler und sollte nicht zu einer Endlos-Schleife
			// fuehren
			ASSERT( nVal, "OpenRec: Record-Header ist 0" );
			ASSERT( cRecTyp == cType,
					"OpenRec: Falscher Block-Header" );
		 	Error();
			aRecTypes[nLvl] = SWG_EOF;
			aRecSizes[nLvl] = pStrm->Tell();
			bRes = sal_False;
		}
		if( pStrm->GetErrorCode() != SVSTREAM_OK || pStrm->IsEof() )
		{
			if( pStrm->GetErrorCode() != SVSTREAM_OK &&
				IsWarning(pStrm->GetErrorCode()) )
			{
				Warning( pStrm->GetErrorCode() );
				pStrm->ResetError();
			}
			else
			{
				// Bei Fehlern wird ein EOF-Record erzeugt
			 	Error( ERR_SWG_READ_ERROR );
				aRecTypes[nLvl] = SWG_EOF;
				aRecSizes[nLvl] = pStrm->Tell();
				bRes = sal_False;
			}
		}
	}
	return bRes;
}

// Record schliessen

void Sw3IoImp::CloseRec( sal_uInt8 cType )
{
	sal_uInt16 nLvl = aRecTypes.Count();
	ASSERT( nLvl == aRecSizes.Count(), "CloseRec: falscher Level" );
	ASSERT( nLvl, "CloseRec: keine Schachtelung" );
	if( nLvl )
	{
		nLvl--;
		ASSERT( cType == aRecTypes[nLvl],
				"CloseRec: Falscher Block-Header" );
		sal_uInt32 nPos = pStrm->Tell();
		if( bOut )
		{
			sal_uInt32 nBgn = aRecSizes[nLvl];
			pStrm->Seek( nBgn );
			sal_uInt32 nSize = nPos - nBgn;
			if( nSize > MAX_SMALL_RECSIZE )
			{
				if( !pRoot.Is() || IsSw31Or40Export() )
				{
				 	Error( ERR_SWG_LARGE_DOC_ERROR );
				}
				else
				{
					InsertRecordSize( nBgn, nSize );
					nSize = LONG_RECSIZE;
				}
			}
			sal_uInt32 nVal = ( nSize << 8 ) | aRecTypes[nLvl];
			*pStrm << nVal;
			pStrm->Seek( nPos );
			if( pStrm->GetError() != SVSTREAM_OK )
			 	Error( ERR_SWG_WRITE_ERROR );
		}
		else
		{
			sal_uInt32 n = aRecSizes[nLvl];
			ASSERT( n >= nPos, "CloseRec: zu viele Daten gelesen" );
			if( n != nPos )
			{
				pStrm->Seek( n );
				if( n < nPos )
				 	Error();
				else
					Warning();
			}
			if( pStrm->GetErrorCode() != SVSTREAM_OK )
			{
				if( IsWarning(pStrm->GetErrorCode()) )
				{
					Warning( pStrm->GetErrorCode() );
					pStrm->ResetError();
				}
				else
				 	Error( ERR_SWG_READ_ERROR );
			}
		}

		aRecTypes.Remove( nLvl, 1 );
		aRecSizes.Remove( nLvl, 1 );
	}
}

void Sw3IoImp::InsertRecordSize( sal_uInt32 nPos, sal_uInt32 nSize )
{
	if( !pRecSizes )
		pRecSizes = new Sw3RecordSizeTable;

	pRecSizes->Insert( nPos, nSize );
}

sal_uInt32 Sw3IoImp::GetRecordSize( sal_uInt32 nPos )
{
	sal_uInt32 nTablePos, nRet = ULONG_MAX;

	if( pRecSizes &&
		TABLE_ENTRY_NOTFOUND != pRecSizes->SearchKey( nPos, &nTablePos ) )
	{
		nRet = pRecSizes->GetObject( nTablePos );
	}
	ASSERT( nRet != ULONG_MAX, "Record-Size nicht gefunden" );

	return nRet;
}

void Sw3IoImp::FlushRecSizes()
{
	delete pRecSizes;
	pRecSizes = 0;
}

// Zurueckliefern, wie viele Bytes ein Record noch enthaelt

sal_uInt32 Sw3IoImp::BytesLeft()
{
	sal_uInt16 nLvl = aRecSizes.Count();
	sal_uInt32 n = 0;
	if( nLvl && !nRes )
	{
		sal_uInt32 nEndPos = aRecSizes[ nLvl-1 ];
		sal_uInt32 nPos = pStrm->Tell();
		if( nEndPos > nPos )
			n = nEndPos - nPos;
	}

	return n;
}

// was gibt es als naechstes?

sal_uInt8 Sw3IoImp::Peek()
{
	sal_uInt8 c = SWG_EOF;
	if( !nRes )
	{
		sal_uInt32 nPos = pStrm->Tell();
		*pStrm >> c;
		pStrm->Seek( nPos );
		if( pStrm->GetErrorCode() != SVSTREAM_OK )
		{
			if( IsWarning(pStrm->GetErrorCode()) )
			{
				Warning( pStrm->GetErrorCode() );
				pStrm->ResetError();
			}
			else
			{
			 	Error( ERR_SWG_READ_ERROR );
				c = SWG_EOF;
			}
		}
	}
	return c;
}

// Den aktuellen Record ueberspringen

void Sw3IoImp::SkipRec()
{
	sal_uInt8 c = Peek();
	OpenRec( c );
	pStrm->Seek( aRecSizes[aRecSizes.Count()-1] );
	CloseRec( c );
}

void Sw3IoImp::InRecSizes( sal_uInt32 nRecPos )
{
	ASSERT( !pRecSizes, "RecSize-Tabelle existiert noch" );
	ASSERT( nRecPos, "Keine Position der RecSize-Tabelle" );

	if( nRecPos )
	{
		pRecSizes = new Sw3RecordSizeTable;

		// Wenn der Stream vor dem Record steht, wird der Record
		// normal gelesen. Sonst wird erstmal zu ihm geseekt und
		// nach dem Lesen wieder am die aktuelle Stelle zurueck.
		sal_uInt32 nOldPos = pStrm->Tell();
		if( nOldPos != nRecPos )
			pStrm->Seek( nRecPos );

		sal_uInt32 nCount, nPos, nSize;
		OpenRec( SWG_RECSIZES );
		OpenFlagRec();
		*pStrm >> nCount;
		CloseFlagRec();

		for( sal_uInt32 i=0; i < (sal_uInt32)nCount; i++ )
		{
			*pStrm >> nPos >> nSize;
			pRecSizes->Insert( (sal_uInt32)nPos, nSize );
		}

		CloseRec( SWG_RECSIZES );

		if( nOldPos != nRecPos )
			pStrm->Seek( nOldPos );
	}
}

sal_uInt32 Sw3IoImp::OutRecSizes()
{
	sal_uInt32 nRecPos = 0;
	if( pRecSizes )
	{
		sal_uInt32 nCount = pRecSizes->Count();
		ASSERT( nCount, "RecSize-Tabelle ist leer" );

		if( (nCount*8 + 4) > MAX_SMALL_RECSIZE )
		{
			// Der Record darf kein langer sein, sonst haben wir ein
			// Problem ...
		 	Error( ERR_SWG_LARGE_DOC_ERROR );
		}
		else
		{
			nRecPos = pStrm->Tell();
			OpenRec( SWG_RECSIZES );

			*pStrm << (sal_uInt8)0x04 << (sal_uInt32)nCount;

			for( sal_uInt32 i=0; i < nCount; i++ )
			{
				*pStrm  << (sal_uInt32)pRecSizes->GetObjectKey( i )
						<< (sal_uInt32)pRecSizes->GetObject( i );
			}

			CloseRec( SWG_RECSIZES );
		}
	}

	return nRecPos;
}

// Ein Flag-Byte enthaelt immer die Anzahl Daten im unteren Nybble.
// Hier wird das Flagbyte mit der aktuellen Position ausgewertet.

sal_uInt8 Sw3IoImp::OpenFlagRec()
{
	sal_uInt8 cFlags;
	*pStrm >> cFlags;
	nFlagRecEnd = pStrm->Tell() + ( cFlags & 0x0F );
	return cFlags;
}

// Die folgende Routine fuehrt einen Skip durch, falls noch nicht
// alle Daten gelesen wurden.

void Sw3IoImp::CloseFlagRec()
{
	ASSERT( pStrm->Tell() <= nFlagRecEnd, "Zu viele Binaerdaten gelesen" );
	if( pStrm->Tell() != nFlagRecEnd )
		Warning(),
		pStrm->Seek( nFlagRecEnd );
}

// Merken der Position fuer einen 16-Bit-Wert, der spaeter dort eingefuegt wird
// Der Parameter ist nur Dokumentation

void Sw3IoImp::OpenValuePos16( sal_uInt16 )
{
	sal_uInt16 nLvl = aValPositions.Count();
	if( nLvl >= 31 && IsSw31Or40Export() )
	 	Error( ERR_SWG_LARGE_DOC_ERROR );
	aValPositions.Insert( pStrm->Tell(), nLvl  );
	*pStrm << (sal_uInt16) 0;
}

// Einfuegen eines 16-Bit-Werts an der obersten Stack-Position

void Sw3IoImp::CloseValuePos16( sal_uInt16 nVal )
{
	sal_uInt16 nLvl = aValPositions.Count();
	ASSERT( nLvl, "Unterlauf ValuePos-Stack" );
	if( nLvl )
	{
		nLvl--;
		sal_uInt32 nPos = pStrm->Tell();
		pStrm->Seek( aValPositions[nLvl] );
		aValPositions.Remove( nLvl, 1 );
		*pStrm << nVal;
		pStrm->Seek( nPos );
	}
}

// Merken der Position fuer einen 32-Bit-Wert, der spaeter dort eingefuegt wird
// Der Parameter ist nur Dokumentation

void Sw3IoImp::OpenValuePos32( sal_uInt32 )
{
	sal_uInt16 nLvl = aValPositions.Count();
	if( nLvl >= 31 && IsSw31Or40Export() )
	 	Error( ERR_SWG_LARGE_DOC_ERROR );
	aValPositions.Insert( pStrm->Tell(), nLvl );
	*pStrm << (sal_uInt32) 0;
}

// Einfuegen eines 32-Bit-Werts an der obersten Stack-Position

void Sw3IoImp::CloseValuePos32( sal_uInt32 nVal )
{
	sal_uInt16 nLvl = aValPositions.Count();
	ASSERT( nLvl, "Unterlauf ValuePos-Stack" );
	if( nLvl )
	{
		nLvl--;
		sal_uInt32 nPos = pStrm->Tell();
		pStrm->Seek( aValPositions[nLvl] );
		aValPositions.Remove( nLvl, 1 );
		*pStrm << nVal;
		pStrm->Seek( nPos );
	}
}

void Sw3IoImp::CheckIoError( SvStream* p )
{
	const sal_uInt32 nErr = p->GetErrorCode();
	if( nErr != SVSTREAM_OK )
	{
		if( IsWarning(nErr) )
		{
			nWarn = p->GetErrorCode();
			p->ResetError();
		}
		else if( nErr == SVSTREAM_DISK_FULL )
			nRes = ERR_W4W_WRITE_FULL;
		else
			nRes = bOut ? ERR_SWG_WRITE_ERROR : ERR_SWG_READ_ERROR;
	}
}

// Komprimiertes Speichern von sal_uInt32. Das Speichern erfolgt aehnlich wie
// im UTF-Zeichensatz:
//
// von			bis         bytes	start byte (binaer)
// ----------------------------------------------------
// 0x0000 0000	0x0000 007f 1		0x0xxx xxxx
// 0x0000 0080	0x0000 3fff 2		0x10xx xxxx
// 0x0000 4000	0x001f ffff 3		0x110x xxxx
// 0x0020 0000	0x0fff ffff	4		0x1110 xxxx
// 0x1000 0000	0xffff ffff	5		0x1111 0??? xxxx xxxx
//
// Sofern zwei oder view Bytes gleichzeitig geschrieben werden koennten,
// werden sie als sal_uInt16 oder sal_uInt32 am Stueck geschrieben.
// Bei 5 Bytes bleiben die ersten 3 Bits unbenutzt. Sie werden beim
// Einlesen ignoriert und koennen deshalb spaeter mal fuer etwas anderes
// benutzt werden.

sal_uInt32 Sw3IoImp::InULong( SvStream& rStrm )
{
	sal_uInt32 n32;
	sal_uInt16 n16;
	sal_uInt8 n8;

	rStrm >> n8;
	if( (n8 & 0x80) == 0x00 )
	{
		// 0x0www wwww
		// --> 0x0000 0000  0000 0000  0000 0000  0www wwww

		n32 = (sal_uInt32)(n8 & 0x7F);
	}
	else if( (n8 & 0xC0) == 0x80 )
	{
		// 0x10xx xxxx  wwww wwww
		// --> 0x0000 0000  0000 0000  00xx xxxx  wwww wwww

		n32 = (sal_uInt32)(n8 & 0x3F);
		n32 <<= 8;

		rStrm >> n8;
		n32 += (sal_uInt32)n8;
	}
	else if( (n8 & 0xE0) == 0xC0 )
	{
		// 0x110y yyyy  wwww wwww  xxxx xxxx
		// --> 0x0000 0000  000y yyyy  xxxx xxxx  wwww wwww

		n32 = (sal_uInt32)(n8 & 0x1F);
		n32 <<= 16;

		rStrm >> n16;
		n32 += (sal_uInt32)n16;
	}
	else if( (n8 & 0xF0) == 0xE0 )
	{
		// 0x1110 zzzz  yyyy yyyy  wwww wwww  xxxx xxxx
		// --> 0x0000 zzzz  yyyy yyyy  xxxx xxxx  wwww wwww

		n32 = (sal_uInt32)(n8 & 0x0F);
		n32 <<= 8;

		rStrm >> n8;
		n32 += (sal_uInt32)n8;
		n32 <<= 16;

		rStrm >> n16;
		n32 += (sal_uInt32)n16;
	}
	else if( (n8 & 0xF8) == 0xF0 )
	{
		// 0x1111 0???  wwww wwww  xxxx xxxx  yyyy yyyy  zzzz zzzz
		// --> zzzz zzzz  yyyy yyyy  xxxx xxxx  wwww wwww
		rStrm >> n32;
	}
	else
	{
//	 	Error( ERR_SWG_READ_ERROR );
		n32 = 0xABADCAFE;
	}

	return (sal_uInt32)n32;
}

void Sw3IoImp::OutULong( SvStream& rStrm, sal_uInt32 n32 )
{
	if( n32 < 0x00000080 )
	{
		// 0w0000 0000  0000 0000  0000 0000  0www wwww
		// -> 0w0www wwww

		rStrm << (sal_uInt8)n32;
	}
	else if( n32 < 0x00004000 )
	{
		// 0x0000 0000  0000 0000  00xx xxxx  wwww wwww
		// --> 0x10xx xxxx  wwww wwww

		n32 |= 0x00008000;
		rStrm << (sal_uInt8)(n32 >> 8);
		rStrm << (sal_uInt8)n32;
	}
	else if( n32 < 0x00200000 )
	{
		// 0x110y yyyy  xxxx xxxx  wwww wwww
		// --> 0x0000 0000  000y yyyy  wwww wwww  xxxx xxxx

		n32 |= 0x00C00000;
		rStrm << (sal_uInt8)(n32 >> 16);
		rStrm << (sal_uInt16)n32;
	}
	else if( n32 < 0x10000000 )
	{
		// 0x1110 zzzz  yyyy yyyy  xxxx xxxx  wwww wwww
		// --> 0x0000 zzzz  yyyy yyyy  wwww wwww  xxxx xxxx

		n32 |= 0xE0000000;
		rStrm << (sal_uInt8)(n32 >> 24);
		rStrm << (sal_uInt8)(n32 >> 16);
		rStrm << (sal_uInt16)n32;
	}
	else
	{
		// zzzz zzzz  yyyy yyyy  xxxx xxxx  wwww wwww
		// --> 0x1111 00000  wwww wwww  xxxx xxxx  yyyy yyyy  zzzz zzzz

		rStrm << (sal_uInt8)0xF0;
		rStrm << (sal_uInt32)n32;
	}
}

/*************************************************************************
*
*		Prozentanzeige
*
*************************************************************************/

void Sw3IoImp::OpenPercentBar( sal_uInt32 n1, sal_uInt32 n2 )
{
	if( !bBlock )
	{
		nCurPercent = n1;
		nEndPercent = n2;
		::StartProgress( bOut ? STR_STATSTR_SWGWRITE : STR_STATSTR_SWGREAD,
						 n1, n2, pDoc->GetDocShell() );
	}
}

void Sw3IoImp::ClosePercentBar()
{
	if( !bBlock )
		::EndProgress( pDoc->GetDocShell() );
}

void Sw3IoImp::SetPercentBar( sal_uInt32 n )
{
	//ASSERT( pStrm!=pContents || (n-nCurPercent)<1024, "SetPercentBar zu lange nicht mehr aufgerufen!" );
	if( !bBlock && (pStrm == &pContents ) && 	// nicht fuer SwPageStyles
		( n > nCurPercent ) && ( n <= nEndPercent ) )
		::SetProgressState( nCurPercent = n, pDoc->GetDocShell() );
}

/*************************************************************************
*
*		Drawing Layer
*
*************************************************************************/

#define SIGN_FRMIDS 0x444D

void Sw3IoImp::LoadDrawingLayer()
{
	if( !pDrawing.Is() || ( nFltFlags & FLTF_NO_DRAWINGS )
#ifndef PRODUCT
			|| SwViewOption::IsTest9()
#endif
			)
	{
		// gar kein Drawing-Stream da!
//		nGblFlags |= SW3F_NODRAWING;
		return;
	}

	// Wenn der erste Stream gelesen wird, kann es noch keine RecSizes geben
	ASSERT( !HasRecSizes(), "Hier darf es noch keine RecSizes geben" );
	if( HasRecSizes() )
		FlushRecSizes();

	pDrawing->Seek( 0L );
	pDrawing->SetBufferSize( SW3_BSR_DRAWING );
	SdrModel* pModel = NULL;
	if( bInsert )
	{
		//!!Diesen Code parallel zum Code fuer die Pools im docnew.cxx
		//pflegen.
		SfxItemPool *pAttrPool = new SfxItemPool(
										String::CreateFromAscii("SWG"),
										POOLATTR_BEGIN, POOLATTR_END-1,
										aSlotTab, aAttrTab );
		SfxItemPool *pSdrPool = new SdrItemPool( pAttrPool );
		SfxItemPool *pEEgPool = EditEngine::CreatePool();
		pSdrPool->SetSecondaryPool( pEEgPool );
		pAttrPool->FreezeIdRanges();
		SdrModel* pInsModel = new SwDrawDocument( pAttrPool, pDoc->GetDocShell() );
		pSdrPool->Load( *pDrawing );
		if( pDrawing->GetError() == SVSTREAM_OK )
			*pDrawing >> *pInsModel;
		if( pDrawing->GetError() == SVSTREAM_OK )
		{
			pModel = pDoc->MakeDrawModel();
			// Objekte werden vor die aktuellen Objekte eingefuegt
			SdrPage* pInsPage = pInsModel->GetPage( 0 );
			SdrPage* pPage = pModel->GetPage( 0 );
			pPage->RecalcObjOrdNums();
			nZOrderOff = pPage->GetObjCount();

			for( sal_uInt32 n = pInsPage->GetObjCount(); n--; )
			{
				SdrObject* pObj = pInsPage->RemoveObject( 0 );
				if( pObj )
					pPage->InsertObject( pObj );
				else
					ASSERT( !this, "wo ist das DrawObject?" );
			}
		}
		delete pInsModel;
		pSdrPool->Delete();
		pAttrPool->SetSecondaryPool(0);
		pSdrPool->SetSecondaryPool(0);
		delete pAttrPool;
		delete pSdrPool;
		delete pEEgPool;
	}
	else
	{
		pModel = pDoc->MakeDrawModel();
		SfxItemPool *pDrawPool = pModel->GetItemPool().GetSecondaryPool();
		ASSERT( pDrawPool, "DrawPool not found" );
		pDrawPool->Load( *pDrawing );
		if( pDrawing->GetError() == SVSTREAM_OK )
		{
			*pDrawing >> *pModel;
			// for Bug 73110 - decrement all item refcounts
			pDrawPool->LoadCompleted();
		}
	}
	if( pDrawing->GetError() != SVSTREAM_OK )
	{
		// Wenn der doofe Drawing Layer mal wieder Probleme gemacht hat,
		// einfach keine Zeichenobjekte laden!
		pDoc->InitDrawModel();
		// Keinen Fehler setzen, sondern Dokument weiter bearbeiten,
		// um so viel wie moeglich vom Dok zu retten.
		bNoDrawings = sal_True;
		pDrawing->SetBufferSize( 0 );
		return;
	}
	else
		// Der Drawing Layer ist jetzt verfuegbar
		nGblFlags &= ~SW3F_NODRAWING;
	// Zu guter Letzt muss noch fuer jeden frame::Frame ein FlyDraw-Objekt
	// angelegt werden, damit die Z-Order der Zeichenobjekte wieder
	// stimmt.
	sal_uInt16 nSign = 0, nFrmIds = 0;
	*pDrawing >> nSign >> nFrmIds;
	if( nSign == SIGN_FRMIDS )
	{
		pModel = pDoc->MakeDrawModel();
		SdrPage* pPage = pModel->GetPage( 0 );
		for( sal_uInt16 i = 0; i < nFrmIds; i++ )
		{
			sal_uInt32 nFrmPos;
			*pDrawing >> nFrmPos;
			if( pDrawing->GetError() != SVSTREAM_OK || pDrawing->IsEof() )
			{
			 		Error( ERR_SWG_READ_ERROR );
				break;
			}
			pPage->InsertObject( new SwFlyDrawObj, nFrmPos + nZOrderOff );
		}
	}
	nHiddenDrawObjs = ULONG_MAX;
	if( !nRes && SOFFICE_FILEFORMAT_50 <= pDrawing->GetVersion() )
	{
		sal_uInt32 n;
		*pDrawing >> n;
		if( !pDrawing->IsEof() && pModel )
		{
			sal_uInt32 nCount = pModel->GetPage( 0 )->GetObjCount();
			if( n <= nCount )
				nHiddenDrawObjs = nCount - n;
		}
	}

	CheckIoError( pDrawing );
	pDrawing->SetBufferSize( 0 );
}

void Sw3IoImp::SaveDrawingLayer()
{
	// Wenn kein Stream da ist, gibt es im Layer nix zu saven.
	if( !pDrawing.Is() )
		return;

	if( HasRecSizes() )	// sicher ist sicher
		FlushRecSizes();

	pDrawing->SetSize( 0L );
	// Stream weg, wenn wir kein OLE-Objekt sind
	//if( pRoot->IsRoot() )
	//	pRoot->Commit();
	pDrawing->SetBufferSize( SW3_BSW_DRAWING );

	// Den Pool nicht vergessen...
	SdrModel* pModel = pDoc->GetDrawModel();
	ASSERT( pModel, "SaveDrawingLayer without DrawModel" );
	//Auf die Korrektheit der OrdNums sind wir schon angewiesen.
	pModel->GetPage( 0 )->RecalcObjOrdNums();

//-/	pModel->PrepareStore();
	pModel->PreSave();

	SfxItemPool *pDrawIPool = pModel->GetItemPool().GetSecondaryPool();
	ASSERT( pDrawIPool, "DrawPool not found" );

	// Die FF-Version muss an einem Master-Pool stehen
	long nFFVersion = pDrawing->GetVersion();
	long nOldFFVersion = pModel->GetItemPool().GetFileFormatVersion();
	ASSERT( IsSw31Export() ? nFFVersion==SOFFICE_FILEFORMAT_31
						   : (nFFVersion==SOFFICE_FILEFORMAT_40 ||
							  nFFVersion==SOFFICE_FILEFORMAT_50),
			"FF-Version am Drawing-Layer-Stream stimmt nicht" );
	pModel->GetItemPool().SetFileFormatVersion( (sal_uInt16)nFFVersion );

	pDrawIPool->Store( *pDrawing );
	*pDrawing << *pModel;

	pModel->GetItemPool().SetFileFormatVersion( nOldFFVersion );


	// Nun noch die Liste der frame::Frame-Z-IDs
	sal_uInt16 nFrmIds = 0;
	sal_uInt32 nIdPos = 0;
	SdrPage* pPage = pModel->GetPage( 0 );
	for ( sal_uInt32 i = 0; i < pPage->GetObjCount(); i++ )
	{
		SdrObject *pObj = pPage->GetObj( i );
		// fix #45256#: Auch die Indizes von Master-Objekten muessen
		// exportiert werden, weil sonst die Indizes der anderen Objekte
		// beim Laden nicht mehr stimmen.
		if ( pObj->IsWriterFlyFrame() || pObj->ISA(SwFlyDrawObj) )
		{
			if( !nFrmIds )
			{
				*pDrawing << (sal_uInt16) SIGN_FRMIDS;
				nIdPos = pDrawing->Tell();
				*pDrawing << (sal_uInt16) nFrmIds;
			}
			*pDrawing << (sal_uInt32) i;
			nFrmIds++;
		}
	}
#ifndef PRODUCT
	{
		size_t nArrSz = pPage->GetObjCount() / 8;
		if( (pPage->GetObjCount() % 8) > 0 )
			nArrSz++;
		pRefSdrObjects = new sal_uInt8[nArrSz];
		while( nArrSz )
			pRefSdrObjects[--nArrSz] = 0;
	}
#endif

	if( nFrmIds )
	{
		sal_uInt32 nPos = pDrawing->Tell();
		pDrawing->Seek( nIdPos );
		*pDrawing << (sal_uInt16) nFrmIds;
		pDrawing->Seek( nPos );
	}
	else
	{
		*pDrawing << (sal_uInt16)0 << (sal_uInt16)0;
	}
	if( !IsSw31Or40Export() )
	{
		sal_uInt32 n = (nHiddenDrawObjs != ULONG_MAX)
						? (pPage->GetObjCount() - nHiddenDrawObjs)
						: 0;
		*pDrawing << n;
	}

	ASSERT( !pModel->GetStyleSheetPool(), "SdrModel hat StyleSheet-Pool" );
	pDrawing->Commit();
	CheckIoError( pDrawing );
	pDrawing->SetBufferSize( 0 );

	pModel->PostSave();
}

/*************************************************************************
*
*		Seitenvorlagen
*
*************************************************************************/

void Sw3IoImp::LoadPageStyles()
{
	pPageStyles->Seek( 0L );
	pPageStyles->SetBufferSize( SW3_BSR_PAGESTYLES );
	SvStream* pOld = pStrm;
	pStrm = pPageStyles;
	if( !nRes )
		InPageDescs();
	pStrm = pOld;
	CheckIoError( pPageStyles );
	pPageStyles->SetBufferSize( 0 );
}

void Sw3IoImp::SavePageStyles( sal_Bool bUsed )
{
	// Falls der Stream existiert, muessen die dazugehoerigen Grafiken
	// geloescht werden.
	SvStream* pOld = pStrm;
	pStrm = pPageStyles;
	pPageStyles->SetSize( 0L );
	// Stream weg, wenn wir kein OLE-Objekt sind
	//if( pRoot->IsRoot() )
	//	pRoot->Commit();
	pPageStyles->SetBufferSize( SW3_BSW_PAGESTYLES );
	OutPageDescs( bUsed );

	sal_uInt32 nRecSzPos = 0;
	if( !nRes && HasRecSizes() && !IsSw31Or40Export() )
		nRecSzPos = OutRecSizes();

	OpenRec( SWG_EOF );
	CloseRec( SWG_EOF );

	if( nRecSzPos )
		OutRecordSizesPos( nRecSzPos );

	pStrm = pOld;
	pPageStyles->Commit();
	CheckIoError( pPageStyles );
	pPageStyles->SetBufferSize( 0 );
}

/*************************************************************************
*
*		Numerierungs-Regeln
*
*************************************************************************/

void Sw3IoImp::LoadNumRules()
{
	if( !pNumRules.Is() )
		return;

	pNumRules->Seek( 0L );
	pNumRules->SetBufferSize( SW3_BSR_NUMRULES );
	SvStream* pOld = pStrm;
	pStrm = pNumRules;
	if( !nRes )
		InNumRules();
	pStrm = pOld;
	CheckIoError( pNumRules );
	pNumRules->SetBufferSize( 0 );
}

void Sw3IoImp::SaveNumRules( sal_Bool bUsed )
{
	if( !pNumRules.Is() )
		return;

	SvStream* pOld = pStrm;
	pStrm = pNumRules;
	pNumRules->SetSize( 0L );
	pNumRules->SetBufferSize( SW3_BSW_NUMRULES );
	OutNumRules( bUsed );

	sal_uInt32 nRecSzPos = 0;
	if( !nRes && HasRecSizes() && !IsSw31Or40Export() )
		nRecSzPos = OutRecSizes();

	OpenRec( SWG_EOF );
	CloseRec( SWG_EOF );

	if( nRecSzPos )
		OutRecordSizesPos( nRecSzPos );

	pStrm = pOld;
	pNumRules->Commit();
	CheckIoError( pNumRules );
	pNumRules->SetBufferSize( 0 );
}

/*************************************************************************
*
*		Inhaltlicher Teil
*
*************************************************************************/

void Sw3IoImp::LoadContents( SwPaM* pPaM )
{
	pContents->Seek( 0L );
	pContents->SetBufferSize( SW3_BSR_CONTENTS );
	pStrm = pContents;
	LoadDocContents( pPaM );
	pStrm = NULL;
	CheckIoError( pContents );
	pContents->SetBufferSize( 0 );
}

void Sw3IoImp::SaveContents( SwPaM& rPaM, const String* pBlkName )
{
	pStrm = pContents;
	pContents->SetSize( 0L );
	// Stream weg, wenn wir kein OLE-Objekt sind
	//if( pRoot->IsRoot() )
	//	pRoot->Commit();
	pContents->SetBufferSize( SW3_BSW_CONTENTS );
	SaveDocContents( rPaM, pBlkName );
	pStrm = NULL;
	pContents->Commit();
	CheckIoError( pContents );
	pContents->SetBufferSize( 0 );
}

/*************************************************************************
*
*		String-Pool
*
*************************************************************************/

#define EXT_SEPARATOR ((sal_Unicode) 0x0A)

Sw3StringPool::Sw3StringPool()
{
	bFixed = sal_False;
}

const RES_POOLCOLL_HTML_LISTING_40 = 0x3002;
const RES_POOLCOLL_HTML_XMP_40 = 0x3003;
const RES_POOLCOLL_HTML_HR_40 = 0x3004;
const RES_POOLCOLL_HTML_H6_40 = 0x3005;
const RES_POOLCOLL_HTML_DD_40 = 0x3006;
const RES_POOLCOLL_HTML_DT_40 = 0x3007;

sal_uInt16 Sw3StringPool::ConvertFromOldPoolId( sal_uInt16 nId, sal_uInt16 nVersion )
{
	if( nVersion < SWG_HTMLCOLLCHG )
	{
		// - H6 wurde entfernt und muss durch Ueberschrift 6 ersetzt werden.
		// - LISTING unx XMP wurden ebenfalls entfernt. Fuer sie muessen
		//	 Benutzer-Vorlagen angelegt werden
		// - HR, DT und DD sind nach vorne gerueckt.
		switch( nId )
		{
		case RES_POOLCOLL_HTML_LISTING_40:
		case RES_POOLCOLL_HTML_XMP_40:
			nId |= USER_FMT;
			break;

		case RES_POOLCOLL_HTML_HR_40:	nId = RES_POOLCOLL_HTML_HR; break;
		case RES_POOLCOLL_HTML_H6_40:	nId = RES_POOLCOLL_HEADLINE6; break;
		case RES_POOLCOLL_HTML_DD_40:	nId = RES_POOLCOLL_HTML_DD; break;
		case RES_POOLCOLL_HTML_DT_40:	nId = RES_POOLCOLL_HTML_DT; break;
		}
	}

	return nId;
}

sal_uInt16 Sw3StringPool::ConvertToOldPoolId( sal_uInt16 nId, sal_uInt32 nFFVersion )
{
	if( nFFVersion <= SOFFICE_FILEFORMAT_40 )
	{
		// H6, LISTUNG undx XMP wurden entfernt.
		// HR, DT und DD sind nach vorne gerueckt.
		switch( nId )
		{
		case RES_POOLCOLL_HTML_HR:	nId = RES_POOLCOLL_HTML_HR_40; break;
		case RES_POOLCOLL_HEADLINE6:nId = RES_POOLCOLL_HTML_H6_40; break;
		case RES_POOLCOLL_HTML_DD:	nId = RES_POOLCOLL_HTML_DD_40; break;
		case RES_POOLCOLL_HTML_DT:	nId = RES_POOLCOLL_HTML_DT_40; break;

		//JP 05.05.98: im 3.1/4.0 war ein Bug im sw3style bei der Abfrage
		//				ob die PoolID einer Zeichenvorlage eine Benutzer-
		//				definierte ID ist. Alles zwischen
		// 				RES_POOLCHR_NORMAL_END und RES_POOLCHR_HTML_BEGIN
		//				werden als gueltig erkannt, was falsch ist.
		default:
			if( ( RES_POOLCHR_TOXJUMP < nId && nId < RES_POOLCHR_NORMAL_END )
			  ||( RES_POOLFRM_WATERSIGN < nId && nId < RES_POOLFRM_END )
			  ||( RES_POOLPAGE_HTML < nId && nId < RES_POOLPAGE_END ) )
			  nId = USHRT_MAX;
		}
	}

	return nId;
}


// Sammeln der Strings am Doc. Es werden alle Strings aus benannten
// Formaten, Collections und PageDescs gesammelt. Weiter wird allen
// Auto-Frameformaten eine Extension im Namen verpat, weil die Namen
// nicht eindeutig sind.

void Sw3StringPool::Setup( SwDoc& rDoc, long nFFVersion,
						   Sw3ExportInfo *pExportInfo )
{
	Clear();
	nExpFFVersion = nFFVersion;

	// Das Written-Flag wird gleich mit geknackt!
	// Das ist wichtig, da Formate (theoretisch) in verschiedenen
	// Streams landen koennen.
	SwMsgPoolItem aMsgHint( RES_RESET_FMTWRITTEN );
	rDoc.GetDfltFrmFmt()->Modify( &aMsgHint, &aMsgHint );

	bFixed = sal_False;
	// Defaultformate:
	Setup( rDoc, *rDoc.GetDfltFrmFmt() );
	Setup( rDoc, *rDoc.GetDfltCharFmt() );
	// Text-Collections
	sal_uInt16 nArrLen = rDoc.GetTxtFmtColls()->Count();
	for( sal_uInt16 n = 0; n < nArrLen; n++ )
		Setup( rDoc, *(*rDoc.GetTxtFmtColls())[ n ] );
	// benannte Zeichen- und Rahmenvorlagen
	nArrLen = rDoc.GetCharFmts()->Count();
	// Element 0 ist das Default-Format!
	for( n = 1; n < nArrLen; n++ )
	Setup( rDoc, *(*rDoc.GetCharFmts())[ n ] );
	nArrLen = rDoc.GetFrmFmts()->Count();
	// Element 0 ist das Default-Format!
	for( n = 1; n < nArrLen; n++ )
	{
		const SwFmt& rFmt = *(*rDoc.GetFrmFmts())[ n ];
		// Autoformate in dieser Liste muessen mit einer
		// Extension versehen werden!
		sal_uInt16 nFmtId =  0;
		const String& rName = rFmt.GetName();
		// TODO: unicode: correct?
		if( rFmt.IsAuto() ) 		// Autoformat
			nFmtId = Count()+1; //++nId;
		Setup( rDoc, rFmt, nFmtId );
	}
	nArrLen = rDoc.GetSpzFrmFmts()->Count();
	for( n = 0; n < nArrLen; n++ )
		Setup( rDoc, *(*rDoc.GetSpzFrmFmts())[ n ], Count()+1 /*++nId*/ );
	// Auch hier muss eine Extension mit ran
	nArrLen = rDoc.GetTblFrmFmts()->Count();
	for( n = 0; n < nArrLen; n++ )
		Setup( rDoc, *(*rDoc.GetTblFrmFmts())[ n ], Count()+1 /*++nId*/ );
	nArrLen = rDoc.GetSections().Count();
	for( n = 0; n < nArrLen; n++ )
		Setup( rDoc, *rDoc.GetSections()[ n ], Count()+1 /*++nId*/ );
	// Seitenvorlagen
	nArrLen = rDoc.GetPageDescCnt();
	for( n = 0; n < nArrLen; n++ )
	{
		const SwPageDesc& rPg = rDoc.GetPageDesc( n );
		Add( rPg.GetName(), rPg.GetPoolFmtId() );
	}

	if( nExpFFVersion <= SOFFICE_FILEFORMAT_40 )
	{
		Add( String::CreateFromAscii(sSW3IO_FixedField), USHRT_MAX );
		Add( String::CreateFromAscii(sSW3IO_AuthorityField), USHRT_MAX );
	}

	// fix #26064#: Namen der 3 Label Numernkreise: Hier wird zusaetzlich
	// noch die Pool-Id des dazugehoerigen Formats gespeichert
	{
		String aAbb( SW_RES(STR_POOLCOLL_LABEL_ABB) );
		String aTable( SW_RES(STR_POOLCOLL_LABEL_TABLE) );
		String aFrame( SW_RES(STR_POOLCOLL_LABEL_FRAME) );
		String aDrawing( SW_RES(STR_POOLCOLL_LABEL_DRAWING) );

		for( n = 0; n < INIT_FLDTYPES; n++ )
		{
			SwFieldType *pFldType = (*rDoc.GetFldTypes())[n];
			switch (pFldType->Which())
			{
				case RES_SETEXPFLD:
				{
					if( GSE_SEQ & ((const SwSetExpFieldType *)pFldType)->GetType() )
					{
						sal_uInt16 nPoolId = USHRT_MAX;
						const String& rName = pFldType->GetName();
						if( aAbb == rName )
							nPoolId = RES_POOLCOLL_LABEL_ABB;
						else if( aTable == rName )
							nPoolId = RES_POOLCOLL_LABEL_TABLE;
						else if( aFrame == rName )
							nPoolId = RES_POOLCOLL_LABEL_FRAME;
						else if( aDrawing == rName )
							nPoolId = RES_POOLCOLL_LABEL_DRAWING;

						Add( rName, nPoolId );
					}
				}
				break;

				case RES_DBSETNUMBERFLD:
				case RES_DBNUMSETFLD:
				case RES_DBNEXTSETFLD:
				case RES_DBNAMEFLD:
				if( nExpFFVersion > SOFFICE_FILEFORMAT_31 )
				{
					SwClientIter aIter( *pFldType );

					for( SwFmtFld* pFmtFld = (SwFmtFld*)aIter.First( TYPE(SwFmtFld) );
						pFmtFld; pFmtFld = (SwFmtFld*)aIter.Next() )
					{
						if( pFmtFld->GetTxtFld() )
						{
							SwDBNameInfField* pFld = (SwDBNameInfField *)pFmtFld->GetFld();
							SwDBData aData(pFld->GetRealDBData());
							String sDBName(aData.sDataSource);
							sDBName += DB_DELIM;
							sDBName += (String)aData.sCommand;
							Add( sDBName, IDX_NOCONV_FF );
						}
					}
				}
				break;
			}

		}
	}
	// Namen benutzerdefinierter Felder
	nArrLen = rDoc.GetFldTypes()->Count();
	if( nArrLen > INIT_FLDTYPES )
	{
		for( n = INIT_FLDTYPES; n < nArrLen; n++ )
		{
			SwFieldType *pFldType = (*rDoc.GetFldTypes())[n];

			switch (pFldType->Which())
			{
				case RES_DBFLD:
					Add( ((SwDBFieldType*)pFldType)->GetColumnName(), USHRT_MAX );
					if( nExpFFVersion > SOFFICE_FILEFORMAT_31 )
					{
						SwDBData aData(((SwDBFieldType*)pFldType)->GetDBData());
						String sDBName(aData.sDataSource);
						sDBName += DB_DELIM;
						sDBName += (String)aData.sCommand;
						Add( sDBName, IDX_NOCONV_FF );
					}
					break;

				default:
					Add( pFldType->GetName(), USHRT_MAX );
					break;
			}
		}
	}

	// Ab dem 5.0-FF stehen auch die Benutzer-definierten Verzeichnisnamen
	// im String-Pool
	if( nExpFFVersion > SOFFICE_FILEFORMAT_40 )
	{
		const SwSectionFmts& rSectFmts = rDoc.GetSections();
		for( sal_uInt16 n = rSectFmts.Count(); n; )
		{
			const SwTOXType* pType;
			const SwTOXBaseSection *pTOXBaseSect;
			const SwSectionFmt* pSectFmt = rSectFmts[ --n ];
			const SwSection* pSect = pSectFmt->GetSection();
			if( pSect && TOX_CONTENT_SECTION == pSect->GetType() &&
				pSect->GetFmt() && pSectFmt->GetSectionNode() &&
				0 != (pTOXBaseSect = PTR_CAST( SwTOXBaseSection, pSect )) &&
				0 != (pType = pTOXBaseSect->GetTOXType()) )
			{
				// All types above TOX_USER are new in version 5.2. That for,
				// their names must be added to the string pool.
				if( pType->GetType() >= TOX_ILLUSTRATIONS ||
					pType->GetTypeName() !=
								SwTOXBase::GetTOXName(pType->GetType()) )
				{
					Add( pType->GetTypeName(), USHRT_MAX );
				}
				// Add template names
				const SwForm& rForm = pTOXBaseSect->GetTOXForm();
				for( sal_uInt16 i = 0; i < rForm.GetFormMax(); i++ )
				{
					const String& rCollNm = rForm.GetTemplate( i );
					if( rCollNm.Len() )
						SetupTxtCollByName( rDoc, rCollNm );
				}
				// Add text style names used in patterns
				for( i = 0; i < rForm.GetFormMax(); i++ )
				{
					const String& rPattern = rForm.GetPattern(i);
					if( rPattern.Len() )
					{
						SwFormTokenEnumerator aEnum( rPattern );
						while( aEnum.HasNextToken() )
						{
							SwFormToken aToken( aEnum.GetNextToken() );
							if( aToken.sCharStyleName.Len() )
								Add( aToken.sCharStyleName, aToken.nPoolId );
						}
					}
				}
				// Add style names
				for( i=0; i<MAXLEVEL; i++ )
				{
					const String& rStyleNames = pTOXBaseSect->GetStyleNames(i);
					if( rStyleNames.Len() )
					{
						xub_StrLen nStrPos = 0;
						while( nStrPos != STRING_NOTFOUND )
						{
							String aName = rStyleNames.GetToken( 0,
												TOX_STYLE_DELIMITER, nStrPos );
							ASSERT( aName.Len(), "empty style name" );
							if( aName.Len() )
								SetupTxtCollByName( rDoc, aName );
						}
					}
				}
				// Add text coll names used if new indices are converted to
				// user indices
				sal_uInt16 nPoolId = USHRT_MAX;
				switch( pType->GetType() )
				{
				case TOX_ILLUSTRATIONS:
					nPoolId = RES_POOLCOLL_LABEL_ABB;
					break;
				case TOX_OBJECTS:
					nPoolId = RES_POOLCOLL_LABEL_FRAME;
					break;
				case TOX_TABLES:
					nPoolId = RES_POOLCOLL_LABEL_TABLE;
					break;
				}
				if( USHRT_MAX != nPoolId )
				{
					String aName;
					SwStyleNameMapper::FillUIName( nPoolId, aName );
					Add( aName, nPoolId );
				}
				const String& rMainStyle =
					pTOXBaseSect->GetMainEntryCharStyle();
				if( rMainStyle.Len() )
				{
					sal_uInt16 nPoolId = SwStyleNameMapper::GetPoolIdFromUIName( rMainStyle,
													 GET_POOLID_CHRFMT );
					Add( rMainStyle, nPoolId );
				}
			}
		}
	}

	const SwTOXMark* pItem;
	nArrLen = nExpFFVersion > SOFFICE_FILEFORMAT_40
			? rDoc.GetAttrPool().GetItemCount( RES_TXTATR_TOXMARK )
			: 0;
	for( n = 0; n < nArrLen; ++n )
	{
		pItem = (const SwTOXMark*)rDoc.GetAttrPool().GetItem( RES_TXTATR_TOXMARK, n );
		if( pItem )
		{
			const SwTOXType* pType = pItem->GetTOXType();
			if( pType && pType->GetTypeName() !=
								SwTOXBase::GetTOXName(pType->GetType()) )
			{
				Add( pType->GetTypeName(), USHRT_MAX );
			}
		}
	}

	const SwFmtINetFmt* pINetFmt;
	nArrLen = nExpFFVersion > SOFFICE_FILEFORMAT_31
			? rDoc.GetAttrPool().GetItemCount( RES_TXTATR_INETFMT )
			: 0;
	for( n = 0; n < nArrLen; ++n )
	{
		pINetFmt = (const SwFmtINetFmt*)rDoc.GetAttrPool().GetItem( RES_TXTATR_INETFMT, n );
		if( pINetFmt )
		{
			if( pINetFmt->GetINetFmt().Len() )
				Add( pINetFmt->GetINetFmt(), pINetFmt->GetINetFmtId() );
			if( pINetFmt->GetVisitedFmt().Len() )
				Add( pINetFmt->GetVisitedFmt(), pINetFmt->GetVisitedFmtId() );
		}
	}

	// Seit der 5.0 gibt es Redlines. Die Autoren stehen dann im String-Pool
	if( nExpFFVersion > SOFFICE_FILEFORMAT_40 )
		SetupRedlines( rDoc );

	// Beim 3.1/4.0-Export standen die Tabellen-Line/Box-Formate noch
	// im FrmFmt-Array und wurden ueber den String-Pool dort eingetragen.
	// Deshalb muessen sie jetzt auch dort eingetragen werden. Die
	// Umbennenerei erfolgt allerdings nicht mehr im Format. Stattdessen
	// wird der (erweiterte) Name in einem Array gemerkt und ueber dieses
	// ermittelt.
	if( nExpFFVersion <= SOFFICE_FILEFORMAT_40 && pExportInfo &&
		pExportInfo->pTblLineBoxFmts40 )
	{
		if( !pExportInfo->pTblLineBoxFmtNames40 )
			pExportInfo->pTblLineBoxFmtNames40 = new SvStringsDtor;

		SvStringsDtor *pNames = pExportInfo->pTblLineBoxFmtNames40;
		if( pNames->Count() )
			pNames->DeleteAndDestroy( 0, pNames->Count() );

		Sw3FrmFmts *pFmts = pExportInfo->pTblLineBoxFmts40;
		sal_uInt16 nArrLen = pFmts->Count();
		for( n=0; n<nArrLen; n++ )
		{
			// TODO: unicode: currect?
			String * pName = new String( (*pFmts)[n]->GetName() );
			(*pName += EXT_SEPARATOR) += String::CreateFromInt32( Count()+1 );
			Add( *pName, (*pFmts)[n]->GetPoolFmtId() );
			pNames->Insert( pName, pNames->Count() );
		}
	}

	// Und danach darf nix mehr in den Pool hinein!
	bFixed = sal_True;
}

void Sw3StringPool::SetupForNumRules( SwDoc& rDoc, long nFFVersion )
{
	Clear();
	nExpFFVersion = nFFVersion;
	bFixed = sal_False;

	// Die Namen von Zeichenvorlagen werden benoetigt, weil in den
	// Numerierungen auuf sie verwiesen werden kann.
	sal_uInt16 nArrLen = rDoc.GetCharFmts()->Count();
	// Element 0 ist das Default-Format!
	for( sal_uInt16 n = 1; n < nArrLen; n++ )
		Setup( rDoc, *(*rDoc.GetCharFmts())[ n ] );

	// Die Namen der Numerierungen werden sowieso benoetigt.
	nArrLen = rDoc.GetNumRuleTbl().Count();
	for( n=0; n<nArrLen; n++ )
	{
		const SwNumRule *pNumRule = rDoc.GetNumRuleTbl()[n];
		Add( pNumRule->GetName(), pNumRule->GetPoolFmtId() );
	}

	// Und die Outline-Numerierung hat auch einen Namen.
	const SwNumRule *pOutline = rDoc.GetOutlineNumRule();
	if( pOutline )
		Add( pOutline->GetName(), pOutline->GetPoolFmtId() );

	// Und danach darf nix mehr in den Pool hinein!
	bFixed = sal_True;
}

// Entfernen der Autoformat-Extension nach dem Laden/Speichern
// Dies ist ein Hash und eine Zahl, mit der Autoformate im
// FrmFmt-Array des Docs erweitert wurden.

void Sw3StringPool::RemoveExtensions( SwDoc& rDoc )
{
	sal_uInt16 nArrLen = rDoc.GetFrmFmts()->Count();
	// Element 0 ist das Default-Format!
	for( sal_uInt16 n = 1; n < nArrLen; n++ )
	{
		SwFmt& rFmt = (SwFmt&) *(*rDoc.GetFrmFmts())[ n ];
		RemoveExtension( rFmt );
	}
	nArrLen = rDoc.GetSpzFrmFmts()->Count();
	for( n = 0; n < nArrLen; n++ )
	{
		SwFmt& rFmt = (SwFmt&) *(*rDoc.GetSpzFrmFmts())[ n ];
		RemoveExtension( rFmt );
	}
	nArrLen = rDoc.GetTblFrmFmts()->Count();
	for( n = 0; n < nArrLen; n++ )
	{
		SwFmt& rFmt = (SwFmt&) *(*rDoc.GetTblFrmFmts())[ n ];
		RemoveExtension( rFmt );
	}
	nArrLen = rDoc.GetSections().Count();
	for( n = 0; n < nArrLen; n++ )
	{
		SwFmt& rFmt = (SwFmt&) *rDoc.GetSections()[ n ];
		RemoveExtension( rFmt );
	}
}

// Entfernen der Autoformat-Extension nach dem Laden/Speichern
// Dies ist ein Hash und eine Zahl, mit der Autoformate im
// FrmFmt-Array des Docs erweitert wurden.

void Sw3StringPool::RemoveExtension( SwFmt& rFmt )
{
	String aName( rFmt.GetName() );
	RemoveExtension( aName );
	// Kein SetName() wg. Assert
	(String&)rFmt.GetName() = aName;
}

void Sw3StringPool::RemoveExtension( String& rName )
{
	xub_StrLen nOff = rName.Search( EXT_SEPARATOR );
	if( nOff != STRING_NOTFOUND )
		rName.Erase( nOff );
}

// Eintragen der Strings eines Formats
// Falls nId angegeben ist, wird diese Zahl mit einem Hash an den Namen
// angefuegt, um eine Eindeutigkeit zu gewaehrleisten.

void Sw3StringPool::Setup( SwDoc& rDoc, const SwFmt& rFmt, sal_uInt16 nId )
{
	// Das Written-Flag wird gleich mit geknackt!
	// Das ist wichtig, da Formate (theoretisch) in verschiedenen
	// Streams landen koennen.
	ASSERT( !rFmt.IsWritten(), "Written-Flag am Format ist gesetzt" );
//	((SwFmt&)rFmt).ResetWritten();

	String aName( rFmt.GetName() );
	if( nId )
	{
		ASSERT( nId==Count()+1, "id ungleich String-Pool-Pos" );
		aName += EXT_SEPARATOR, aName += String::CreateFromInt32(nId);
		// Kein SetName() wg. Assert
		(String&)((SwFmt&)rFmt).GetName() = aName;
	}
	Add( aName, rFmt.GetPoolFmtId(), nId!=0 );
	if( rFmt.GetPoolHlpFileId() != UCHAR_MAX )
	{
		String* pId = rDoc.GetDocPattern( rFmt.GetPoolHlpFileId() );
		if( pId )
			Add( *pId, 0 );
	}
}

void Sw3StringPool::SetupTxtCollByName( SwDoc& rDoc, const String& rName )
{
	if( !rName.Len() )
		return;

	const SwTxtFmtColl *pColl = rDoc.FindTxtFmtCollByName( rName );
	sal_uInt16 nPoolId = pColl ? pColl->GetPoolFmtId()
						   : SwStyleNameMapper::GetPoolIdFromUIName( rName, GET_POOLID_TXTCOLL );
	Add( rName, nPoolId );
}

sal_uInt16 Sw3StringPool::Add( const String& r, sal_uInt16 n, sal_Bool bDontSearch )
{
	sal_uInt16 i = bDontSearch ? aPool.Count() : 0;

	ASSERT( nExpFFVersion, "String-Pool: FF-Version nicht gesetzt" );
	if( nExpFFVersion <= SOFFICE_FILEFORMAT_40 && n && n<IDX_SPEC_VALUE )
		n = ConvertToOldPoolId( n, nExpFFVersion );

	for( ; i < aPool.Count(); i++ )
	{
		const Sw3String* p3Str = aPool.GetObject( i );
		if( n == p3Str->GetPoolId() && r == *p3Str )
			return i;
	}
	if( !bFixed )
	{
		Sw3String* p = new Sw3String( r, n );
		aPool.Insert( p, i );
		return i;
	}
	else
	{
		ASSERT( !bFixed, "String nicht im Pool eingetragen" );
		return IDX_NO_VALUE;
	}
}


sal_uInt16 Sw3StringPool::Find( const String& r, sal_uInt16 nPoolId )
{
	ASSERT( nExpFFVersion, "String-Pool: FF-Version nicht gesetzt" );
	if( nExpFFVersion  <= SOFFICE_FILEFORMAT_40 && nPoolId && nPoolId<IDX_SPEC_VALUE )
		nPoolId = ConvertToOldPoolId( nPoolId, nExpFFVersion );

	xub_StrLen nOff = r.Search( EXT_SEPARATOR );
	if( nOff != STRING_NOTFOUND )
	{
		xub_StrLen nPos = (xub_StrLen)r.Copy(nOff+1).ToInt32() - 1;
		if( nPos<aPool.Count() )
		{
			const Sw3String* p3Str = aPool.GetObject( nPos );
			if( nPoolId == p3Str->GetPoolId() && r==*p3Str )
				return nPos;
		}
		ASSERT( !this, "String-Pool-Position ungueltig" );
	}

	xub_StrLen nLen = r.Len();
	for( sal_uInt16 i = 0; i < aPool.Count(); i++ )
	{
		const Sw3String* p3Str = aPool.GetObject( i );
		if( nPoolId == p3Str->GetPoolId() && nLen==p3Str->Len() )
		{
			xub_StrLen n = nLen;
			sal_Bool bFound = sal_True;
			while( bFound && n )
			{
				n--;
				if( r.GetChar(n) != p3Str->GetChar(n) )
				{
					bFound = sal_False;
					break;
				}
			}

			if( bFound )
				return i;
		}
	}
	return IDX_NO_VALUE;
}

const String& Sw3StringPool::Find( sal_uInt16 i )
{
	if( i < IDX_SPEC_VALUE )
	{
		if( i < aPool.Count() )
			return *aPool.GetObject( i );
		ASSERT( !this, "String-Index nicht im Stringpool" );
	}
	return aEmpty;
}

sal_uInt16 Sw3StringPool::FindPoolId( sal_uInt16 i )
{
	if( i < IDX_SPEC_VALUE )
	{
		if( i < aPool.Count() )
			return aPool.GetObject( i )->GetPoolId();
		ASSERT( !this, "String-Index nicht im Stringpool" );
	}
	return 0;
}

// OPT: Cache fuer Formate im StringPool

void Sw3StringPool::SetCachedFmt( sal_uInt16 i, SwFmt *pFmt )
{
	ASSERT( i < IDX_SPEC_VALUE && i < aPool.Count(),
			"SetCachedFmt fuer ungueltigen Index" );
	if( i < IDX_SPEC_VALUE && i < aPool.Count() )
		aPool.GetObject( i )->SetCachedFmt( pFmt );
}



SwFmt *Sw3StringPool::FindCachedFmt( sal_uInt16 i ) const
{
	if( i < IDX_SPEC_VALUE )
	{
		if( i < aPool.Count() )
			return aPool.GetObject( i )->GetCachedFmt();
		ASSERT( !this, "String-Index nicht im Stringpool" );
	}
	return 0;
}

// /OPT: Cache fuer Formate im StringPool


// Laderoutine fuer Dokumente bis 134g

void Sw3StringPool::LoadOld( SvStream& r )
{
	aPool.DeleteAndDestroy( 0, aPool.Count() );
	sal_uInt16 n;
	String s;
	r >> n;
	// Dieser schlimme Hack ist notwendig, da ich vergessen habe,
	// den Zeichensatz im Record zu speichern. Und kein Flag-Byte da!
	// Dieser Hack arbeitet gut, wenn das LSByte der Anzahl Strings != 0
	// ist, was bis heute (10.04.95) der Fall ist.
 	rtl_TextEncoding eSrcEnc = r.GetStreamCharSet();
	if( n >= 256 )
	{
		sal_uInt8 cCharSet, cDummyFlags;
		r.SeekRel( -2L );
		r >> cDummyFlags >> cCharSet >> n;
		eSrcEnc = (rtl_TextEncoding)cCharSet;
	}
	while( n-- )
	{
		r.ReadByteString( s, eSrcEnc );
		Sw3String* p = new Sw3String( s, 0 );
		aPool.Insert( p, aPool.Count() );
	}
	bFixed = sal_True;
}

void Sw3StringPool::Load( SvStream& r, sal_uInt16 nSVersion )
{
	aPool.DeleteAndDestroy( 0, aPool.Count() );
	sal_uInt8 cSet;
	sal_uInt16 n;
	String s;
	r >> cSet >> n;

	// MIB 8.4.97: Datenbank-Felder enthalten ein 0xff, das auf keinen
	// Fall mit konvertiert werden darf. Wir erkennen sie am Wert
	// IDX_NOCONV_FF.
 	rtl_TextEncoding eSrcEnc =  GetSOLoadTextEncoding( (rtl_TextEncoding)cSet,
													   r.GetVersion() );
	while( n-- )
	{
		sal_uInt16 nId;
		ByteString s8;
		r >> nId;
		r.ReadByteString( s8 );
		if( nId == IDX_NOCONV_FF )
			s = Sw3IoImp::ConvertStringNoDbDelim( s8, eSrcEnc );
		else
			s = String( s8, eSrcEnc );

		// Ggf. alte Pool-Ids auf neue mappen.
		if( nSVersion < SWG_HTMLCOLLCHG && nId && nId < IDX_SPEC_VALUE )
		{
			// Die ehemaligen Listing und XMP-Vorlagen werden umbenannt,
			// damit sie beim Export wiedergefunden werden.
			switch( nId )
			{
			case RES_POOLCOLL_HTML_LISTING_40:
				s.AssignAscii( sHTML_listing );
				break;
			case RES_POOLCOLL_HTML_XMP_40:
				s.AssignAscii( sHTML_xmp );
				break;
			}
			nId = ConvertFromOldPoolId( nId, nSVersion );
		}

		// Id und ist PoolFormat ?
		if( nId && !(USER_FMT & nId))
			SwStyleNameMapper::FillUIName( nId, s );     // dann String vom Pool erfragen

		Sw3String* p = new Sw3String( s, nId );
		aPool.Insert( p, aPool.Count() );
	}
	bFixed = sal_True;
}

void Sw3StringPool::Store( SvStream& r )
{
	ASSERT( nExpFFVersion==r.GetVersion(),
			"Sw3StringPool::Store: FF-Version am Stream stimmt nicht" );
	rtl_TextEncoding eSrcEnc = r.GetStreamCharSet();
	sal_uInt16 n = aPool.Count();
	r << (sal_uInt8) eSrcEnc
	  << (sal_uInt16) n;
	for( sal_uInt16 i = 0; i < n; i++ )
	{
		Sw3String* p = aPool.GetObject( i );
		sal_uInt16 nId = (sal_uInt16) p->GetPoolId();
		r << nId;
		if( nId == IDX_NOCONV_FF )
			r.WriteByteString( Sw3IoImp::ConvertStringNoDbDelim(
										(const String&)*p, eSrcEnc ) );
		else
			r.WriteByteString( (const String&)*p, eSrcEnc );
	}
}

void Sw3StringPool::Clear()
{
	aPool.DeleteAndDestroy( 0, aPool.Count() );
	nExpFFVersion = 0;	// um ungesetzte Version zu erkennen!
}

ByteString Sw3IoImp::ConvertStringNoDbDelim( const String& rStr,
											 rtl_TextEncoding eSource )
{
	return ConvertStringNoDelim( rStr, DB_DELIM, '\xff', eSource );
}

String Sw3IoImp::ConvertStringNoDbDelim( const ByteString& rStr,
										 rtl_TextEncoding eSource )
{
	return ConvertStringNoDelim( rStr, '\xff', DB_DELIM, eSource );
}

ByteString Sw3IoImp::ConvertStringNoDelim( const String& rStr,
										   sal_Unicode cSrcDelim,
										   sal_Char cDelim,
										   rtl_TextEncoding eSource )
{
	ByteString sDest;
	xub_StrLen nStart = 0;
	xub_StrLen nPos = 0;
	do
	{
		nPos = rStr.Search( cSrcDelim, nStart );
		if( STRING_NOTFOUND == nPos )
			nPos = rStr.Len();

		if( nStart > 0 )
			sDest += cDelim;

		if( nPos > nStart )
			sDest += ByteString( rStr.Copy( nStart, nPos-nStart ), eSource );
		nStart = nPos+1;
	}
	while( nPos < rStr.Len() );

	return sDest;
}

String Sw3IoImp::ConvertStringNoDelim( const ByteString& rStr,
									   sal_Char cSrcDelim,
									   sal_Unicode cDelim,
									   rtl_TextEncoding eSource )
{
	String sDest;
	xub_StrLen nStart = 0;
	xub_StrLen nPos = 0;
	do
	{
		nPos = rStr.Search( cSrcDelim, nStart );
		if( STRING_NOTFOUND == nPos )
			nPos = rStr.Len();

		if( nStart > 0 )
			sDest += cDelim;

		if( nPos > nStart )
			sDest += String( rStr.Copy( nStart, nPos-nStart ), eSource );
		nStart = nPos+1;
	}
	while( nPos < rStr.Len() );

	return sDest;
}

void Sw3IoImp::ChangeFontItemCharSet()
{
	rtl_TextEncoding eSysEnc = gsl_getSystemTextEncoding();
	sal_uInt16 nMaxItems = pDoc->GetAttrPool().GetItemCount( RES_CHRATR_FONT );
	SvxFontItem *pItem;
	for( sal_uInt16 i=0; i<nMaxItems; i++ )
	{
		pItem = (SvxFontItem *)pDoc->GetAttrPool().GetItem( RES_CHRATR_FONT, i );
		if( pItem && pItem->GetCharSet() == eSrcSet )
			pItem->GetCharSet() = eSysEnc;
	}
}

void Sw3IoImp::ConvertFmtsToStarSymbol()
{
	if( pConvToSymbolFmts && pConvToSymbolFmts->Count() )
	{
		const Font& rSymbolFont = SwNumRule::GetDefBulletFont();
		SvxFontItem aFontItem( rSymbolFont.GetFamily(), rSymbolFont.GetName(),
						  	   rSymbolFont.GetStyleName(),
							   rSymbolFont.GetPitch(),
							   rSymbolFont.GetCharSet() );
		for( USHORT i=0; i < pConvToSymbolFmts->Count(); i++ )
		{
			if( (SW3IO_CONV_TO_SYMBOL & pConvToSymbolFmts->GetFlags(i)) != 0 )
				pConvToSymbolFmts->GetFmt(i)->SetAttr( aFontItem );
		}
	}
}

/*************************************************************************
*
*		Cleanup nach dem Laden
*
*************************************************************************/

void Sw3IoImp::Cleanup( sal_Bool bConnectPageDescs )
{
	// Expr-Felder in Shared-Formaten?
//	if( nGblFlags & SW3F_UPDEXPR )
//		pDoc->SetUpdateExpFldStat();
	// Offene Seitenbeschreibungen in Formaten aufloesen
	// (falls noch nicht geschehen)
	if( bConnectPageDescs )
		ConnectPageDescAttrs();
	// Temporaere Namenserweiterungen entfernen
	aStringPool.RemoveExtensions( *pDoc );

	rtl_TextEncoding eSysEnc = gsl_getSystemTextEncoding();
	if( eSysEnc != eSrcSet )
	{
		// Bug 9714: Der CharSet an den Fonts muss geaendert werden, wenn
		// es der globale CharSet ist
		ChangeFontItemCharSet();

		SvxFontItem *pItem = (SvxFontItem*) pDoc->GetAttrPool().GetPoolDefaultItem(RES_CHRATR_FONT);
		if( pItem && pItem->GetCharSet() == eSrcSet )
			pItem->GetCharSet() = eSysEnc;
	}
	ConvertFmtsToStarSymbol();

	// Unbenutzte SwDrawFlyObjs aus dem Drawing Layer entfernen
	// Dies sind vor allem jene, die vor dem Speichern in den
	// Seitenkoepfen auftraten
	if ( pDoc->GetDrawModel() )
	{
		if( nHiddenDrawObjs != ULONG_MAX )
			RemoveHiddenDrawObjs();
		SdrPage* pPage = pDoc->GetDrawModel()->GetPage( 0 );
		sal_uInt32 i = 0;
		while( i < pPage->GetObjCount() )
		{
			SdrObject *pObj = pPage->GetObj( i );
			if ( !pObj->GetUserCall() )
			{
				pPage->RemoveObject( i );
				delete pObj;
			}
			else
				i++;
		}
	}

	//if( nVersion < SWG_DBTABLE )
	if( !IsVersion( SWG_DBTABLE, SWG_EXPORT31, SWG_DESKTOP40 ) )
		pDoc->SetInitDBFields(sal_True);

	// Unbenutzte DB-Feldtypen loeschen
	const SwFldTypes *pFldTypes = pDoc->GetFldTypes();
	sal_uInt16 i = INIT_FLDTYPES;

	SwFieldType* pFnd;

	while (i < pFldTypes->Count())
	{
		if (RES_DBFLD == (pFnd = pFldTypes->GetObject(i))->Which() &&
			((SwDBFieldType*)pFnd)->GetRefCount() <= 0)
		{
			pDoc->RemoveFldType(i);
		}
		else
			i++;
	}

	// Unbenutzte automatische NumRules loeschen.
	// Kann hier geschehen, denn der NumRules-Stream wird nur bei normalen
	// Dokumenten und beim Laden von NumRules und beim Laden von
	// Seiten-Vorlagen gelesen. Beim normalen Laden und Laden von
	// Seiten-Vorlagen wird Cleanup gerufen. Beim Laden von NumRules zwar
	// nicht, da werden aber auch keine automatischen NumRules eingelesen.
	// Wenn Vorlagen ueber den Organizer geladen werden, duerfen unbenutzte
	// Vorlagen allerdings nicht geloescht werden, denn sie koennten aus
	// dem Content-Stream kommen und der wird dann weder geladen noch
	// gespeichert.
	while( aNumRuleInfos.Count() )
	{
		Sw3NumRuleInfo *pInfo = aNumRuleInfos[0];
		if( !bOrganizer && !pInfo->IsUsed() )
		{
#ifndef PRODUCT
			sal_uInt16 nCount = pDoc->GetNumRuleTbl().Count();
#endif
			pDoc->DelNumRule( pInfo->GetNewName() );
#ifndef PRODUCT
			ASSERT( pDoc->GetNumRuleTbl().Count() == nCount-1,
					"unbenutzte NumRule wurde nicht geloescht" );
#endif
		}

		aNumRuleInfos.Remove( (sal_uInt16)0, 1 );
		delete pInfo;
	}

	CleanupRedlines();
}

/*************************************************************************
*
*		Passwortroutinen
*
*************************************************************************/

// Testen des an der Root gesetzten Passwortes
// Der erforderliche Header ist bereits eingelesen

sal_Bool Sw3IoImp::CheckPasswd()
{
	if( pCrypter )
	{
		sal_Char buf[ 17 ];
		sprintf( buf, "%08lx%08lx", nDate, nTime );
		ByteString aTest( buf );
		pCrypter->Encrypt( aTest );
		return sal_Bool( !memcmp( cPasswd, aTest.GetBuffer(), PASSWDLEN ) );
	}
	else
		return sal_Bool( ( nFileFlags & SWGF_HAS_PASSWD ) == 0 );
}

// Setzen des Passwortes in der Root.

void Sw3IoImp::SetPasswd()
{
	delete pCrypter; pCrypter = NULL;
	if( pRoot && pRoot->GetKey().Len() )
	{
		pCrypter = new Crypter( pRoot->GetKey() );
		sal_Char buf[ 17 ];
		sprintf( buf, "%08lx%08lx", nDate, nTime );
		ByteString aTest( buf );
		pCrypter->Encrypt( aTest );
		memcpy( cPasswd, aTest.GetBuffer(), aTest.Len() );
		nFileFlags|= SWGF_HAS_PASSWD;
	}
}

/*************************************************************************
*
*		unbenutzte Objekte aus 3.0-Storages entfernen
*
*************************************************************************/

void Sw3IoImp::RemoveUnusedObjects()
{
	ASSERT( nVersion<=SWG_SHORTFIELDS && bNormal && !bInsert,
			"ungueltiger Aufruf von RomoveUnusedObjects" );

	if( pDoc->GetPersist()->GetObjectList() )
	{
		SvPersistRef rpDoc( pDoc->GetPersist() );
		SvInfoObject* pIO = NULL;
		String aObjName;

		// alle Objekte in SvPersist betrachten
		for( sal_uInt32 i=0; i < rpDoc->GetObjectList()->Count(); i++ )
		{
			pIO = rpDoc->GetObjectList()->GetObject(i);
			aObjName = pIO->GetObjName();
			if( aObjName.CompareToAscii("Obj",3)==COMPARE_EQUAL ||
				aObjName.CompareToAscii("StarObj",7)==COMPARE_EQUAL )
			{
				// wenn kein OLE-Node dazu existiert: Objekt loeschen
				if( p30OLENodes )
					for( sal_uInt16 j=0; j<p30OLENodes->Count(); j++ )
					{
						if( aObjName==((*p30OLENodes)[j])->GetOLEObj().GetName() )
						{
							pIO = NULL;
							p30OLENodes->Remove(j);
							break;
						}
					}
				if( pIO )
				{
					rpDoc->Remove(aObjName);
					i--; // das aktuelle Object fehlt ja jetzt
				}
			}
		}
	}
}

#ifdef TEST_HUGE_DOCS
void Sw3IoImp::InHugeRecord()
{
	OpenRec( SWG_TESTHUGEDOCS  );
	sal_uInt32 nBlocks, nBlockSize;
	*pStrm >> nBlocks >> nBlockSize;
	sal_Char *pBuffer = new sal_Char[nBlockSize + 1];
	for( sal_uInt32 i=0; i < nBlocks; i++ )
		pStrm->Read( pBuffer, nBlockSize );

	delete pBuffer;
	CloseRec( SWG_TESTHUGEDOCS  );
}

void Sw3IoImp::OutHugeRecord( sal_uInt32 nBlocks, sal_uInt32 nBlockSize )
{
	OpenRec( SWG_TESTHUGEDOCS  );
	*pStrm << nBlocks << nBlockSize;
	sal_Char *pBuffer = new sal_Char[nBlockSize + 1];
	for( sal_uInt32 i=0; i << nBlockSize; i++ )
		pBuffer[i] = (sal_Char)i;
	for( i=0; i < nBlocks; i++ )
		pStrm->Write( pBuffer, nBlockSize );

	delete pBuffer;
	CloseRec( SWG_TESTHUGEDOCS  );
}
#endif


