/*************************************************************************
 *
 *  $RCSfile: sw3sectn.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mib $ $Date: 2001/10/12 14:07:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SVSTDARR_USHORTS_DECL
#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>
#endif
#ifndef _LINKMGR_HXX
#include <so3/linkmgr.hxx>
#endif

#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _SW3MARKS_HXX
#include <sw3marks.hxx>
#endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _NDNOTXT_HXX
#include <ndnotxt.hxx>
#endif
#ifndef _FLYPOS_HXX
#include <flypos.hxx>
#endif
#ifndef _SWSWERROR_H
#include <swerror.h>
#endif

//////////////////////////////////////////////////////////////////////////////

// Wird ein Text in einen Absatz eingefuegt, wird der erste Absatz an den
// ersten Teil angefuegt, ohne die Formate zu uebernehmen. Alle anderen
// Absaetze uebernehmen die Formate, was auch den Rest des alten Absatzes
// betrifft.
// Die Position rPos wird weitergefuehrt. Der uebergebene Offset ist
// ein Offset in einen TextNode, der an InTxtNode() uebergeben wird.
// Falls bNode1 FALSE ist, wird ein evtl. vorhandener leerer Node nicht
// gefuellt. Dadurch laesst sich diese Methode fuer mehrere Contents
// verwenden.

void Sw3IoImp::InContents( SwNodeIndex& rPos, xub_StrLen nOffset, BOOL bNode1,
						   BYTE nInsFirstPara, BOOL bDontMove )
{
	OpenRec( SWG_CONTENTS );

	// Der aktuelle NumRange eines 3.1/40-Files muss gerettet werden, falls
	// eine Section innerhalb einer Section gelesen wird (z.B. Flys)
	SwNumRule* pOld40Rule;
	SwPaM* pOld40Range;
	BOOL bOldConvertNoNum;
	if( !IsVersion(SWG_LONGIDX) )
	{
		pOld40Rule = pCurNumRule;
		pOld40Range = pCurNumRange;
		bOldConvertNoNum = bConvertNoNum;
		pCurNumRange = NULL;
		pCurNumRule = NULL;
		bConvertNoNum = FALSE;
	}

	// fuer die Sonderbehandlung des ersten/letzten Node beim "Datei/Einfuegen"
	BYTE nSaveInsFirstPara = nInsFirstPara;

	// Bei einem echten Insert muss der aktuelle Node gesplittet werden,
	// Falls mehr als 1 Node eingelesen wird.
	BOOL bSplit = FALSE;
	SwTxtNode* pLast = NULL;
	const SwStartNode *pSttNd, *pSectSttNd = 0;
	SwNode* pStart = pDoc->GetNodes()[ rPos ];
	if( pStart->GetStartNode() && !bDontMove )
	{
		pSttNd = (const SwStartNode *)pStart;
		pSectSttNd = pSttNd;

		// Index zeigt auf StartNode. In Contents-Bereich reingehen
		// und den ersten TextNode nehmen
		rPos++;
		pStart = pDoc->GetNodes()[ rPos ];
	}
	else
		pSttNd = pStart->FindStartNode();

	SwTxtNode* pNd = bNode1 ? pStart->GetTxtNode() : NULL;
	SwTxtNode* pNd1 = pNd;
	ASSERT( !nInsFirstPara || pNd, "Einfuegen in Nicht-Content-Node?" );
	SwPosition *pEndPos = 0;
	if( nInsFirstPara && pNd )
	{
		SwIndex aTmp( pNd, nOffset );
		pEndPos = new SwPosition( rPos, aTmp );
	}

	UINT32 nNodes;
	if( IsVersion(SWG_LAYFRAMES) )
		OpenFlagRec();
	if( IsVersion(SWG_LONGIDX) )
	{
		*pStrm >> nNodes;
	}
	else
	{
		UINT16 nNodes16, nSectIdDummy;
		if( IsVersion(SWG_LAYFRAMES) )
			*pStrm >> nSectIdDummy;
		*pStrm >> nNodes16;
		nNodes = nNodes16;
	}
	if( IsVersion(SWG_LAYFRAMES) )
		CloseFlagRec();

	ULONG i = 0;
	while( BytesLeft() )
	{
		SetPercentBar( pStrm->Tell() );
		BYTE cType = Peek();
		i++;
		switch( cType )
		{
			case SWG_TEXTNODE:
				// Der Node muss gesplittet werden,
				// wenn mehrere Nodes inserted werden
				if( !bSplit && bInsert && nNodes > 1 )
				{
					if( pNd )
					{
						// natuerlich nur TextNodes splitten
						SwPosition aSplitPos( rPos, SwIndex( pNd, nOffset ) );
						pDoc->SplitNode( aSplitPos );
						pLast = pNd;
						rPos--;
						pNd = pDoc->GetNodes()[ rPos ]->GetTxtNode();
						bSplit = TRUE;
					}
				}
				else if( i == nNodes && pLast )
				{
					// der letzte Node: nimm evtl. den gesplitteten
					pNd = pLast;
					if( nSaveInsFirstPara && pNd && pNd->GetTxt().Len() )
						nInsFirstPara = 2;
				}
				InTxtNode( pNd, rPos, nOffset, nInsFirstPara );
				pNd = pNd1 = NULL; nOffset = 0;
				nInsFirstPara = 0;
				break;
			case SWG_GRFNODE:
				InGrfNode( rPos );
				nInsFirstPara = 0;
				break;
			case SWG_OLENODE:
				InOLENode( rPos );
				nInsFirstPara = 0;
				break;
			case SWG_TABLE:
				// JP 20.05.94: Dok. einfuegen: wird als 1.Node eine
				//				Tabelle eingefuegt, dann immer splitten !!
				nInsFirstPara = 0;
				if( 1 == i && bInsert && pNd )
				{
					SwPosition aSplitPos( rPos, SwIndex( pNd, nOffset ) );
					pDoc->SplitNode( aSplitPos );
					nOffset = 0;	//	mit dem Offset hat sichs erledigt!
				}
				InTable( rPos );
				break;
			case SWG_SECTION:
				// JP 20.05.94: Dok. einfuegen: wird als 1.Node eine
				//				Section eingefuegt, dann immer splitten !!
				nInsFirstPara = 0;
				if( 1 == i && bInsert && pNd )
				{
					SwPosition aSplitPos( rPos, SwIndex( pNd, nOffset ) );
					pDoc->SplitNode( aSplitPos );
					nOffset = 0;	//	mit dem Offset hat sichs erledigt!
				}
				InSection( rPos );
				break;
			case SWG_REPTEXTNODE:
				// keine Spezialbehandlung fuer 1. und letzten Node neoetig,
				// weil der erste und letzte Knoten eines gespeicherten
				// Doks nie ein RepTextNode ist.
				// MIB 21.7.97: Irrtum: Beim Einfuegen von Tabellen wird
				// auch immer gesplittet.
				{
					BOOL bJoin = pLast && i==nNodes;
					InRepTxtNode( rPos );
					if( bJoin )
					{
						rPos--;
						SwTxtNode* pTxtNode = rPos.GetNode().GetTxtNode();
						if( pTxtNode && pTxtNode->CanJoinNext() )
							pTxtNode->JoinNext();
						rPos++;
					}
				}
				break;
			case SWG_SDRFMT:
				// Keine Draw-Formate in Kopf oder Fusszeilen einfuegen oder
				// wenn kein Drawing-Layer da ist!
				if( (nGblFlags & SW3F_NODRAWING) || bInsIntoHdrFtr )
				{
					i--; // War gar kein Node
					SkipRec();
					break;
				} // sonst weiter:
			case SWG_FLYFMT:
				{
					// Was auch immer jetzt passiert, einen Node lesen wir
					// nicht ein.
					i--;

					if( SwFlyStartNode != pSttNd->GetStartNodeType() )
					{
						ASSERT( !this,
								"Verankerung an Frames ist nur fuer Fly-Frames implementiert" );
						break;
					}

					// Rahmengebundener FlyFrame
					USHORT eSave_StartNodeType = eStartNodeType;
					eStartNodeType = SwFlyStartNode;
					SwFrmFmt* pFmt = (SwFrmFmt*) InFormat( cType, NULL );
					eStartNodeType = eSave_StartNodeType;

					if( !pFmt )
						break;

					// Anker darin versenken
					SwFmtAnchor aAnchor( pFmt->GetAnchor() );
					SwPosition aPos( *pSttNd );
					aAnchor.SetAnchor( &aPos );
					pFmt->SetAttr( aAnchor );

					// Layout-Frames im Insert Mode fuer absatzgebundene
					// Flys erzeugen
					if( bInsert && !nRes )
						pFmt->MakeFrms();
				}
				break;

			case SWG_NODEREDLINE:
				{
					i--;
					if( nSaveInsFirstPara )
					{
						// Hier kann es nur einen End-Index geben. Der
						// entspricht dann der Einfuege-Position.
						INT32 nOffs = pEndPos->nContent.GetIndex();
						InNodeRedline( pEndPos->nNode, nOffs, nSaveInsFirstPara );
					}
					else
					{
						SwNodeIndex aIdx( *pSttNd );
						INT32 nDummy = 0;
						InNodeRedline( aIdx, nDummy );
					}
				}
				break;

			default:
				// MIB 15.4.97: Wenn wir diesen Record ueberspringen, dann
				// fuegen wir auch keinen Node ein. Dann sollten wir
				// vielleicht auch den Node-Zaehler wir eins runterzaehlen,
				// weil sonst doch das ein oder andere schiefgehen kann.
				i--;
				SkipRec();
				break;
		}
	}
	CloseRec( SWG_CONTENTS );
	if( !IsVersion(SWG_LONGIDX) )
	{
		CloseNumRange40( rPos );
		pCurNumRange = pOld40Range;
		pCurNumRule = pOld40Rule;
		bConvertNoNum = bOldConvertNoNum;
	}

	// MIB 8.9.97: Wenn man eine Section fuellt, sollte man eigentlich nie
	// auf einem End-Node stehen koennen, der nicht zur eigenen Section
	// gehoert. Fuer den Fall, dass man keine Section laed und trotzdem
	// auf einem End-Node steht, lassen wir den Code erstmal drinne, aber
	// es ist doc recht fraglich, wozu er da ist.
	SwEndNode *pEndNd = pDoc->GetNodes()[ rPos ]->GetEndNode();
	ASSERT( !pEndNd || !pSectSttNd || pEndNd->FindStartNode()==pSectSttNd,
			"PaM steht auf EndNode, der nicht zur Section gehoert." );
	if( pEndNd && !pSectSttNd &&
		pEndNd != &pDoc->GetNodes().GetEndOfContent())
	{
		rPos++;
	}

	// Eine Tabelle und eine Section koennen u.U. alleine
	// in einer Textsection existieren, d.h. es muss ggf.
	// der ueberfluessige Node entfernt werden!
	if( pNd1 && !nRes )
	{
		SwNodeIndex aPos( *pNd1 );
		// MIB 8.9.97: Mit dieser Abrage wird sichergestellt, dass beim
		// Einfuegen nie der Absatz geloscht wird, in den eingefuegt wird.
		if( !pCurPaM ||
			pCurPaM->GetPoint()->nNode != aPos )
		{
			pDoc->GetNodes().Delete( aPos );
		}
	}

	// Die aktuelle Position ggf. hinter die Section stellen,
	// die gerade eingelesen wurde.
	if( pSectSttNd )
		rPos = pSectSttNd->EndOfSectionIndex() + 1;

	delete pEndPos;
}

// Einfuegen einer nicht vorhandenen Contents-Section. Die Section
// wird am Textende eingefuegt und der numerische Index des StartNodes
// zurueckgeliefert.

SwStartNode& Sw3IoImp::InContents()
{
	// Anlegen einer Section mit einem TextNode
#if 0
	SwStartNode* pSttNd = pDoc->GetNodes().MakeTextSection(
								pDoc->GetNodes().EndOfAutotext,
								(SwStartNodeType)eStartNodeType,
								(SwTxtFmtColl*) pDoc->GetDfltTxtFmtColl() );
	SwIndex aStart( pSttNd->GetMyIndex() );
	InContents( aStart );
#endif
// OPT: Section leer anlegen
	SwNodeIndex aStart( pDoc->GetNodes().GetEndOfAutotext() );
	SwStartNode* pSttNd = pDoc->GetNodes().MakeEmptySection(  aStart,
									(SwStartNodeType)eStartNodeType );
	aStart = *pSttNd->EndOfSectionNode();

	InContents( aStart, 0, FALSE );
// /OPT: Section leer anlegen

	return *pSttNd;
}

// Einlesen des puren Textes eines Content-Bereichs

String Sw3IoImp::InContentsText()
{
	String aText;
	OpenRec( SWG_CONTENTS );
	if( IsVersion(SWG_LAYFRAMES) )
		OpenFlagRec();
	if( IsVersion(SWG_LONGIDX) )
	{
		UINT32 nNodes;
		*pStrm >> nNodes;
	}
	else
	{
		UINT16 nNodes16, nSectIdDummy;
		if( IsVersion(SWG_LAYFRAMES) )
			*pStrm >> nSectIdDummy;
		*pStrm >> nNodes16;
	}
	if( IsVersion(SWG_LAYFRAMES) )
		CloseFlagRec();

	xub_StrLen nLastPos;
	while( BytesLeft() )
	{
		switch( Peek() )
		{
			case SWG_TEXTNODE:
				nLastPos = aText.Len();
				InTxtNodeText( aText );
				break;
			case SWG_REPTEXTNODE:
				{
					UINT32 nRepetitions;
					OpenRec( SWG_REPTEXTNODE );
					*pStrm >> nRepetitions;
					CloseRec( SWG_REPTEXTNODE );

					String aRepString;
					if( nLastPos==0 )
						aRepString += ' ';

					aRepString += aText.Copy( nLastPos, aText.Len()-nLastPos );
					while( nRepetitions--  )
						aText += aRepString;
				}
				break;
			default:
				SkipRec();
		}
	}
	CloseRec( SWG_CONTENTS );
	return aText;
}

// Einen Basis-Contents-Bereich des Dokuments ausgeben

// Der PaM zeigt (was er ja muss) immer auf einen Cntnt-Node. Somit
// muss noch getestet werden, ob dieser am Tabellenanfang liegt. In
// diesem Fall wird die Tabelle ausgegeben. Auch, wenn am Anfang eine
// Section liegt, muss dies gesondert behandelt werden!

void Sw3IoImp::OutContents( SwPaM* pPaM )
{
	// Gespeichert wird immer von Point bis Mark
	if( *pPaM->GetPoint() > *pPaM->GetMark() )
		pPaM->Exchange();
	// gebe alle Bereiche des Pams in das File aus.
	ULONG nCurNode = pPaM->GetPoint()->nNode.GetIndex();
	ULONG nEndNode = pPaM->GetMark()->nNode.GetIndex();
	xub_StrLen nCurPos	= pPaM->GetPoint()->nContent.GetIndex();
	xub_StrLen nEndPos	= STRING_LEN;
	SwNode* pNd1 = pDoc->GetNodes()[ nCurNode ];

	// Is the node contained in a table?
	const SwTableNode* pTbl = pNd1->FindTableNode();
	if( pTbl )
		nCurNode = pTbl->GetIndex();

	// Step out of sections, in fact to the start node of the first
	// section.
	// #67503#: This must be done if the first text node is contained in
	// a table, too.
	do
	{
		pNd1 = pDoc->GetNodes()[ --nCurNode ]->GetSectionNode();
	} while( pNd1 );
	nCurNode++;

	// Dieses OutContents schreibt den Top-Level
	OutContents( nCurNode, nEndNode, nCurPos, nEndPos, TRUE );
}

// Ausgabe einer kompletten Contents-Section
// Der uebergebene Index zeigt auf den StartNode

void Sw3IoImp::OutContents( const SwNodeIndex& rStart )
{
	// Der Index zeigt auf den Start-Node, also muessen wir einen
	// bauen, der auf den naechsten Node zeigt
	SwStartNode* pStt = pDoc->GetNodes()[ rStart ]->GetStartNode();
	ASSERT( pStt, "StartNode nicht gefunden" );
	if( pStt )
	{
		// Hole vom Node und vom letzten Node die Position in der Section
		ULONG nStt = rStart.GetIndex();
		ULONG nEnd = pStt->EndOfSectionIndex()-1;
		// kein Bereich also kein gueltiger Node
		if( nStt <= nEnd )
			OutContents( nStt, nEnd, 0, STRING_LEN );
	}
}

// Besitzt ein Text-Knoten Markierungen oder FlyFrames?
BOOL lcl_sw3sectn_NodeHasFlyOrMark( Sw3IoImp& rIo, ULONG nIdx )
{
	USHORT nPos;

	if( rIo.pMarks )
		for( nPos = 0; nPos < rIo.pMarks->Count(); ++nPos )
		{
			const Sw3Mark *pMark = (*rIo.pMarks)[ nPos ];
			if( pMark->GetNodePos() == nIdx )
				return TRUE;
			else if( pMark->GetNodePos() > nIdx )
				break;
		}

	if( rIo.pFlyFrms )
		for( nPos = 0; nPos < rIo.pFlyFrms->Count(); nPos++ )
		{
			ULONG nIdFly = (*rIo.pFlyFrms)[nPos]->GetNdIndex().GetIndex();
			if( nIdFly == nIdx )
				return TRUE;
			else if( nIdFly > nIdx )
				break;
		}

	return FALSE;
}


// Ausgabe eines fest definierten Doc-Bereichs.
// Der Offset wird beim ersten TextNode angewandt.

void Sw3IoImp::OutContents
	( ULONG nCurNode, ULONG nEndNode, xub_StrLen nCurPos, xub_StrLen nEndPos,
	  BOOL bTopLevel )
{
	// Die aktuelle NumRuke muss gerettet werden, falls ein 3.1/40-Export
	// stattfindet und eine Sectioninnerhalb einer Section geschrieben
	// wird (z.B. Flys)
	SwNumRule* pOld40Rule;
	if( IsSw31Or40Export() )
	{
		pOld40Rule = pCurNumRule;
		pCurNumRule = NULL;
	}

	BOOL bOldExportFlyFrmFmt;
	const SwFlyFrm* pOldExportFlyFrm;
	if( pExportInfo )
	{
		bOldExportFlyFrmFmt = pExportInfo->bFlyFrmFmt;
		pOldExportFlyFrm = pExportInfo->pFlyFrm;
		pExportInfo->bFlyFrmFmt = FALSE;
		pExportInfo->pFlyFrm = NULL;
	}

	SwStartNode* pStt = pDoc->GetNodes()[ nCurNode ]->GetStartNode();
	if( pStt && pStt->GetNodeType() == ND_STARTNODE )
		nCurNode++; // StartNode nicht speichern, TblNode/SectionNode wohl
	else
		pStt = pDoc->GetNodes()[ nCurNode ]->FindStartNode();
	OpenRec( SWG_CONTENTS );
	*pStrm << (BYTE)   0x04; 		// 4 Byte Daten, aber unterschiedliche

	ULONG nNodes = 0;
	if( IsSw31Or40Export() )
	{
		*pStrm << (UINT16) IDX_NO_VALUE;	// war mal Section-Id (siehe Tbl)
		OpenValuePos16( (UINT16)nNodes );
	}
	else
	{
		OpenValuePos32( nNodes );
	}

	nNodes = OutNodes( nCurNode, nEndNode, nCurPos, nEndPos, bTopLevel );

	if( IsSw31Or40Export() )
		CloseValuePos16( (UINT16)nNodes );
	else
		CloseValuePos32( nNodes );

	// Jetzt noch an den Start-Node der Section (Rahmen)gebundenen
	// Rahmen und Redlines rausschreiben.
	if( !IsSw31Or40Export() )
	{
		OutNodeFlyFrames( pStt->GetIndex() );
		OutNodeRedlines( pStt->GetIndex() );
		OutNodeRedlines( pStt->EndOfSectionIndex() );
	}


	CloseRec( SWG_CONTENTS );

	if( IsSw31Or40Export() )
		pCurNumRule = pOld40Rule;

	if( pExportInfo )
	{
		pExportInfo->bFlyFrmFmt = bOldExportFlyFrmFmt;
		pExportInfo->pFlyFrm = pOldExportFlyFrm;
	}
}

ULONG Sw3IoImp::OutNodes( ULONG nCurNode, ULONG nEndNode,
						  xub_StrLen nCurPos, xub_StrLen nEndPos,
						  BOOL bTopLevel )
{
	ULONG nNodes = 0;

	ULONG nWords, nChars;
	ULONG nRepNodesToWrite = 0;
	SwTxtNode *pLastNode = NULL;
	BOOL bFirstNode = bTopLevel;

	while( nCurNode <= nEndNode && Good() )
	{
		SetPercentBar( nCurNode );
		SwNode* pNd = pDoc->GetNodes()[ nCurNode ];

		BYTE nNodeType = pNd->GetNodeType();

		if( nNodeType==ND_TEXTNODE )
		{
			// Ist der Knoten einer Wiederholung des vorherigen?
			// NIE(!!!) wenn dies der letzte zu speichernde Knoten des
			// Top-Levels ist, weil dies beim Einfuegen des Doks Probleme
			// bereiten kann.
			SwTxtNode *pTxtNd = pNd->GetTxtNode();
			if( pLastNode &&
				(!bTopLevel || nCurNode!=nEndNode) &&
				pLastNode->GetFmtColl() == pTxtNd->GetFmtColl() &&
				pLastNode->GetCondFmtColl() == pTxtNd->GetCondFmtColl() &&
				!pTxtNd->HasHints() &&
				!pTxtNd->GetpSwAttrSet() &&
				pLastNode->GetTxt().Len() == pTxtNd->GetTxt().Len() &&
				pLastNode->GetTxt() == pTxtNd->GetTxt() &&
				!lcl_sw3sectn_NodeHasFlyOrMark( *this, nCurNode ) )
			{
				nRepNodesToWrite++;
				nCurNode++;
				continue;
			}
			// Den ersten Knoeten des Top-Levels duerfen wir nie als
			// Ausgangsbasis einer Wiederholung benutzen, sonst gibt's beim
			// Einfuegen des Doks in ein anderes Probleme, weil der
			// Knoten kopiert wird.
			if( !bFirstNode &&
				!pTxtNd->HasHints() &&
				!pTxtNd->GetpSwAttrSet() &&
				!lcl_sw3sectn_NodeHasFlyOrMark( *this, nCurNode ) )
				pLastNode = pTxtNd;
			else
				pLastNode = NULL;
		}
		else
			pLastNode = NULL;

		bFirstNode = FALSE;

		if( nRepNodesToWrite>0 )
		{
			OutRepTxtNode( nRepNodesToWrite );
			aStat.nPara += nRepNodesToWrite;
			aStat.nWord += nRepNodesToWrite*(aStat.nWord-nWords);
			aStat.nChar += nRepNodesToWrite*(aStat.nChar-nChars);
			nRepNodesToWrite = 0;
			nNodes++;
		}

		switch( (int)nNodeType	)
		{
			case ND_SECTIONNODE:
				nNodes += OutSection( *pNd->GetSectionNode() );
				nCurNode = pNd->GetSectionNode()->EndOfSectionIndex() + 1;
				break;
			case ND_TABLENODE:
				OutTable( *pNd->GetTableNode() );
				nCurNode = pNd->GetTableNode()->EndOfSectionIndex() + 1;
				break;
			case ND_TEXTNODE:
				nWords = aStat.nWord;
				nChars = aStat.nChar;
				OutTxtNode( *pNd->GetTxtNode(), nCurPos, nEndPos, nCurNode );
				nCurPos = 0; nCurNode++;
				break;
			case ND_GRFNODE:
				OutGrfNode( *pNd->GetNoTxtNode() );
				nCurPos = 0; nCurNode++;
				break;
			case ND_OLENODE:
				OutOLENode( *pNd->GetNoTxtNode() );
				nCurPos = 0; nCurNode++;
				break;
			case ND_ENDNODE:
				// Das kann der Teil einer Section sein,
				// kann einfach ignoriert werden
				nNodes--; nCurNode++; break;
			default:
				ASSERT( !this, "Node kann nicht gespeichert werden" );
				Error( ERR_SWG_WRITE_ERROR );
				nCurNode = nEndNode;
		}
		nNodes++;
	}

	// falls der letzte Knoten eine Wiederholung ist:
	if( nRepNodesToWrite>0 && Good() )
	{
		OutRepTxtNode( nRepNodesToWrite );
		aStat.nPara += nRepNodesToWrite;
		aStat.nWord += nRepNodesToWrite*(aStat.nWord-nWords);
		aStat.nChar += nRepNodesToWrite*(aStat.nChar-nChars);
		nRepNodesToWrite = 0;
		nNodes++;
	}

	return nNodes;
}

// Einlesen einer "echten" Section innerhalb eines Content-Bereichs
// Auch hier wird der uebergebene Index weitergefuehrt.

void Sw3IoImp::InSection( SwNodeIndex& rPos )
{
	OpenRec( SWG_SECTION );
	String aName, aCond;
	InString( *pStrm, aName );
	InString( *pStrm, aCond );
	// 0x10 - hidden
	// 0x20 - protected
	// 0x40 - !conditional hidden (gedreht, fuers Einlesen von alten Docs)
	BYTE cFlags = OpenFlagRec();
	UINT16 nType;
	*pStrm >> nType;
	CloseFlagRec();

	// beim Insert vom Doc einen eindeutigen Namen erzeugen
	if( bInsert )
	{
		aName = pDoc->GetUniqueSectionName( &aName );
		if( !pSectionDepths )
			pSectionDepths = new SvUShorts;
		if( 0 == pSectionDepths->Count() )
		{
			pSectionDepths->Insert( 1U, 0U );
		}
		else
		{
			(*pSectionDepths)[pSectionDepths->Count()-1]++;
		}
	}


	SwSection aSect( (SectionType) nType, aName );
	SwSectionFmt* pFmt = (SwSectionFmt*) InFormat( SWG_SECTFMT, NULL );
	ULONG n = rPos.GetIndex();

	SwNodeIndex aTmpIdx( pDoc->GetNodes().GetEndOfContent() );
	SwSectionNode* pSectNd =
		pDoc->GetNodes().InsertSection( rPos, *pFmt, aSect, &aTmpIdx, FALSE );

	SwSection& rNdSection = pSectNd->GetSection();

	rPos = n;
	InContents( rPos );

	// Link-Filenamen einlesen
	if( nVersion >= SWG_FLYWRAPCHGD )
	{
		String aLinkFileName;
		ByteString s8;

		pStrm->ReadByteString( s8 );
        aLinkFileName = ConvertStringNoDelim( s8, '\xff', so3::cTokenSeperator,
											  eSrcSet );

		if( aLinkFileName.Len() && FILE_LINK_SECTION == nType )
		{
            xub_StrLen nTokenPos = aLinkFileName.Search( so3::cTokenSeperator );
			if( STRING_NOTFOUND != nTokenPos && nTokenPos )
			{
				String sURL( aLinkFileName.Copy( 0, nTokenPos ) );
				aLinkFileName.Erase( 0, nTokenPos );
				aLinkFileName.Insert( URIHelper::SmartRelToAbs( sURL ), 0 );
			}
		}
		rNdSection.SetLinkFileName( aLinkFileName );
	}

	rNdSection.SetCondition( aCond );
	if( cFlags & 0x10 )
		rNdSection.SetHidden();
	if( cFlags & 0x20 )
		rNdSection.SetProtect();
	if( cFlags & 0x40 )
		rNdSection.SetCondHidden( FALSE );
	if( cFlags & 0x80 )
		rNdSection.SetConnectFlag( FALSE );

	// ggf. Link neu verbinden aber nicht updaten
	if( pSectNd->GetSection().IsLinkType() )
		pSectNd->GetSection().CreateLink( CREATE_CONNECT );

	// create frames
	if( bInsert )
	{
		(*pSectionDepths)[pSectionDepths->Count()-1]--;
		if( 0 == (*pSectionDepths)[pSectionDepths->Count()-1] )
		{
			SwSectionFmt *pSFmt = rNdSection.GetFmt();
			pSFmt->DelFrms();
			pSFmt->MakeFrms();
		}
	}

	CloseRec( SWG_SECTION );
}

BOOL lcl_sw3io_isTOXHeaderSection( const SwStartNode& rSttNd )
{
	BOOL bRet = FALSE;

	const SwSectionNode *pSectNd = rSttNd.GetSectionNode();
	if( pSectNd &&
		TOX_HEADER_SECTION == pSectNd->GetSection().GetType() )
	{
		bRet = TRUE;
	}

	return bRet;
}

ULONG Sw3IoImp::OutTOXSection( const SwSectionNode& rNd )
{
	const SwSection& rSect = rNd.GetSection();

	ASSERT( TOX_HEADER_SECTION == rSect.GetType() ||
			TOX_CONTENT_SECTION == rSect.GetType(),
			"Not a TOX section" );

	ULONG nStt = rNd.GetIndex() + 1;
	ULONG nEnd = rNd.EndOfSectionIndex()-1;

	if( nStt > nEnd )
		return 0;

	ULONG nNodes = 0;

	// If a tox content section starts with a start node or ends with
	// an end node that doesn't belong to a tox header section, an
	// additional text node has to be inserted.

	//                  +-- tox c   +-- tox c   +-- tox c   +-- tox c
	//                 *|   text   *|+- stt     |+- tox h  *|+- tox h
	//                  |           ||         *||  text    ||+ stt
	//
	//                  |           ||         *||  text    ||+ end
	//                 *|   text   *|+- end     |+- tox h  *|+- tox h
	//                  +-- tox c   +-- tox c   +-- tox c   +-- tox c
	//
	// node before:     no          yes         no          yes
	// node behind:     no          yes         no          yes
	//
	// The * indicate the position of the tox marks

	if( TOX_CONTENT_SECTION == rSect.GetType() )
	{
		const SwStartNode *pSttNd = pDoc->GetNodes()[nStt]->GetStartNode();
		if( pSttNd && ( !lcl_sw3io_isTOXHeaderSection( *pSttNd ) ||
						!pDoc->GetNodes()[nStt+1]->IsTxtNode() ) )
		{
			OutEmptyTxtNode( nStt, TRUE );
			nNodes++;
		}
	}

	nNodes += OutNodes( nStt, nEnd, 0, STRING_LEN, FALSE );

	if( TOX_CONTENT_SECTION == rSect.GetType() )
	{
		const SwEndNode *pEndNd = pDoc->GetNodes()[nEnd]->GetEndNode();
		if( pEndNd &&
			( !lcl_sw3io_isTOXHeaderSection(*pEndNd->StartOfSectionNode()) ||
			  !pDoc->GetNodes()[nEnd-1]->IsTxtNode() ) )
		{
			OutEmptyTxtNode( nEnd, TRUE );
			nNodes++;
		}
	}

	// The sections start node is counted by OutNodes, but it hasn't been
	// written. That for, the number of nodes must be reduced by one.
	ASSERT( nNodes > 0, "empty TOX section?" );
	return nNodes - 1;
}

ULONG Sw3IoImp::OutSection( const SwSectionNode& rNd )
{
	const SwSection& rSect = rNd.GetSection();

	if( TOX_HEADER_SECTION == rSect.GetType() ||
		TOX_CONTENT_SECTION == rSect.GetType() )
	{
		return OutTOXSection( rNd );
	}

	OpenRec( SWG_SECTION );
	OutString( *pStrm, rSect.GetName() );
    OutString( *pStrm, rSect.GetCondition() );
	// 0x02 - 2 Bytes Daten (Typ)
	// 0x10 - hidden
	// 0x20 - protected
	// 0x40 - !conditional hidden (gedreht, fuers Einlesen von alten Docs)
	BYTE cFlags = 0x02;
	if( rSect.IsHidden() )
		cFlags |= 0x10;
	if( rSect.IsProtect() )
		cFlags |= 0x20;
	if( !rSect.IsCondHidden() )
		cFlags |= 0x40;
	if( !rSect.IsConnectFlag() )
		cFlags |= 0x80;
	*pStrm << (BYTE) cFlags
		   << (UINT16) rSect.GetType();

	SwSectionFmt* pFmt = rSect.GetFmt();
	OutFormat( SWG_SECTFMT, *rSect.GetFmt() );

	// Hier einen auf den StartNode draufzaehlen, sonst wird
	// der Bereich rekursiv gespeichert!
	ULONG nStt = rNd.GetIndex() + 1;
	ULONG nEnd = rNd.EndOfSectionIndex()-1;
	// kein Bereich also kein gueltiger Node
	if( nStt <= nEnd )
	{
		if( !IsSw31Export() &&
			pDoc->IsGlobalDoc() && !pDoc->IsGlblDocSaveLinks() &&
			pFmt->GetGlobalDocSection() )
		{
			// nur eine Section mit einem DummyTextNode speichern!
			OpenRec( SWG_CONTENTS );
			*pStrm << (BYTE)   0x04;	// 4 Byte Daten

			if( IsSw31Or40Export() )
			{
				*pStrm << (UINT16) IDX_NO_VALUE; // war mal Section-Id
				OpenValuePos16( 0 );
			}
			else
			{
				OpenValuePos32( 0 );
			}

			// leeren TextNode schreiben
			OutEmptyTxtNode();

			if( IsSw31Or40Export() )
				CloseValuePos16( 1 );
			else
				CloseValuePos32( 1 );

			CloseRec( SWG_CONTENTS );
		}
		else
			OutContents( nStt, nEnd, 0, STRING_LEN );
	}
	// Link-Filenamen schreiben
	String aLinkFileName( rSect.GetLinkFileName() );
	if( aLinkFileName.Len() && FILE_LINK_SECTION == rSect.GetType() )
	{
        xub_StrLen nTokenPos = aLinkFileName.Search( so3::cTokenSeperator );
		if( STRING_NOTFOUND != nTokenPos && nTokenPos )
		{
			String sURL( aLinkFileName.Copy( 0, nTokenPos ) );
			aLinkFileName.Erase( 0, nTokenPos );
			aLinkFileName.Insert( INetURLObject::AbsToRel( sURL ), 0 );
		}
	}

    ByteString s8 = ConvertStringNoDelim( aLinkFileName, so3::cTokenSeperator,
										  '\xff', eSrcSet );
	pStrm->WriteByteString( s8 );

	CloseRec( SWG_SECTION );

	return 0;
}

// NEXT: sw3sectn_0a


