/*************************************************************************
 *
 *  $RCSfile: sw3style.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mib $ $Date: 2001/07/25 07:34:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// Diese Implementation geht davon aus, dass der Pool nur temporaer
// verwendet wird, d.h. der ctor macht einen Snapshot der Vorlagen am Doc.

#ifdef PRECOMPILED
#include "core_pch.hxx"
#endif

#pragma hdrstop

#include "swerror.h"
#include "doc.hxx"
#include "docary.hxx"
#include "hintids.hxx"			//Damit "unsere" Attribute angezogen werden.

#ifndef _SVX_FONTITEM_HXX //autogen
#include <svx/fontitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_TSPTITEM_HXX //autogen
#include <svx/tstpitem.hxx>
#endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#ifndef _HTMLKYWD_HXX
#include <svtools/htmlkywd.hxx>
#endif

#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif

#ifndef _FMTCOL_HXX //autogen
#include <fmtcol.hxx>
#endif

#ifndef _FRMFMT_HXX //autogen
#include <frmfmt.hxx>
#endif
#ifndef _CHARFMT_HXX //autogen
#include <charfmt.hxx>
#endif
#include "sw3imp.hxx"
#include "poolfmt.hxx"
#include "hints.hxx"
#include "paratr.hxx"
#include "frmatr.hxx"
#include "numrule.hxx"
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

#define SWG_CONDSTYLES_BUG	1		//Versionsnummern fuer die StyleSheets
#define SWG_CONDSTYLES		2		//Versionsnummern fuer die StyleSheets
#define SWG_CHARFMTOFFSET 	3		//Versionsnummern fuer die StyleSheets
#define SWG_AUTOUPDATE_FLAG 4		// zusaetzliches Flag-Byte
#define SWG_TEN_HEADLINES	5		// HTML-H6-Vorlage mappen
#define SWG_NUM_RELSPACE	6		// Numerierung mit rel. Abstaenden

#ifdef NUM_RELSPACE
#define SWG_STYLE_VERSION (SWG_NUM_RELSPACE)
#else
#define SWG_STYLE_VERSION (SWG_TEN_HEADLINES)
#endif

///////////////////////////////////////////////////////////////////////////

//FEATURE::CONDCOLL
struct SwStyleCondColl
{
	UINT32 nCondition, nSubCondition;
	String sColl;

	SwStyleCondColl()
		: nCondition( 0 ), nSubCondition( 0 )
	{}
	SwStyleCondColl( const String& rColl, UINT32 nCond, UINT32 nSubCond )
		: nCondition( nCond ),
		  nSubCondition( nSubCond ),
		  sColl( rColl )
	{}
	SwStyleCondColl( const SwStyleCondColl& rCopy )
		: nCondition( rCopy.nCondition ),
		  nSubCondition( rCopy.nSubCondition ),
		  sColl( rCopy.sColl )
	{}
};
typedef SwStyleCondColl* SwStyleCondCollPtr;
SV_DECL_PTRARR_DEL( SwStyleCondColls, SwStyleCondCollPtr, 0, 5 );
//FEATURE::CONDCOLL

// Unsere Ableitungen der Klassen SfxStyleSheetBase und SfxStyleSheetBasePool

class SwStyleSheet : public SfxStyleSheetBase {
	friend class SwStyleSheetPool;
	SfxItemSet aSet;				// Set fuer Load/Store
	SwDoc& 	   rDoc;				// Dokument
	SwFmt*	   pFmt;				// zugehoeriges Format
	long   	   nVersion;			// Export: FF-Version
									// Import: Vorlagen-Version
	USHORT 	   nId;					// PoolId
	BYTE 	   nLevel;				// Outline-Level
	BYTE	   cFlags;				// diverse Flags (0x01 == AutoUpdate)
	BOOL	   bNew : 1;	   		// TRUE: neu eingelesen/erzeugt
	SwStyleCondColls* pCondColls;	// != 0 -> CondColl - Tabelle der Conditions
	SvxLRSpaceItem *pNumLRSpace;	// Original-LRSpace-Item bei Kapitel-Num.
private:
	SwStyleSheet( const String&, SwStyleSheetPool&, SfxStyleFamily eFam,
					USHORT nMask );
	SwStyleSheet( const SwStyleSheet& );
	virtual SfxItemSet& GetItemSet();
public:
	virtual ~SwStyleSheet();
	SwDoc& GetDoc() { return rDoc; }
	SwFmt* GetFmt() { return pFmt; }
	SwTxtFmtColl* GetColl();
	BYTE GetNumLevel() const { return nLevel; }
	void ConnectParent( const String& );
	void ConnectFollow( const String& );
	virtual void Load( SvStream&, USHORT );
	virtual void Store( SvStream& );
	virtual USHORT GetVersion() const;

	// fuers Rename - Vorlagen muessen noch nicht im Pool umbenannt sein,
	// 				  die normale Set-Methoden suchen aber danach und setzen
	//				  nur um, wenn sie die Vorlage gefunden haben.
	void SetNewName( const String& rName )		{ aName = rName; }
	void SetNewParent( const String& rName )	{ aParent = rName; }
	void SetNewFollow( const String& rName )	{ aFollow = rName; }
};

class SwStyleSheetPool : public SfxStyleSheetBasePool {
	friend class SwStyleSheet;
	SwDoc&  	 rDoc;			// Dokument
	Sw3Fmts* 	 pConvToSymbolFmts;
	long		 nExpFFVersion;	// FF-Version fuer Export
	virtual SfxStyleSheetBase* Create( const String&, SfxStyleFamily, USHORT nMask);
	virtual SfxStyleSheetBase* Create( const SfxStyleSheetBase& );
	void Add( const SwFmt& rFmt, SfxStyleFamily eFam );
	void CopyFromDoc( BOOL bUsed );
	void CopyToDoc( BOOL bOverwrite, USHORT eMask );
	void Rename( const String&, const String&, SfxStyleFamily );
	SwStyleSheet *FindByPoolId( USHORT nPoolId );
public:
	SwStyleSheetPool( SwDoc&, SfxItemPool&, long nFFVersion, Sw3Fmts *pConvFmts );
	virtual ~SwStyleSheetPool();
	BOOL Load( SvStream&, BOOL, USHORT eMask );
	BOOL Store( SvStream&, BOOL );
};




SV_IMPL_PTRARR( SwStyleCondColls, SwStyleCondCollPtr )

///////////////////////////////////////////////////////////////////////////
//							lokale Hilfsroutinen						 //
///////////////////////////////////////////////////////////////////////////

// Suche eines Formats anhand der Family-Bits

SwFmt* lcl_sw3io__FindFmt( SwDoc& rDoc, const String& rName, USHORT nFamily )
{
	if( nFamily & SFX_STYLE_FAMILY_PARA )
		return rDoc.FindTxtFmtCollByName( rName );
	else if( nFamily & SFX_STYLE_FAMILY_FRAME )
		return rDoc.FindFrmFmtByName( rName );
	else if( nFamily & SFX_STYLE_FAMILY_CHAR )
		return rDoc.FindCharFmtByName( rName );

	DBG_ASSERT( nFamily || !nFamily, "Unbekannte Style-Familie" );
	return NULL;
}

////////////////////////////////////////////////////////////////////////////

SwStyleSheet::SwStyleSheet( const String& rName, SwStyleSheetPool& rPool,
							SfxStyleFamily eFam, USHORT nMask )
	: SfxStyleSheetBase( rName, rPool, eFam, nMask ),
	  rDoc( rPool.rDoc ), aSet( rPool.rPool,
			RES_CHRATR_BEGIN,		RES_CHRATR_END - 1,
			RES_PARATR_BEGIN, 		RES_PARATR_END - 1,
			RES_FRMATR_BEGIN, 		RES_FRMATR_END - 1,
			0 ),
	  cFlags( 0 ),
	  pCondColls( 0 ),
	  pNumLRSpace( 0 )
{
	nId = 0xFFFF;
	nHelpId = UCHAR_MAX;
	nLevel = NO_NUMBERING;
	pFmt = NULL;
	bNew = FALSE;
	nVersion = 0;
}

__EXPORT SwStyleSheet::~SwStyleSheet()
{
	// wird von SFX-DLL gerufen!
//FEATURE::CONDCOLL
	delete pCondColls;
//FEATURE::CONDCOLL
	delete pNumLRSpace;
}

SwTxtFmtColl* SwStyleSheet::GetColl()
{
	return ( nFamily & SFX_STYLE_FAMILY_PARA )
		   ? (SwTxtFmtColl*) pFmt : NULL;
}

SwStyleSheet::SwStyleSheet( const SwStyleSheet& r )
	: SfxStyleSheetBase( r ), rDoc( r.rDoc ), aSet( r.aSet ),
	pCondColls( 0 ), pNumLRSpace( 0 )
{
	nId    = r.nId;
	nLevel = r.nLevel;
	pFmt   = r.pFmt;
	bNew   = r.bNew;
	nVersion = r.nVersion;
	cFlags = r.cFlags;

//FEATURE::CONDCOLL
	if( r.pCondColls )
	{
		USHORT nCnt = r.pCondColls->Count();
		pCondColls = new SwStyleCondColls( nCnt < 255 ? nCnt : 255, 5 );
		for( USHORT n = 0; n < nCnt; ++n )
		{
			SwStyleCondCollPtr pCpy = new SwStyleCondColl( *(*r.pCondColls)[n] );
			pCondColls->Insert( pCpy, n );
		}
	}
//FEATURE::CONDCOLL

	if( r.pNumLRSpace )
		pNumLRSpace = new SvxLRSpaceItem( *r.pNumLRSpace );
}

void __EXPORT SwStyleSheet::Load( SvStream& r, USHORT nVer )
{
	nVersion = nVer;	// Version wird noch gebraucht

	r >> nId >> nLevel;

	// Numerierungs-Ebende weglassen, wenn sie nicht unterstuetzt wird
	if( nLevel != NO_NUMBERING && GetRealLevel(nLevel) >= MAXLEVEL )
		nLevel = NO_NUMBERING;

//FEATURE::CONDCOLL
	if( SWG_CONDSTYLES_BUG <= nVer )
	{
		//JP 31.10.96: Bug vom TemplateDialog beheben. Es wurde eine falsche
		//				PoolId (1) fuer die Textkoerpervorlage verwendet
		if( SWG_CONDSTYLES_BUG == nVer && SFX_STYLE_FAMILY_PARA == nFamily
			&& 1 == nId )
		{
			nId = RES_POOLCOLL_TEXT;
		}

		// ConditionStyleSheets ??
		UINT16 nTmp;
		r >> nTmp;
		if( 1 == nTmp )
		{
			r >> nTmp;	// Anzahl:
			pCondColls = new SwStyleCondColls( nTmp < 255 ? nTmp : 255, 5 );
			for( USHORT n = 0; n < nTmp; ++n )
			{
				SwStyleCondColl* pNew = new SwStyleCondColl;
				r.ReadByteString( pNew->sColl, r.GetStreamCharSet() );
				r >> pNew->nCondition;

				if( USRFLD_EXPRESSION & pNew->nCondition )
				{
					ASSERT( !this, "noch nicht implementiert" );
					String s;
					r.ReadByteString( s, r.GetStreamCharSet() );
				}
				else
					r >> pNew->nSubCondition;
				pCondColls->Insert( pNew, n );
			}
		}
	}
//FEATURE::CONDCOLL

	// Zusaetzliches Flag-Byte laden
	if( SWG_AUTOUPDATE_FLAG <= nVer )
	{
		r >> cFlags;
	}
#ifdef NUM_RELSPACE
	if( SWG_NUM_RELSPACE >= nVer && (cFlags & 0x02) != 0 )
	{
		UINT32 nLen;
		r >> nLen;
		if( nLen > 0 )
		{
			ULONG nPos = r.Tell();
			UINT16 nIVer;
			r >> nIVer;
			const SfxPoolItem& rDflt =
				GetItemSet().GetPool()->GetDefaultItem( RES_LR_SPACE );
			SfxPoolItem *pItem = rDflt.Create( r, nIVer );
			GetItemSet().Put( *pItem );
			delete pItem;
			nPos += nLen;
			if( r.Tell() != nPos )
				r.Seek( nPos );
		}
		else
		{
			GetItemSet().ClearItem( RES_LR_SPACE );
		}
	}
#endif

	// JP 11.12.96: die Zeichenvorlagen wurden um die HTML-Vorlagen erweitert,
	// aber ohne ein wenig Platz zu lassen. Das wurde spaeter nachgepflegt.
	if( SWG_CONDSTYLES == nVer && SFX_STYLE_FAMILY_CHAR == nFamily &&
		RES_POOLCHR_JUMPEDIT < nId )
	{
		// dann den akt. Offset drauf addieren
		nId = RES_POOLCHR_HTML_BEGIN + ( nId - RES_POOLCHR_JUMPEDIT ) - 1;
	}
	// In der 5.0 gibt es 10 Ueberschrift-Vorlagen. Die alte HTML-H6-Vorlage
	// wird deshalb auf die neue Ueberschrift 6 gemappt.
	if( SWG_TEN_HEADLINES > nVer )
		nId = Sw3StringPool::ConvertFromOldPoolId( nId, SWG_LONGIDX );
}

void __EXPORT SwStyleSheet::Store( SvStream& r )
{
	ASSERT( nVersion == r.GetVersion(),
			"SwStyleSheet::Store: FF-Version != Stream-FF-Version" );

	r << nId;
	if( r.GetVersion() <= SOFFICE_FILEFORMAT_40 &&
		nLevel != NO_NUMBERING && nLevel >= OLD_MAXLEVEL )
	{
		nLevel = NO_NUMBERING;
	}
	r << nLevel;

	if( nVersion > SOFFICE_FILEFORMAT_31 )
	{
//FEATURE::CONDCOLL
		UINT16 nType = RES_CONDTXTFMTCOLL == pFmt->Which() ? 1 : 0;
		r << nType;
		if( nType )
		{
			// Tabelle der ConditionTypes und der Vorlagen ausgeben:
			const SwFmtCollConditions& rCColls = ((SwConditionTxtFmtColl*)pFmt)->
													GetCondColls();
			r << (UINT16)rCColls.Count();
			for( USHORT n = 0; n < rCColls.Count(); ++n )
			{
				const SwCollCondition& rCColl = *rCColls[ n ];
				r.WriteByteString( rCColl.GetTxtFmtColl()->GetName(),
								   r.GetStreamCharSet() );
				r << (UINT32) rCColl.GetCondition();

				if( USRFLD_EXPRESSION & rCColl.GetCondition() )
				{
					String s( *rCColl.GetFldExpression() );
					r.WriteByteString( s, r.GetStreamCharSet() );
				}
				else
					r << (UINT32) rCColl.GetSubCondition();
			}
		}
//FEATURE::CONDCOLL

		// zusaetzliches Flag-Byte speichern
		r << cFlags;

#ifdef NUM_RELSPACE
		if( nVersion > SOFFICE_FILEFORMAT_40 && (cFlags & 0x02) != 0 )
		{
			r << (UINT32)0;
			if( pNumLRSpace )
			{
				USHORT nIVer = pNumLRSpace->GetVersion( (USHORT)nVersion );
				if( nIVer != USHRT_MAX )
				{
					ULONG nPos = r.Tell();
					r << (UINT16)nIVer;
					pNumLRSpace->Store( r, nIVer );

					ULONG nNewPos = r.Tell();
					r.Seek( nPos-4UL );
					r << (UINT32)(nNewPos - nPos);
					r.Seek( nNewPos );
				}
			}
		}
#endif
	}
}

//FEATURE::CONDCOLL
USHORT __EXPORT SwStyleSheet::GetVersion() const
{
	ASSERT( nVersion,
			"SwStyleSheet::GetVersion: Fileformat-Version nicht gesetzt" );
	switch( nVersion )
	{
	case SOFFICE_FILEFORMAT_31:
		return 0;
	case SOFFICE_FILEFORMAT_40:
		return SWG_AUTOUPDATE_FLAG;
	}
#ifdef NUM_RELSPACE
	return SWG_NUM_RELSPACE;
#else
	return SWG_TEN_HEADLINES;
#endif
}
//FEATURE::CONDCOLL

SfxItemSet& __EXPORT SwStyleSheet::GetItemSet()
{
	return aSet;
}

// Setzen des Parents: Wenn kein Parent angegeben ist, wird der Default
// gesetzt

void SwStyleSheet::ConnectParent( const String& rName )
{
	SwFmt* pParent;
	if( rName.Len() )
		pParent = lcl_sw3io__FindFmt( rDoc, rName, nFamily );
	else switch( nFamily )
	{
		case SFX_STYLE_FAMILY_CHAR:
			pParent = (*rDoc.GetCharFmts())[ 0 ]; break;
		case SFX_STYLE_FAMILY_FRAME:
			pParent = (*rDoc.GetFrmFmts())[ 0 ]; break;
		case SFX_STYLE_FAMILY_PARA:
			pParent = (*rDoc.GetTxtFmtColls())[ 0 ]; break;
	}
	if( pParent )
		pFmt->SetDerivedFrom( pParent );
	else
		ASSERT( !this, "Parent nicht gefunden" );
}

// Setzen des Follows

void SwStyleSheet::ConnectFollow( const String& rName )
{
	if( nFamily == SFX_STYLE_FAMILY_PARA )
	{
		SwTxtFmtColl* pFollow;
		if( rName.Len() )
			pFollow = rDoc.FindTxtFmtCollByName( rName );
		else
			pFollow = rDoc.GetTxtCollFromPool( RES_POOLCOLL_STANDARD );
		if( pFollow )
			GetColl()->SetNextTxtFmtColl( *pFollow );
		else
			ASSERT( !this, "Follow nicht gefunden" );
	}
}

////////////////////////////////////////////////////////////////////////////

// der nachfolgende ctor ist potentiell crashgefaehrlich, da die
// Sfx-Implementation den Pool als Referenz haelt.

SwStyleSheetPool::SwStyleSheetPool( SwDoc& r, SfxItemPool& rp, long nFFVersion,
								 	Sw3Fmts *pConvFmts )
				: SfxStyleSheetBasePool( rp ), rDoc( r ),
				  nExpFFVersion( nFFVersion ),
				  pConvToSymbolFmts( pConvFmts )
{}

__EXPORT SwStyleSheetPool::~SwStyleSheetPool()
{
	// wird von SFX-DLL gerufen!
}

// Laden und Speichern eines Pools

BOOL SwStyleSheetPool::Load( SvStream& s, BOOL bOverWrite, USHORT eMask )
{
	// Der Stream koennte auch leer sein, wenn eine neue Textbausteindatei
	// eingelesen wird.
	BOOL bRes = TRUE;
	USHORT n;
	s.Seek( 0L );
	s >> n;
	if( s.GetError() != SVSTREAM_OK )
		bRes = FALSE;
	if( !s.IsEof() )
	{
		s.Seek( 0L );
		rPool.Load( s );
		if( s.GetError() != SVSTREAM_OK )
			bRes = FALSE;
		bRes = SfxStyleSheetBasePool::Load( s );
		SetSearchMask( SFX_STYLE_FAMILY_ALL );
		if( bRes )
			CopyToDoc( bOverWrite, eMask );
	}
	return bRes;
}

const RES_POOLCOLL_HTML_LISTING_40_USER = 0x3002 | USER_FMT;
const RES_POOLCOLL_HTML_XMP_40_USER = 0x3003 | USER_FMT;

BOOL SwStyleSheetPool::Store( SvStream& s, BOOL bUsed )
{
	ASSERT( nExpFFVersion == s.GetVersion(),
			"SwStyleSheetPool::Store: FF-Version != Stream-FF-Version" );

	CopyFromDoc( bUsed );
	SetSearchMask( SFX_STYLE_FAMILY_ALL );

	rPool.SetFileFormatVersion( (USHORT)nExpFFVersion );

	//JP 11.06.97: laut ChangesMail muss das vorm Speichern gesetzt werden.
	if( SOFFICE_FILEFORMAT_31 == nExpFFVersion )
		rPool.SetStoringRange( 1, 60 );

	rPool.Store( s );

	return SfxStyleSheetBasePool::Store( s, bUsed );
}

// Auffuellen eines Pools mit allen am Doc definierten Vorlagen

void SwStyleSheetPool::CopyFromDoc( BOOL bUsed )
{
	Clear();
	// Uebernahme der benannten Formate
	// Die Defaultvorlagen werden nicht uebernommen
	// Zeichenvorlagen: alle uebernehmen
	// Rahmenvorlagen: nur die Nicht-Auto-Vorlagen uebernehmen
	const SwFmt* pFmt;
	USHORT nArrLen = rDoc.GetCharFmts()->Count();
	for( USHORT i = 0; i < nArrLen; i++ )
	{
		pFmt = (*rDoc.GetCharFmts())[ i ];
		if( ( !bUsed || rDoc.IsUsed( *pFmt ) ) && !pFmt->IsDefault() )
			Add( *pFmt, SFX_STYLE_FAMILY_CHAR );
	}
	nArrLen = rDoc.GetFrmFmts()->Count();
	for( i = 0; i < nArrLen; i++ )
	{
		pFmt = (*rDoc.GetFrmFmts())[ i ];
		if( ( !bUsed || rDoc.IsUsed( *pFmt ) )
		  && !pFmt->IsDefault() && !pFmt->IsAuto() )
			Add( *pFmt, SFX_STYLE_FAMILY_FRAME );
	}
	// Uebernahme der Absatzvorlagen
	nArrLen = rDoc.GetTxtFmtColls()->Count();
	for( i = 0; i < nArrLen; i++ )
	{
		const SwTxtFmtColl* pColl = (*rDoc.GetTxtFmtColls())[ i ];
		if( ( !bUsed || rDoc.IsUsed( *pColl ) ) && !pColl->IsDefault() )
			Add( *pColl, SFX_STYLE_FAMILY_PARA );
	}
	if( bUsed )
	{
		//JP 30.03.99: falls die Follows nicht angewendet werden, so muessen
		//				sie doch kopiert werden!
		for( i = 0; i < nArrLen; i++ )
		{
			const SwTxtFmtColl* pColl = (*rDoc.GetTxtFmtColls())[ i ];
			if( pColl != &pColl->GetNextTxtFmtColl() &&
				!Find( pColl->GetNextTxtFmtColl().GetName(),
					   SFX_STYLE_FAMILY_PARA ))
				Add( pColl->GetNextTxtFmtColl(), SFX_STYLE_FAMILY_PARA );
		}
	}
}

// Hinzufuegen eines neuen StyleSheets.
// Es muss mind. ein Bit in der Maske gesetzt werden, da die Suchroutinen
// der Basisklasse ein AND auf die Maske machen!
// Der Set wird auch temporaer kopiert.

#define DUMMYBITS	0x0001

void SwStyleSheetPool::Add( const SwFmt& rFmt, SfxStyleFamily eFam )
{
	SwStyleSheet& r = (SwStyleSheet&) Make( rFmt.GetName(), eFam, DUMMYBITS );

	// SW31-Export oder nicht
	r.nVersion = nExpFFVersion;

	// ItemSet
	r.GetItemSet().Put( rFmt.GetAttrSet() );

	// es muss natuerlich der Pointer vom kopierten geschrieben werden !!!
	r.pSet = &r.GetItemSet();
	r.bMySet = FALSE;

	// Members setzen
	ASSERT( nExpFFVersion, "SwStylePool::Add: FF-Version ist nicht gesetzt" );
	if( nExpFFVersion <= SOFFICE_FILEFORMAT_40 )
		r.nId = Sw3StringPool::ConvertToOldPoolId( rFmt.GetPoolFmtId(),
												   nExpFFVersion );
	else
		r.nId  = rFmt.GetPoolFmtId();
	r.pFmt = (SwFmt*) &rFmt;
	if( r.nId & USER_FMT )
		r.nMask |= SFXSTYLEBIT_USERDEF;
	if( rDoc.IsUsed( rFmt ) )
		r.nMask |= SFXSTYLEBIT_USED;
	if( rFmt.GetPoolHlpFileId() != UCHAR_MAX )
		r.aHelpFile = *rDoc.GetDocPattern( rFmt.GetPoolHlpFileId() );
	r.nHelpId = rFmt.GetPoolHelpId();
	if( rFmt.IsAutoUpdateFmt() )
		r.cFlags |= 0x01;

	// Parent und Follow
	SwFmt* pFmt = rFmt.DerivedFrom();
	// Parent-Namen nur uebernehmen, wenn kein Default
	if( pFmt && !pFmt->IsDefault() )
		r.aParent = rFmt.DerivedFrom()->GetName();
	if( r.nFamily & SFX_STYLE_FAMILY_PARA )
	{
		r.nLevel = r.GetColl()->GetOutlineLevel();
#ifdef NUM_RELSPACE
		if( NO_NUMBERING != r.nLevel )
		{
			// Beim Export in das 3.1- oder 4.0-Format wird die Vorlage noch
			// an die Outline Numerierung angepasst. Der linke Einzug wird
			// aber nur veraendert, wenn er nicht relativ ist.
			// Beim Schreiben des 5.0/5.1-Formats werden die Einzuege immer
			// veraendert und das Original-Item gemerkt.
			// Beim 3.1- und 4.0-Export werden auch Vorlagen angepasst, deren
			// Outline-Level >= 5 ist.
			const SwNumRule *pOutline = rDoc.GetOutlineNumRule();
			BYTE nLevel = GetRealLevel( r.nLevel );
			if( pOutline )
			{
				const SwNumFmt& rNumFmt = pOutline->Get( nLevel );
				const SvxLRSpaceItem& rLRSpace = rFmt.GetLRSpace();
				USHORT nOldLSpace = rLRSpace.GetTxtLeft();
				USHORT nLSpace = rLRSpace.GetTxtLeft();
				BOOL bNonProp = FALSE;
				if( rLRSpace.GetPropLeft() == 100U ||
					nExpFFVersion > SOFFICE_FILEFORMAT_40 )
				{
					if( pOutline->IsAbsSpaces() )
						nLSpace = rNumFmt.GetAbsLSpace();
					else
						nLSpace += rNumFmt.GetAbsLSpace();
					bNonProp = TRUE;
				}
				if( nLSpace != rLRSpace.GetTxtLeft() ||
					rNumFmt.GetFirstLineOffset() !=
								rLRSpace.GetTxtFirstLineOfst() )
				{
					if( nExpFFVersion > SOFFICE_FILEFORMAT_40 )
					{
						r.cFlags |= 0x02;
						if( SFX_ITEM_SET == r.GetItemSet().
									GetItemState( RES_LR_SPACE, FALSE ) )
						{
							r.pNumLRSpace = new SvxLRSpaceItem( rLRSpace );
						}
					}
					SvxLRSpaceItem aLRSpace( rLRSpace );
					aLRSpace.SetTxtFirstLineOfst(
							rNumFmt.GetFirstLineOffset() );
					if( bNonProp )
						aLRSpace.SetTxtLeft( nLSpace );
					r.GetItemSet().Put( aLRSpace );

					if( nExpFFVersion <= SOFFICE_FILEFORMAT_40 &&
						nLSpace != nOldLSpace )
					{
						const SfxPoolItem* pItem;
						if( SFX_ITEM_SET == rFmt.GetAttrSet().GetItemState(
										RES_PARATR_TABSTOP, TRUE, &pItem ))
						{
							SvxTabStopItem aTStop( *(SvxTabStopItem*)pItem );
							lcl_sw3io__ConvertNumTabStop( aTStop,
											(long)nOldLSpace - (long)nLSpace );
							r.GetItemSet().Put( aTStop );
						}
					}
				}
			}
		}
#endif

		const SwTxtFmtColl& rFollow = r.GetColl()->GetNextTxtFmtColl();
		if( !rFollow.IsDefault() )
			r.aFollow = rFollow.GetName();
	}

}

// Kopieren aller StyleSheets in das Doc
// Ggf. werden die StyleSheets neu erzeugt

sal_Bool lcl_sw3io_isStarSymbolFontItem( const SvxFontItem& rFontItem );

void SwStyleSheetPool::CopyToDoc( BOOL bOverwrite, USHORT eMask )
{
	SwFmt* pFmt;
	for( SwStyleSheet* p = (SwStyleSheet*) aStyles.First(); p;
		 p = (SwStyleSheet*) aStyles.Next() )
	{
		if( !p->pFmt &&	(eMask & p->nFamily) )
		{
			BOOL bNewFmt = FALSE;

			if( p->nVersion < SWG_TEN_HEADLINES &&
				p->nFamily & SFX_STYLE_FAMILY_PARA &&
				(RES_POOLCOLL_HTML_LISTING_40_USER == p->nId ||
				 RES_POOLCOLL_HTML_XMP_40_USER == p->nId) )
			{
				// Listing und XMP werden umbenannt, aber nur, wenn
				// sie nicht schon im Pool vorhanden sind
				String aNewName( String::CreateFromAscii(
						RES_POOLCOLL_HTML_XMP_40_USER == p->nId
							? sHTML_xmp
							: sHTML_listing ) );
				BOOL bPresent = Find( aNewName, p->nFamily ) != 0;

				// Umbennnen. Das muss auch sein, wenn eine Vorlage
				// mit dem neuen Namen existiert, damit die abgeleiteten
				// und Folgevorlagen umgehaengt wenrden.
				Rename( p->GetName(), aNewName, p->nFamily );
				aStyles.First();

				if( bPresent )
				{
					// Vorlage von nun an ignorieren
					p->nFamily = (SfxStyleFamily)0;
					continue;
				}

				// Benutzter-Vorlage ohne ID daraus machen.
				p->nId |= (USHRT_MAX &
								~(COLL_GET_RANGE_BITS + POOLGRP_NOCOLLID));
				p->nMask |= SFXSTYLEBIT_USERDEF;
			}

			pFmt = lcl_sw3io__FindFmt( rDoc, p->GetName(), p->nFamily );
			if( !pFmt )
			{
				bNewFmt = TRUE;
				BOOL bIsUserDefined = p->IsUserDefined();
				if( !bIsUserDefined )
				{
					//JP 31.01.96:
					// 		dann teste mal ob die Ids im aktuellen PoolId-
					//		Bereich sind. Wenn nicht, dann muss sie als
					//		BenutzerVorlage angelegt werden!!!!!!!
					USHORT nId = p->nId;
					if( p->nFamily & SFX_STYLE_FAMILY_CHAR )
						bIsUserDefined = !(
								(RES_POOLCHR_NORMAL_BEGIN <= nId &&
										nId < RES_POOLCHR_NORMAL_END) ||
								(RES_POOLCHR_HTML_BEGIN <= nId &&
										nId < RES_POOLCHR_HTML_END));
					else if( p->nFamily & SFX_STYLE_FAMILY_FRAME )
						bIsUserDefined = RES_POOLFRM_BEGIN > nId ||
											nId >= RES_POOLFRM_END;
					else
						bIsUserDefined = !(
								(RES_POOLCOLL_TEXT_BEGIN <= nId &&
										nId < RES_POOLCOLL_TEXT_END) ||
								(RES_POOLCOLL_LISTS_BEGIN <= nId &&
										nId < RES_POOLCOLL_LISTS_END) ||
								(RES_POOLCOLL_EXTRA_BEGIN <= nId &&
										nId < RES_POOLCOLL_EXTRA_END) ||
								(RES_POOLCOLL_REGISTER_BEGIN <= nId &&
										nId < RES_POOLCOLL_REGISTER_END) ||
								(RES_POOLCOLL_DOC_BEGIN <= nId &&
										nId < RES_POOLCOLL_DOC_END) ||
								(RES_POOLCOLL_HTML_BEGIN <= nId &&
										nId < RES_POOLCOLL_HTML_END));

					// es war eine Poolvorlage die wir aber noch nicht kennen
					if( bIsUserDefined )
					{
						p->nId |= (USHRT_MAX &
									~(COLL_GET_RANGE_BITS + POOLGRP_NOCOLLID));
					}
				}
				else
				{
					// Die Vorlage ist Benutzer-definiert, aber
					// vielleicht gibt es ja mitlerweile eine
					// Pool-Vorlage mit dem gleichen Namen.
					// Dann nehmen wir die Pool-Vorlage
					// statt der Benutzer-Vorlage, aber auch nur
					// dann, wenn die Pool-Vorlage nicht auch noch
					// eingelesen wird. Ist das der Fall, wird
					// die Benutzer-Vorlage ignoriert.
					SwGetPoolIdFromName eNameType;
					if( p->nFamily & SFX_STYLE_FAMILY_CHAR )
						eNameType = GET_POOLID_CHRFMT;
					else if( p->nFamily & SFX_STYLE_FAMILY_FRAME )
						eNameType = GET_POOLID_FRMFMT;
					else
						eNameType = GET_POOLID_TXTCOLL;
					USHORT nPoolId = SwStyleNameMapper::GetPoolIdFromUIName( p->GetName(),
													  eNameType );
					if( nPoolId != USHRT_MAX )
					{
						if( FindByPoolId( nPoolId ) )
						{
							// Vorlage von nun an ignorieren
							p->nFamily = (SfxStyleFamily)0;
							continue;
						}
						else
						{
							bIsUserDefined = FALSE;
							p->nId = nPoolId;
						}
					}

				}

				if( bIsUserDefined )
				{
					// Benutzerdefinierte Formate werden am Doc neu eingerichtet.
					// PageDescs werden z.Zt. noch nicht hier gepflegt!
					if( p->nFamily & SFX_STYLE_FAMILY_CHAR )
					{
						pFmt = rDoc.MakeCharFmt( p->GetName(), NULL );
						pFmt->SetAuto( FALSE );
					}
					else if( p->nFamily & SFX_STYLE_FAMILY_FRAME )
					{
						pFmt = rDoc.MakeFrmFmt( p->GetName(), NULL );
						pFmt->SetAuto( FALSE );
					}
					else if( p->pCondColls )
					{
						SwTxtFmtColl* pDer = (*rDoc.GetTxtFmtColls())[ 0 ];
						pFmt = rDoc.MakeCondTxtFmtColl( p->GetName(), pDer );
					}
					else
					{
						SwTxtFmtColl* pDer = (*rDoc.GetTxtFmtColls())[ 0 ];
						pFmt = rDoc.MakeTxtFmtColl( p->GetName(), pDer );
					}

					// Bei benutzerdefinierten Vorlagen werden die Help-Ids
					// im Doc gesetzt.
					pFmt->SetPoolFmtId( p->nId );
					if( p->aHelpFile.Len() )
						pFmt->SetPoolHlpFileId
							( (BYTE) rDoc.SetDocPattern( p->aHelpFile ) );
					pFmt->SetPoolHelpId( (USHORT)p->nHelpId );
				}
				else
				{
					// Poolformate werden am Doc angefordert.
					// PageDescs werden z.Zt. noch nicht hier gepflegt!
					if( p->nFamily & SFX_STYLE_FAMILY_CHAR )
					{
						USHORT nStyleCnt = rDoc.GetCharFmts()->Count();
						pFmt = rDoc.GetCharFmtFromPool( p->nId );
						bNewFmt = nStyleCnt != rDoc.GetCharFmts()->Count();
					}
					else if( p->nFamily & SFX_STYLE_FAMILY_FRAME )
					{
						USHORT nStyleCnt = rDoc.GetFrmFmts()->Count();
						pFmt = rDoc.GetFrmFmtFromPool( p->nId );
						bNewFmt = nStyleCnt != rDoc.GetFrmFmts()->Count();
					}
					else
					{
						USHORT nStyleCnt = rDoc.GetTxtFmtColls()->Count();
						pFmt = rDoc.GetTxtCollFromPool( p->nId );
						bNewFmt = nStyleCnt != rDoc.GetTxtFmtColls()->Count();
					}
					// Hier werden die Help-Ids aus der Vorlage uebernommen!
					if( pFmt->GetPoolHlpFileId() != UCHAR_MAX )
						p->aHelpFile = *rDoc.GetDocPattern( pFmt->GetPoolHlpFileId() );
					p->nHelpId = pFmt->GetPoolHelpId();

					// MIB 27.11.96: "kleine" Optimierung: Nichts umbenennen,
					// wo nichts umzubenennen ist.
					if( p->GetName() != pFmt->GetName() )
					{
						Rename( p->GetName(), pFmt->GetName(), p->GetFamily() );
						// Da Rename() selbst eine Schleife hat, muss von
						// vorne gearbeitet werden.
						aStyles.First();
					}
				}
			}
			else if( p->IsUserDefined() )
			{
				// Wenn aus dem selben Dokument eine Pool-Vorlage
				// mit gleichem Namen gelesen wurde, dann wird die
				// Benutzer-Vorlage ignoriert.
				USHORT nPoolId = pFmt->GetPoolFmtId();
				SwStyleSheet *pTmp;
				if( nPoolId != p->nId && (nPoolId & USER_FMT) == 0 &&
					(pTmp = FindByPoolId( nPoolId )) != 0 &&
					pTmp->pFmt == pFmt )
				{
					// Vorlage von nun an ignorieren
					p->nFamily = (SfxStyleFamily)0;
					continue;
				}
			}
			p->pFmt = pFmt;
			/* Attribute nur uebernehmen, wenn bOverwrite TRUE ist */
			if( bOverwrite || bNewFmt )
			{
				p->bNew = TRUE;
				pFmt->ResetAllAttr();	// die neue Vorlage kann auch weniger
										// Attribute enthalten
				((SwAttrSet&) pFmt->GetAttrSet()).Put( p->GetItemSet() );
				SwTxtFmtColl* pColl = p->GetColl();
				if( pColl )
				{
					((SwAttrSet&) pColl->GetAttrSet()).SetModifyAtAttr( pColl );

					// Bei Einfuegen von Vorlagen muss ggf. der Outline-Level
					// geloescht werden, wenn bereits eine Vorlage mit diesem
					// Level existiert.

					BYTE nLevel = p->GetNumLevel();
					if( !bOverwrite && nLevel != NO_NUMBERING )
					{
						BYTE nRealLevel = GetRealLevel(nLevel);
						USHORT nArrLen = rDoc.GetTxtFmtColls()->Count();
						for( USHORT i=0; i<nArrLen; i++ )
						{
							SwTxtFmtColl* pCur =
								(*rDoc.GetTxtFmtColls())[i];
							BYTE nCurLevel = pCur->GetOutlineLevel();
							if( nCurLevel != NO_NUMBERING &&
								GetRealLevel(nCurLevel) == nRealLevel )
							{
								if( pColl != pCur )
									nLevel = NO_NUMBERING;
								break;
							}
						}
					}
					pColl->SetOutlineLevel( nLevel );
				}
				pFmt->SetAutoUpdateFmt( (p->cFlags & 0x01) != 0 );
			}
			const SfxPoolItem *pItem;
			if( SFX_ITEM_SET == p->GetItemSet().GetItemState( 
						RES_CHRATR_FONT, sal_False, &pItem ) &&
				RTL_TEXTENCODING_SYMBOL ==
						((const SvxFontItem *)pItem)->GetCharSet() )
			{
				BOOL bBats = ((const SvxFontItem *)pItem)->GetFamilyName().EqualsIgnoreCaseAscii( "StarBats", 0, sizeof("StarBats")-1 );
				BOOL bMath = ((const SvxFontItem *)pItem)->GetFamilyName().EqualsIgnoreCaseAscii( "StarMath", 0, sizeof("StarMath")-1 );

				if( bBats || bMath )
				{
					if( p->bNew )
					{
						// Allways convert font to StarSymbol
						pConvToSymbolFmts ->Insert( pFmt, SW3IO_CONV_TO_SYMBOL );
					}
					else if( SFX_ITEM_SET == pFmt->GetAttrSet().GetItemState( 
							 RES_CHRATR_FONT, sal_True, &pItem ) &&
							 lcl_sw3io_isStarSymbolFontItem( *(const SvxFontItem *)pItem ) )
					{
						pConvToSymbolFmts ->Insert( pFmt, bBats ? SW3IO_CONV_FROM_BATS : SW3IO_CONV_FROM_MATH  );
					}
				}
			}
		}
	}
	// Nun sind alle Vorlagen drin, sie koennen also verbunden werden
	for( p = (SwStyleSheet*) aStyles.First(); p;
		 p = (SwStyleSheet*) aStyles.Next() )
	{
		if( p->bNew )
		{
			p->ConnectParent( p->GetParent() );
			p->ConnectFollow( p->GetFollow() );
			// das Format hat sich geaendert!
			SwFmtChg aHint( p->pFmt );
			p->pFmt->Modify( &aHint, &aHint );
		}
	}

//FEATURE::CONDCOLL
	// dann koennen auch alle bedingten Vorlagen verbunden werden
	for( p = (SwStyleSheet*) aStyles.First(); p;
		 p = (SwStyleSheet*) aStyles.Next() )
	{
		if( p->bNew && p->pCondColls )
			for( USHORT n = 0; n < p->pCondColls->Count(); ++n )
			{
				SwStyleCondColl* pCColl = (*p->pCondColls)[n];
				SwTxtFmtColl* pDColl = rDoc.FindTxtFmtCollByName( pCColl->sColl );
				if( pDColl )
				{
					((SwConditionTxtFmtColl*)p->pFmt)->InsertCondition(
							SwCollCondition( pDColl,
								pCColl->nCondition, pCColl->nSubCondition ));
				}
				else
					ASSERT( !this, "Collection nicht gefunden" );
			}
	}
//FEATURE::CONDCOLL
}

////////////////////////////////////////////////////////////////////////////

// Faktorei

SfxStyleSheetBase* __EXPORT SwStyleSheetPool::Create( const String& rName,
											 SfxStyleFamily eFam, USHORT nMask)
{
	return new SwStyleSheet( rName, *this, eFam, nMask);
}

SfxStyleSheetBase* __EXPORT SwStyleSheetPool::Create( const SfxStyleSheetBase& r )
{
	return new SwStyleSheet( (const SwStyleSheet&) r );
}

// Umbenennen eines bestimmten Strings innerhalb einer Family

void SwStyleSheetPool::Rename
	( const String& rOld, const String& rNew, SfxStyleFamily eFam )
{
	// da mit Referenzen gearbeitet wird, muss der Name zwischen-
	// gelagert werden!
	String aOld( rOld );
	for( SwStyleSheet* p = (SwStyleSheet*) aStyles.First(); p;
		 p = (SwStyleSheet*) aStyles.Next() )
	{
		if( p->GetFamily() == eFam )
		{
			if( p->GetName() == aOld )
				p->SetNewName( rNew );
			if( p->GetParent() == aOld )
				p->SetNewParent( rNew );
			if( p->GetFollow() == aOld )
				p->SetNewFollow( rNew );

//FEATURE::CONDCOLL
			if( p->pCondColls )
			{
				SwStyleCondColl* pCColl;
				for( USHORT n = 0; n < p->pCondColls->Count(); ++n )
					if( ( pCColl = (*p->pCondColls)[n] )->sColl == aOld )
						pCColl->sColl = rNew;
			}
//FEATURE::CONDCOLL
		}
	}
}

SwStyleSheet *SwStyleSheetPool::FindByPoolId( USHORT nPoolId )
{
	SwStyleSheet *pS = 0;
	ULONG nCount = aStyles.Count();
	for( ULONG i=0; i<nCount; i++ )
	{
		SwStyleSheet *p = (SwStyleSheet *)aStyles.GetObject( i );
		if( p->nId == nPoolId )
		{
			pS = p;
			break;
		}
	}

	return pS;
}

///////////////////////////////////////////////////////////////////////////

// Laden und speichern aller StyleSheets
// Der Code liegt hier, um ein HXX fuer den lokalen Pool einzusparen

void Sw3IoImp::LoadStyleSheets( BOOL bNew )
{
	ASSERT( !HasRecSizes(), "Hier darf es noch keine RecSizes geben" );
	// Bisher wurde allenfalls der Drawing-Layer gelesen. Deshalb
	// kann es hier noch gar keine RecSizes geben. Besser ist aber besser ...
	if( HasRecSizes() )
		FlushRecSizes();

	SfxItemPool *pTmp = pDoc->GetAttrPool().GetSecondaryPool();
	pDoc->GetAttrPool().SetSecondaryPool( 0 );
	SfxItemPool* pPool = pDoc->GetAttrPool().Clone();
	pDoc->GetAttrPool().SetSecondaryPool( pTmp );

	ASSERT( !pConvToSymbolFmts, "ConvToSymbol array exists" );
	pConvToSymbolFmts = new Sw3Fmts;
	SwStyleSheetPool* p = new SwStyleSheetPool( *pDoc, *pPool, 0, pConvToSymbolFmts );
	pStyles->SetBufferSize( SW3_BSR_STYLES );
	pStrm = pStyles;
	USHORT eMask = bNormal ? SFX_STYLE_FAMILY_ALL : 0;
	if( !bNormal )
	{
		if( bFrmFmts )
			eMask |= SFX_STYLE_FAMILY_FRAME;
		if( bTxtColls )
			eMask |= SFX_STYLE_FAMILY_PARA;
		if( bCharFmts )
			eMask |= SFX_STYLE_FAMILY_CHAR;
	}

	nRes = p->Load( *pStyles, bNew, eMask ) ? 0 : ERR_SWG_READ_ERROR;
	pStyles->SetBufferSize( 0 );

	// JP 09.06.95: die Pool-Defaults muessen beim normalen Einlesen
	//				aus temp Pool mitgenommen werden !!
	if( !nRes && !bInsert )
	{
		const SfxPoolItem* pCpyItem;
		for( USHORT nWh = POOLATTR_BEGIN; nWh < POOLATTR_END; ++nWh )
			if( 0 != ( pCpyItem = pPool->GetPoolDefaultItem( nWh ) ) )
				pDoc->GetAttrPool().SetPoolDefaultItem( *pCpyItem );
	}

	// alle Attribute, die auf irgendwelche Vorlagen verweisen hier verbinden
	// (Attribute: DropCaps)
	{
		BOOL bReadStrPool = FALSE;
		const SfxPoolItem* pItem;
		USHORT nMaxItems = pDoc->GetAttrPool().GetItemCount( RES_PARATR_DROP );

		for( USHORT n = 0; n < nMaxItems; ++n )
			if( 0 != (pItem = pDoc->GetAttrPool().GetItem( RES_PARATR_DROP, n ) )
				&& USHRT_MAX != ((SwFmtDrop*)pItem)->GetReadFmt() )
			{
				if( !bReadStrPool )
				{
					bReadStrPool = TRUE;
					if( pPageStyles.Is() )
					{
						pPageStyles->Seek( 0L );
						pPageStyles->SetBufferSize( SW3_BSR_PAGESTYLES );
						SvStream* pOld = pStrm;
						pStrm = pPageStyles;
						if( !nRes )
						{
							if( Peek() != SWG_STRINGPOOL )
								InHeader( TRUE );
							if( Good() && Peek() == SWG_STRINGPOOL )
								InStringPool( SWG_STRINGPOOL, aStringPool );
						}
						pStrm = pOld;
						CheckIoError( pPageStyles );
						pPageStyles->SetBufferSize( 0 );
					}
				}
				((SwFmtDrop*)pItem)->SetCharFmt( (SwCharFmt*) FindFmt(
						((SwFmtDrop*)pItem)->GetReadFmt(), SWG_CHARFMT ) );
			}

		// fix #41308#: Wenn nur Vorlagen geladen werden, muessen die
		// Font-Items noch den richten Charset verpasst bekommen. Es sei
		// denn, es werden auch Seitenvorlagen geladen. Dann passiert das
		// automatisch im Cleanup
		if( !bNormal && !bPageDescs )
		{
			BOOL bSrcSetValid = bReadStrPool;
			if( !bSrcSetValid && pPageStyles.Is() )
			{
				pPageStyles->Seek( 0L );
				pPageStyles->SetBufferSize( SW3_BSR_PAGESTYLES );
				SvStream* pOld = pStrm;
				pStrm = pPageStyles;
				if( !nRes && Peek() != SWG_STRINGPOOL )
				{
					InHeader(); // RecSizes brauchen hier nicht gelesen zu
								// werden, weil keine Records gelesen werden.
					bSrcSetValid = Good();
				}
				pStrm = pOld;
				CheckIoError( pPageStyles );
				pPageStyles->SetBufferSize( 0 );
			}

			if( bSrcSetValid )
				ChangeFontItemCharSet();
			ConvertFmtsToStarSymbol();
		}

		if( bReadStrPool )
			aStringPool.Clear();
	}

#ifndef NUM_RELSPACE
	// JP 14.09.98: Bug 55957 - die Vorlagen muessen dann aber
	// 				auch die OutlineRule aktualisieren
	if( !bNormal && bTxtColls )
	{
		const SwTxtFmtColls& rColls = *pDoc->GetTxtFmtColls();
		const SwTxtFmtColl* pColl;
		SwNumRule* pOutlRule = (SwNumRule*)pDoc->GetOutlineNumRule();
		BYTE nLevel;
		for( USHORT n = rColls.Count(); n; )
			if( MAXLEVEL > ( nLevel = GetRealLevel(
				( pColl = rColls[ --n ])->GetOutlineLevel() )) )
			{
				const SvxLRSpaceItem& rLR = pColl->GetLRSpace();
				const SwNumFmt& rNFmt = pOutlRule->Get( nLevel );
				SwNumFmt aTmp( rNFmt );

				// ohne Nummer immer ohne FirstLineOffset!!!!
				if( pColl->GetOutlineLevel() & NO_NUMLEVEL )
					aTmp.SetFirstLineOffset( 0 );
				else
					aTmp.SetFirstLineOffset( rLR.GetTxtFirstLineOfst() );

				aTmp.SetAbsLSpace( rLR.GetTxtLeft() );
				if( aTmp != rNFmt )
					pOutlRule->Set( nLevel, aTmp );
			}
	}

	//JP 21.07.98: Bug 53390
	if( !bNormal && !bAdditive && bTxtColls )
	{
		pDoc->SetOutlineNumRule( *pDoc->GetOutlineNumRule() );
	}
#endif

	delete p;
	delete pPool;
	if( !pConvToSymbolFmts->Count() )
	{
		delete pConvToSymbolFmts;
		pConvToSymbolFmts = 0;
	}
}

void Sw3IoImp::SaveStyleSheets( BOOL bUsed )
{
	ASSERT( !HasRecSizes(), "Hier darf es noch keine RecSizes geben" );
	// Bisher wurde allenfalls der Drawing-Layer gespeichert. Deshalb
	// kann es hier noch gar keine RecSizes geben. Besser ist aber besser ...
	if( HasRecSizes() )
		FlushRecSizes();

	SfxItemPool *pTmp = pDoc->GetAttrPool().GetSecondaryPool();
	pDoc->GetAttrPool().SetSecondaryPool( 0 );
	SfxItemPool* pPool = pDoc->GetAttrPool().Clone();
	pDoc->GetAttrPool().SetSecondaryPool( pTmp );

	pStyles->Seek( 0L );
	pStyles->SetSize( 0L );
	pStyles->SetBufferSize( SW3_BSW_STYLES );
	pStrm = pStyles;
	SwStyleSheetPool* p = new SwStyleSheetPool( *pDoc, *pPool,
												pStrm->GetVersion(), 0 );
	nRes = p->Store( *pStyles, bUsed ) ? 0 : ERR_SWG_WRITE_ERROR;
	pStyles->SetBufferSize( 0 );
	pStyles->Commit();
	delete p;
	delete pPool;
}

