/*************************************************************************
 *
 *  $RCSfile: lotimpop.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: os $ $Date: 2001/09/28 07:40:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "filt_pch.hxx"
#endif

#pragma hdrstop

#include <stdio.h>

#include "hintids.hxx"


#ifndef _SVX_ADJITEM_HXX //autogen
#include <svx/adjitem.hxx>
#endif

#include "doc.hxx"
#include "pam.hxx"
#include "swtable.hxx"
#include "lotpar.hxx"
#include "fltglbls.hxx"



// ----------------------------------------- SwLotusParser::Bof() - 0x00 -
void SwLotusParser::Bof()
	{
	USHORT nRev;

	Read( nRev );

	if( nRev == 0x0404 )
		{
		eDateiTyp = WKS;
		eQuellChar = RTL_TEXTENCODING_IBM_437;
		}
	else if( nRev == 0x0406 )
		{
		eDateiTyp = WK1;
		eQuellChar = RTL_TEXTENCODING_IBM_437;
		}
	else
		eDateiTyp = WKUnknown;

	}

// ---------------------------------- SwLotusParser::Dimensions() - 0x06 -
void SwLotusParser::Dimensions()
{
	USHORT nCS, nCE, nRS, nRE;

	Read( nCS, nRS, nCE, nRE );

	pLotGlob->ColLimitter( nCS );	// Cols/Rows in ihre Schranken verweisen
	pLotGlob->ColLimitter( nCE );

	pLotGlob->RowLimitter( nRS );
	pLotGlob->RowLimitter( nRE );

	pLotGlob->SetRange( nCS, nCE, nRS, nRE );
}


// --------------------------------------- SwLotusParser::Blank() - 0x0C -
void SwLotusParser::Blank1()
{
	BYTE nFormat;
	USHORT nCol, nRow;

	Read( nFormat, nCol, nRow );

}

// ------------------------------------ SwLotusParser::Integer1() - 0x0D -
void SwLotusParser::Integer1()
{
	BYTE nFormat;
	USHORT nCol, nRow;

	Read( nFormat, nCol, nRow );

	if( pLotGlob->IsInRange( nCol, nRow ) )
	{
		short nValue;

		Read( nValue );

		PutCell( nCol, nRow, nValue );
		//SetFormat( nCol, nRow, nTab, nFormat, 0 );
	}
}

// ------------------------------------- SwLotusParser::Number1() - 0x0E -
void SwLotusParser::Number1()
{
	BYTE nFormat;
	USHORT nCol, nRow;

	Read( nFormat, nCol, nRow );

	if( pLotGlob->IsInRange( nCol, nRow ) )
	{
		double fValue;

		Read( fValue );

		PutCell( nCol, nRow, fValue );
		//SetFormat( nCol, nRow, nTab, nFormat, nDezFloat );
	}
}


// -------------------------------------- SwLotusParser::Label1() - 0x0F -
void SwLotusParser::Label1()
{
	BYTE nFormat;
	USHORT nCol, nRow;

	Read( nFormat, nCol, nRow );

	if( pLotGlob->IsInRange( nCol, nRow ) )
	{
		sal_Char cPrefix;
		String aLabel;

		ReadChar( cPrefix );
		Read( aLabel );

		PutCell( nCol, nRow, aLabel, cPrefix );
		//SetFormat( nCol, nRow, nTab, nFormat, nDezStd );
	}
}



// ------------------------------------ SwLotusParser::Formula1() - 0x10 -
void SwLotusParser::Formula1()
	{
	BYTE nFormat;
	USHORT nCol, nRow;

	Read( nFormat, nCol, nRow );


	if( pLotGlob->IsInRange( nCol, nRow ) )
		{
		double fValue;

		Read( fValue );

		PutCell( nCol, nRow, fValue );
		// nFormat = Standard -> Nachkommastellen wie Float
		//SetFormat( nCol, nRow, nTab, nFormat, nDezFloat );
		}
	}

//--------------------------------- SwLotusParser::PutCell( ..., short ) -
void SwLotusParser::PutCell( USHORT nCol, USHORT nRow, short nVal )
{
	PutCell( nCol, nRow, String( nVal ), '"' );
}

//-------------------------------- SwLotusParser::PutCell( ..., double ) -
void SwLotusParser::PutCell( USHORT nCol, USHORT nRow, double fVal )
{
	register sal_Char *pC = pReadBuff;

	sprintf( pC, "%.8g", fVal );
	while( *pC != 0x00 )		// Q&D tauschen ',' <-> '.'  -> nur
	{							//  fuer deutsche Version brauchbar!
		if( *pC == '.' )
			*pC = ',';
		else if( *pC == ',' )
			*pC = '.';
		pC++;
	}

	PutCell( nCol, nRow, String::CreateFromAscii(pReadBuff), '"' );
}


//-------------------------- SwLotusParser::PutCell( ..., String, char ) -
void SwLotusParser::PutCell( USHORT nCol, USHORT nRow,
	const String &rText, sal_Char cJusty )
{
	pLotGlob->Normalize( nCol, nRow );
	pLotGlob->InsertText( nCol, nRow, rText );

	SvxAdjust eAdjust = SVX_ADJUST_LEFT;
	switch( cJusty )
	{
	case '"':   // rechtsbuendig
		eAdjust =  SVX_ADJUST_RIGHT;
		break;
	case '^':   // zentriert
		eAdjust =  SVX_ADJUST_CENTER;
		break;
	}

	pLotGlob->InsertAttr( SvxAdjustItem( eAdjust ) );
}


#ifdef USED

// ----------------------------------------- SwLotusParser::Eof() - 0x01 -
void SwLotusParser::Eof()
{
}

// -------------------------------------- SwLotusParser::Nrange() - 0x0B -
void SwLotusParser::Nrange()
{
}
// ------------------------------------------------- SwLotusParser:: -
void SwLotusParser::Text3()
{
/*	USHORT nRow;
	BYTE nCol,nTab;
	char pText[ 256 ];

	*pIn >> nRow >> nTab >> nCol;
	nLaenge -= 4;

	aS.Read( pText, nLaenge );
	pText[ nLaenge ] = 0;   // zur Sicherheit Nullterminator anhaengen

	PutFormString( nCol, nRow, nTab, pText );
*/
}

// ------------------------------------------------- SwLotusParser:: -
void SwLotusParser::Integer3()
{
/*	USHORT nRow;
	BYTE nCol,nTab;
	short nValue;

	*pIn >> nRow >> nTab >> nCol >> nValue;
*/
}

// ------------------------------------------------- SwLotusParser:: -
void SwLotusParser::Number3()
	{
/*	USHORT nRow;
	BYTE nCol,nTab;
	long double fValue;

	*pIn >> nRow >> nTab >> nCol;

	aS.Read( &fValue, 10 );

	//SetPrec( nCol, nRow, nTab, nDezFloat );   // Standard->nDezFloat Dez.stellen
*/
	}
// ------------------------------------------------- SwLotusParser:: -
void SwLotusParser::Formula3()
	{
//	aS.SeekRel( nLaenge );
	}

// ------------------------------------------------- SwLotusParser:: -
void SwLotusParser::ColumnWidth()
	{
/*	USHORT nCol, nBreite, nTab = 0;
	BYTE nWidthSpaces;
	*pIn >> nCol >> nWidthSpaces;

	// Annahme: 10cpi-Zeichensatz
	nBreite = ( USHORT ) ( TWIPS_PER_CHAR * nWidthSpaces );

	pDoc->SetColWidth( nCol, nTab, nBreite );
*/
	}

// ------------------------------------------------- SwLotusParser:: -
/*
void SwLotusParser::NamedRange() -> Nrange
	{
	// POST:    waren Koordinaten ungueltig, wird nicht gespeichert
	USHORT nColSt, nRowSt, nColEnd, nRowEnd;
	char cPuffer[ 32 ];
	aS.Read( cPuffer, 16 );

	*pIn >> nColSt >> nRowSt >> nColEnd >> nRowEnd;

	// Endkoordinaten in Variablenformat wandeln
	if( !KoordToAbs( nColEnd, nRowEnd, pPuffer1 ) )
		return;

	// Startkoordinaten in Variablenformat wandeln
	if( !KoordToAbs( nColSt, nRowSt, pPuffer0 ) )
		return;

	if( nColSt != nColEnd || nRowSt != nRowEnd )
		{// echter Bereich (else: nur eine Zelle)
		strcat( pPuffer0, ":" );
		strcat( pPuffer0, pPuffer1 );
		}

	if( isdigit( *cPuffer ) )
		{// erstes Zeichen im Namen eine Zahl -> 'A' vor Namen setzen
		*pAnsi = 'A';
		strcpy( pAnsi + 1, cPuffer );
		}
	else
		strcpy( pAnsi, cPuffer );

	DosToSystem( pAnsi );

	ScRangeName *pBereiche = pDoc->GetRangeName();
	pBereiche->Insert( new ScRangeData( String( pAnsi ),

	// Bereich merken
	AddRange( pAnsi, nColSt, nRowSt, nColEnd, nRowEnd );
	}
*/
// ------------------------------------------------- SwLotusParser:: -
/*
void SwLotusParser::SymphNamedRange()
	{
	// POST:    waren Koordinaten ungueltig, wird nicht gespeichert
	USHORT nColSt, nRowSt, nColEnd, nRowEnd, nN = 0;
	BYTE nType;
	char *pName, cPuffer[ 32 ];

	aS.Read( cPuffer, 16 );
	cPuffer[ 16 ] = 0;
	pName = cPuffer;

	*pIn >> nColSt >> nRowSt >> nColEnd >> nRowEnd >> nType;

	// Startkoordinaten in Variablenformat wandeln
	if( !KoordToAbs( nColSt, nRowSt, pErgebnis ) )
		{// bei Fehler nochmal mit zweiter Koordinate versuchen
		nColSt = nColEnd;
		nRowSt = nRowEnd;
		if( !KoordToAbs( nColSt, nRowSt, pErgebnis ) )
			// jetzt hilft nichts mehr!
			return;
		}

	if( nColSt != nColEnd || nRowSt != nRowEnd )
		{// Bereich
		strcat( pErgebnis, ":" );
		if( !KoordToAbs( nColEnd, nRowEnd, pErgebnis + strlen( pErgebnis ) ) )
			return;
		}

	if( isdigit( *cPuffer ) )
		{// erstes Zeichen im Namen eine Zahl -> 'A' vor Namen setzen
		*pAnsi = 'A';
		strcpy( pAnsi + 1, cPuffer );
		}
	else
		strcpy( pAnsi, cPuffer );

	DosToSystem( pAnsi );

	ScRangeName *pBereiche = pDoc->GetRangeName();
	pBereiche->Insert( new ScRangeData( String( pAnsi ),
						String( pErgebnis ), 0, 0, 0 ) );

	// Bereich merken
	AddRange( pAnsi, nColSt, nRowSt, nColEnd, nRowEnd );
	}
*/
// ------------------------------------------------- SwLotusParser:: -
void SwLotusParser::Window1()
	{
/*	USHORT nDefWidth;

	aS.SeekRel( 4 );    // Cursor Pos ueberspringen

	*pIn >> nDefaultFormat;

	aS.SeekRel( 1 );    // 'unused' ueberspringen

	*pIn >> nDefWidth;

	aS.SeekRel( nLaenge - 8 );  // und den Rest ueberspringen

	nDefWidth = ( USHORT ) ( TWIPS_PER_CHAR * nDefWidth );

	// statt Defaulteinstellung in SC alle Cols zu Fuss setzen
	for( USHORT nCol = 0 ; nCol <= MAXCOL ; nCol++ )
		pDoc->SetColWidth( nCol, 0, nDefWidth );
*/
	}

#endif


