/*************************************************************************
 *
 *  $RCSfile: srcvcfg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: os $ $Date: 2000/10/31 12:01:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop


#include "swtypes.hxx"
#include "srcvcfg.hxx"
#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

using namespace utl;
using namespace rtl;
using namespace com::sun::star::uno;

#define C2U(cChar) OUString::createFromAscii(cChar)
/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

SwSrcViewConfig::SwSrcViewConfig() :
	ConfigItem(C2U("Office.WriterWeb/SourceText")),
	nFontHeight(240)
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues = GetProperties(aNames);
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
	if(aValues.getLength() == aNames.getLength())
	{
		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
		{
			DBG_ASSERT(pValues[nProp].hasValue(), "property value missing")
			if(pValues[nProp].hasValue())
			{
				switch(nProp)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					{
						sal_Int32 nVal;
						pValues[nProp] >>= nVal;
						aSyntaxColors[nProp].SetColor((ColorData)nVal);
					}
					break;
					case 4: pValues[nProp] >>= sFontStyle;  break;
					case 5:
					{
						sal_Int32 nSet;
						pValues[nProp] >>= nSet;
						nFontHeight = MM100_TO_TWIP(nSet);
					}
					break;
				}
			}
		}
	}
}
/* -----------------------------09.10.00 14:33--------------------------------

 ---------------------------------------------------------------------------*/
SwSrcViewConfig::~SwSrcViewConfig()
{
}
/* -----------------------------09.10.00 14:33--------------------------------

 ---------------------------------------------------------------------------*/
Sequence<OUString> SwSrcViewConfig::GetPropertyNames()
{
	static const char* aPropNames[] =
	{
		"Color/SGML",			// 0
		"Color/Comment",		// 1
		"Color/KeyWord",		// 2
		"Color/Unknown",		// 3
		"Font/Name",			// 4
		"Font/Height"			// 5
	};
	const int nCount = 6;
	Sequence<OUString> aNames(nCount);
	OUString* pNames = aNames.getArray();
	for(int i = 0; i < nCount; i++)
		pNames[i] = OUString::createFromAscii(aPropNames[i]);
	return aNames;
}
/* -----------------------------09.10.00 14:33--------------------------------

 ---------------------------------------------------------------------------*/
void SwSrcViewConfig::Commit()
{
	Sequence<OUString> aNames = GetPropertyNames();

	OUString* pNames = aNames.getArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();

	const Type& rType = ::getBooleanCppuType();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
			case 0:
			case 1:
			case 2:
			case 3:
				pValues[nProp] <<= (sal_Int32)aSyntaxColors[nProp].GetColor();
			break;
			case 4: pValues[nProp] <<= sFontStyle;  break;
			case 5: pValues[nProp] <<= TWIP_TO_MM100(nFontHeight);  break;
		}
	}
	PutProperties(aNames, aValues);
}
/*-----------------19.04.97 10:08-------------------

--------------------------------------------------*/
void	SwSrcViewConfig::SetSyntaxColor(USHORT nIdx, const Color& rColor)
{
	DBG_ASSERT(nIdx < SYNTAX_COLOR_MAX, "falscher Index")
	if(aSyntaxColors[nIdx] != rColor)
	{
		SetModified();
		aSyntaxColors[nIdx] = rColor;
	}
}





