/*************************************************************************
 *
 *  $RCSfile: frmex.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jp $ $Date: 2001/09/27 17:21:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef _SV_POLY_HXX //autogen
#include <vcl/poly.hxx>
#endif
#ifndef _SV_METRIC_HXX //autogen
#include <vcl/metric.hxx>
#endif
#ifndef _SVX_SVXENUM_HXX //autogen
#include <svx/svxenum.hxx>
#endif

#ifndef _ORNTENUM_HXX
#include <orntenum.hxx>
#endif
#ifndef _FMTSRND_HXX
#include <fmtsrnd.hxx>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _FRMEX_HXX
#include <frmex.hxx>
#endif

#define FLYINFLY_BORDER	3
#define DEMOTEXT		"Ij"
#define C2S(cChar) UniString::CreateFromAscii(cChar)


/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

SwFrmPagePreview::SwFrmPagePreview( Window *pParent, const ResId& rResID ) :

	Window(pParent, rResID),

	aFrameColor	(COL_LIGHTGREEN),
	aAlignColor	(COL_LIGHTRED),
	aTransColor	(COL_TRANSPARENT),
	nAnchor		(FLY_PAGE),
	nHAlign		(HORI_CENTER),
	nHRel		(FRAME),
	nVAlign		(VERT_TOP),
	nVRel		(PRTAREA),
	aRelPos		(Point(0,0)),
	nWrap		(SURROUND_NONE),
	bTrans		(FALSE)
{
	SetMapMode(MAP_PIXEL);
}

/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

SwFrmPagePreview::~SwFrmPagePreview()
{
}

/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

void SwFrmPagePreview::InitAllRects()
{
//    const Size aSz(GetOutputSizePixel());

	// Seite
//    aPage.SetSize(Size(aSz.Width() - 3, aSz.Height() - 3));
    aPage.SetSize( GetOutputSizePixel() );

	ULONG nOutWPix = aPage.GetWidth();
	ULONG nOutHPix = aPage.GetHeight();

	// PrintArea
	ULONG nLBorder;
	ULONG nRBorder;
	ULONG nTBorder;
	ULONG nBBorder;

	ULONG nLTxtBorder;
	ULONG nRTxtBorder;
	ULONG nTTxtBorder;
	ULONG nBTxtBorder;

	if (nAnchor != FLY_IN_CNTNT)
	{
		nLBorder = 14;
		nRBorder = 10;
		nTBorder = 10;
		nBBorder = 15;

		nLTxtBorder = 8;
		nRTxtBorder = 4;
		nTTxtBorder = 2;
		nBTxtBorder = 2;
	}
	else
	{
		nLBorder = 2;
		nRBorder = 2;
		nTBorder = 2;
		nBBorder = 2;

		nLTxtBorder = 2;
		nRTxtBorder = 2;
		nTTxtBorder = 2;
		nBTxtBorder = 2;
	}
	aPagePrtArea = Rectangle(Point(nLBorder, nTBorder), Point((nOutWPix - 1) - nRBorder, (nOutHPix - 1) - nBBorder));

	// Beispiel-Text: Vorbereiten fuer die Textausgabe
	// Eine Textzeile
	aTextLine = aPagePrtArea;
	aTextLine.SetSize(Size(aTextLine.GetWidth(), 2));
	aTextLine.Left()	+= nLTxtBorder;
	aTextLine.Right()	-= nRTxtBorder;
	aTextLine.Move(0, nTTxtBorder);

	// Rechteck um Absatz incl. Rnder
	USHORT nLines = (USHORT)((aPagePrtArea.GetHeight() / 2 - nTTxtBorder - nBTxtBorder)
			 / (aTextLine.GetHeight() + 2));
	aPara = aPagePrtArea;
	aPara.SetSize(Size(aPara.GetWidth(),
		(aTextLine.GetHeight() + 2) * nLines + nTTxtBorder + nBTxtBorder));

	// Rechteck um Absatz ohne Rnder
	aParaPrtArea = aPara;
	aParaPrtArea.Left()		+= nLTxtBorder;
	aParaPrtArea.Right()	-= nRTxtBorder;
	aParaPrtArea.Top()		+= nTTxtBorder;
	aParaPrtArea.Bottom()	-= nBTxtBorder;

	if (nAnchor == FLY_IN_CNTNT || nAnchor == FLY_AUTO_CNTNT)
	{
        Font aFont = OutputDevice::GetDefaultFont(
                				DEFAULTFONT_LATIN_TEXT, ::GetAppLanguage(),
								DEFAULTFONT_FLAGS_ONLYONE, this );
		aFont.SetFillColor(Color(COL_WHITE));
		aFont.SetWeight(WEIGHT_NORMAL);

		if (nAnchor == FLY_IN_CNTNT)
		{
			aFont.SetSize(Size(0, aParaPrtArea.GetHeight() - 2));
			SetFont(aFont);
			aParaPrtArea.SetSize(Size(GetTextWidth(C2S(DEMOTEXT)), GetTextHeight()));
		}
		else
		{
			aFont.SetSize(Size(0, aParaPrtArea.GetHeight() / 2));
			SetFont(aFont);
			aAutoCharFrame.SetSize(Size(GetTextWidth('A'), GetTextHeight()));
			aAutoCharFrame.SetPos(Point(aParaPrtArea.Left() + (aParaPrtArea.GetWidth() - aAutoCharFrame.GetWidth()) / 2,
				aParaPrtArea.Top() + (aParaPrtArea.GetHeight() - aAutoCharFrame.GetHeight()) / 2));
		}
	}

	// Innerer Frame fuer am Frame verankerte Rahmen
	aFrameAtFrame = aPara;
	aFrameAtFrame.Left() += 9;
	aFrameAtFrame.Right() -= 5;
	aFrameAtFrame.Bottom() += 5;
	aFrameAtFrame.SetPos(Point(aFrameAtFrame.Left() + 2, (aPagePrtArea.Bottom() - aFrameAtFrame.GetHeight()) / 2 + 5));

	// Gre des zu positionierenden Rahmens
	if (nAnchor != FLY_IN_CNTNT)
	{
		ULONG nLFBorder = nAnchor == FLY_PAGE ? nLBorder : nLTxtBorder;
		ULONG nRFBorder = nAnchor == FLY_PAGE ? nRBorder : nRTxtBorder;

		switch (nHRel)
		{
			case REL_PG_LEFT:
			case REL_FRM_LEFT:
				aFrmSize = Size(nLFBorder - 4, (aTextLine.GetHeight() + 2) * 3);
				break;

			case REL_PG_RIGHT:
			case REL_FRM_RIGHT:
				aFrmSize = Size(nRFBorder - 4, (aTextLine.GetHeight() + 2) * 3);
				break;

			default:
				aFrmSize = Size(nLBorder - 3, (aTextLine.GetHeight() + 2) * 3);
				break;
		}
		aFrmSize.Width() = Max(5L, aFrmSize.Width());
		aFrmSize.Height() = Max(5L, aFrmSize.Height());
	}
	else
	{
		ULONG nFreeWidth = aPagePrtArea.GetWidth() - GetTextWidth(C2S(DEMOTEXT));

		aFrmSize = Size(nFreeWidth / 2, (aTextLine.GetHeight() + 2) * 3);
		aDrawObj.SetSize(Size(Max(5L, (long)nFreeWidth / 3L), Max(5L, aFrmSize.Height() * 3L)));
		aDrawObj.SetPos(Point(aParaPrtArea.Right() + 1, aParaPrtArea.Bottom() / 2));
		aParaPrtArea.Right() = aDrawObj.Right();
	}
}

/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

void SwFrmPagePreview::CalcBoundRect(Rectangle &rRect)
{
	switch (nAnchor)
	{
		case FLY_PAGE:
		{
			switch (nHRel)
			{
				case FRAME:
				case REL_PG_FRAME:
					rRect.Left() = aPage.Left();
					rRect.Right() = aPage.Right();
					break;

				case PRTAREA:
				case REL_PG_PRTAREA:
					rRect.Left() = aPagePrtArea.Left();
					rRect.Right() = aPagePrtArea.Right();
					break;

				case REL_PG_LEFT:
					rRect.Left() = aPage.Left();
					rRect.Right() = aPagePrtArea.Left();
					break;

				case REL_PG_RIGHT:
					rRect.Left() = aPagePrtArea.Right();
					rRect.Right() = aPage.Right();
					break;
			}

			switch (nVRel)
			{
				case PRTAREA:
				case REL_PG_PRTAREA:
					rRect.Top() = aPagePrtArea.Top();
					rRect.Bottom() = aPagePrtArea.Bottom();
					break;

				case FRAME:
				case REL_PG_FRAME:
					rRect.Top() = aPage.Top();
					rRect.Bottom() = aPage.Bottom();
					break;
			}
		}
		break;

		case FLY_AT_FLY:
		{
			switch (nHRel)
			{
				case FRAME:
				case REL_PG_FRAME:
					rRect.Left() = aFrameAtFrame.Left();
					rRect.Right() = aFrameAtFrame.Right();
					break;

				case PRTAREA:
				case REL_PG_PRTAREA:
					rRect.Left() = aFrameAtFrame.Left() + FLYINFLY_BORDER;
					rRect.Right() = aFrameAtFrame.Right() - FLYINFLY_BORDER;
					break;

				case REL_PG_LEFT:
					rRect.Left() = aFrameAtFrame.Left();
					rRect.Right() = aFrameAtFrame.Left() + FLYINFLY_BORDER;
					break;

				case REL_PG_RIGHT:
					rRect.Left() = aFrameAtFrame.Right();
					rRect.Right() = aFrameAtFrame.Right() - FLYINFLY_BORDER;
					break;
			}

			switch (nVRel)
			{
				case FRAME:
				case REL_PG_FRAME:
					rRect.Top() = aFrameAtFrame.Top();
					rRect.Bottom() = aFrameAtFrame.Bottom();
					break;

				case PRTAREA:
				case REL_PG_PRTAREA:
					rRect.Top() = aFrameAtFrame.Top() + FLYINFLY_BORDER;
					rRect.Bottom() = aFrameAtFrame.Bottom() - FLYINFLY_BORDER;
					break;
			}
		}
		break;

		case FLY_AT_CNTNT:
		case FLY_AUTO_CNTNT:
		{
			switch (nHRel)
			{
				case FRAME:
					rRect.Left() = aPara.Left();
					rRect.Right() = aPara.Right();
					break;

				case PRTAREA:
					rRect.Left() = aParaPrtArea.Left();
					rRect.Right() = aParaPrtArea.Right();
					break;

				case REL_PG_LEFT:
					rRect.Left() = aPage.Left();
					rRect.Right() = aPagePrtArea.Left();
					break;

				case REL_PG_RIGHT:
					rRect.Left() = aPagePrtArea.Right();
					rRect.Right() = aPage.Right();
					break;

				case REL_PG_FRAME:
					rRect.Left() = aPage.Left();
					rRect.Right() = aPage.Right();
					break;

				case REL_PG_PRTAREA:
					rRect.Left() = aPagePrtArea.Left();
					rRect.Right() = aPagePrtArea.Right();
					break;

				case REL_FRM_LEFT:
					rRect.Left() = aPara.Left();
					rRect.Right() = aParaPrtArea.Left();
					break;

				case REL_FRM_RIGHT:
					rRect.Left() = aParaPrtArea.Right();
					rRect.Right() = aPara.Right();
					break;

				case REL_CHAR:
					rRect.Left() = aAutoCharFrame.Left();
					rRect.Right() = aAutoCharFrame.Left();
					break;
			}

			switch (nVRel)
			{
				case FRAME:
					rRect.Top() = aPara.Top();
					rRect.Bottom() = aPara.Bottom();
					break;

				case PRTAREA:
					rRect.Top() = aParaPrtArea.Top();
					rRect.Bottom() = aParaPrtArea.Bottom();
					break;

				case REL_CHAR:
					if (nVAlign != VERT_NONE && nVAlign != SVX_VERT_CHAR_BOTTOM)
						rRect.Top() = aAutoCharFrame.Top();
					else
						rRect.Top() = aAutoCharFrame.Bottom();
					rRect.Bottom() = aAutoCharFrame.Bottom();
					break;
			}
		}
		break;

		case FLY_IN_CNTNT:
			rRect.Left() = aParaPrtArea.Left();
			rRect.Right() = aParaPrtArea.Right();

			switch (nVAlign)
			{
				case SVX_VERT_NONE:
				case SVX_VERT_TOP:
				case SVX_VERT_CENTER:
				case SVX_VERT_BOTTOM:
				{
					FontMetric aMetric(GetFontMetric());

					rRect.Top() = aParaPrtArea.Bottom() - aMetric.GetDescent();
					rRect.Bottom() = rRect.Top();
				}
				break;

				default:

				case SVX_VERT_LINE_TOP:
				case SVX_VERT_LINE_CENTER:
				case SVX_VERT_LINE_BOTTOM:
					rRect.Top() = aParaPrtArea.Top();
					rRect.Bottom() = aDrawObj.Bottom();
					break;

				case SVX_VERT_CHAR_TOP:
				case SVX_VERT_CHAR_CENTER:
				case SVX_VERT_CHAR_BOTTOM:
					rRect.Top() = aParaPrtArea.Top();
					rRect.Bottom() = aParaPrtArea.Bottom();
					break;
			}
			break;

		default:
			break;
	}
}

/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

Rectangle SwFrmPagePreview::DrawInnerFrame(const Rectangle &rRect, const Color &rFillColor, const Color &rBorderColor)
{
	DrawRect(rRect, rFillColor, rBorderColor);

	// Bereich, zu dem relativ positioniert wird, bestimmen
	Rectangle aRect(rRect);	// aPagePrtArea = Default
	CalcBoundRect(aRect);

	if (nAnchor == FLY_AT_FLY && &rRect == &aPagePrtArea)
	{
		// Testabsatz zeichnen
		const long nTxtLineHeight = aTextLine.GetHeight();
		Rectangle aTxt(aTextLine);
		USHORT nStep = aTxt.GetHeight() + 2;
		USHORT nLines = (USHORT)(aParaPrtArea.GetHeight() / (aTextLine.GetHeight() + 2));

		for (USHORT i = 0; i < nLines; i++)
		{
			if (i == nLines - 1)
				aTxt.SetSize(Size(aTxt.GetWidth() / 2, aTxt.GetHeight()));
			DrawRect(aTxt, Color(COL_GRAY), aTransColor);
			aTxt.Move(0, nStep);
		}
	}

	return aRect;
}

/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

void SwFrmPagePreview::Paint(const Rectangle &rRect)
{
	InitAllRects();

	// Schatten zeichnen
//    Rectangle aShadow(aPage);
//    aShadow += Point(3, 3);
//    DrawRect(aShadow, Color(COL_GRAY), aTransColor);

	// Seite zeichnen
	DrawRect(aPage, Color(COL_WHITE), Color(COL_BLACK));

	// PrintArea zeichnen
	Rectangle aRect = DrawInnerFrame(aPagePrtArea, aTransColor, Color(COL_GRAY));

	if (nAnchor == FLY_AT_FLY)
		aRect = DrawInnerFrame(aFrameAtFrame, Color(COL_WHITE), Color(COL_BLACK));

	long lXPos 	  = 0;
	long lYPos 	  = 0;

	// Horizontale Ausrichtung
	//
	if (nAnchor != FLY_IN_CNTNT)
	{
		switch (nHAlign)
		{
			case HORI_RIGHT:
			{
				lXPos = aRect.Right() - aFrmSize.Width() + 1;
				break;
			}
			case HORI_CENTER:
			{
				lXPos = aRect.Left() + (aRect.GetWidth() - aFrmSize.Width()) / 2;
				break;
			}
			case HORI_NONE:
			{
				lXPos = aRect.Left() + aRelPos.X();
				break;
			}

			default: // HORI_LEFT
				lXPos = aRect.Left();
				break;
		}
	}
	else
		lXPos = aRect.Right() + 2;

	// Vertikale Ausrichtung
	//
	if (nAnchor != FLY_IN_CNTNT)
	{
		switch (nVAlign)
		{
			case VERT_BOTTOM:
			case VERT_LINE_BOTTOM:
			{
				lYPos = aRect.Bottom() - aFrmSize.Height() + 1;
				break;
			}
			case VERT_CENTER:
			case VERT_LINE_CENTER:
			{
				lYPos = aRect.Top() + (aRect.GetHeight() - aFrmSize.Height()) / 2;
				break;
			}
			case VERT_NONE:
			{
				if (nVRel != REL_CHAR)
					lYPos = aRect.Top() + aRelPos.Y();
				else
					lYPos = aRect.Top() - aRelPos.Y();
				break;
			}
			default:
				lYPos = aRect.Top();
				break;
		}
	}
	else
	{
		switch(nVAlign)
		{
			case SVX_VERT_CENTER:
			case SVX_VERT_CHAR_CENTER:
			case SVX_VERT_LINE_CENTER:
				lYPos = aRect.Top() + (aRect.GetHeight() - aFrmSize.Height()) / 2;
				break;

			case SVX_VERT_TOP:
			case SVX_VERT_CHAR_BOTTOM:
			case SVX_VERT_LINE_BOTTOM:
				lYPos = aRect.Bottom() - aFrmSize.Height() + 1;
				break;

/*			case SVX_VERT_NONE:
			case SVX_VERT_BOTTOM:
			case SVX_VERT_CHAR_TOP:
			case SVX_VERT_LINE_TOP:*/
			default:
				lYPos = aRect.Top() - aRelPos.Y();
				break;
		}
	}

	Rectangle aFrmRect(Point(lXPos, lYPos), aFrmSize);

	Rectangle *pOuterFrame = &aPage;

	if (nAnchor == FLY_AT_FLY)
		pOuterFrame = &aFrameAtFrame;

	if (aFrmRect.Left() < pOuterFrame->Left())
		aFrmRect.Move(pOuterFrame->Left() - aFrmRect.Left(), 0);
	if (aFrmRect.Right() > pOuterFrame->Right())
		aFrmRect.Move(pOuterFrame->Right() - aFrmRect.Right(), 0);

	if (aFrmRect.Top() < pOuterFrame->Top())
		aFrmRect.Move(0, pOuterFrame->Top() - aFrmRect.Top());
	if (aFrmRect.Bottom() > pOuterFrame->Bottom())
		aFrmRect.Move(0, pOuterFrame->Bottom() - aFrmRect.Bottom());

	// Testabsatz zeichnen
	const long nTxtLineHeight = aTextLine.GetHeight();
	Rectangle aTxt(aTextLine);
	USHORT nStep, nLines;

	if (nAnchor == FLY_AT_FLY)
	{
		aTxt.Left() = aFrameAtFrame.Left() + FLYINFLY_BORDER;
		aTxt.Right() = aFrameAtFrame.Right() - FLYINFLY_BORDER;
		aTxt.Top() = aFrameAtFrame.Top() + FLYINFLY_BORDER;
		aTxt.Bottom() = aTxt.Top() + aTextLine.GetHeight() - 1;

		nStep = aTxt.GetHeight() + 2;
		nLines = (USHORT)(((aFrameAtFrame.GetHeight() - 2 * FLYINFLY_BORDER) * 2 / 3)
				 / (aTxt.GetHeight() + 2));
	}
	else
	{
		nStep = aTxt.GetHeight() + 2;
		nLines = (USHORT)(aParaPrtArea.GetHeight() / (aTextLine.GetHeight() + 2));
	}

	if (nAnchor != FLY_IN_CNTNT)
	{
		// Text simulieren
		//
		const long nOldR = aTxt.Right();
		const long nOldL = aTxt.Left();

		BOOL bIgnoreWrap = nAnchor == FLY_AUTO_CNTNT && (nHRel == REL_CHAR || nVRel == REL_CHAR);

		for (USHORT i = 0; i < nLines; ++i)
		{
			if (i == (nLines - 1))
				aTxt.SetSize(Size(aTxt.GetWidth() / 2, aTxt.GetHeight()));

			if (aTxt.IsOver(aFrmRect) && nAnchor != FLY_IN_CNTNT && !bIgnoreWrap)
			{
				switch(nWrap)
				{
					case SURROUND_NONE:
						aTxt.Top() 	  = aFrmRect.Bottom() + nTxtLineHeight;
						aTxt.Bottom() = aTxt.Top() + nTxtLineHeight - 1;
						break;

					case SURROUND_LEFT:
						aTxt.Right() = aFrmRect.Left();
						break;

					case SURROUND_RIGHT:
						aTxt.Left() = aFrmRect.Right();
						break;
				}
			}
			if (pOuterFrame->IsInside(aTxt))
				DrawRect(aTxt, Color(COL_GRAY), aTransColor);

			aTxt.Move(0, nStep);
			aTxt.Right() = nOldR;
			aTxt.Left()  = nOldL;
		}
		aTxt.Move(0, -nStep);

		if (nAnchor != FLY_AT_FLY && aTxt.Bottom() > aParaPrtArea.Bottom())
		{
			// Text wurde durch Rahmen verdraengt, daher Para-Hoehe anpassen
			ULONG nDiff = aTxt.Bottom() - aParaPrtArea.Bottom();
			aParaPrtArea.Bottom() += nDiff;
			aPara.Bottom() += nDiff;

			CalcBoundRect(aRect);

			aParaPrtArea.Bottom() -= nDiff;
			aPara.Bottom() -= nDiff;
		}
		if (nAnchor == FLY_AUTO_CNTNT && bIgnoreWrap)
			DrawText(aAutoCharFrame, 'A');
	}
	else
	{
		DrawText(aParaPrtArea, C2S(DEMOTEXT));
		DrawRect(aDrawObj, Color(COL_LIGHTGRAY), Color(COL_GRAY));
	}

	// Rechteck zeichnen, zu dem der Rahmen ausgerichtet wird:
	DrawRect(aRect, aTransColor, aAlignColor);

	// Frame anzeigen
	BOOL bDontFill = (nAnchor == FLY_AUTO_CNTNT && aFrmRect.IsOver(aAutoCharFrame))
						? TRUE : bTrans;
	DrawRect(aFrmRect, bDontFill ? aTransColor : Color(COL_WHITE), aFrameColor);
}

void SwFrmPagePreview::SetRelPos(const Point& rP)
{
	aRelPos = rP;

	if (aRelPos.X() > 0)
		aRelPos.X() = 5;
	if (aRelPos.X() < 0)
		aRelPos.X() = -5;

	if (aRelPos.Y() > 0)
		aRelPos.Y() = 5;
	if (aRelPos.Y() < 0)
		aRelPos.Y() = -5;
}

/*-----------------------------------------------------------------------
	Beschreibung:
 -----------------------------------------------------------------------*/

void SwFrmPagePreview::DrawRect(const Rectangle &rRect, const Color &rFillColor, const Color &rLineColor)
{
	SetFillColor(rFillColor);
	SetLineColor(rLineColor);
	Window::DrawRect(rRect);
}

/*-----------------25.02.94 21:22-------------------
   $Log: frmex.cxx,v $
   Revision 1.4  2001/09/27 17:21:00  jp
   Task #91873#: remove usage of GetSystemLanguage and other system realted methods

   Revision 1.3  2001/06/28 09:54:15  os
   #81329# use OutputDevice::GetDefaulFont

   Revision 1.2  2001/06/22 07:35:46  dr
   #88289# redesign fixes

   Revision 1.1.1.1  2000/09/18 17:14:37  hr
   initial import

   Revision 1.41  2000/09/18 16:05:33  willem.vandorp
   OpenOffice header added.

   Revision 1.40  2000/04/18 15:14:56  os
   UNICODE

   Revision 1.39  2000/03/03 15:17:01  os
   StarView remainders removed

   Revision 1.38  2000/02/11 14:47:28  hr
   #70473# changes for unicode ( patched by automated patchtool )

   Revision 1.37  1998/02/27 15:41:46  OM
   Unterhalb


	  Rev 1.36   27 Feb 1998 16:41:46   OM
   Unterhalb

	  Rev 1.35   28 Jan 1998 12:25:50   OM
   Aufgeraeumt

	  Rev 1.34   27 Jan 1998 15:25:48   OM
   Vorschau fuer Zeichenausrichtungen

	  Rev 1.33   27 Jan 1998 14:58:04   OM
   Vorschau fuer Zeichenausrichtungen

	  Rev 1.32   27 Jan 1998 13:42:52   OM
   Vorschau fuer Zeichenausrichtungen

	  Rev 1.31   27 Jan 1998 13:08:26   OM
   Vorschau fuer Zeichenausrichtungen

	  Rev 1.30   26 Jan 1998 17:36:54   OM
   Rahmenvorschau

	  Rev 1.29   26 Jan 1998 13:47:02   OM
   Rahmenvorschau

	  Rev 1.28   26 Jan 1998 12:13:08   OM
   Rahmenvorschau

	  Rev 1.27   23 Jan 1998 10:48:24   OM
   Neue Rahmenvorschau

	  Rev 1.26   28 Nov 1997 19:44:08   MA
   includes

	  Rev 1.25   24 Nov 1997 17:40:14   MA
   include

	  Rev 1.24   03 Nov 1997 13:19:48   MA
   precomp entfernt

	  Rev 1.23   01 Sep 1997 13:26:22   OS
   DLL-Umstellung

	  Rev 1.22   15 Aug 1997 12:13:24   OS
   chartar/frmatr/txtatr aufgeteilt

	  Rev 1.21   09 Jul 1997 17:40:30   HJS
   includes

	  Rev 1.20   04 Jun 1997 12:17:34   OM
   Rahmenvorschau verbessert

	  Rev 1.19   23 Apr 1997 13:43:16   OS
   ResId const

	  Rev 1.18   06 Sep 1996 14:15:20   OM
   #31010# GPF bei fehlenden Groessenangaben behoben

	  Rev 1.17   28 Aug 1996 11:52:44   OS
   includes

	  Rev 1.16   19 Apr 1996 16:11:16   MA
   chg: Vorbereitung fuer kleine Rahmen

	  Rev 1.15   13 Apr 1996 15:34:24   MA
   chg: Neue Ausrichtung fuer Zeichengebunde Rahmen

	  Rev 1.14   22 Mar 1996 15:12:38   MH
   add: include pageitem.hxx

	  Rev 1.13   24 Nov 1995 16:58:08   OM
   PCH->PRECOMPILED

	  Rev 1.12   21 Nov 1995 08:08:52   OS
   aSize komnt jetzt von der Basisklasse

	  Rev 1.11   08 Nov 1995 13:46:20   OM
   Change->Set

	  Rev 1.10   22 Aug 1995 09:13:06   MA
   svxitems-header entfernt

	  Rev 1.9   18 Jul 1995 19:24:00   OM
   Neue Vorschau

	  Rev 1.8   17 Jul 1995 18:57:38   OM
   Neue Rahmenvorschau

	  Rev 1.7   17 Jul 1995 10:57:18   OS
   nur gesetzte Items aus dem Set holen

--------------------------------------------------*/


