/*************************************************************************
 *
 *  $RCSfile: txtq.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "cmdid.h"
#include "hintids.hxx"


#ifndef _LIST_HXX //autogen steht hier wg. "internal Microsoft error"
#include <tools/list.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif

#include "wrtsh.hxx"
#include "frmatr.hxx"
#include "pagedesc.hxx"
#include "fmtcol.hxx"
#include "charfmt.hxx"
#include "textsh.hxx"
#include "num.hxx"
#include "fldbas.hxx"

/*--------------------------------------------------

--------------------------------------------------*/

void SwTextShell::StateQuery( SfxItemSet& rSet )
{
	register SwWrtShell& rSh = GetShell();
	SfxWhichIter aIter( rSet );
	USHORT nWhich = aIter.FirstWhich();
	register BOOL bFlag;

	switch( nWhich )
	{
		case FN_GET_SELECTION:
		case FN_GET_SELECTED_TEXT:
			{
				String sSelection;
				rSh.GetSelectedText( sSelection,
					FN_GET_SELECTION == nWhich
							? GETSELTXT_PARABRK_KEEP
							: GETSELTXT_PARABRK_TO_BLANK );
				rSet.Put( SfxStringItem( nWhich, sSelection ) );
				nWhich = 0;
			}
			break;
		case FN_GETSET_LINE_TEXT:
		{
			rSh.StartAction();
			rSh.Push();
			rSh.LeftMargin(FALSE);
			rSh.RightMargin(TRUE);
			rSet.Put( SfxStringItem( nWhich, rSh.GetSelTxt() ) );
			rSh.Pop(FALSE);
			rSh.EndAction();
			nWhich = 0;
		}
		break;
		case FN_GET_CURSOR_XPOS:
			{
				const SvxLRSpaceItem& rLR = rSh.GetPageDesc( rSh.GetCurPageDesc()
													).GetMaster().GetLRSpace();
				long nRet = rSh.GetCharRect().Left() -
								(rLR.GetLeft() + DOCUMENTBORDER);
				rSet.Put( SfxInt32Item( nWhich, nRet ) );
				nWhich = 0;
			}
			break;
		case FN_GET_CURSOR_YPOS:
			{
				const SvxULSpaceItem& rUL = rSh.GetPageDesc( rSh.GetCurPageDesc()
													).GetMaster().GetULSpace();
				long nRet = rSh.GetCharRect().Top() -
								(rUL.GetUpper() + DOCUMENTBORDER);
				rSet.Put( SfxInt32Item( nWhich, nRet ) );
				nWhich = 0;
			}
			break;
		case FN_GET_PAGECOUNT:
			{
				rSet.Put( SfxUInt16Item( nWhich, rSh.GetPageCnt()));
				nWhich = 0;
			}
			break;
		case FN_GET_PAGENUMBER:
		case FN_GET_LOG_PAGENUMBER:
			{
				USHORT nPage, nLogPage;
				rSh.GetPageNum( nPage, nLogPage,
				   rSh.IsCrsrVisible(), FALSE);
				rSet.Put( SfxUInt16Item( nWhich,
					nWhich == FN_GET_PAGENUMBER ? nPage : nLogPage));
				nWhich = 0;
			}
			break;
		case FN_IS_START_OF_PARA:
			bFlag = rSh.IsSttOfPara();
			break;
		case FN_IS_START_OF_WORD:
			bFlag = rSh.IsSttWrd();
			break;
		case FN_IS_START_OF_DOC:
			bFlag = rSh.IsStartOfDoc();
			break;
		case FN_IS_END_OF_PARA:
			bFlag = rSh.IsEndOfPara();
			break;
		case FN_IS_END_OF_WORD:
			bFlag = rSh.IsEndWrd();
			break;
		case FN_IS_END_OF_DOC:
			bFlag = rSh.IsEndOfDoc();
			break;
		case FN_GET_NO_OF_SEL:
				rSet.Put( SfxUInt16Item( nWhich, rSh.GetCrsrCnt(FALSE) ) );
				nWhich = 0;
			break;
		case FN_GET_CUR_VALUE:
		{
				String aRet;
				if(rSh.HasSelection())
					aRet = rSh.GetSelTxt();
				else if( rSh.GetCurFld())
				{
					SwField* pFld = rSh.GetCurFld();
					aRet = pFld->GetCntnt();
				}
				else
				{
					rSh.Push();
					rSh.SelNearestWrd();
					aRet = rSh.GetSelTxt();
					rSh.Pop(FALSE);
				}
				rSet.Put(SfxStringItem(nWhich, aRet));
				nWhich = 0;
		}
		break;
		case FN_IS_START_OF_PAGE:
			break;
		case FN_IS_END_OF_PAGE:
			break;
		case FN_IS_START_OF_SENT:
			break;
		case FN_IS_END_OF_SENT:
		{
			bFlag = FALSE;

			if (!rSh.IsSttOfPara())
			{
				switch (rSh.GetChar(FALSE, -1))
				{
					case ';':
					case '.':
					case ':':
					case '!':
					case '?':
						bFlag = TRUE;
						break;
				}
			}
		}
		break;
		case FN_IS_END_OF_LINE:
		{
			BOOL bLocked = rSh.IsViewLocked();
			if (!bLocked)
				rSh.LockView(TRUE);
			Point aStartPos = rSh.GetCrsrDocPos();
			rSh.Push();
			rSh.RightMargin(FALSE);
			bFlag = aStartPos == rSh.GetCrsrDocPos();
			rSh.Pop(FALSE);
			if (!bLocked)
				rSh.LockView(FALSE);
		}
		break;
		case FN_GET_CHAR_STYLE_COUNT:
		{
			rSet.Put( SfxUInt16Item( nWhich,
									rSh.GetCharFmtCount() - 1 ));
			nWhich = 0;
		}
		break;
		case FN_GET_PARA_STYLE_COUNT:
		{
			rSet.Put( SfxUInt16Item( nWhich,
									rSh.GetTxtFmtCollCount() - 1 ));
			nWhich = 0;
		}
		break;
		default:
			ASSERT(FALSE, falscher Dispatcher);
			return;
	}
	if( nWhich )
		rSet.Put( SfxBoolItem( nWhich, bFlag ) );
}

/*--------------------------------------------------

--------------------------------------------------*/

void SwTextShell::ExecQuery(SfxRequest &rReq)
{
	register SwWrtShell& rSh = GetShell();
	const SfxItemSet* pArgs = rReq.GetArgs();
	USHORT nSlot = rReq.GetSlot();

	switch( nSlot )
	{
		case FN_GET_CHAR_STYLE_AT:
		{
			if(pArgs)
			{
				String aStyle = aEmptyStr;

				const USHORT nIndex = ((SfxUInt16Item &)pArgs->
												Get(nSlot)).GetValue();
				if( nIndex <  rSh.GetCharFmtCount() - 1 )
					aStyle = rSh.GetCharFmt(nIndex+1).GetName();
				rReq.SetReturnValue(SfxStringItem(nSlot, aStyle));
			}
		}
		break;
		case FN_GET_PARA_STYLE_AT:
		{
			if(pArgs)
			{
				String aStyle = aEmptyStr;
				const USHORT nIndex = ((SfxUInt16Item &)pArgs->
												Get(nSlot)).GetValue();
				USHORT nCount = rSh.GetTxtFmtCollCount() - 1;
				if(nIndex < nCount)
					aStyle = rSh.GetTxtFmtColl(nIndex + 1).GetName();
				rReq.SetReturnValue(SfxStringItem(nSlot, aStyle));
			}
		}
		break;
		case FN_GETSET_LINE_TEXT:
		if(pArgs)
		{
			const String sArg = ((SfxStringItem &)pArgs->
												Get(nSlot)).GetValue();
			rSh.StartAction();
			rSh.Push();
			rSh.LeftMargin(FALSE);
			rSh.RightMargin(TRUE);
			rSh.Insert(sArg);
			rSh.Pop(FALSE);
			rSh.EndAction();
		}
		break;
		case FN_GET_LINE_COUNT:
		{
			BOOL bActPos = FALSE;
			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(FN_GET_LINE_COUNT))
				bActPos = ((const SfxBoolItem&)pArgs->Get(FN_GET_LINE_COUNT)).GetValue();
			rReq.SetReturnValue(SfxUInt16Item(FN_GET_LINE_COUNT, rSh.GetLineCount(bActPos)));
		}
		break;
		default:
			ASSERT(FALSE, falscher Dispatcher);
			return;
	}
}
/*------------------------------------------------------------------------

	$Log: txtq.cxx,v $
	Revision 1.1.1.1  2000/09/18 17:14:47  hr
	initial import
	
	Revision 1.46  2000/09/18 16:06:07  willem.vandorp
	OpenOffice header added.
	
	Revision 1.45  2000/05/26 07:21:33  os
	old SW Basic API Slots removed
	
	Revision 1.44  2000/04/20 12:51:52  os
	GetName() returns String&

	Revision 1.43  1998/06/27 13:58:34  JP
	GetSelectedText hat andere Parameter


	  Rev 1.42   27 Jun 1998 15:58:34   JP
   GetSelectedText hat andere Parameter

	  Rev 1.41   24 Nov 1997 09:46:52   MA
   includes

	  Rev 1.40   06 Nov 1997 16:21:22   OS
   Satzende ist auch am Semikolon #45401#

	  Rev 1.39   03 Nov 1997 13:55:44   MA
   precomp entfernt

	  Rev 1.38   15 Sep 1997 13:29:40   OM
   GetSelectedText: Letztes FormFeed nicht in Space wandeln

	  Rev 1.37   15 Aug 1997 11:48:36   OS
   chartar/frmatr/txtatr aufgeteilt

	  Rev 1.36   12 Aug 1997 16:01:50   OS
   frmitems/textitem/paraitem aufgeteilt

	  Rev 1.35   08 Aug 1997 17:29:04   OM
   Headerfile-Umstellung

	  Rev 1.34   07 Aug 1997 14:59:52   OM
   Headerfile-Umstellung

	  Rev 1.33   29 Jul 1997 16:30:24   OM
   #42006# Basic: Selektierten Text zurueckliefern

	  Rev 1.32   14 Jul 1997 11:31:06   OS
   FN_GET_PAGENUMBER und FN_GET_LOG_PAGENUMBER zusammengefasst

	  Rev 1.31   21 Jun 1997 14:53:14   OS
   neu: GetLineCount

	  Rev 1.30   18 Jun 1997 17:03:20   OM
   Basic: IsEndOfLine und IsEndOfSentence

	  Rev 1.29   13 Jun 1997 16:13:02   OM
   Basic: Cursor-YPos ermitteln

	  Rev 1.28   07 Apr 1997 17:44:04   MH
   chg: header

	  Rev 1.27   04 Feb 1997 16:53:42   OS
   fehlendes break!

	  Rev 1.26   13 Jan 1997 11:15:44   OS
   neu: LineText

	  Rev 1.25   22 Nov 1996 15:11:28   OS
   GetCrsrCount soll nur aufgespannte Markierungen zaehlen

	  Rev 1.24   07 Sep 1996 10:32:24   OS
   neu: FN_GET_SELECTION fuer Selection.ValueAndBreaks

	  Rev 1.23   28 Aug 1996 15:55:06   OS
   includes

	  Rev 1.22   22 Apr 1996 15:45:28   OS
   CursorXPos nicht auf mm umrechnen Bug #27291#

	  Rev 1.21   22 Mar 1996 15:35:42   TRI
   sfxiiter.hxx included

	  Rev 1.20   31 Jan 1996 17:47:54   OS
   GET_CHAR/PARA_STYLE_COUNT:  nWhich auf 0, damit nicht noch ein BoolItem nachgeschickt wird

	  Rev 1.20   31 Jan 1996 17:35:10   OS
   GET_CHAR/PARA_STYLE_COUNT:  nWhich auf 0, damit nicht noch ein BoolItem nachgeschickt wird

	  Rev 1.19   09 Jan 1996 11:44:00   OS
   Bug#23895#: Selektionen ueber mehrere Absatze ans Basic ausgeben

	  Rev 1.18   30 Nov 1995 14:26:40   OM
   Slots verschoben

	  Rev 1.17   24 Nov 1995 16:59:30   OM
   PCH->PRECOMPILED

	  Rev 1.16   09 Nov 1995 17:59:54   OS
   neue Slots fuer Grosskunden

	  Rev 1.15   30 Oct 1995 18:56:50   OS
   Selection: String immer putten und mit GetSelTxt() holen

	  Rev 1.14   12 Oct 1995 16:41:14   MA
   chg: unuetzes Zeug entfernt.

	  Rev 1.13   21 Aug 1995 19:53:08   MA
   chg: svxitems-header entfernt

------------------------------------------------------------------------*/


