/*************************************************************************
 *
 *  $RCSfile: wizcfg.cxx,v $
 *
 *  $Revision: 1.6.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/06/01 05:19:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef _WIZCFG_HXX
#include <wizcfg.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _WIZAG_HXX
#include <wizag.hxx>
#endif
#ifndef _WIZDOKU_HXX
#include <wizdoku.hxx>
#endif

using namespace rtl;
using namespace com::sun::star;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;

#define C2U(cChar) OUString::createFromAscii(cChar)
#define C2S(cChar) String::CreateFromAscii(cChar)
const char* cAgendaList = "AgendaTopics/AgendaList";
/* -----------------------------29.05.01 08:51--------------------------------

 ---------------------------------------------------------------------------*/
void lcl_ExpandPlaceHolder(OUString& rPropertyName)
{
    static const char cTemplate[] = "Template/";
    static const char cLogo[] = "Logo/";
    static const char cSender[] = "Sender/";
    static const char cRecipient[] = "Recipient/";
    static const char cElements[] = "Elements/";
    static const char cSave[] = "Save/";
    static const char cHeader[] = "Header/";
    static const char cFooter[] = "Footer/";
    static const char cPrint[] = "Print/";
    static const char cElementsElement[] = "Elements/Element";
    static const char cLogoAlignPos[] = "Logo/Alignment/Position/";
    static const char cSenderAlignPos[] = "Sender/Alignment/Position/";
    static const char cRecipientAlignPos[] = "Recipient/Alignment/Position/";
    sal_Int32 nToken = rPropertyName.getStr()[0];
    nToken -= '0';
    const char* cReplace = 0;
    switch(nToken)
    {
        case 0 : cReplace = cTemplate; break;
        case 1 : cReplace = cLogo; break;
        case 2 : cReplace = cSender; break;
        case 3 : cReplace = cRecipient; break;
        case 4 : cReplace = cElements; break;
        case 5 : cReplace = cSave; break;
        case 6 : cReplace = cHeader; break;
        case 7 : cReplace = cFooter; break;
        case 8 : cReplace = cPrint; break;
        case 9 : cReplace = cElementsElement; break;
        case 49: cReplace = cLogoAlignPos; break; //'a'
        case 50: cReplace = cSenderAlignPos; break; //'b'
        case 51: cReplace = cRecipientAlignPos; break; // 'c'
    }
    if(cReplace)
    {
        String sTmp(rPropertyName);
        sTmp.Erase(0, 1);
        sTmp.InsertAscii(cReplace, 0);
        rPropertyName = sTmp;
    }

}
/* -----------------------------25.09.00 09:31--------------------------------

 ---------------------------------------------------------------------------*/
void SwWizardCfgDocInfo::ReadDocInfo(WizardDokuDlg& rDoc)
{
	rDoc.pD_List_InfTit->SelectEntry(sSaveDocInfoTitle);
	rDoc.pD_List_InfTem->SelectEntry(sSaveDocInfoSubject);
	rDoc.pD_Edit_VorNam->SetText(sSaveTemplateName);
	rDoc.pD_Edit_VorInf->SetText(sSaveTemplateInfo);
	rDoc.pD_CBox_AutoFN->Check(bSaveAutoDocName);
	rDoc.pD_Edit_AutoFN->SetText(sSaveAutoPrefix);
	rDoc.pD_Text_Folder->SetText(sSaveAutoPath);
}
/* -----------------------------25.09.00 09:38--------------------------------

 ---------------------------------------------------------------------------*/
void SwWizardCfgDocInfo::WriteDocInfo(const WizardDokuDlg& rDoc)
{
	sSaveDocInfoTitle = 	rDoc.pD_List_InfTit->GetSelectEntry();
	sSaveDocInfoSubject = 	rDoc.pD_List_InfTem->GetSelectEntry();
	sSaveTemplateName = 	rDoc.pD_Edit_VorNam->GetText();
	sSaveTemplateInfo = 	rDoc.pD_Edit_VorInf->GetText();
	bSaveAutoDocName = 		rDoc.pD_CBox_AutoFN->IsChecked();
	sSaveAutoPrefix = 		rDoc.pD_Edit_AutoFN->GetText();
	sSaveAutoPath  = 		rDoc.pD_Text_Folder->GetText();
};
/* -----------------------------14.09.00 12:58--------------------------------

 ---------------------------------------------------------------------------*/
Sequence<OUString> SwAgendaWizardCfg::GetPropertyNames()
{
	static const char* aPropNames[] =
	{
        "0Style/PreferredStyle",            // 0
        "1GraphicFile/Name",  // 1
        "1GraphicFile/Filter",// 2
        "4Occasion",         // 3
		"AgendaTopics/Number",			// 4
        "5AutoPrefix",       // 5
        "5AutoDocName",      // 6
        "5AutoPath",         // 7
        "4Notes",            // 8
        "4Date",             // 9
        "4Convened",         // 10
        "4Experts",          // 11
        "4Guests",           // 12
        "5DocInfoSubject",   // 13
        "5DocInfoTitle",     // 14
        "4Presiding",        // 15
        "4BringAlong",       // 16
        "4Postprocessing",   // 17
        "4Location",         // 18
        "4Minutes",          // 19
        "4UseMinutes",       // 20
        "4Participants",     // 21
        "4Title",            // 22
        "1Visible",     // 23
        "4Time",                // 24
        "4Prepare",          // 25
        "5TemplateInfo",     // 26
        "5TemplateName"      // 27
	};
	const int nCount = 28;
	Sequence<OUString> aNames(nCount);
	OUString* pNames = aNames.getArray();
	for(int i = 0; i < nCount; i++)
	{
		pNames[i] = OUString::createFromAscii(aPropNames[i]);
        lcl_ExpandPlaceHolder(pNames[i]);
	}
	return aNames;
}
/* -----------------------------14.09.00 12:58--------------------------------

 ---------------------------------------------------------------------------*/
SwAgendaWizardCfg::SwAgendaWizardCfg() :
	ConfigItem( C2U("Office.Writer/Wizard/Agenda")),
	pAgendaArr(0),
	nStyle(0),
	bOccasion(false),
	nNumber(0),
	bNotes(false),
	nDate(0),
	bConvened(false),
	bExperts(false),
	bGuests(false),
	bPresiding(false),
	bBringAlong(false),
	bPostprocessing(false),
	bMinutes(false),
	bUseMinutes(false),
	bParticipants(false),
	bLogoVisible(false),
	nTime(0),
	bPrepare(false)
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues = GetProperties(aNames);
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
	if(aValues.getLength() == aNames.getLength())
	{
		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
		{
			if(pValues[nProp].hasValue())
			{
				SetValuesRead();
				switch(nProp)
				{
					case 0: pValues[nProp] >>= nStyle; break;
					case 1: pValues[nProp] >>= sLogoGrapicName; break;
					case 2: pValues[nProp] >>= sLogoGrapicFilter; break;
					case 3: bOccasion = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 4: pValues[nProp] >>= nNumber; break;
					case 5: pValues[nProp] >>= sSaveAutoPrefix; break;
					case 6: bSaveAutoDocName = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 7: pValues[nProp] >>= sSaveAutoPath; break;
					case 8: bNotes = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 9: pValues[nProp] >>= nDate; break;
					case 10:bConvened = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 11:bExperts = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 12:bGuests = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 13:pValues[nProp] >>= sSaveDocInfoSubject; break;
					case 14:pValues[nProp] >>= sSaveDocInfoTitle; break;
					case 15:bPresiding = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 16:bBringAlong = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 17:bPostprocessing = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 18:pValues[nProp] >>= sLocation; break;
					case 19:bMinutes = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 20:bUseMinutes = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 21:bParticipants = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 22:pValues[nProp] >>= sTitle; break;
					case 23:bLogoVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 24:pValues[nProp] >>= nTime; break;
					case 25:bPrepare = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 26:pValues[nProp] >>= sSaveTemplateInfo; break;
					case 27:pValues[nProp] >>= sSaveTemplateName; break;
				}
			}
		}
	}
}
/* -----------------------------14.09.00 12:58--------------------------------

 ---------------------------------------------------------------------------*/
SwAgendaWizardCfg::~SwAgendaWizardCfg()
{
	delete pAgendaArr;
}
/* -----------------------------14.09.00 12:58--------------------------------

 ---------------------------------------------------------------------------*/
void	SwAgendaWizardCfg::Commit()
{
	Sequence<OUString> aNames = GetPropertyNames();

	OUString* pNames = aNames.getArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();

	const Type& rType = ::getBooleanCppuType();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
			case 0: pValues[nProp] <<= nStyle; break;
			case 1: pValues[nProp] <<= sLogoGrapicName; break;
			case 2: pValues[nProp] <<= sLogoGrapicFilter; break;
			case 3: pValues[nProp].setValue(&bOccasion, rType); break;
			case 4: pValues[nProp] <<= nNumber; break;
			case 5: pValues[nProp] <<= sSaveAutoPrefix; break;
			case 6: pValues[nProp].setValue(&bSaveAutoDocName, rType); break;
			case 7: pValues[nProp] <<= sSaveAutoPath; break;
			case 8: pValues[nProp].setValue(&bNotes, rType); break;
			case 9: pValues[nProp] <<= nDate; break;
			case 10:pValues[nProp].setValue(&bConvened, rType); break;
			case 11:pValues[nProp].setValue(&bExperts, rType); break;
			case 12:pValues[nProp].setValue(&bGuests, rType); break;
			case 13:pValues[nProp] <<= sSaveDocInfoSubject; break;
			case 14:pValues[nProp] <<= sSaveDocInfoTitle; break;
			case 15:pValues[nProp].setValue(&bPresiding, rType); break;
			case 16:pValues[nProp].setValue(&bBringAlong, rType); break;
			case 17:pValues[nProp].setValue(&bPostprocessing, rType); break;
			case 18:pValues[nProp] <<= sLocation; break;
			case 19:pValues[nProp].setValue(&bMinutes, rType); break;
			case 20:pValues[nProp].setValue(&bUseMinutes, rType); break;
			case 21:pValues[nProp].setValue(&bParticipants, rType); break;
			case 22:pValues[nProp] <<= sTitle; break;
			case 23:pValues[nProp].setValue(&bLogoVisible, rType); break;
			case 24:pValues[nProp] <<= nTime;break;
			case 25:pValues[nProp].setValue(&bPrepare, rType); break;
			case 26:pValues[nProp] <<= sSaveTemplateInfo; break;
			case 27:pValues[nProp] <<= sSaveTemplateName; break;
		}
	}
	PutProperties(aNames, aValues);
	if(pAgendaArr)
	{
		OUString sAuthorSuffix(C2U("/Author"));
		OUString sDurationSuffix(C2U("/Duration"));
		OUString sTopicSuffix(C2U("/Topic"));
		Sequence< PropertyValue > aValues(pAgendaArr->GetAnz() * 3);
		PropertyValue* pValues = aValues.getArray();

		sal_Int32 nIndex = 0;
		for(sal_Int32 i = 0; i < pAgendaArr->GetAnz(); i++)
		{
			AgendaRec aRec;
			pAgendaArr->GetRec(i,aRec);

			OUString sPrefix(C2U(cAgendaList));
			sPrefix += C2U("/_");
			sPrefix += OUString::valueOf(i);
			pValues[nIndex].Name	= sPrefix;
			pValues[nIndex].Name	+= sAuthorSuffix;
			pValues[nIndex++].Value <<= OUString(aRec.aName);
			pValues[nIndex].Name    = sPrefix;
			pValues[nIndex].Name    += sDurationSuffix;
			pValues[nIndex++].Value <<= aRec.nZeit;
			pValues[nIndex].Name	= sPrefix;
			pValues[nIndex].Name    += sTopicSuffix;
			pValues[nIndex++].Value <<= OUString(aRec.aThem);
		}
		ReplaceSetProperties( C2U(cAgendaList), aValues);
	}
}
/* -----------------------------15.09.00 16:50--------------------------------

 ---------------------------------------------------------------------------*/
AgendaArray&	SwAgendaWizardCfg::GetAgendaArray()
{
	if(!pAgendaArr)
	{
		pAgendaArr = new AgendaArray;
		Sequence<OUString> aListNames = GetNodeNames(C2U(cAgendaList));
		if(aListNames.getLength())
		{
			const OUString* pListNames = aListNames.getConstArray();
			Sequence< rtl::OUString > aNames(aListNames.getLength() * 3);
			OUString* pNames = aNames.getArray();
			const OUString sSlash('/');
			sal_Int32 nIndex = 0;
			for(sal_Int32 i = 0; i < aListNames.getLength(); i++)
			{
				OUString sPrefix(C2U(cAgendaList));
				sPrefix += sSlash;
				sPrefix += pListNames[i];
				sPrefix += sSlash;
				pNames[nIndex] = sPrefix;
				pNames[nIndex++] += C2U("Author");
				pNames[nIndex] = sPrefix;
				pNames[nIndex++] += C2U("Duration");
				pNames[nIndex] = sPrefix;
				pNames[nIndex++] += C2U("Topic");
			}
			Sequence< Any> aProperties = GetProperties(aNames);
			const Any* pProperties = aProperties.getConstArray();
			if(aProperties.getLength() == aNames.getLength())
			{
				nIndex = 0;
				for(sal_Int32 i = 0; i < aListNames.getLength(); i++)
				{
					OUString sAuthor;
					sal_Int32 nDuration;
					OUString sTopic;
					pProperties[nIndex++] >>= sAuthor;
					pProperties[nIndex++] >>= nDuration;
					pProperties[nIndex++] >>= sTopic;
					pAgendaArr->SetThm(i, sTopic);
					pAgendaArr->SetNam(i, sAuthor);
					pAgendaArr->SetTim(i, nDuration);
				}
			}
		}
	}
	return *pAgendaArr;
}
/******************************************************************************

******************************************************************************/
Sequence<OUString> SwLetterWizardCfg::GetPropertyNames()
{
	static const char* aPropNames[] =
	{
        "0Type",  //                                    0
        "0Style/PreferredStyle",  //            1
        "1Visible",  //                                 2
        "1IsGraphic",  //                               3
        "1Text",  //                                    4
        "1GraphicFile/Name",  //                            5
        "1GraphicFile/Filter",  //                          6
        "1Position/X",  //                          7
        "1Position/Y",  //                          8
        "1Size/Width",  //                          9
        "1Size/Height",  //                         10
        "1Alignment/Type/Position",  //                 11
        "aLeft",  //                 12
        "aRight",  //                13
        "aTop",  //                  14
        "aBottom",  //               15
        "2Show",  //                                  16
        "2Content",  //                               17
        "2Repeat",  //                                18
        "2Position/X",  //                            19
        "2Position/Y",  //                            20
        "2Size/Width",  //                            21
        "2Size/Height",  //                           22
        "2Alignment/Type/Position",  //               23
        "bLeft",  //               24
        "bRight",  //              25
        "bTop",  //                26
        "bBottom",  //             27
        "3Database",  //                           28
        "3Content",  //                            29
        "3Salutation",  //                         30
        "3SalutationField",  //                    31
        "3Position/X",  //                         32
        "3Position/Y",  //                         33
        "3Size/Width",  //                         34
        "3Size/Height",  //                        35
        "3Alignment/Type/Position",  //            36
        "cLeft",  //            37
        "cRight",  //           38
        "cTop",  //             39
        "cBottom",  //          40
        "91/Text/Visible",  //               41
        "91/Text/Content",  //               42
        "92/Text/Visible",  //               43
        "92/Text/Content",  //               44
        "93/Text/Visible",  //               45
        "93/Text/Content",  //               46
        "94/Text/Visible",  //               47
        "94/Text/Content",  //               48
        "4Date/Value/Visible",  //                  49
        "4Date/Value/Content",  //                  50
        "4Subject/Text/Visible",  //                51
        "4Subject/Text/Content",  //                52
        "4Copy",  //                                53
        "4Enclosure",  //                           54
        "4PageNumber/Visible",  //                  55
        "4PageNumber/TextBefore",  //               56
        "4PageNumber/Format",  //                   57
        "4PageNumber/TotalPageCount/Visible",//     58
        "4PageNumber/TotalPageCount/TextBefore",//  59
        "6FromTop",  //                               60
        "6FromText",  //                              61
        "6Sender/Visible",  //                        62
        "6Sender/Size/Width",  //                     63
        "6Sender/Size/Height",  //                    64
        "6Sender/Alignment/Position",  //             65
        "6Logo/Visible",  //                          66
        "6Logo/Size/Width",  //                       67
        "6Logo/Size/Height",  //                      68
        "6Logo/Alignment/Position",  //               69
        "7OnPage1/Enable",  //                        70
        "7OnPage1/Separator",  //                     71
        "7OnPage1/Text",  //                          72
        "7OnPage1/FromBottom",  //                    73
        "7OnPage1/FromText",  //                      74
        "7OnContinuationPages/Enable",  //            75
        "7OnContinuationPages/FromBottom",  //        76
        "7OnContinuationPages/FromText",  //          77
        "5DocInfoTitle",  //                            78
        "5DocInfoSubject",  //                          79
        "5TemplateName",  //                            80
        "5TemplateInfo",  //                            81
        "5AutoDocName",  //                             82
        "5AutoPrefix",  //                              83
        "5AutoPath",  //                                84
        "8Sender",  //                                 85
        "8Logo",  //                                   86
        "8Printer",  //                                87
        "8Tray/Page1",  //                             88
        "8Tray/ContinuationPage",  //                  89
		"PageMargin/Left",//								90
        "PageMargin/Right", //                               91
        "3DataTable",  //                           92
    };
    const int nCount = 93;
	Sequence<OUString> aNames(nCount);
	OUString* pNames = aNames.getArray();
	for(int i = 0; i < nCount; i++)
	{
		pNames[i] = OUString::createFromAscii(aPropNames[i]);
        lcl_ExpandPlaceHolder(pNames[i]);
    }
	return aNames;
}
/* -----------------------------14.09.00 13:23--------------------------------

 ---------------------------------------------------------------------------*/
SwLetterWizardCfg::SwLetterWizardCfg() :
	ConfigItem( C2U("Office.Writer/Wizard/Letter")),
	nPageMarginLeft(0),
	nPageMarginRight(0),
	bTemplateType(0),
	nTemplateStyleTypePreferredStyle(0),
	bLogoVisible(0),
	bLogoIsGraphic(0),
	nLogoPositionXYTypeX(0),
	nLogoPositionXYTypeY(0),
	nLogoSizeTypeWidth(0),
	nLogoSizeTypeHeight(0),
	nLogoAlignmentAlignmentTypePosition(0),
	nLogoAlignmentPositionTypeLeft(0),
	nLogoAlignmentPositionTypeRight(0),
	nLogoAlignmentPositionTypeTop(0),
	nLogoAlignmentPositionTypeBottom(0),
	bSenderShow(0),
	bSenderRepeat(0),
	nSenderPositionXYTypeX(0),
	nSenderPositionXYTypeY(0),
	nSenderSizeTypeWidth(0),
	nSenderSizeTypeHeight(0),
	nSenderAlignmentTypePosition(0),
	nSenderPositionTypeLeft(0),
	nSenderPositionTypeRight(0),
	nSenderPositionTypeTop(0),
	nSenderPositionTypeBottom(0),
	nRecipientPositionXYTypeX(0),
	nRecipientPositionXYTypeY(0),
	nRecipientSizeTypeWidth(0),
	nRecipientSizeTypeHeight(0),
	nRecipientAlignmentAlignmentTypePosition(0),
	nRecipientAlignmentPositionTypeLeft(0),
	nRecipientAlignmentPositionTypeRight(0),
	nRecipientAlignmentPositionTypeTop(0),
	nRecipientAlignmentPositionTypeBottom(0),
	bElementsElement1TextElementTypeVisible(0),
	bElementsElement2TextElementTypeVisible(0),
	bElementsElement3TextElementTypeVisible(0),
	bElementsElement4TextElementTypeVisible(0),
	bElementsDateIntElementTypeVisible(0),
	nElementsDateIntElementTypeContent(0),
	bElementsSubjectTextElementTypeVisible(0),
	bElementsCopy(0),
	bElementsEnclosure(0),
	bElementsPageNumberVisible(0),
	nElementsPageNumberFormat(0),
	bElementsPageNumberTotalPageCountVisible(0),
	nHeaderFromTop(0),
	nHeaderFromText(0),
	bHeaderSenderVisible(0),
	nHeaderSenderSizeTypeWidth(0),
	nHeaderSenderSizeTypeHeight(0),
	nHeaderSenderAlignmentTypePosition(0),
	bHeaderLogoVisible(0),
	nHeaderLogoSizeTypeWidth(0),
	nHeaderLogoSizeTypeHeight(0),
	nHeaderLogoAlignmentTypePosition(0),
	bFooterOnPage1Enable(0),
	bFooterOnPage1Separator(0),
	nFooterOnPage1FromBottom(0),
	nFooterOnPage1FromText(0),
	bFooterOnContinuationPagesEnable(0),
	nFooterOnContinuationPagesFromBottom(0),
	nFooterOnContinuationPagesFromText(0),
	nPrintSender(0),
	nPrintLogo(0)
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues = GetProperties(aNames);
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
	if(aValues.getLength() == aNames.getLength())
	{
		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
		{
			if(pValues[nProp].hasValue())
			{
				SetValuesRead();
				switch(nProp)
				{
					case 0:	 bTemplateType = *(sal_Bool*)pValues[nProp].getValue();			break;
					case 1:  pValues[nProp] >>= nTemplateStyleTypePreferredStyle;            	break;
					case 2:  bLogoVisible = *(sal_Bool*)pValues[nProp].getValue();          	break;
					case 3:  bLogoIsGraphic = *(sal_Bool*)pValues[nProp].getValue();        	break;
					case 4:  pValues[nProp] >>= sLogoText;                                      break;
					case 5:  pValues[nProp] >>= sLogoFileTypeName;                              break;
					case 6:  pValues[nProp] >>= sLogoFileTypeFilter;                            break;
					case 7:  pValues[nProp] >>= nLogoPositionXYTypeX;                           break;
					case 8:  pValues[nProp] >>= nLogoPositionXYTypeY;                           break;
					case 9:  pValues[nProp] >>= nLogoSizeTypeWidth;                             break;
					case 10: pValues[nProp] >>= nLogoSizeTypeHeight;                            break;
					case 11: pValues[nProp] >>= nLogoAlignmentAlignmentTypePosition;            break;
					case 12: pValues[nProp] >>= nLogoAlignmentPositionTypeLeft;                 break;
					case 13: pValues[nProp] >>= nLogoAlignmentPositionTypeRight;                break;
					case 14: pValues[nProp] >>= nLogoAlignmentPositionTypeTop;                  break;
					case 15: pValues[nProp] >>= nLogoAlignmentPositionTypeBottom;               break;
					case 16: bSenderShow = *(sal_Bool*)pValues[nProp].getValue();                  break;
					case 17: pValues[nProp] >>= sSenderContent;                  break;
					case 18: bSenderRepeat = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 19: pValues[nProp] >>= nSenderPositionXYTypeX;                         break;
					case 20: pValues[nProp] >>= nSenderPositionXYTypeY;                         break;
					case 21: pValues[nProp] >>= nSenderSizeTypeWidth;                           break;
					case 22: pValues[nProp] >>= nSenderSizeTypeHeight;                          break;
					case 23: pValues[nProp] >>= nSenderAlignmentTypePosition;                   break;
					case 24: pValues[nProp] >>= nSenderPositionTypeLeft;                        break;
					case 25: pValues[nProp] >>= nSenderPositionTypeRight;                       break;
					case 26: pValues[nProp] >>= nSenderPositionTypeTop;                         break;
					case 27: pValues[nProp] >>= nSenderPositionTypeBottom;                      break;
					case 28: pValues[nProp] >>= sRecipientDatabase;                             break;
					case 29: pValues[nProp] >>= sRecipientContent;               break;
					case 30: pValues[nProp] >>= sRecipientSalutation;                           break;
					case 31: pValues[nProp] >>= sRecipientSalutationField;                      break;
					case 32: pValues[nProp] >>= nRecipientPositionXYTypeX;                      break;
					case 33: pValues[nProp] >>= nRecipientPositionXYTypeY;                      break;
					case 34: pValues[nProp] >>= nRecipientSizeTypeWidth;                        break;
					case 35: pValues[nProp] >>= nRecipientSizeTypeHeight;                       break;
					case 36: pValues[nProp] >>= nRecipientAlignmentAlignmentTypePosition;       break;
					case 37: pValues[nProp] >>= nRecipientAlignmentPositionTypeLeft;            break;
					case 38: pValues[nProp] >>= nRecipientAlignmentPositionTypeRight;           break;
					case 39: pValues[nProp] >>= nRecipientAlignmentPositionTypeTop;             break;
					case 40: pValues[nProp] >>= nRecipientAlignmentPositionTypeBottom;          break;
					case 41: bElementsElement1TextElementTypeVisible = *(sal_Bool*)pValues[nProp].getValue();break;
					case 42: pValues[nProp] >>= sElementsElement1TextElementTypeContent;        break;
					case 43: bElementsElement2TextElementTypeVisible = *(sal_Bool*)pValues[nProp].getValue();break;
					case 44: pValues[nProp] >>= sElementsElement2TextElementTypeContent;        break;
					case 45: bElementsElement3TextElementTypeVisible = *(sal_Bool*)pValues[nProp].getValue();break;
					case 46: pValues[nProp] >>= sElementsElement3TextElementTypeContent;        break;
					case 47: bElementsElement4TextElementTypeVisible = *(sal_Bool*)pValues[nProp].getValue();break;
					case 48: pValues[nProp] >>= sElementsElement4TextElementTypeContent;        break;
					case 49: bElementsDateIntElementTypeVisible = *(sal_Bool*)pValues[nProp].getValue();     break;
					case 50: pValues[nProp] >>= nElementsDateIntElementTypeContent;             break;
					case 51: bElementsSubjectTextElementTypeVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 52: pValues[nProp] >>= sElementsSubjectTextElementTypeContent;         break;
					case 53: bElementsCopy = *(sal_Bool*)pValues[nProp].getValue();            break;
					case 54: bElementsEnclosure = *(sal_Bool*)pValues[nProp].getValue();       break;
					case 55: bElementsPageNumberVisible = *(sal_Bool*)pValues[nProp].getValue();break;
					case 56: pValues[nProp] >>= sElementsPageNumberTextBefore;                  break;
					case 57: pValues[nProp] >>= nElementsPageNumberFormat;                      break;
					case 58: bElementsPageNumberTotalPageCountVisible = *(sal_Bool*)pValues[nProp].getValue();break;
					case 59: pValues[nProp] >>= sElementsPageNumberTotalPageCountTextBefore;    break;
					case 60: pValues[nProp] >>= nHeaderFromTop;                                 break;
					case 61: pValues[nProp] >>= nHeaderFromText;                                break;
					case 62: bHeaderSenderVisible = *(sal_Bool*)pValues[nProp].getValue();     break;
					case 63: pValues[nProp] >>= nHeaderSenderSizeTypeWidth;                     break;
					case 64: pValues[nProp] >>= nHeaderSenderSizeTypeHeight;                    break;
					case 65: pValues[nProp] >>= nHeaderSenderAlignmentTypePosition;             break;
					case 66: bHeaderLogoVisible = *(sal_Bool*)pValues[nProp].getValue();       break;
					case 67: pValues[nProp] >>= nHeaderLogoSizeTypeWidth;                       break;
					case 68: pValues[nProp] >>= nHeaderLogoSizeTypeHeight;                      break;
					case 69: pValues[nProp] >>= nHeaderLogoAlignmentTypePosition;               break;
					case 70: bFooterOnPage1Enable = *(sal_Bool*)pValues[nProp].getValue();     break;
					case 71: bFooterOnPage1Separator = *(sal_Bool*)pValues[nProp].getValue();  break;
					case 72: pValues[nProp] >>= sFooterOnPage1Text;                             break;
					case 73: pValues[nProp] >>= nFooterOnPage1FromBottom;                       break;
					case 74: pValues[nProp] >>= nFooterOnPage1FromText;                         break;
					case 75: bFooterOnContinuationPagesEnable = *(sal_Bool*)pValues[nProp].getValue();               break;
					case 76: pValues[nProp] >>= nFooterOnContinuationPagesFromBottom;           break;
					case 77: pValues[nProp] >>= nFooterOnContinuationPagesFromText;             break;
					case 78: pValues[nProp] >>= sSaveDocInfoTitle;                              break;
					case 79: pValues[nProp] >>= sSaveDocInfoSubject;                            break;
					case 80: pValues[nProp] >>= sSaveTemplateName;                              break;
					case 81: pValues[nProp] >>= sSaveTemplateInfo;                              break;
					case 82: bSaveAutoDocName = *(sal_Bool*)pValues[nProp].getValue(); 		break;
					case 83: pValues[nProp] >>= sSaveAutoPrefix;                                break;
					case 84: pValues[nProp] >>= sSaveAutoPath;                                  break;
					case 85: pValues[nProp] >>= nPrintSender;                                   break;
					case 86: pValues[nProp] >>= nPrintLogo;                                     break;
					case 87: pValues[nProp] >>= sPrintPrinter;                                  break;
					case 88: pValues[nProp] >>= sPrintTrayPage1;                                break;
					case 89: pValues[nProp] >>= sPrintTrayContinuationPage;                     break;
					case 90: pValues[nProp] >>= nPageMarginLeft;break;
					case 91: pValues[nProp] >>= nPageMarginRight;break;
                    case 92: pValues[nProp] >>= sRecipientDataTable;                             break;

				}
			}
		}
	}
}
/* -----------------------------14.09.00 13:23--------------------------------

 ---------------------------------------------------------------------------*/
SwLetterWizardCfg::~SwLetterWizardCfg()
{
}
/* -----------------------------14.09.00 13:23--------------------------------

 ---------------------------------------------------------------------------*/
void SwLetterWizardCfg::Commit()
{
	Sequence<OUString> aNames = GetPropertyNames();

	OUString* pNames = aNames.getArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();

	const Type& rType = ::getBooleanCppuType();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
			case  0:	 pValues[nProp].setValue(&bTemplateType, rType);break;
			case  1:  pValues[nProp] <<= nTemplateStyleTypePreferredStyle;            	break;
			case  2:  pValues[nProp].setValue(&bLogoVisible, rType);break;
			case  3:  pValues[nProp].setValue(&bLogoIsGraphic, rType);break;
			case  4:  pValues[nProp] <<= sLogoText;                                      break;
			case  5:  pValues[nProp] <<= sLogoFileTypeName;                              break;
			case  6:  pValues[nProp] <<= sLogoFileTypeFilter;                            break;
			case  7:  pValues[nProp] <<= nLogoPositionXYTypeX;                           break;
			case  8:  pValues[nProp] <<= nLogoPositionXYTypeY;                           break;
			case  9:  pValues[nProp] <<= nLogoSizeTypeWidth;                             break;
			case 10: pValues[nProp] <<= nLogoSizeTypeHeight;                            break;
			case 11: pValues[nProp] <<= nLogoAlignmentAlignmentTypePosition;            break;
			case 12: pValues[nProp] <<= nLogoAlignmentPositionTypeLeft;                 break;
			case 13: pValues[nProp] <<= nLogoAlignmentPositionTypeRight;                break;
			case 14: pValues[nProp] <<= nLogoAlignmentPositionTypeTop;                  break;
			case 15: pValues[nProp] <<= nLogoAlignmentPositionTypeBottom;               break;
			case 16: pValues[nProp].setValue(&bSenderShow, rType);break;
			case 17: pValues[nProp] <<= sSenderContent;                  break;
			case 18: pValues[nProp].setValue(&bSenderRepeat, rType);break;
			case 19: pValues[nProp] <<= nSenderPositionXYTypeX;                         break;
			case 20: pValues[nProp] <<= nSenderPositionXYTypeY;                         break;
			case 21: pValues[nProp] <<= nSenderSizeTypeWidth;                           break;
			case 22: pValues[nProp] <<= nSenderSizeTypeHeight;                          break;
			case 23: pValues[nProp] <<= nSenderAlignmentTypePosition;                   break;
			case 24: pValues[nProp] <<= nSenderPositionTypeLeft;                        break;
			case 25: pValues[nProp] <<= nSenderPositionTypeRight;                       break;
			case 26: pValues[nProp] <<= nSenderPositionTypeTop;                         break;
			case 27: pValues[nProp] <<= nSenderPositionTypeBottom;                      break;
			case 28: pValues[nProp] <<= sRecipientDatabase;                             break;
			case 29: pValues[nProp] <<= sRecipientContent;               break;
			case 30: pValues[nProp] <<= sRecipientSalutation;                           break;
			case 31: pValues[nProp] <<= sRecipientSalutationField;                      break;
			case 32: pValues[nProp] <<= nRecipientPositionXYTypeX;                      break;
			case 33: pValues[nProp] <<= nRecipientPositionXYTypeY;                      break;
			case 34: pValues[nProp] <<= nRecipientSizeTypeWidth;                        break;
			case 35: pValues[nProp] <<= nRecipientSizeTypeHeight;                       break;
			case 36: pValues[nProp] <<= nRecipientAlignmentAlignmentTypePosition;       break;
			case 37: pValues[nProp] <<= nRecipientAlignmentPositionTypeLeft;            break;
			case 38: pValues[nProp] <<= nRecipientAlignmentPositionTypeRight;           break;
			case 39: pValues[nProp] <<= nRecipientAlignmentPositionTypeTop;             break;
			case 40: pValues[nProp] <<= nRecipientAlignmentPositionTypeBottom;          break;
			case 41: pValues[nProp].setValue(&bElementsElement1TextElementTypeVisible, rType);break;
			case 42: pValues[nProp] <<= sElementsElement1TextElementTypeContent;        break;
			case 43: pValues[nProp].setValue(&bElementsElement2TextElementTypeVisible, rType);break;
			case 44: pValues[nProp] <<= sElementsElement2TextElementTypeContent;        break;
			case 45: pValues[nProp].setValue(&bElementsElement3TextElementTypeVisible, rType);break;
			case 46: pValues[nProp] <<= sElementsElement3TextElementTypeContent;        break;
			case 47: pValues[nProp].setValue(&bElementsElement4TextElementTypeVisible, rType);break;
			case 48: pValues[nProp] <<= sElementsElement4TextElementTypeContent;        break;
			case 49: pValues[nProp].setValue(&bElementsDateIntElementTypeVisible, rType);break;
			case 50: pValues[nProp] <<= nElementsDateIntElementTypeContent;             break;
			case 51: pValues[nProp].setValue(&bElementsSubjectTextElementTypeVisible, rType);break;
			case 52: pValues[nProp] <<= sElementsSubjectTextElementTypeContent;         break;
			case 53: pValues[nProp].setValue(&bElementsCopy, rType);break;
			case 54: pValues[nProp].setValue(&bElementsEnclosure, rType);break;
			case 55: pValues[nProp].setValue(&bElementsPageNumberVisible, rType);break;
			case 56: pValues[nProp] <<= sElementsPageNumberTextBefore;                  break;
			case 57: pValues[nProp] <<= nElementsPageNumberFormat;                      break;
			case 58: pValues[nProp].setValue(&bElementsPageNumberTotalPageCountVisible, rType);break;
			case 59: pValues[nProp] <<= sElementsPageNumberTotalPageCountTextBefore;    break;
			case 60: pValues[nProp] <<= nHeaderFromTop;                                 break;
			case 61: pValues[nProp] <<= nHeaderFromText;                                break;
			case 62: pValues[nProp].setValue(&bHeaderSenderVisible, rType);break;
			case 63: pValues[nProp] <<= nHeaderSenderSizeTypeWidth;                     break;
			case 64: pValues[nProp] <<= nHeaderSenderSizeTypeHeight;                    break;
			case 65: pValues[nProp] <<= nHeaderSenderAlignmentTypePosition;             break;
			case 66: pValues[nProp].setValue(&bHeaderLogoVisible, rType);break;
			case 67: pValues[nProp] <<= nHeaderLogoSizeTypeWidth;                       break;
			case 68: pValues[nProp] <<= nHeaderLogoSizeTypeHeight;                      break;
			case 69: pValues[nProp] <<= nHeaderLogoAlignmentTypePosition;               break;
			case 70: pValues[nProp].setValue(&bFooterOnPage1Enable, rType);break;
			case 71: pValues[nProp].setValue(&bFooterOnPage1Separator, rType);break;
			case 72: pValues[nProp] <<= sFooterOnPage1Text;                             break;
			case 73: pValues[nProp] <<= nFooterOnPage1FromBottom;                       break;
			case 74: pValues[nProp] <<= nFooterOnPage1FromText;                         break;
			case 75: pValues[nProp].setValue(&bFooterOnContinuationPagesEnable, rType);break;
			case 76: pValues[nProp] <<= nFooterOnContinuationPagesFromBottom;           break;
			case 77: pValues[nProp] <<= nFooterOnContinuationPagesFromText;             break;
			case 78: pValues[nProp] <<= sSaveDocInfoTitle;                              break;
			case 79: pValues[nProp] <<= sSaveDocInfoSubject;                            break;
			case 80: pValues[nProp] <<= sSaveTemplateName;                              break;
			case 81: pValues[nProp] <<= sSaveTemplateInfo;                              break;
			case 82: pValues[nProp].setValue(&bSaveAutoDocName, rType);break;
			case 83: pValues[nProp] <<= sSaveAutoPrefix;                                break;
			case 84: pValues[nProp] <<= sSaveAutoPath;                                  break;
			case 85: pValues[nProp] <<= nPrintSender;                                   break;
			case 86: pValues[nProp] <<= nPrintLogo;                                     break;
			case 87: pValues[nProp] <<= sPrintPrinter;                                  break;
			case 88: pValues[nProp] <<= sPrintTrayPage1;                                break;
			case 89: pValues[nProp] <<= sPrintTrayContinuationPage;                     break;
			case 90: pValues[nProp] <<= nPageMarginLeft;                                break;
			case 91: pValues[nProp] <<= nPageMarginRight;                               break;
            case 92: pValues[nProp] <<= sRecipientDataTable;                             break;
        }
	}
	PutProperties(aNames, aValues);
}
/******************************************************************************

******************************************************************************/
Sequence<OUString> SwFaxWizardCfg::GetPropertyNames()
{
	static const char* aPropNames[] =
	{
        "0Style/PreferredStyle",  //             0
        "0Format/Width",//                       1
        "0Format/Height",//                      2
        "0Title",//                              3
        "1Visible",  //                              4
        "1IsGraphic",  //                            5
        "1Text",  //                                 6
        "1GraphicFile/Name",  //                     7
        "1GraphicFile/Filter",  //                   8
        "1Position/X",  //                           9
        "1Position/Y",  //                          10
        "1Size/Width",  //                          11
        "1Size/Height",  //                         12
        "1Alignment/Type/Position",  //             13
        "aLeft",  //             14
        "aRight",  //            15
        "aTop",  //              16
        "aBottom",  //           17
        "2Content",  //                           18
        "2TelNumber",   //                        19
        "2FaxNumber",   //                        20
        "2Position/X",  //                        21
        "2Position/Y",  //                        22
        "2Size/Width",  //                        23
        "2Size/Height",  //                       24
        "2Alignment/Type/Position",  //           25
        "bLeft",  //           26
        "bRight",  //          27
        "bTop",  //            28
        "bBottom",  //         29
        "3Database",  //                       30
        "3TelNumber", //                       31
        "3FaxNumber", //                       32
        "3Content",  //                        33
        "3Position/X",  //                     34
        "3Position/Y",  //                     35
        "3Size/Width",  //                     36
        "3Size/Height",  //                    37
        "3Alignment/Type/Position",  //        38
        "cLeft",  //        39
        "cRight",  //       40
        "cTop",  //         41
        "cBottom",  //      42
        "91/Text/Visible",  //           43
        "91/Text/Content",  //           44
        "92/Text/Visible",  //           45
        "92/Text/Content",  //           46
        "93/Text/Visible",  //           47
        "93/Text/Content",  //           48
        "94/Text/Visible",  //           49
        "94/Text/Content",  //           50
        "4Date/Value/Visible",  //              51
        "4Date/Value/Content",  //              52
        "4Time/Value/Visible", //               53
        "4Time/Value/Content", //               54
        "4Subject/Value/Visible",  //           55
        "4Subject/Value/Content",  //           56
        "4Copy",  //                            57
        "7Enable",  //                            58
        "7Separator",  //                         59
        "7Text",  //                              60
		"PageMargin/Left",//                            61
		"PageMargin/Right",//                           62
        "5DocInfoTitle",  //                        63
        "5DocInfoSubject",  //                      64
        "5TemplateName",  //                        65
        "5TemplateInfo",  //                        66
        "5AutoDocName",  //                         67
        "5AutoPrefix",  //                          68
        "5AutoPath",  //                            69
        "3DataTable"  //                            70
    };
    const int nCount = 71;
	Sequence<OUString> aNames(nCount);
	OUString* pNames = aNames.getArray();
	for(int i = 0; i < nCount; i++)
	{
		pNames[i] = OUString::createFromAscii(aPropNames[i]);
        lcl_ExpandPlaceHolder(pNames[i]);
    }
	return aNames;
}
/* -----------------------------25.09.00 09:44--------------------------------

 ---------------------------------------------------------------------------*/
SwFaxWizardCfg::SwFaxWizardCfg() :
	ConfigItem( C2U("Office.Writer/Wizard/Fax"))
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues = GetProperties(aNames);
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
	if(aValues.getLength() == aNames.getLength())
	{
		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
		{
			if(pValues[nProp].hasValue())
			{
				SetValuesRead();
				switch(nProp)
				{
					case 0:			pValues[nProp] >>= nTemplateStylePreferredStyle; break;
					case 1:         pValues[nProp] >>= nTemplateFormatWidth; break;
					case 2:         pValues[nProp] >>= nTemplateFormatHeight; break;
					case 3:         pValues[nProp] >>= sTemplateTitle; break;
					case 4:         bLogoVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 5:         bLogoIsGraphic = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 6:         pValues[nProp] >>= sLogoText; break;
					case 7:         pValues[nProp] >>= sLogoGraphicFileName; break;
					case 8:         pValues[nProp] >>= sLogoGraphicFileFilter; break;
					case 9:         pValues[nProp] >>= nLogoPositionX; break;
					case 10:        pValues[nProp] >>= nLogoPositionY; break;
					case 11:        pValues[nProp] >>= nLogoSizeWidth; break;
					case 12:        pValues[nProp] >>= nLogoSizeHeight; break;
					case 13:        pValues[nProp] >>= nLogoAlignmentTypePosition; break;
					case 14:        pValues[nProp] >>= nLogoAlignmentPositionLeft; break;
					case 15:        pValues[nProp] >>= nLogoAlignmentPositionRight; break;
					case 16:        pValues[nProp] >>= nLogoAlignmentPositionTop; break;
					case 17:        pValues[nProp] >>= nLogoAlignmentPositionBottom; break;
					case 18:        pValues[nProp] >>= sSenderContent; break;
					case 19:        pValues[nProp] >>= sSenderTelNumber; break;
					case 20:        pValues[nProp] >>= sSenderFaxNumber; break;
					case 21:        pValues[nProp] >>= nSenderPositionX; break;
					case 22:        pValues[nProp] >>= nSenderPositionY; break;
					case 23:        pValues[nProp] >>= nSenderSizeWidth; break;
					case 24:        pValues[nProp] >>= nSenderSizeHeight; break;
					case 25:        pValues[nProp] >>= nSenderAlignmentTypePosition; break;
					case 26:        pValues[nProp] >>= nSenderAlignmentPositionLeft; break;
					case 27:        pValues[nProp] >>= nSenderAlignmentPositionRight; break;
					case 28:        pValues[nProp] >>= nSenderAlignmentPositionTop; break;
					case 29:        pValues[nProp] >>= nSenderAlignmentPositionBottom; break;
					case 30:        pValues[nProp] >>= sRecipientDatabase; break;
					case 31:        pValues[nProp] >>= sRecipientTelNumber; break;
					case 32:        pValues[nProp] >>= sRecipientFaxNumber; break;
					case 33:        pValues[nProp] >>= sRecipientContent; break;
					case 34:        pValues[nProp] >>= nRecipientPositionX; break;
					case 35:        pValues[nProp] >>= nRecipientPositionY; break;
					case 36:        pValues[nProp] >>= nRecipientSizeWidth; break;
					case 37:        pValues[nProp] >>= nRecipientSizeHeight; break;
					case 38:        pValues[nProp] >>= nRecipientAlignmentTypePosition; break;
					case 39:        pValues[nProp] >>= nRecipientAlignmentPositionLeft; break;
					case 40:        pValues[nProp] >>= nRecipientAlignmentPositionRight; break;
					case 41:        pValues[nProp] >>= nRecipientAlignmentPositionTop; break;
					case 42:        pValues[nProp] >>= nRecipientAlignmentPositionBottom; break;
					case 43:        bElementsElement1TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 44:        pValues[nProp] >>= sElementsElement1TextContent; break;
					case 45:        bElementsElement2TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 46:        pValues[nProp] >>= sElementsElement2TextContent; break;
					case 47:        bElementsElement3TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 48:        pValues[nProp] >>= sElementsElement3TextContent; break;
					case 49:        bElementsElement4TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 50:        pValues[nProp] >>= sElementsElement4TextContent; break;
					case 51:        bElementsDateValueVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 52:        pValues[nProp] >>= nElementsDateValueContent; break;
					case 53:        bElementsTimeValueVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 54:        pValues[nProp] >>= nElementsTimeValueContent; break;
					case 55:        bElementsSubjectValueVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 56:        pValues[nProp] >>= sElementsSubjectValueContent; break;
					case 57:        bElementsCopy = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 58:        bFooterEnable = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 59:        bFooterSeparator = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 60:        pValues[nProp] >>= sFooterText; break;
					case 61:        pValues[nProp] >>= nPageMarginLeft; break;
					case 62:        pValues[nProp] >>= nPageMarginRight; break;
					case 63:        pValues[nProp] >>= sSaveDocInfoTitle; break;
					case 64:        pValues[nProp] >>= sSaveDocInfoSubject; break;
					case 65:        pValues[nProp] >>= sSaveTemplateName; break;
					case 66:        pValues[nProp] >>= sSaveTemplateInfo; break;
					case 67:        bSaveAutoDocName = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 68:        pValues[nProp] >>= sSaveAutoPrefix; break;
					case 69:        pValues[nProp] >>= sSaveAutoPath; break;
                    case 70:        pValues[nProp] >>= sRecipientDataTable; break;
                }
			}
		}
	}
}
/* -----------------------------25.09.00 09:44--------------------------------

 ---------------------------------------------------------------------------*/
SwFaxWizardCfg::~SwFaxWizardCfg()
{
}
/* -----------------------------25.09.00 09:44--------------------------------

 ---------------------------------------------------------------------------*/
void SwFaxWizardCfg::Commit()
{
	Sequence<OUString> aNames = GetPropertyNames();

	OUString* pNames = aNames.getArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();

	const Type& rType = ::getBooleanCppuType();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
			case 0:	pValues[nProp] <<= nTemplateStylePreferredStyle; break;
			case 1: pValues[nProp] <<= nTemplateFormatWidth; break;
			case 2: pValues[nProp] <<= nTemplateFormatHeight; break;
			case 3: pValues[nProp] <<= sTemplateTitle; break;
			case 4: pValues[nProp].setValue(&bLogoVisible, rType); break;
			case 5: pValues[nProp].setValue(&bLogoIsGraphic, rType); break;
			case 6: pValues[nProp] <<= sLogoText; break;
			case 7: pValues[nProp] <<= sLogoGraphicFileName; break;
			case 8: pValues[nProp] <<= sLogoGraphicFileFilter; break;
			case 9: pValues[nProp] <<= nLogoPositionX; break;
			case 10:pValues[nProp] <<= nLogoPositionY; break;
			case 11:pValues[nProp] <<= nLogoSizeWidth; break;
			case 12:pValues[nProp] <<= nLogoSizeHeight; break;
			case 13:pValues[nProp] <<= nLogoAlignmentTypePosition; break;
			case 14:pValues[nProp] <<= nLogoAlignmentPositionLeft; break;
			case 15:pValues[nProp] <<= nLogoAlignmentPositionRight; break;
			case 16:pValues[nProp] <<= nLogoAlignmentPositionTop; break;
			case 17:pValues[nProp] <<= nLogoAlignmentPositionBottom; break;
			case 18:pValues[nProp] <<= sSenderContent; break;
			case 19:pValues[nProp] <<= sSenderTelNumber; break;
			case 20:pValues[nProp] <<= sSenderFaxNumber; break;
			case 21:pValues[nProp] <<= nSenderPositionX; break;
			case 22:pValues[nProp] <<= nSenderPositionY; break;
			case 23:pValues[nProp] <<= nSenderSizeWidth; break;
			case 24:pValues[nProp] <<= nSenderSizeHeight; break;
			case 25:pValues[nProp] <<= nSenderAlignmentTypePosition; break;
			case 26:pValues[nProp] <<= nSenderAlignmentPositionLeft; break;
			case 27:pValues[nProp] <<= nSenderAlignmentPositionRight; break;
			case 28:pValues[nProp] <<= nSenderAlignmentPositionTop; break;
			case 29:pValues[nProp] <<= nSenderAlignmentPositionBottom; break;
			case 30:pValues[nProp] <<= sRecipientDatabase; break;
			case 31:pValues[nProp] <<= sRecipientTelNumber; break;
			case 32:pValues[nProp] <<= sRecipientFaxNumber; break;
			case 33:pValues[nProp] <<= sRecipientContent; break;
			case 34:pValues[nProp] <<= nRecipientPositionX; break;
			case 35:pValues[nProp] <<= nRecipientPositionY; break;
			case 36:pValues[nProp] <<= nRecipientSizeWidth; break;
			case 37:pValues[nProp] <<= nRecipientSizeHeight; break;
			case 38:pValues[nProp] <<= nRecipientAlignmentTypePosition; break;
			case 39:pValues[nProp] <<= nRecipientAlignmentPositionLeft; break;
			case 40:pValues[nProp] <<= nRecipientAlignmentPositionRight; break;
			case 41:pValues[nProp] <<= nRecipientAlignmentPositionTop; break;
			case 42:pValues[nProp] <<= nRecipientAlignmentPositionBottom; break;
			case 43:pValues[nProp].setValue(&bElementsElement1TextVisible, rType); break;
			case 44:pValues[nProp] <<= sElementsElement1TextContent; break;
			case 45:pValues[nProp].setValue(&bElementsElement2TextVisible, rType); break;
			case 46:pValues[nProp] <<= sElementsElement2TextContent; break;
			case 47:pValues[nProp].setValue(&bElementsElement3TextVisible, rType); break;
			case 48:pValues[nProp] <<= sElementsElement3TextContent; break;
			case 49:pValues[nProp].setValue(&bElementsElement4TextVisible, rType); break;
			case 50:pValues[nProp] <<= sElementsElement4TextContent; break;
			case 51:pValues[nProp].setValue(&bElementsDateValueVisible, rType); break;
			case 52:pValues[nProp] <<= nElementsDateValueContent; break;
			case 53:pValues[nProp].setValue(&bElementsTimeValueVisible, rType); break;
			case 54:pValues[nProp] <<= nElementsTimeValueContent; break;
			case 55:pValues[nProp].setValue(&bElementsSubjectValueVisible, rType); break;
			case 56:pValues[nProp] <<= sElementsSubjectValueContent; break;
			case 57:pValues[nProp].setValue(&bElementsCopy, rType); break;
			case 58:pValues[nProp].setValue(&bFooterEnable, rType); break;
			case 59:pValues[nProp].setValue(&bFooterSeparator, rType); break;
			case 60:pValues[nProp] <<= sFooterText; break;
			case 61:pValues[nProp] <<= nPageMarginLeft; break;
			case 62:pValues[nProp] <<= nPageMarginRight; break;
			case 63:pValues[nProp] <<= sSaveDocInfoTitle; break;
			case 64:pValues[nProp] <<= sSaveDocInfoSubject; break;
			case 65:pValues[nProp] <<= sSaveTemplateName; break;
			case 66:pValues[nProp] <<= sSaveTemplateInfo; break;
			case 67:pValues[nProp].setValue(&bSaveAutoDocName, rType); break;
			case 68:pValues[nProp] <<= sSaveAutoPrefix; break;
			case 69:pValues[nProp] <<= sSaveAutoPath; break;
            case 70:pValues[nProp] <<= sRecipientDataTable; break;
        }
	}
	PutProperties(aNames, aValues);
}
/******************************************************************************

******************************************************************************/
Sequence<OUString> SwMemoWizardCfg::GetPropertyNames()
{
	static const char* aPropNames[] =
	{
        "0Style/PreferredStyle",  //     0
        "0Title/Text",            //     1
        "0Title/IsGraphic",       //     2
        "0Title/File/Name",       //     3
        "0Title/File/Filter",     //     4
        "91/Text/Visible",  //    5
        "91/Text/Content",  //    6
        "92/Text/Visible",  //    7
        "92/Text/Content",  //    8
        "93/Text/Visible",  //    9
        "93/Text/Content",  //   10
        "94/Text/Visible",  //   11
        "94/Text/Content",  //   12
        "4Date/Value/Visible",  //      13
        "4Date/Value/Content",  //      14
        "4Subject/Text/Visible",  //    15
        "4Subject/Text/Content",  //    16
        "4To",                    //    17
        "4Copy",                  //    18
        "4From",                  //    19
        "6Date",                    //    20
        "6Title",                   //    21
        "6PageNumber",              //    22
        "6Separator",               //    23
        "7Date",  //                      24
        "7PageNumber",  //                25
        "7Separator",  //                 26
        "7ConfidentialLevel/Visible",//   27
        "7ConfidentialLevel/Content",//   28
        "5DocInfoTitle",  //                29
        "5DocInfoSubject",  //              30
        "5TemplateName",  //                31
        "5TemplateInfo",  //                32
        "5AutoDocName",  //                 33
        "5AutoPrefix",   //                 34
        "5AutoPath" //                      35
	};
    const int nCount = 36;
	Sequence<OUString> aNames(nCount);
	OUString* pNames = aNames.getArray();
	for(int i = 0; i < nCount; i++)
	{
		pNames[i] = OUString::createFromAscii(aPropNames[i]);
        lcl_ExpandPlaceHolder(pNames[i]);
    }
	return aNames;
}
/* -----------------------------25.09.00 09:45--------------------------------

 ---------------------------------------------------------------------------*/
SwMemoWizardCfg::SwMemoWizardCfg() :
	ConfigItem( C2U("Office.Writer/Wizard/Memo"))
{
	Sequence<OUString> aNames = GetPropertyNames();
	Sequence<Any> aValues = GetProperties(aNames);
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
	if(aValues.getLength() == aNames.getLength())
	{
		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
		{
			if(pValues[nProp].hasValue())
			{
				SetValuesRead();
				switch(nProp)
				{
					case 0:		pValues[nProp] >>= nTemplateStylePreferredStyle; break;
					case 1:     pValues[nProp] >>= sTemplateTitleText; break;
					case 2:     bTemplateTitleIsGraphic = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 3:     pValues[nProp] >>= sTemplateTitleFileName; break;
					case 4:     pValues[nProp] >>= sTitleFileFilter; break;
					case 5:     bElementsElement1TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 6:     pValues[nProp] >>= sElementsElement1TextContent; break;
					case 7:     bElementsElement2TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 8:     pValues[nProp] >>= sElementsElement2TextContent; break;
					case 9:     bElementsElement3TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 10:    pValues[nProp] >>= sElementsElement3TextContent; break;
					case 11:    bElementsElement4TextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 12:    pValues[nProp] >>= sElementsElement4TextContent; break;
					case 13:    bElementsDateValueVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 14:    pValues[nProp] >>= nElementsDateValueContent; break;
					case 15:    bElementsSubjectTextVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 16:    pValues[nProp] >>= sElementsSubjectTextContent; break;
					case 17:    bElementsTo = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 18:    bElementsCopy = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 19:    bElementsFrom = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 20:    bHeaderDate = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 21:    bHeaderTitle = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 22:    bHeaderPageNumber = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 23:    bHeaderSeparator = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 24:    bFooterDate = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 25:    bFooterPageNumber = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 26:    bFooterSeparator = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 27:    bFooterConfidentialLevelVisible = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 28:    pValues[nProp] >>= sFooterConfidentialLevelContent; break;
					case 29:    pValues[nProp] >>= sSaveDocInfoTitle; break;
					case 30:    pValues[nProp] >>= sSaveDocInfoSubject; break;
					case 31:    pValues[nProp] >>= sSaveTemplateName; break;
					case 32:    pValues[nProp] >>= sSaveTemplateInfo; break;
					case 33:    bSaveAutoDocName = *(sal_Bool*)pValues[nProp].getValue(); break;
					case 34:    pValues[nProp] >>= sSaveAutoPrefix; break;
					case 35:    pValues[nProp] >>= sSaveAutoPath; break;
				}
			}
		}
	}
}
/* -----------------------------25.09.00 09:45--------------------------------

 ---------------------------------------------------------------------------*/
SwMemoWizardCfg::~SwMemoWizardCfg()
{
}
/* -----------------------------25.09.00 09:45--------------------------------

 ---------------------------------------------------------------------------*/
void SwMemoWizardCfg::Commit()
{
	Sequence<OUString> aNames = GetPropertyNames();

	OUString* pNames = aNames.getArray();
	Sequence<Any> aValues(aNames.getLength());
	Any* pValues = aValues.getArray();

	const Type& rType = ::getBooleanCppuType();
	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
	{
		switch(nProp)
		{
			case 0:		pValues[nProp] <<= nTemplateStylePreferredStyle; break;
			case 1:     pValues[nProp] <<= sTemplateTitleText; break;
			case 2:     pValues[nProp].setValue(&bTemplateTitleIsGraphic, rType); break;
			case 3:     pValues[nProp] <<= sTemplateTitleFileName; break;
			case 4:     pValues[nProp] <<= sTitleFileFilter; break;
			case 5:     pValues[nProp].setValue(&bElementsElement1TextVisible, rType); break;
			case 6:     pValues[nProp] <<= sElementsElement1TextContent; break;
			case 7:     pValues[nProp].setValue(&bElementsElement2TextVisible, rType); break;
			case 8:     pValues[nProp] <<= sElementsElement2TextContent; break;
			case 9:     pValues[nProp].setValue(&bElementsElement3TextVisible, rType); break;
			case 10:    pValues[nProp] <<= sElementsElement3TextContent; break;
			case 11:    pValues[nProp].setValue(&bElementsElement4TextVisible, rType); break;
			case 12:    pValues[nProp] <<= sElementsElement4TextContent; break;
			case 13:    pValues[nProp].setValue(&bElementsDateValueVisible, rType); break;
			case 14:    pValues[nProp] <<= nElementsDateValueContent; break;
			case 15:    pValues[nProp].setValue(&bElementsSubjectTextVisible, rType); break;
			case 16:    pValues[nProp] <<= sElementsSubjectTextContent; break;
			case 17:    pValues[nProp].setValue(&bElementsTo, rType); break;
			case 18:    pValues[nProp].setValue(&bElementsCopy, rType); break;
			case 19:    pValues[nProp].setValue(&bElementsFrom, rType); break;
			case 20:    pValues[nProp].setValue(&bHeaderDate, rType); break;
			case 21:    pValues[nProp].setValue(&bHeaderTitle, rType); break;
			case 22:    pValues[nProp].setValue(&bHeaderPageNumber, rType); break;
			case 23:    pValues[nProp].setValue(&bHeaderSeparator, rType); break;
			case 24:    pValues[nProp].setValue(&bFooterDate, rType); break;
			case 25:    pValues[nProp].setValue(&bFooterPageNumber, rType); break;
			case 26:    pValues[nProp].setValue(&bFooterSeparator, rType); break;
			case 27:    pValues[nProp].setValue(&bFooterConfidentialLevelVisible, rType); break;
			case 28:    pValues[nProp] <<= sFooterConfidentialLevelContent; break;
			case 29:    pValues[nProp] <<= sSaveDocInfoTitle; break;
			case 30:    pValues[nProp] <<= sSaveDocInfoSubject; break;
			case 31:    pValues[nProp] <<= sSaveTemplateName; break;
			case 32:    pValues[nProp] <<= sSaveTemplateInfo; break;
			case 33:    pValues[nProp].setValue(&bSaveAutoDocName, rType); break;
			case 34:    pValues[nProp] <<= sSaveAutoPrefix; break;
			case 35:    pValues[nProp] <<= sSaveAutoPath; break;
		}
	}
	PutProperties(aNames, aValues);
}


