/*************************************************************************
 *
 *  $RCSfile: wizfxgo.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: os $ $Date: 2001/09/28 07:21:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#ifndef _PRTOPT_HXX
#include <prtopt.hxx>
#endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>     // Writershell
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _TABCOL_HXX
#include <tabcol.hxx>  	// SwTabCols
#endif
#ifndef _WIZARD_HRC
#include <wizard.hrc>
#endif
#ifndef _WIZPAGE_HXX
#include <wizpage.hxx>
#endif
#ifndef _WIZGO_HXX
#include <wizgo.hxx>
#endif
#ifndef _WIZDOKU_HXX
#include <wizdoku.hxx>
#endif
#ifndef _WIZFX_HXX
#include <wizfx.hxx>
#endif
#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef WINDOCHFILM
#define WIZNOFILM
#endif
#ifndef WINDOCHUNDO
#define WIZNOUNDO
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL FaxDialog::MakeDoc()
{
	BOOL bRet=FALSE;
	String aVorNam;
	if( a1_RBtn_Stil2.IsChecked() )
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizfax2" ));
	else if (a1_RBtn_Stil3.IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizfax3" ));
	else
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizfax1" ));

	if (NewVorlage(aVorNam)) {
#ifdef WIZNOFILM
		pShell->StartAction();
#endif
#ifdef WIZNOUNDO
		pShell->DoUndo(FALSE); // hat leider noch Seiteneffekte
#endif
		AssignDBas(aEmpf.pE_List_DBase->GetSelectEntry(), aEmpf.pE_List_DBTable->GetSelectEntry());
		SetMarg(aPage1,NULL,&aPage1.aFusz);
		SetFaxPrinter();
		InsLogo();
		InsTitl();
		InsDatm();
		InsEmpf();
		InsAbsn();
		InsElem();
		InsBetr();
		SetFusz(aPage1.aFusz,"Fus1", 0 );
		SetFusz(aPage1.aFusz,"FusF", 0 );
		DelText();
		MarkText();
		CreateMacro();
		SaveMacro();
		FillDocInfo( *pDoku );
#ifdef WIZNOFILM
		pShell->EndAction();
#endif
		if (SaveVorNewDoc( *pDoku ) )
			bRet=TRUE;
	}
	return bRet;
}

void FaxDialog::SetFaxPrinter()
{
	JobSetup	aJob;
	SwPrintOptions* pOpt = SW_MOD()->GetPrtOptions(FALSE);
	Printer* pNewPrt = new Printer(pOpt->GetFaxName());
	SetPrinter(pNewPrt);
	if (pNewPrt)
		delete pNewPrt;
}

void FaxDialog::CreateMacro()
{
	ULONG nDateFmt = NODATE;
	ULONG nTimeFmt = NOTIME;

	if (a5_CBox_Datum.IsChecked())
		nDateFmt=a5_List_Datum.GetFormat();

	if (a5_CBox_Uhrzt.IsChecked())
		nTimeFmt=a5_List_Uhrzt.GetFormat();

	SetCreateMacro( *pDoku, nDateFmt, nTimeFmt );
}

void FaxDialog::SaveMacro()
{
	 BOOL bDown1=GetDocInfoGoDown(pDoku->pD_List_InfTit->GetSelectEntryPos());
	 BOOL bDown2=GetDocInfoGoDown(pDoku->pD_List_InfTem->GetSelectEntryPos());
	 SetSaveMacro(*pDoku,bDown1,bDown2);
}

void FaxDialog::InsAbsn()
{
	if (GotoBookmark("Absn")) {
		if (aPage1.aAbsn.IsVisible()) {
			InsString(aPage1.aAbsn.GetStr());
			if (a3_Edit_Telfon.GetText().Len()!=0) {
				pShell->SplitNode();
				InsString(SW_RESSTR(STR_GoF_AbsTelefon));
				InsString(a3_Edit_Telfon.GetText());
			}
			if (a3_Edit_Telfax.GetText().Len()!=0) {
				pShell->SplitNode();
				InsString(SW_RESSTR(STR_GoF_AbsTelefax));
				InsString(a3_Edit_Telfax.GetText());
			}
			MovFrame(aPage1.aAbsn);
		} else { // ansonsten wird er geloescht
			DelFrame();
		}
	}
}

void FaxDialog::InsLogo()
{
	if (GotoBookmark("Logo")) {
		if (aPage1.aLogo.IsVisible()) {
			MovFrame(aPage1.aLogo);
			InsLogoObj(aPage1.aLogo);
		} else {
			DelFrame();
		}
	}
}

void FaxDialog::InsTitl()
{
	if (GotoBookmark("Titl")) {
		if (aPage1.aTitl.IsVisible()) {
			MovFrame(aPage1.aTitl);
			InsLogoObj(aPage1.aTitl);
		} else {
			DelFrame();
		}
	}
}

void FaxDialog::InsDatm()
{
	if (GotoBookmark("Uhrz")) {
		if (aPage1.aDatm.IsVisible()) {
			if (a5_CBox_Uhrzt.IsChecked())
			{
				if( !pShell->IsEndPara() )
					pShell->MovePara( fnParaCurr, fnParaEnd );
				InsertBookmark("Uhrzeit" );
			} else {
				pShell->DelFullPara();
			}
			if (GotoBookmark("Datm")) {
				if (a5_CBox_Datum.IsChecked()) {
					if( !pShell->IsEndPara() )
						pShell->MovePara( fnParaCurr, fnParaEnd );
					InsertBookmark("Datum");
				} else {
					pShell->DelFullPara();
				}
			MovFrame(aPage1.aDatm); // MoveFrame veraendert die CursorPos!!!
			}
		} else {
			DelFrame();
		}
	}
}

void FaxDialog::InsEmpf()
{
	if (GotoBookmark("Empf"))
	{
		if (aPage1.aEmpf.IsVisible())
		{
			InsDBasFldStr(aPage1.aEmpf.GetStr());
			if (aEmpf.pE_List_Telfon->GetSelectEntryPos()!=0)
			{
				pShell->SplitNode();
				InsString(SW_RESSTR(STR_GoF_EmpTelefon));

				String aFld(aEmpf.pE_List_DBase->GetSelectEntry());
				aFld += DB_DELIM;
				aFld += aEmpf.pE_List_DBTable->GetSelectEntry();
				aFld += DB_DELIM;
                aFld += aEmpf.pE_List_DBTable->GetEntryData(aEmpf.pE_List_DBTable->GetSelectEntryPos()) == 0 ? '0' : '1';
				aFld += DB_DELIM;
				aFld += aEmpf.pE_List_Telfon->GetSelectEntry();
				InsDBasFld(aFld);
			}
			if (aEmpf.pE_List_Telfax->GetSelectEntryPos()!=0)
			{
				pShell->SplitNode();
				InsString(SW_RESSTR(STR_GoF_EmpTelefax));

				String aFld(aEmpf.pE_List_DBase->GetSelectEntry());
				aFld += DB_DELIM;
				aFld += aEmpf.pE_List_DBTable->GetSelectEntry();
				aFld += DB_DELIM;
                aFld += aEmpf.pE_List_DBTable->GetEntryData(aEmpf.pE_List_DBTable->GetSelectEntryPos()) == 0 ? '0' : '1';
                aFld += DB_DELIM;
				aFld += aEmpf.pE_List_Telfax->GetSelectEntry();
				InsDBasFld(aFld);
			}
			MovFrame(aPage1.aEmpf);
		}
		else
		{
			DelFrame();
		}
	}
}

void FaxDialog::InsBetr()
{
	if (GotoBookmark("Kopi")) {
		if (aPage1.aBetr.IsVisible()) {
			if (a5_CBox_KopiAn.IsChecked()) {
			} else {
				pShell->DelFullPara();
				/*RightMargin();
				pShell->LeftMarginSel();
				pShell->LeftSel();
				pShell->DelRight();*/
			}
			if (GotoBookmark("Betr"))
			{
				if( !pShell->IsSttPara() )
					pShell->MovePara( fnParaCurr, fnParaStart );

				if (a5_CBox_Betref.IsChecked()) {
					InsString(a5_Edit_Betref.GetText());
					if( !pShell->IsSttPara() )
						pShell->MovePara( fnParaCurr, fnParaStart );

					InsDocInfBookmark(4);
				} else {
					pShell->DelFullPara();
					/*pShell->RightMarginSel();
					pShell->RightSel();
					pShell->DelRight();*/
				}
			MovFrame(aPage1.aBetr);
			}
		} else {
			DelFrame();
		}
	}
}

void FaxDialog::InsElem()
{
	const sal_Char* pBookmkNm = "Elem";
	if( GotoBookmark( pBookmkNm ) )
	{
		WizardElem& rPg1Elem = aPage1.aElem;
		if( rPg1Elem.IsAnyVisible() )
		{
			USHORT i;
			USHORT nElemAnz = 0;
			for (i = 0; i < 5; ++i )
				if( rPg1Elem.IsVisible( i ) )
					++nElemAnz;

			if( 5 > nElemAnz )
			{
				InsertBookmark( pBookmkNm );
				pShell->GoNextCell();
				pShell->SetMark();

				for( i = nElemAnz+1; i < 5; ++i )
					pShell->GoNextCell();

				pShell->DeleteCol(); 	// Ueberfluessige Spalten loeschen
				pShell->ClearMark();

				// und wieder in die Tabelle zurueck
				if( USHRT_MAX != ( i = pShell->FindBookmark(
									String::CreateFromAscii( pBookmkNm )) ) )
				{
					pShell->GotoBookmark( i );
					pShell->DelBookmark( i );
				}
				else
					ASSERT( !this, "Wer hat meine Bookmark zerstoert" )
			}

			MovFrame( rPg1Elem.GetPosX(), rPg1Elem.GetPosY(),
						rPg1Elem.GetWdt(), rPg1Elem.GetHgt(), TRUE );

			SwTabCols aCols;
			pShell->GetTabCols( aCols );

			USHORT nElemNum=0; // Nummer der Tabellenspalte (0..ElemAnz-1)
			for( i = 0; i < 5; ++i )
			{
				// beim Fax eigentlich nur 4 Elemente
				if( rPg1Elem.IsVisible( i ) )
				{
					// Breite der letzten Spalte nicht setzen
					if( nElemNum < nElemAnz - 1 )
						SetTabColWidth( aCols, nElemNum,
							Twip( rPg1Elem.aBezeich[i].GetWdt() ));

					String aStr;
					switch( i )
					{
						case 0: aStr=a5_Edit_Elem1.GetText(); break;
						case 1: aStr=a5_Edit_Elem2.GetText(); break;
						case 2: aStr=a5_Edit_Elem3.GetText(); break;
						case 3: aStr=a5_Edit_Elem4.GetText(); break;
					}
					InsString(aStr);

					if( !pShell->IsSttPara() )
						pShell->MovePara( fnParaCurr, fnParaStart );

					InsDocInfBookmark( i );
					if( nElemNum<nElemAnz-1)	// kommt noch mehr ?
						pShell->GoNextCell();

					++nElemNum;
				}
			}
		}
		else
			DelFrame();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

void FaxDialog::InsDocInfBookmark(USHORT nElemNum)
{
	if (GetDocInfStrOk(nElemNum)) {   // als DocInf freigegeben ?
		USHORT nIdx=nElemNum;      // nIdx geht von 0..pDoku->GetTxFieldAnz()-1
		USHORT i;
		for (i=0; i<nElemNum; i++) // fuer jeden nicht freigeg. davor, Idx um 1 dec.
			if (!GetDocInfStrOk(i)) nIdx--;
		nIdx+=pDoku->GetTxFieldOfs();
		if (nIdx==pDoku->pD_List_InfTit->GetSelectEntryPos())
			InsertBookmark("Titel");
		if (nIdx==pDoku->pD_List_InfTem->GetSelectEntryPos())
			InsertBookmark("Thema");
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////




