/*************************************************************************
 *
 *  $RCSfile: wizgo2.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: os $ $Date: 2002/01/02 11:49:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#if STLPORT_VERSION>=321
#include <cstdarg>
#endif

#ifndef _SFXREQUEST_HXX
#include <sfx2/request.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFX_DOCFILT_HACK_HXX //autogen
#include <sfx2/docfilt.hxx>
#endif
#ifndef _SFXDOCTEMPL_HXX //autogen
#include <sfx2/doctempl.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXDOCINF_HXX //autogen
#include <sfx2/docinf.hxx>
#endif


#ifndef _WRTSH_HXX
#include <wrtsh.hxx>     // Writershell
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _WIZGO_HXX
#include <wizgo.hxx>
#endif
#ifndef _WIZDOKU_HXX
#include <wizdoku.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _DBMGR_HXX
#include <dbmgr.hxx>     // SwDBMgr, der Datanbankmanager (nur fuer's delete!)
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

WizardGo::WizardGo()
{
	pShell = 0;
	pDBas = 0;
}

WizardGo::~WizardGo()
{
	if( pDBas )
		delete pDBas;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WizardGo::NewVorlage( const String& rVorlage )
{
	SfxApplication *pSApp = SFX_APP();
	BOOL bRet = FALSE;

	String sTemplate( String::CreateFromAscii("wizard") );
	sTemplate += INET_PATH_TOKEN;
	sTemplate += rVorlage;
    String sOldTemplate(sTemplate);
#ifndef MAC_WITHOUT_EXT
    sTemplate.AppendAscii(".stw");
    sOldTemplate.AppendAscii(".vor");
#endif

	const SfxFilter* pFilter = (SfxFilter*)-1;
	SvtPathOptions aOpt;
    if( (aOpt.SearchFile( sTemplate, SvtPathOptions::PATH_TEMPLATE )
#ifndef MAC_WITHOUT_EXT
            || (sTemplate = sOldTemplate, aOpt.SearchFile( sTemplate, SvtPathOptions::PATH_TEMPLATE ))
#endif
            )
        &&  0 != (pFilter = SwIoSystem::GetFileFilter(sTemplate, aEmptyStr)) )
	{
        sTemplate = URIHelper::SmartRelToAbs( sTemplate );

        SfxRequest aReq( SID_OPENDOC, SFX_CALLMODE_SYNCHRON, pSApp->GetPool() );
        aReq.AppendItem( SfxStringItem( SID_TARGETNAME, String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM( "_blank" ))));
        aReq.AppendItem( SfxStringItem( SID_FILE_NAME, sTemplate ));
		aReq.AppendItem( SfxStringItem( SID_FILTER_NAME, pFilter->GetName() ));
		aReq.AppendItem( SfxBoolItem( SID_HIDDEN, TRUE ) );
		aReq.AppendItem( SfxStringItem( SID_REFERER, String::CreateFromAscii(URL_PREFIX_PRIV_SOFFICE) ));

		pSApp->ExecuteSlot( aReq, pSApp->SfxApplication::GetInterface());
		SfxViewFrameItem* pVItem = (SfxViewFrameItem*)aReq.GetReturnValue();
		if( pVItem )
		{
			// DocShell besorgen
			SwDocShell* pDocSh = (SwDocShell*)pVItem->GetFrame()
													->GetObjectShell();
			pShell = pDocSh->GetWrtShell();
			pShell->CalcLayout();
			return TRUE;
		}
	}

#ifndef PRODUCT
	const sal_Char* pStr = 0;
	if( (SfxFilter*)-1 == pFilter )
		pStr = "can't find the template";
	else if( 0 == pFilter )
		pStr = "can't find the filter for the template";
	else
		pStr = "can't load the template";

	if( pStr )
	{
		ByteString sOut( pStr ); sOut += ": ";
		sOut += ByteString( sTemplate, RTL_TEXTENCODING_ASCII_US );
		DbgError( sOut.GetBuffer(), __FILE__, __LINE__ );
	}

#endif
	return FALSE;
}

BOOL WizardGo::SaveVorNewDoc( const WizardDokuDlg& rDoku )
{
	BOOL bRet = FALSE;
	String aVorFN( rDoku.pD_Edit_VorNam->GetText() );
	if( aVorFN.Len() )
	{
// evt. die Vorgabe holen, aber woher??
USHORT nRegion = 0; 		// ist das der Standard - Bereich ??

		{
			SfxRequest aReq( SID_DOCTEMPLATE, 0, SFX_APP()->GetPool() );
			aReq.AppendItem( SfxStringItem( SID_TEMPLATE_NAME, aVorFN ) );
			aReq.AppendItem( SfxUInt16Item( SID_TEMPLATE_REGION, nRegion ));
			SfxObjectShell *pDSh = pShell->GetView().GetDocShell();
			pDSh->ExecuteSlot( aReq, pDSh->SfxObjectShell::GetInterface() );
			bRet = aReq.IsDone();
		}

		pShell->ResetModified();
		// nach eier SFX Aenderung muss eine Hidden ObjShell ueber den
		// OwnerLock geschlossen werden.
		pShell->GetView().GetDocShell()->OwnerLock( FALSE );

		if( bRet )
		{
			// fuers besorgen vom RegionNamen !!
			SfxDocumentTemplates aFac;
			aFac.Construct();
			SfxApplication *pSApp = SFX_APP();

			SfxRequest aReq( SID_NEWDOC, 0, pSApp->GetPool() );
			aReq.AppendItem( SfxStringItem( SID_TEMPLATE_NAME, aVorFN ) );
			aReq.AppendItem( SfxStringItem( SID_TEMPLATE_REGIONNAME,
										aFac.GetRegionName( nRegion ) ) );
			pSApp->ExecuteSlot( aReq, pSApp->SfxApplication::GetInterface() );
			bRet = aReq.IsDone();
		}
	}

	return bRet;
}

void WizardGo::FillDocInfo(const WizardDokuDlg& rDoku)
{
	String aStr( rDoku.pD_Edit_VorInf->GetText() );

	// DocInfo holen
	SfxDocumentInfo aInfo( *pShell->GetInfo() );
	aInfo.SetComment( aStr );

	// Ueber Dispatcher updaten
	pShell->GetView().GetDocShell()->SetDocumentInfo( aInfo );
}

void WizardGo::SetPrinter( Printer *pPrt )
{
	if (pPrt)
	{
		SwDocShell *pDocSh = pShell->GetView().GetDocShell();
		pDocSh->GetDoc()->SetJobsetup(pPrt->GetJobSetup());
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

