/*************************************************************************
 *
 *  $RCSfile: wizgo3.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: os $ $Date: 2001/11/21 11:26:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ui_pch.hxx"
#endif

#pragma hdrstop


#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _IPOBJ_HXX //autogen
#include <so3/ipobj.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _BASMGR_HXX //autogen
#include <basic/basmgr.hxx>
#endif
#ifndef _SFXMACITEM_HXX
#include <svtools/macitem.hxx>
#endif
#ifndef _SFX_EVENTCONF_HXX //autogen
#include <sfx2/evntconf.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif

#include "wrtsh.hxx"
#include "view.hxx"
#include "docsh.hxx"
#include "flddat.hxx"
#include "wizgo.hxx"
#include "wizdoku.hxx"
#ifndef _COM_SUN_STAR_SCRIPT_XLIBRARYCONTAINER_HPP_
#include <com/sun/star/script/XLibraryContainer.hpp>
#endif




#ifdef DEBUG
#define WRITESOURCE
#endif

using namespace ::com::sun::star::script;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::container;
using namespace ::rtl;

//#define WRITESOURCE


/////////////////////////////////////////////////
//  Basicanbindung

static void IndentStr(String& rStr, USHORT n)
{
	String aIns;
	aIns.Fill(n);
	USHORT nLen = rStr.Len();
	USHORT i = nLen;
	char c1 = '\n', c = 0;
	while( i > 0 )
	{
		c = rStr.GetChar( --i );
		if( c == '\n' && c1 != '\n' )
			rStr.Insert( aIns, i+1 );
        c1 = c;
	}
	c = rStr.GetChar( 0 );   // und nun noch die erste Zeile
	if( c != 0 && c != '\n' )
		rStr.Insert( aIns, 0 );
}

static void ValidateMacroName( String& rName )
{
	rName.ToUpperAscii();
	sal_Unicode* pStr = rName.GetBufferAccess();

	if( *pStr >= '0' && *pStr <= '9' )
		*pStr = '_';

	for( USHORT i = rName.Len(); i; --i, ++pStr )
		if( !(( *pStr >= 'A' && *pStr <= 'Z' ) ||
			  ( *pStr >= '0' && *pStr <= '9' ) || *pStr == '_' ) )
			*pStr = '_';
}


// Macros einfuegen
BOOL WizardGo::AssignMacro( String& rMacStr, String& rMacNam,
							const String& rLibNam, const String& rModulNam,
							USHORT nEvent, String *pCode )
{
	if( !rMacStr.Len() )
		return FALSE;

	String aLibNam('~');
	aLibNam += rLibNam;

	rMacNam.ToUpperAscii();

	String aStr;
	aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "FUNCTION " ));
	aStr += rMacNam;
	aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("()\n"));
	aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("    REM \n"));
	aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("    REM (c) Sun Microsystems, Inc.\n"));
	aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("    xDoc = ThisComponent\n"));
	aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM("    xBkms = xDoc.getBookmarks\n"));

	//aStr+="    Fehler%=0\n";
	aStr += rMacStr;
	aStr.AppendAscii("END FUNCTION");
	//aStr.SearchAndReplace( "GetErrorCode()", "Fehler%" );
	rMacStr = aStr;

#ifdef WRITESOURCE
	{
		String aSrcFN( rMacNam );
		aSrcFN.AppendAscii(".bas");
		SvFileStream aOut( aSrcFN, STREAM_STD_WRITE );
		aOut.WriteByteString(rMacStr, aOut.GetStreamCharSet());
	}
#endif

	BOOL bRet = FALSE;

	SFX_APP()->EnterBasicCall();

	SwDocShell* pDocSh = pShell->GetView().GetDocShell();

    Reference< XLibraryContainer > xLibCont = pDocSh->GetBasicContainer();
    Reference< XNameContainer > xLib;
    if(!xLibCont->hasByName(aLibNam))
        xLib = xLibCont->createLibrary(aLibNam);
    else
    {
        Any aLib = xLibCont->getByName(aLibNam);
        aLib >>= xLib;
    }
    if(xLib.is())
    {
        OUString sMac(rMacStr);
        Any aMac(&sMac, ::getCppuType(&sMac));
        xLib->insertByName(rModulNam, aMac);

        // so, dann mal an die DocShell fuer den Event binden
        String aCode( aLibNam );
        (((aCode += '.') += rModulNam) += '.') += rMacNam;
        SfxEventConfiguration* pECfg = SFX_APP()->GetEventConfig();
        pECfg->ConfigureEvent( nEvent,
                                SvxMacro( aCode, aEmptyStr, STARBASIC ),
                                pDocSh );
        if ( pCode )
            *pCode = aCode;
	}
	SFX_APP()->LeaveBasicCall();

    return xLib.is();
}

BOOL WizardGo::SetCreateMacro( WizardDokuDlg& rDoku,
								ULONG nDateFmt, ULONG nTimeFmt,
								USHORT nDateAnz, BOOL bDelUmbr )
{
	BOOL bRet = TRUE;
	String sPath( rDoku.pD_Text_Folder->GetText() );
	String sDelim(INET_PATH_TOKEN);
	if (sPath.Len() >= sDelim.Len() &&
		sPath.Copy(sPath.Len()-sDelim.Len()).CompareTo(sDelim) != COMPARE_EQUAL)
		sPath += sDelim;
	String aPrefix( rDoku.pD_Edit_AutoFN->GetText() );
	String aLibNam( String::CreateFromAscii( "AutoPilot" )
					/*rDoku.pD_Edit_VorNam->GetText()*/ );
	String aMacNam( aLibNam );
	aMacNam.AppendAscii("_Create");
	ValidateMacroName( aMacNam );

	String aMacStr;
	if( rDoku.pD_CBox_AutoFN->IsChecked() && aPrefix.Len() )
	{
		String aCntFN;
		aCntFN.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "cnt_" ));
		aCntFN += aPrefix;
		aCntFN.AppendAscii(RTL_CONSTASCII_STRINGPARAM(".wiz"));

		{
static char __READONLY_DATA cAutoFNamMacro1[] =
    "REM Automatic file name generation\n"
    "path$ = \"_$GRUPPE$_\"\n"
    "prefix$ = \"_$PREFIX$_\"\n"
    "extension$ = \".sxw\"\n"
    "nNumber = 1\n"
    "sDirEntry$ = Dir$(path$ + prefix$ + \"*\" + extension$)\n"
    "nPrefixLen = Len(prefix$)\n"
    "nExtensionLen = Len(extension$)\n"
    "while sDirEntry$ <> \"\"\n"
    "\tsCount = Mid$(sDirEntry$, nPrefixLen + 1, Len(sDirEntry$) - nPrefixLen - nExtensionLen)\n"
    "\tnTempValue = Val(sCount)\n"
    "\tif nTempValue > nNumber then nNumber = nTempValue\n"
    "\tsDirEntry$ = Dir$\n"
    "wend\n"
    "nNumber = nNumber + 1\n"
    "\tFileName$ = path$ + prefix$ + nNumber + extension$\n"
    "\t\tthiscomponent.storeAsURL(FileName$, EmptyArgs())\n";

			String aTmp;
            aTmp.AppendAscii(cAutoFNamMacro1);
			aTmp.SearchAndReplaceAscii("_$CNTFN$_",aCntFN);
			aTmp.SearchAndReplaceAscii("_$PREFIX$_",aPrefix);
			aTmp.SearchAndReplaceAscii("_$GRUPPE$_",sPath);
            IndentStr(aTmp,4); // add insertion
			aMacStr+=aTmp;
		}
	}
	if (nDateFmt >= 0 && nDateAnz > 0)
	{
		// Macro zum setzen des aktuellen Datums
		aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
						"    REM Setzen des aktuellen Datums\n" ));
		for( USHORT i = 0; i < nDateAnz; ++i )
		{
			String aMark( String::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( "Datum" )));
			if( i > 0)
				aMark += String::CreateFromInt32( i );
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
							"    IF xBkms.hasByName(\""));
			aMacStr+= aMark;
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					   "\") THEN\n"
					   "        xBkm = xBkms.getByName(\""));
			aMacStr+= aMark;
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					   "\")\n"
					   "        xAnchor = xBkm.getAnchor\n"
					   "        xFld = xDoc.createInstance(\"com.sun.star.text.TextField.DateTime\")\n"
					   "        xFld.IsFixed = TRUE\n"
					   "        xFld.IsDate = TRUE\n"
					   "        xFld.NumberFormat = "));
			aMacStr += String::CreateFromInt32( nDateFmt );
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					   "\n"
					   "		xAnchor.getText.insertTextContent(xAnchor, xFld, false)\n"
					   "        xBkm.dispose\n"
					   "    END IF\n"));
		}
	}
	if (nTimeFmt >= 0)
	{
		// Macro zum setzen der aktuellen Uhrzeit
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
						"    IF xBkms.hasByName(\"Uhrzeit\")THEN\n"
						"        xBkm = xBkms.getByName(\"Uhrzeit\")\n"
						"        xAnchor = xBkm.getAnchor\n"
						"        xFld = xDoc.createInstance(\"com.sun.star.text.TextField.DateTime\")\n"
						"        xFld.IsFixed = TRUE\n"
						"        xFld.IsDate = FALSE\n"
						"        xFld.NumberFormat = "));
			aMacStr += String::CreateFromInt32( nTimeFmt );
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
						"\n"
						"		xAnchor.getText.insertTextContent(xAnchor, xFld, false)\n"
						"        xBkm.dispose\n"
						"    END IF\n"));
	}
	if (bDelUmbr)
	{
		aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					"    REM Loeschen des harten Seitenumbruchs\n"
					"    IF xBkms.hasByName(\"Umbruch\")THEN\n"
					"        xBkm = xBkms.getByName(\"Umbruch\")\n"
					"        xAnchor = xBkm.getAnchor\n"
					"        xCrsr = xAnchor.getText.CreateTextCursorByRange(xAnchor)\n"
					"        xBkm.dispose\n"
					"        xCrsr.goRight(1, TRUE)\n"
					"        xCrsr.setString(\"\")\n"
					"    END IF\n"));
	}
	// Loeschen der aus der Vorlage geerbten Description
	aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
				"    REM Loeschen der aus der Vorlage geerbten Doc-Beschreibung\n"
				"    xDoc.DocumentInfo.Description = \"\"\n"
	// Macro zum springen zum Textanfang
				"    REM Zum Textbeginn springen und die Zeile dort markieren\n"
				"    IF xBkms.hasByName(\"Text\")THEN\n"
				"        xBkm = xBkms.getByName(\"Text\")\n"
				"        xAnchor = xBkm.getAnchor\n"
				"        xCrsr = xAnchor.getText.CreateTextCursorByRange(xAnchor)\n"
				"        xCtrl = xDoc.CurrentController\n"
				"        xCtrl.select(xCrsr)\n"
				"        xVCrsr = xCtrl.getViewCursor\n"
				"        xVCrsr.gotoEndOfLine(TRUE)\n"
				"        xBkm.dispose\n"
				"    END IF\n"));
	bRet = AssignMacro( aMacStr, aMacNam, aLibNam,
				String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Create")),
				SFX_EVENT_CREATEDOC );
	return bRet;
}

String WizardGo::GetDocInfoMacroStr( const String& rStr, BOOL bFeld,
									BOOL bGoDown )
{
	String aStr;
	if (bFeld)
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
        "xFieldMasters = xDoc.getTextFieldMasters\n"
        "aElementNames = xFieldMasters.getElementNames\n"
        "sServicePrefix = \"com.sun.star.text.FieldMaster.DataBase\"\n"
        "for i% = 0 to ubound(aElementNames)\n"
        "    sService = Left (aElementNames(i%), Len(sServicePrefix)\n"
        "    if sServicePrefix = sService then\n"
        "        xMaster = xFieldMasters.getByName(aElementNames(i%))\n"
        "        if xMaster.DataColumnName = \""));
        aStr += rStr;
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
         "\" then\n"
        "            xDependentField = xMaster.DependentTextFields(0)\n"
        "            a$ = xDependentField.CurrentPresentation\n"
        "        endif\n"
        "    endif\n"
        "next i%\n"));
	}
	else
	{
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
        "   xController = xDoc.CurrentController\n"
        "   xVCrsr = xController.getViewCursor\n"
        "   IF xBkms.hasByName(\""));
        aStr += rStr;
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
        "\") THEN\n"
        "   xTempBkm = xBkms.getByName(\""));
        aStr += rStr;
        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
        "\")\n"
        "       xAnchor = xTempBkm.getAnchor\n"
        "       xCrsr = xAnchor.getText.createTextCursorByRange(xAnchor)\n"
        "       xCrsr.collapseToStart\n"
        "       xController.select(xCrsr)\n"));
        if (bGoDown)
            aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
                "       xVCrsr.goDown(1, FALSE)\n"));

        aStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
        "       xSelection = xDoc.CurrentController.getSelection\n"
        "       xRange = xSelection(0)\n"
        "       xCrsr = xRange.getText.createTextCursorByRange(xRange)\n"
        "           IF NOT xCrsr.isStartOfParagraph() THEN\n"
        "           xCrsr.gotoStartOfParagraph(FALSE)\n"
        "       END IF\n"
        "       IF NOT xCrsr.isEndOfParagraph() THEN\n"
        "           xCrsr.gotoEndOfParagraph(TRUE)\n"
        "           a$ = xCrsr.getString\n"
        "       END IF\n"
        "   END IF\n"));
    }
	return aStr;
}

BOOL WizardGo::SetSaveMacro( WizardDokuDlg& rDoku,
							BOOL bMarker1Down, BOOL bMarker2Down )
{
	BOOL bRet=TRUE;
	if( rDoku.pD_List_InfTit->GetSelectEntryPos() ||
		rDoku.pD_List_InfTem->GetSelectEntryPos() )
	{
		String aCode;
		String aLibNam( String::CreateFromAscii( "AutoPilot" )
					/*rDoku.pD_Edit_VorNam->GetText()*/ );
		String aMacNam( aLibNam );
		aMacNam.AppendAscii("_Save");
		ValidateMacroName( aMacNam );

		String aMacStr;
		aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
			"	 xSelection = xDoc.CurrentController.getSelection\n"
			"    xRange = xSelection(0)\n"
			"    xCrsr = xRange.getText.createTextCursorByRange(xRange)\n"
			"    xBkm = xDoc.createInstance(\"com.sun.star.text.Bookmark\"\n"
			"    xBkm.setName(\"JoeSaveLabel\")\n"
			"    xCrsr.getText.insertTextContent(xCrsr, xBkm, false)\n"));

		if( rDoku.pD_List_InfTit->GetSelectEntryPos() )
		{
			String aStr(rDoku.pD_List_InfTit->GetSelectEntry());
			BOOL bIsDBFeld = rDoku.IsDocInfoDBFeldSelected( 0 );
			if (!bIsDBFeld)
				aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM("Titel"));
			aMacStr += GetDocInfoMacroStr( aStr, bIsDBFeld, bMarker1Down );
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
				"    xDoc.DocumentInfo.Title = a$\n"));
		}

		if( rDoku.pD_List_InfTem->GetSelectEntryPos() )
		{
			String aStr(rDoku.pD_List_InfTem->GetSelectEntry());
			BOOL bIsDBFeld = rDoku.IsDocInfoDBFeldSelected(1);
			if (!bIsDBFeld)
				aStr.AssignAscii( RTL_CONSTASCII_STRINGPARAM("Thema"));
			aMacStr += GetDocInfoMacroStr( aStr, bIsDBFeld, bMarker2Down );
			aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					"    xDoc.DocumentInfo.Theme = a$\n"));
		}
		aMacStr.AppendAscii(RTL_CONSTASCII_STRINGPARAM(
					"    IF xBkms.hasByName(\"JoeSaveLabel\") THEN\n"
					"		xBkms.getByName(\"JoeSaveLabel\").dispose\n"
					"    END IF\n"));
		bRet = AssignMacro( aMacStr, aMacNam, aLibNam,
				String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("Save")),
				SFX_EVENT_SAVEDOC, &aCode );
		if ( bRet )
		{
			SfxEventConfiguration* pECfg = SFX_APP()->GetEventConfig();
			pECfg->ConfigureEvent( SFX_EVENT_SAVEASDOC,
									SvxMacro( aCode, aEmptyStr, STARBASIC ),
									pShell->GetView().GetDocShell() );
		}
	}
	return bRet;
}




