/*************************************************************************
 *
 *  $RCSfile: wizlt.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WIZLT_HXX
#define _WIZLT_HXX

#include "wizltdlg.hxx"
#include "wizgo.hxx"
#ifndef _WIZCFG_HXX
#include <wizcfg.hxx>
#endif

class LetterDialog: public WizardLettDialog, private WizardGo
{
	WizardLettPage1 	aPage1;
	WizardLettPageF 	aPageF;
	SwLetterWizardCfg   aConfig;

public:
	LetterDialog(Window* pParent);
	virtual void Fill(USHORT StepNum, MultiOne& WinArr);
	virtual BOOL Possible(USHORT StepNum);
	virtual void Enter(USHORT StepNum);
	virtual void Leave(USHORT StepNum);

	void SetEventHandler();

	void SetStyle(BYTE nStyle);
	DECL_LINK( StyleClickHdl, RadioButton * );
	DECL_LINK( PrivRadioClickHdl, RadioButton * );
	DECL_LINK( LogoBBtnHdl, Button * );
	DECL_LINK( LogoRBtnHdl, RadioButton * );
	DECL_LINK( LogoMFldHdl, MetricField * );
	DECL_LINK( SelPrtHdl, Button * );

	DECL_LINK( AbsnBBtnHdl, Button * );
	DECL_LINK( AbsnMFldHdl, MetricField * );
	DECL_LINK( AbsnGschRadioClickHdl, RadioButton * );
	DECL_LINK( AbsnPrivRadioClickHdl, RadioButton * );
	DECL_LINK( ElemCheckClickHdl, CheckBox * );
	DECL_LINK( Fuss1CheckClickHdl, CheckBox * );
	DECL_LINK( Fuss1ModifyHdl, MultiLineEdit * );
	DECL_LINK( FussFCheckClickHdl, CheckBox * );
	DECL_LINK( FussFMetrModifyHdl, MetricField * );
	DECL_LINK( KopzFMetrModifyHdl, MetricField * );
	DECL_LINK( KopzFListSelectHdl, ListBox * );
	DECL_LINK( RandMetrcModifyHdl, MetricField * );
	DECL_LINK( EditModifyHdl, Edit * );
	DECL_LINK( UpdateAdressHdl, PushButton *);
	DECL_LINK( PNumCheckClickHdl, CheckBox * );
	DECL_LINK( PNumModifyHdl, Edit * );
	DECL_LINK( PNumSelectHdl, ListBox * );
	DECL_LINK( ElemModifyHdl, Edit * );

	DECL_LINK( EmpfDBasListHdl, ListBox * );

	void SetFuszKopzMarg();
	void SetLogoBMapBtnDisable();
	void SetAbsnBMapBtnDisable();
	void SetMetDisable();
	void SetElemBetr();
	void SetPrivat();
	void SetFussFDisable();
	void SetKopfFDisable();
	void SetLogoAbsnFDisable();
	void SetLogoAbsnPrnDisable();
	void SetPagNumDisable();
	void SetElemDisable();

	void InitElemUI();  // Datelistbox fuellen
	void InitFinaUI();  // Traylistbox fuellen

	void AbsnToUI();    // Absender
	void Absn1ToUI();   // Absender
	void EmpfToUI();    // Empfaenger (Absender anzeigen?)
	void ElemToUI();    // Elemente
	void LogoFToUI();   // Logo in der Kopfzeile der Folgeseiten
	void AbsnFToUI();   // Absender in der Kopfzeile der Folgeseiten
	void KopzFToUI();   // Kopfzeile der Folgeseiten
	void FuszFToUI();   // Fusszeile der Folgeseiten
	void PgNumToUI();   // Seitennumerierung

	void FillDocInfoList();
	String GetDocInfStr(USHORT nNum);
	BOOL   GetDocInfStrOk(USHORT nNum);
	BOOL   GetDocInfoGoDown(USHORT nNum);

	void GetFromDef();  // Harte Defaults setzen
	void GetFromUsr();  // Defaults von Benutzereinstellungen holen
	void GetFromIni();  // Defaults vom Inifile holen

	virtual void WriteToIni();
	virtual BOOL MakeDoc();

private:
	void InsDocInfBookmark(USHORT nElemNum);
	void InsAbsnStr();
	void InsAbsn();
	void InsAbs2();
	void InsLogo();
	void InsEmpf();

//    void InsFusz(WizardFusz& rFusz, const String& rFusMark, const String& rNumMark);
	void InsKopF();
	void InsElem();
	void InsBetr();
	void InsAnrd();
	void InsAnlg();
	void InsKopi();

	void CreateMacro();
	void SaveMacro();
};

#endif  //_WIZLT_HXX


