/*************************************************************************
 *
 *  $RCSfile: wizmulti.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fme $ $Date: 2001/08/16 09:38:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WIZMULTI_HXX
#define _WIZMULTI_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#include <svtools/svmedit.hxx>

#include "wizpage.hxx"

class WizardDokuDlg;

////////////////////////////////////////////////////////////////////////////////
// Abgekuerzte Dateinamen
////////////////////////////////////////////////////////////////////////////////

void FNam2FixedText(const String& rFNam, FixedText& rText);

////////////////////////////////////////////////////////////////////////////////
// MultiOne
////////////////////////////////////////////////////////////////////////////////

struct WinMerkRec
{
	Window* pWin;
	BOOL    bIsVisible : 1;
	BOOL    bIsGroup : 1;
	BOOL 	bGetFocus : 1;
};

// Enthaelt die Verweise auf alle Elemente eines Schrittes
class MultiOne
{
	USHORT      ElemAnz;
	USHORT      ArrSize;
	long		nHelpId;	// HelpId fuer diese Page
	WinMerkRec* ElemList; // Array mit Zeigern auf die Elemente
public:
	MultiOne();
	~MultiOne();

	void Show();
	void Hide();

	BOOL SetWinShowHide( Window* pWin, BOOL bShow );
	void SetAnz(USHORT nAnz);
	void AddWin(Window* pWin, BOOL bGetFocus=FALSE, BOOL bGroup=FALSE);
	BOOL FindWin(Window* pWin);

	USHORT GetAnz() { return ElemAnz; }
	Window* GetWin( USHORT Num )
		{ return Num < ElemAnz ? ElemList[ Num ].pWin : 0; }
	long GetHelpId() const			{ return nHelpId; }
	void SetHelpId( long nId )		{ nHelpId = nId; }
};

////////////////////////////////////////////////////////////////////////////////
// MultiDialog
////////////////////////////////////////////////////////////////////////////////

class MultiDialog: public ModalDialog
{
private:
	BOOL Step( short n, BOOL bOnlyCheck );
protected:
	USHORT     StepAnz; // Anzahl der Schritte
	USHORT     AktStep; // Aktueller Schritt
	MultiOne*  WinList; // Array mit Zeigern auf Arrays mit Zeigern auf die umzuschaltenden Elemente
	Button*    PrevBtn;
	Button*    NextBtn;

public:
	MultiDialog(Window* pParent, const ResId& rResId, USHORT nAnz);
	~MultiDialog();
	virtual void Init(Button* pPrev, Button* pNext);
	virtual void Fill(USHORT StepNum, MultiOne& WinArr);
	virtual BOOL Possible(USHORT StepNum);
	virtual void Leave(USHORT StepNum); // Aufruf vor Hide
	virtual void Enter(USHORT StepNum); // Aufruf nach Show

	void Inc()			{ Step( +1, FALSE ); }
	void Dec()			{ Step( -1, FALSE ); }
	BOOL IsFrst()		{ return !Step( -1, TRUE ); }
	BOOL IsLast()		{ return !Step( +1, TRUE ); }

	void Switch(USHORT nStepNum);
	void ShowHideWin( Window& rWin, BOOL bShow );
	DECL_LINK( MultiClickHdl, Button * );
	BOOL FindWin(Window* pWin, USHORT& nStep); // Feststellen, in welchem Step das Win ist
	MultiOne* GetWinList(USHORT Num)
		{ return Num < StepAnz ? &WinList[ Num ] : 0; }
};

////////////////////////////////////////////////////////////////////////////////
// WizardPreview
////////////////////////////////////////////////////////////////////////////////

class WizardPreview: public Window
{
	WizardPage* pAktPage;
public:
	WizardPreview(Window* pParent, const ResId& rResId);
	virtual void Paint(const Rectangle&);
	void SetPage(WizardPage* pPage);
};

////////////////////////////////////////////////////////////////////////////////
// SwWizardDialog
////////////////////////////////////////////////////////////////////////////////

class SwWizardDialog : public MultiDialog
{
protected:
	Window*       pTrenWin;
	HelpButton*   pHelpBtn;
	CancelButton* pCnclBtn;
	PushButton*   pPrevBtn;
	PushButton*   pNextBtn;
	OKButton*     pOkayBtn;

	Size          aMinSize;
	Size          aSize0;
	MultiOne      URElem;  // Elemente die nicht umgeschaltet werden

	void FillFldListBox( ListBox& rLstBox, USHORT nType );

public:                    // die muss ich fuers Resize kennen
	WizardPreview aPrevWin;
	WizardDokuDlg* pDoku;

	SwWizardDialog( Window* pParent, const ResId& rResId, USHORT nAnz );
	~SwWizardDialog();

	virtual void Init();
	void FillDefElems(MultiOne& WinArr);

	virtual void WriteToIni() = 0;
	virtual BOOL MakeDoc() = 0;
};

////////////////////////////////////////////////////////////////////////////////
// JBitmapButton
////////////////////////////////////////////////////////////////////////////////

class JBitmapButton: public ImageButton
{
	Image aEnabImg;
	Image aDisbImg;
public:
	JBitmapButton(Window* pParent, const ResId& rResId);
	void Enable(BOOL bEnable);
	void ChangeDisbBitmap(const Bitmap& rBmp);
};



#endif  //_WIZMULTI_HXX

