/*************************************************************************
 *
 *  $RCSfile: copyprj.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: nf $ $Date: 2000/09/20 12:02:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "inimgr.hxx"
#include "copyprj.hxx"
#include "appdef.hxx"
#include "fattr.hxx"
#ifndef UNX
#include <direct.h>
#else
#include <sys/stat.h>
#include <stdlib.h>
#endif
#include "geninfo.hxx"
#include "iparser.hxx"

#include <stdio.h>

#ifdef DOS
#include <stdlib.h>
#endif

//
// class ProjectCop
//

#ifdef UNX
#define SEPARATOR ByteString( "/" )
#else
#define SEPARATOR ByteString( "\\" )
#endif

/****************************************************************************/
ProjectCop::ProjectCop( ByteString &rPrj, ByteString &rVer, ByteString &rDest,
						BOOL bAddPath, BOOL bOutPath, BOOL bFlat,
						BOOL PbOnlyOutpath, BOOL bIsUpdate )
/****************************************************************************/
	: pStand( NULL ),
	pDstVer( NULL ),
	pList( NULL ),
	pEnvList( NULL ),
	bCopyPrj( TRUE ),
	sProject( rPrj ),
	sVersion( rVer ),
	sDstVersion(),
	bDontDelete( FALSE ),
	sDestination( rDest ),
	bFlatVersion( bFlat ),
	bAddOutPath( bOutPath ),
	bOnlyOutPath( PbOnlyOutpath ),
	bUpdate( bIsUpdate ),
	bAddVerName( bAddPath )
{
	sSource = ByteString( "" );

	fprintf( stderr, "\nUpdate of configuration data ...\n" );
	IniManager aIniManager;
	aIniManager.Update();

	ByteString sStandList( _DEF_STAND_LIST );
	sStandList = aIniManager.ToLocal( sStandList );

	fprintf( stderr, "\nDatabase: %s\n", sStandList.GetBuffer());

	InformationParser aParser( REPLACE_VARIABLES );
	String aPath( sStandList, gsl_getSystemTextEncoding());
	pList = aParser.Execute( aPath );
}

/****************************************************************************/
ProjectCop::ProjectCop( ByteString &rSrcVer, ByteString &rDstVer,
			OutpathList *pEnvs,
			GenericInformationList *pIList,
			BOOL bAddPath, BOOL bOutPath, BOOL bFlat  )
/****************************************************************************/
	: pStand( NULL ),
	pDstVer( NULL ),
	pList( NULL ),
	pEnvList( NULL ),
	bCopyPrj( FALSE ),
	sProject(),
	sVersion( rSrcVer ),
	sDstVersion( rDstVer ),
	sDestination(),
	bDontDelete( FALSE ),
	pDstEnvs( pEnvs ),
	bFlatVersion( bFlat ),
	bAddOutPath( bOutPath ),
	bOnlyOutPath( FALSE ),
	bAddVerName( bAddPath )
{
	fprintf( stderr, "\nUpdate of configuration data ...\n" );
	IniManager aIniManager;
	aIniManager.Update();

	ByteString sStandList( _DEF_STAND_LIST );
	sStandList = aIniManager.ToLocal( sStandList );

	fprintf( stderr, "\nDatabase: %s\n", sStandList.GetBuffer());

	if ( !pIList ) {
		InformationParser aParser( REPLACE_VARIABLES );
		String aPath( sStandList, gsl_getSystemTextEncoding());
		pList = aParser.Execute( aPath );
	}
	else {
		bDontDelete = TRUE;
		pList = pIList;
	}
}

/****************************************************************************/
ProjectCop::~ProjectCop()
/****************************************************************************/
{
	if ( pList && !bDontDelete )
		delete pList;
}

/****************************************************************************/
USHORT ProjectCop::IsValid()
/****************************************************************************/
{
	USHORT nRetValue = PC_DATA_VALID;

	if ( !pList ) {
		// no config file found
		nRetValue += PC_VERSION_NOT_VALID;
		return nRetValue;
	}

	// look for requestet version
	if ( ByteString( sVersion ).ToLowerAscii() == "now" ) {
		BOOL bFound = FALSE;

		for ( ULONG i = 0; ( i < pList->Count()) && !bFound; i++ ) {
			pStand = pList->GetObject( i );
			if ( pStand ) {
				ByteString sPath("settings/now" );
				GenericInformation *pNow = pStand->GetSubInfo( sPath, TRUE );
				if ( pNow && ( ByteString( pNow->GetValue()).ToUpperAscii() == "_TRUE" ))
					bFound = TRUE; // pStand holds the act. version
			}
		}

		if ( !bFound ) {
			// inconsistenc: no act. version set in database
			nRetValue += PC_VERSION_NOT_VALID;
			return nRetValue;
		}
	}
	else {
		if ( sVersion.GetTokenCount( '.' ) > 1 ) {
			ByteString sExt = sVersion.GetToken( 1, '.' ).ToLowerAscii();
			sVersion = sVersion.GetToken( 0, '.' );
			sVersion += '.';
			sVersion += sExt;
		}
		ByteString sVerPath( sVersion.GetToken( 0, '.' ));
		pStand = pList->GetInfo( sVerPath, FALSE );
	}

	if ( !pStand ) {
		// the version requestet by user could not be found in database
		nRetValue += PC_VERSION_NOT_VALID;
		return nRetValue;
	}

	// get environment list of current version
	ByteString sEnvPath( "environments" );
	GenericInformation *pEnvs = pStand->GetSubInfo( sEnvPath, FALSE );
	if ( pEnvs ) {
		pEnvList = pEnvs->GetSubList();
	}

	if ( bCopyPrj ) {
		// check project
		ByteString sDrvPath( "drives" );
		GenericInformation *pDrives = pStand->GetSubInfo( sDrvPath, FALSE );
		if ( !pDrives ) {
			nRetValue += PC_VERSION_NOT_VALID;
			return nRetValue;
		}

		GenericInformationList *pDrvList = pDrives->GetSubList();
		if ( !pDrvList ) {
			// no mandatory drives for requestet version
			nRetValue += PC_VERSION_NOT_VALID;
			return nRetValue;
		}

		// now search for the requestet project
		BOOL bFound = FALSE;
		for ( ULONG i = 0; !bFound && i < pDrvList->Count(); i++ ) {
			// get current drive
			GenericInformation *pActDrive = pDrvList->GetObject( i );

			if ( pActDrive ) {
				ByteString sPrjsPath( "projects" );
				GenericInformation *pPrjs = pActDrive->GetSubInfo( sPrjsPath );

				if ( pPrjs ) {
					// get project list
					GenericInformationList *pPrjList = pPrjs->GetSubList();

					if ( pPrjs ) {
						for ( ULONG j = 0; !bFound && j < pPrjList->Count(); j++ ) {
							// get current project
							GenericInformation *pActPrj = pPrjList->GetObject( j );

							ByteString sPrj = sProject;
							ByteString sAct = ByteString( *pActPrj );
							if ( sAct.ToUpperAscii() == sPrj.ToUpperAscii()) {
								// current project is the requested one
								bFound = TRUE;
	#ifndef UNX
								// create source path
								sSource = pActDrive->GetValue();
	#else
								ByteString sUnxPath( "UnixVolume" );
								GenericInformation* pUnxPath = pActDrive->GetSubInfo( sUnxPath, FALSE );
								if ( pUnxPath )
									sSource = pUnxPath->GetValue();
								else
									bFound = FALSE;
	#endif
								ByteString sPathPath( "Settings/Path" );
								GenericInformation *pPath = pStand->GetSubInfo( sPathPath, TRUE );
								if ( pPath ) {
									sSource += SEPARATOR;
									ByteString sPath = pPath->GetValue();
	#ifdef UNX
									sPath.SearchAndReplaceAll( "\\", "/" );
	#endif
									sSource += sPath;
								}
								else
									bFound = FALSE;

								// erweitern um die UPDMINOR
								if ( sVersion.GetTokenCount('.') > 1 ) {
									sSource += '.';
									sSource += sVersion.GetToken(1,'.');
								}
								else
								{
									if (!bFlatVersion) {
										sSource += '.';
										sSource += ByteString( getenv("UPDMINOR"));
									}
								}
								sSource += SEPARATOR;
								sSource += sProject;

								// create source path on lokal device
								if ( bAddVerName ) {
									sDestination += SEPARATOR;
									sDestination += sVersion.GetToken(0,'.');
								}
#ifndef UNX
								while ( sDestination.SearchAndReplace( "\\\\", "\\" ) != STRING_NOTFOUND );
								mkdir((char*) sDestination.GetBuffer());
#else
								mkdir( sDestination.GetBuffer(), 00777 );
#endif
								sDestination += SEPARATOR;
								sDestination += sProject;

#ifndef UNX
								while ( sDestination.SearchAndReplace( "\\\\", "\\" ) != STRING_NOTFOUND );
#endif
							}
						}
					}
				}
			}
		}

		if ( !bFound ) {
			nRetValue += PC_PROJECT_NOT_VALID;
			return nRetValue;
		}

		// now check destination path

		DirEntry aDestEntry( sDestination );
		FileStat aDestStat( aDestEntry );

		if (( aDestEntry.Exists() && ( aDestStat.GetKind() != FSYS_KIND_DIR )) ||
			( !DirEntry( aDestEntry.GetPath()).Exists()))
		{
			nRetValue += PC_DESTINATIONPATH_NOT_EXIST;
		}
	}
	else {
		// destination for taskforce
		ByteString sDstVerPath( sDstVersion.GetToken( 0, '.' ));
		pDstVer = pList->GetInfo( sDstVerPath, FALSE );

		if ( !pDstVer ) {
			// the version requestet by user could not be found in database
			nRetValue += PC_DSTVERSION_NOT_VALID;
			return nRetValue;
		}
	}

	// Source = pStand
	// Destination = pDstVer
	// SourceEnvisonments = pEnvList
	// DestEnvironments = pDstEnvs

	return nRetValue;
}

/****************************************************************************/
BOOL ProjectCop::CVSPatch( ByteString &rSrc, ByteString &rDest )
/****************************************************************************/
{
	ByteString sLine;

	SvFileStream aSourceStream( String( rSrc, gsl_getSystemTextEncoding()), STREAM_READ );
	if ( !aSourceStream.ReadLine( sLine ))
		return FALSE;

	ByteString sFirst( sLine.GetToken( 0, '@' ));
	ByteString sNew( ":pserver:" );
#ifndef UNX
	sNew += ByteString( getenv( "VCSID" )).ToLowerAscii();
#else
	sNew += ByteString( getenv( "USER" )).ToLowerAscii();
#endif
	sNew += sLine.Copy( sFirst.Len());

	DirEntry aDelEntry( String( rDest, gsl_getSystemTextEncoding()));
	aDelEntry.Kill();

	SvFileStream aDestStream( String( rDest, gsl_getSystemTextEncoding()), STREAM_WRITE );
	if ( !aDestStream.WriteLine( sNew ))
		return FALSE;

	return TRUE;
}

/****************************************************************************/
USHORT ProjectCop::Copy()
/****************************************************************************/
{
	DirEntry aEntry( sSource );
	if ( !CopyDirectory( aEntry ))
		return 1;

	return 0;
}

/****************************************************************************/
USHORT ProjectCop::Copy( ByteString &rPrj )
/****************************************************************************/
{
	return 0;
}

/****************************************************************************/
BOOL ProjectCop::CopyDirectory( DirEntry &rDir, BOOL bCopyAllDirs )
/****************************************************************************/
{
	ByteString sName( rDir.GetName(), gsl_getSystemTextEncoding());

	BOOL bIsOutPath =
		( ByteString( sName ).ToUpperAscii() ==
			ByteString( getenv("INPATH")).ToUpperAscii());

	// 'common' ist auch Ausgabepfad
	DirEntry aDirEntry( String( "common", gsl_getSystemTextEncoding()));
	aDirEntry.SetExtension( DirEntry( String( getenv("INPATH"), gsl_getSystemTextEncoding())).GetExtension());
	if ( ByteString( aDirEntry.GetName(), gsl_getSystemTextEncoding()).ToUpperAscii() ==
			ByteString( sName ).ToUpperAscii())
		bIsOutPath = TRUE;

	if ( !bCopyAllDirs )
	{	// Kann das Verzeichnis bersprungen werden

		// Sollen die Ausgabapfade kopiert werden
		if ( !bAddOutPath && bIsOutPath )
			return TRUE;

		// Fremde Environments rausschmeissen
		if ( pEnvList && !bIsOutPath )
		{
			String aBaseName = rDir.GetBase();
			for ( ULONG x = 0; x < pEnvList->Count(); x++ )
			{
				String sEnv( *(pEnvList->GetObject( x )), gsl_getSystemTextEncoding());
				if (( aBaseName.CompareIgnoreCaseToAscii( DirEntry(sEnv).GetBase() ) == COMPARE_EQUAL ) )
					return TRUE;
			}
		}

		// Fremde 'common' rausschmeissen
		if ( rDir.GetBase().CompareIgnoreCaseToAscii( "common" ) == COMPARE_EQUAL && !bIsOutPath )
			return TRUE;
	}

	ByteString sSrc( rDir.GetFull(), gsl_getSystemTextEncoding());
	if ( !rDir.Exists() )
	{
		ByteString sOutput( "Source directory " );
		sOutput += sSrc;
		sOutput += ByteString( " not found" );
		PrintStatus( sOutput.GetBuffer());
		return FALSE;
	}

	Dir aDir( rDir.GetFull(), FSYS_KIND_ALL );

	ByteString sDest = sDestination;
	sDest += sSrc.Copy( sSource.Len());
	ByteString sStatus( sSrc );
	sStatus += ByteString( " => " );
	sStatus += sDest;
	PrintStatus( "\n" ); PrintStatus( sStatus.GetBuffer()); PrintStatus( " " );

	if ( !bOnlyOutPath || bIsOutPath || bCopyAllDirs )
	{
		if ( bOnlyOutPath )
			DirEntry( sDest ).MakeDir( TRUE );
#ifndef UNX
		mkdir((char*) sDest.GetBuffer() );
#else
		mkdir( sDest.GetBuffer(), 00777 );
#endif
	}

	for( USHORT i = 0; i < aDir.Count(); i++ ) {
		String sEntry( aDir[i].GetName());
		if (( ByteString( sEntry, gsl_getSystemTextEncoding()) != "." ) &&
			( ByteString( sEntry, gsl_getSystemTextEncoding()) != ".." ) &&
			( aDir[i].GetDevice() == rDir.GetDevice()))
		{
			if ( FileStat( aDir[i] ).IsKind( FSYS_KIND_DIR ))
				CopyDirectory( aDir[i], bIsOutPath || bCopyAllDirs );
			else {
				if ( !bOnlyOutPath || bIsOutPath || bCopyAllDirs )
				{
					ByteString sSrc( aDir[i].GetFull(), gsl_getSystemTextEncoding());
					ByteString sDest( sDestination );
					sDest += sSrc.Copy( sSource.Len());

					// copy file and all attributes
					ByteString sNm( sName );
					ByteString sEn( sEntry, gsl_getSystemTextEncoding());
					if (( sNm.ToUpperAscii() == "CVS" ) &&
						( sEn.ToUpperAscii() == "ROOT" ))
					{
						if ( CVSPatch( sSrc, sDest ))
							PrintStatus( "p" );
						else
							PrintStatus( "f" );
					}
					else {
						FileCloner aFileCloner( sSrc, sDest);
						aFileCloner.SetUpdateCopy( bUpdate );
						aFileCloner.Execute();
						if ( aFileCloner.GetError() )
						{
							PrintStatus( "\n" );
							PrintStatus( "Error: copying " );
							PrintStatus( ByteString( aFileCloner.GetErrorSource()->GetFull(), gsl_getSystemTextEncoding()).GetBuffer());
							PrintStatus( " to " );
							PrintStatus( ByteString( aFileCloner.GetErrorTarget()->GetFull(), gsl_getSystemTextEncoding()).GetBuffer());
							PrintStatus( "\n" );
						}
						if ( aFileCloner.Copied() )
							PrintStatus( "." );
						else
							PrintStatus( "=" );
					}
				}
				else
					PrintStatus( "/" );
			}
		}
	}
	return TRUE;
}

#if 0
/****************************************************************************/
void ProjectCop::PrintStatus( const char* cStatus )
/****************************************************************************/
{
}
#endif
