/*************************************************************************
 *
 *  $RCSfile: mkcrexe.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: nf $ $Date: 2001/06/12 10:38:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// global includes
#include <stdio.h>

// local includes
#include "mkcreate.hxx"

ULONG nDepth = 0;
void PrintDir( SourceDirectory *pDirectory )
{
	for ( ULONG i = 0; i < nDepth; i++ )
		fprintf( stdout, " " );

	fprintf( stdout, "%s   ", pDirectory->GetBuffer());
	if ( pDirectory->GetOperatingSystems() != OS_ALL ) {
//		if ( pDirectory->GetOperatingSystems() & OS_WIN16 )
//			fprintf( stdout, "WIN16 " );
		if ( pDirectory->GetOperatingSystems() & OS_WIN32 )
			fprintf( stdout, "WIN16 " );
		if ( pDirectory->GetOperatingSystems() & OS_WIN32 )
			fprintf( stdout, "WIN32 " );
		if ( pDirectory->GetOperatingSystems() & OS_OS2 )
			fprintf( stdout, "OS2 " );
		if ( pDirectory->GetOperatingSystems() & OS_UNX )
			fprintf( stdout, "UNX " );
		if ( pDirectory->GetOperatingSystems() & OS_MAC )
			fprintf( stdout, "MAC" );
	}

	if ( pDirectory->GetCodedIdentifier()) {
		fprintf( stdout, "   = " );
		for ( ULONG i = 0; i < pDirectory->GetCodedIdentifier()->Count(); i++ )
			fprintf( stdout, "%s ", pDirectory->GetCodedIdentifier()->GetObject( i )->GetBuffer());
	}

	if ( pDirectory->GetCodedDependencies()) {
		fprintf( stdout, "   : " );
		for ( ULONG i = 0; i < pDirectory->GetCodedDependencies()->Count(); i++ )
			fprintf( stdout, "%s ", pDirectory->GetCodedDependencies()->GetObject( i )->GetBuffer());
	}

	fprintf( stdout, "\n" );

	if ( pDirectory->GetSubDirectories()) {
		nDepth ++;
		for ( ULONG i = 0; i < pDirectory->GetSubDirectories()->Count(); i++ ) {
			PrintDir(( SourceDirectory * ) pDirectory->GetSubDirectories()->GetObject( i ));
		}
		nDepth--;
	}
}

/****************************************************************************/
#ifdef WNT
int _cdecl main( int argc, char *argv[] )
#else
int main( int argc, char *argv[] )
#endif
/****************************************************************************/
{
	if ( argc == 1 || argc > 3 ) {
		fprintf( stdout,
			"\n"
			"mkcreate 0.9, Copyright 2000 Sun Microsystems, Inc. All Rights Reserverd\n"
			"========================================================================\n"
			"\n"
			"Generator for recursive makefiles in a solar environment\n"
			"\n"
			"Syntax : mkcreate root [tree]\n"
			"  root : the root directory of the source tree (e.g. o:\\569)\n"
			"  tree : the sub tree for which the makefile are to be generated\n"
			"         If no sub tree is given, makefiles for the whole source tree will\n"
			"         be generated\n"
			"\n"
			"Example: mkcreate o:\\569 o:\\569\\svtools\n"
			"         recursive makefiles for the project \"svtools\" will be generated into\n"
			"         the svtools tree\n"
			"\n"
			"During generation, status information will be shown for each directory in the\n"
			"given source tree.\n"
			"To run mkcreate, a current solar version (environment variable WORK_STAMP) has\n"
			"to be set! Use setsolar or a env.set script for doing this.\n"
		);
		return 1;
	}

	ByteString sPath( argv[ 1 ] );
	ByteString sVersion;
	if( getenv( "WORK_STAMP" ))
		sVersion = ByteString( getenv( "WORK_STAMP" ));
	else {
		fprintf( stderr, "\nERROR: No solar version set!" );
		return 5;
	}

	fprintf( stderr,
		"\n"
		"mkcreate 0.9, Copyright 2000 Sun Microsystems, Inc. All Rights Reserverd\n"
		"========================================================================\n"
		"\n"
	);
	SourceDirectory *pSourceRoot = SourceDirectory::CreateRootDirectory(
		sPath, sVersion );

	SourceDirectory *pCurrent = NULL;
	if ( argc == 3 )
		pCurrent = pSourceRoot->GetDirectory( argv[ 2 ], OS_NONE );
	else
		pCurrent = pSourceRoot;

	if ( !pCurrent ) {
		if ( argc == 3 )
			fprintf( stderr,
				"ERROR: Unable to find virtual directory tree %s\n\n",
				argv[ 2 ] );
		else
			fprintf( stderr,
				"ERROR: Unable to find workspace %s in stand.lst\n\n",
				 sVersion.GetBuffer());

		return 6;
	}

	pSourceRoot->ResolveDependencies();

	fprintf( stderr, "Generating recursive makefiles...\n\n" );
	pCurrent->CreateRecursiveMakefile( TRUE );

	delete pSourceRoot;

	return 0;
}


