/*************************************************************************
 *
 *  $RCSfile: dos.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <errno.h>
#include <stdlib.h>

#include <fsys.hxx>

DECLARE_LIST( DirEntryList, DirEntry* );
DECLARE_LIST( FSysSortList, FSysSort* );
DECLARE_LIST( FileStatList, FileStat* );

#ifdef W30
static char sBuff[257]; // Buffer for ANSI/OEM conversion

String Lower_Impl( const char *pStr )
{
    strcpy( sBuff, pStr );
    return AnsiLower( sBuff );
}

String Gui2FSys( const String& rStr )
{
    USHORT nLen = Min( (USHORT) 256, rStr.Len() );
    AnsiToOemBuff( rStr.GetStr(), sBuff, nLen );
    sBuff[nLen] = '\0';
    return String( sBuff );
}

String FSys2Gui( const String& rStr )
{
    USHORT nLen = Min( (USHORT) 256, rStr.Len() );
    OemToAnsiBuff( rStr.GetStr(), sBuff, nLen );
    sBuff[nLen] = '\0';
    return String( sBuff );
}

#endif

/*************************************************************************
|*
|*    DirEntry::ToAbs()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 26.04.91
|*    Letzte Aenderung  MA 02.12.91 13:30
|*
*************************************************************************/

BOOL DirEntry::ToAbs()
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

	if ( FSYS_FLAG_VOLUME == eFlag )
	{
		eFlag = FSYS_FLAG_ABSROOT;
		return TRUE;
	}

    if ( IsAbs() )
        return TRUE;

    char sBuf[512];

    // musz das Laufwerk (temporaer) gewechselt werden?
    FSysFailOnErrorImpl();
    DirEntry* pTop = ImpGetTopPtr();
    if ( pTop->eFlag == FSYS_FLAG_RELROOT )
    {
        unsigned nOldDrive;
        unsigned nDummy; //fuer DOSSTCI
        GETDRIVE( nOldDrive );
        if ( pTop->aName.Len() )
            setdrive( (char) ( aName(0) - 'a' + 1 ), &nDummy );

        // das dortige CWD ermitteln;
        DirEntry *pCWD = new DirEntry(
            FSYS2GUI( String( getcwd( sBuf, sizeof( sBuf ) - 1 ) ) ) );

        // die relative Root durch ihr aktuelles Verzeichnis ersetzen
        if ( pTop == this )
        {
            *this = *pCWD;
            delete pCWD;
        }
        else
        {
            ImpGetPreTopPtr()->pParent = pCWD;
            delete pTop;
        }
        // Laufwerk wiederherstellen
        setdrive( nOldDrive, &nDummy );
    }
    else
        // dem Entry das aktuelle Verzeichnis voranstellen
        *this = DirEntry( FSYS2GUI(
                    String( getcwd( sBuf, sizeof( sBuf ) - 1 ) ) ) ) +
                *this;

    return IsAbs();
}

/*************************************************************************
|*
|*    DirEntry::GetVolume()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 04.03.92
|*    Letzte Aenderung  MI 04.03.92
|*
*************************************************************************/

String DirEntry::GetVolume() const
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

    const DirEntry *pTop = ImpGetTopPtr();

    if ( pTop->eFlag == FSYS_FLAG_ABSROOT ||
         pTop->eFlag == FSYS_FLAG_VOLUME )
    {
        const char *pVol;
        pVol = volumeid( (char*) pTop->aName.GetStr() );
        return FSYS2GUI( String( pVol ? pVol : "" ) );
    }

    return String();
}

/*************************************************************************
|*
|*    DirEntry::IsCaseSensitive()
|*
|*    Ersterstellung    BR 23.07.99
|*    Letzte Aenderung  BR 23.07.99
|*
*************************************************************************/

BOOL DirEntry::IsCaseSensitive( FSysPathStyle eFormatter ) const
{
    return FALSE;
}

/*************************************************************************
|*
|*    DirEntry::SetCWD()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 26.04.91
|*    Letzte Aenderung  MI 21.05.92
|*
*************************************************************************/

BOOL DirEntry::SetCWD( BOOL bSloppy )
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

    if ( eFlag == FSYS_FLAG_CURRENT && !aName.Len() )
        return TRUE;

    // wechseln zu UNC Pathnames geht leider nicht (wuerde ummappen)
    const DirEntry *pTop = ImpGetTopPtr();
    if ( ( pTop->eFlag == FSYS_FLAG_ABSROOT ) &&
         ( pTop->aName.Len() > 2 ) )
    {
        nError = FSYS_ERR_INVALIDDEVICE;
        return FALSE;
    }
    // Soll auch das Laufwerk gewechselt werden?
    FSysFailOnErrorImpl();
    if ( ( pTop->aName.Len() == 2 && pTop->aName[ (USHORT) 1 ] == ':' ) &&
         ( ( pTop->eFlag == FSYS_FLAG_ABSROOT ) ||
           ( pTop->eFlag == FSYS_FLAG_RELROOT ) ||
           ( pTop->eFlag == FSYS_FLAG_VOLUME ) ) )
    {
        unsigned nNeu;
        unsigned nAnzahl; // fuer DOSSTCI
        unsigned nNummer = GetDevice().GetName()(0) - 'a' + 1;

        setdrive( nNummer, &nAnzahl );
        GETDRIVE( nNeu );
        if ( nNeu != nNummer )
        {
            nError = FSYS_ERR_INVALIDDEVICE;
            return FALSE;
        }
    }

    if ( ( eFlag == FSYS_FLAG_CURRENT ) || !chdir( GUI2FSYS( GetFull() ) ) ||
         ( bSloppy && pParent && !chdir( GUI2FSYS( pParent->GetFull() ) ) ) )
        return TRUE;
    else
        nError = FSYS_ERR_NOTADIRECTORY;

    return FALSE;
}

//-------------------------------------------------------------------------

USHORT DirReader_Impl::Init()
{
    USHORT nRead = 0;
    if ( pDir->eAttrMask & FSYS_KIND_BLOCK )
    {
        DirEntry aCurrentDir;
        aCurrentDir.ToAbs();
        char sDrive[3] = "?:";

        // Was ist mit Laufwerk b:?
#if !defined(W30)
        // pure DOS
        if ( pDir->aNameMask.Matches( String( "a:" ) ) )
            pDir->pLst->Insert( new DirEntry( String( "a:" ) ), LIST_APPEND );
#endif
        for ( char c = START_DRV; c <= 'z'; c++ )
        {
            sDrive[0] = c;
            DirEntry* pDrive = new DirEntry(
                sDrive, FSYS_FLAG_VOLUME, FSYS_STYLE_HOST );
            if ( pDir->aNameMask.Matches( sDrive ) && DRIVE_EXISTS( c ) )
            {
                if ( pDir->pStatLst ) //Status fuer Sort gewuenscht?
                {
                    FileStat *pNewStat = new FileStat( *pDrive );
                    pDir->ImpSortedInsert( pDrive, pNewStat );
                }
                else
                    pDir->ImpSortedInsert( pDrive, NULL );
                ++nRead;
            }
            else
                delete pDrive;
        }
    }
    return nRead;
}

//-------------------------------------------------------------------------

USHORT DirReader_Impl::Read()
{
    // Directories und Files auflisten?
    if ( ( pDir->eAttrMask & FSYS_KIND_DIR || pDir->eAttrMask & FSYS_KIND_FILE ) &&
         ( ( pDosEntry = readdir( pDosDir ) ) != NULL ) )
    {
        String aEntryName( CMP_LOWER( FSYS2GUI( (const char*) pDosEntry->d_name ) ) );
        BOOL bIsDirAndWantsDir =
                ( ( pDir->eAttrMask & FSYS_KIND_DIR ) &&
                    ( pDosEntry->d_type & DOS_DIRECT ) );
        BOOL bIsFileAndWantsFile =
                ( ( pDir->eAttrMask & FSYS_KIND_FILE ) &&
                    !( pDosEntry->d_type & DOS_DIRECT ) &&
                    !( pDosEntry->d_type & DOS_VOLUMEID ) );

        if ( ( bIsDirAndWantsDir || bIsFileAndWantsFile ) &&
                pDir->aNameMask.Matches( aEntryName ) )
        {
#ifdef DBG_UTIL
            DbgOutf( "%s %s flags:%x",
                pDosEntry->d_name,
                bIsFileAndWantsFile ? "file" : "dir",
                pDosEntry->d_type );
#endif

            // DirEntry fuer den Eintrag erzeugen
            DirEntryFlag eFlag =
                    0 == strcmp( aEntryName.GetStr(), "." ) ? FSYS_FLAG_CURRENT
                :   0 == strcmp( aEntryName.GetStr(), ".." ) ? FSYS_FLAG_PARENT
                :   FSYS_FLAG_NORMAL;
            DirEntry *pTemp = new DirEntry( aEntryName,
                                            eFlag, FSYS_STYLE_NTFS );
            if ( pParent )
                pTemp->ImpChangeParent( new DirEntry( *pParent ), FALSE );
            if ( pDir->pStatLst ) //Status fuer Sort gewuenscht?
            {
                FileStat *pNewStat = new FileStat( (void*) pDosDir, (void*) 0 );
                pDir->ImpSortedInsert( pTemp, pNewStat );
            }
            else
                pDir->ImpSortedInsert( pTemp, NULL );
            return 1;
        }
    }
    else
        bReady = TRUE;
    return 0;
}

/*************************************************************************
|*
|*    FileStat::FileStat()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 05.11.91
|*    Letzte Aenderung  MA 07.11.91
|*
*************************************************************************/

FileStat::FileStat( const void *pInfo,      // struct dirent
                    const void * ):         // dummy
	aDateCreated(0),
	aTimeCreated(0),
	aDateModified(0),
	aTimeModified(0),
	aDateAccessed(0),
	aTimeAccessed(0)
{
    struct dirent *pDirent = (struct dirent*) pInfo;
    nSize = pDirent->d_size;

    aDateCreated  = MsDos2Date( pDirent->d_date );
    aTimeCreated  = MsDos2Time( pDirent->d_time );
    aDateModified = aDateModified;
    aTimeModified = aTimeModified;
    aDateAccessed = aDateModified;
    aTimeAccessed = aTimeModified;

    nKindFlags = FSYS_KIND_FILE;
    if ( pDirent->d_type & DOS_DIRECT )
        nKindFlags = FSYS_KIND_DIR;
}

/*************************************************************************
|*
|*    FileStat::Update()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 11.06.91
|*    Letzte Aenderung  MA 07.11.91
|*
*************************************************************************/

#if defined(WIN) && defined(MSC)
#pragma optimize("", off)

static BOOL NEAR PASCAL IsCDROMDrive(WORD wDrive)
{
    int bCD;

    _asm
    {
        mov ax, 1500h
        xor bx, bx
        int 2fh
        mov ax, bx
        or ax, ax
        jz no_mscdex
        mov ax, 150bh
        mov cx, wDrive
        int 2fh
    no_mscdex:
        mov bCD, ax
    }

    return (BOOL) bCD;
}

#pragma optimize("", on)

#else
#define IsCDROMDrive(w) FALSE
#endif

BOOL FileStat::Update( const DirEntry& rDirEntry, BOOL bAccessRemovableDevice )
{
DBG_TRACE1( "FileStat::Upate( %s )", rDirEntry.GetFull().GetStr() );
    nSize = 0;
    FSysPathStyle eStyle = FSYS_STYLE_UNKNOWN;
    nKindFlags = 0;
    aCreator.Erase();
    aType.Erase();
    aDateCreated = Date(0);
    aTimeCreated = Time(0);
    aDateModified = Date(0);
    aTimeModified = Time(0);
    aDateAccessed = Date(0);
    aTimeAccessed = Time(0);

    if ( !rDirEntry.IsValid() )
    {
        nError = FSYS_ERR_UNKNOWN;
        DBG_TRACE( "FileStat::Upate => unknown" );
        return FALSE;
    }

    // Sonderbehandlung falls es sich um eine Wildcard handelt
    String aTempName( rDirEntry.GetName() );
    if ( strchr( (char*) (const char*) aTempName, '?' ) ||
         strchr( (char*) (const char*) aTempName, '*' ) ||
         strchr( (char*) (const char*) aTempName, ';' ) )
    {
        nKindFlags = FSYS_KIND_WILD;
        nError = FSYS_ERR_OK;
        DBG_TRACE( "FileStat::Upate => wild" );
        return TRUE;
    }

    // Sonderbehandlung falls es sich um eine Root handelt
    if ( rDirEntry.eFlag == FSYS_FLAG_ABSROOT ||
         rDirEntry.eFlag == FSYS_FLAG_RELROOT )
        nKindFlags = FSYS_KIND_DIR;

#if defined(WIN) || defined(W30) || defined(W31)

    // keine Error-Boxen anzeigen
    FSysFailOnErrorImpl();

    // ist ein Medium im Laufwerk?
    HACK(wie?)
    BOOL bAccess = TRUE;
    const DirEntry *pTop = rDirEntry.ImpGetTopPtr();
    String aName( pTop->aName.Lower() );
    if ( !bAccessRemovableDevice &&
            ( pTop->eFlag == FSYS_FLAG_ABSROOT ||
            pTop->eFlag == FSYS_FLAG_RELROOT ||
            pTop->eFlag == FSYS_FLAG_VOLUME ) )
        if ( aName == "a:" || aName == "b:" )
            bAccess = FALSE;
        else
            DBG_TRACE( "FSys: will access removable device!" );
    if ( bAccess && ( aName == "a:" || aName == "b:" ) )
        DBG_ERROR( "floppy will clatter" );

    // Sonderbehandlung, falls es sich um ein Volume handelt
    if ( rDirEntry.eFlag == FSYS_FLAG_VOLUME )
		// MI: nicht die folgenden da Existenz von a: nicht Existenz von a:\
		// impliziert (Laufwerk ohne Medium)
	    // rDirEntry.eFlag == FSYS_FLAG_ABSROOT ||
		// rDirEntry.eFlag == FSYS_FLAG_RELROOT )
    {
        nKindFlags = FSYS_KIND_DEV |
            ( rDirEntry.aName.Len() == 2 ? FSYS_KIND_BLOCK : FSYS_KIND_CHAR );

        if ( !bAccess )
        {
            nKindFlags |= FSYS_KIND_REMOVEABLE;
            nError = FSYS_ERR_NOTEXISTS;
            DBG_TRACE( "FileStat::Upate => notexists" );
            return FALSE;
        }

        USHORT nDriveNo = rDirEntry.aName[ (USHORT) 0 ] - 'a';
        USHORT nType = GetDriveType( nDriveNo );
        if ( nType == 1 || nType == 0 )
        {
            nError = FSYS_ERR_NOTEXISTS;
            DBG_TRACE( "FileStat::Upate => notexists" );
            return FALSE;
        }
        if ( IsCDROMDrive(nDriveNo) )
            nKindFlags = nKindFlags | FSYS_KIND_REMOVEABLE | FSYS_KIND_CDROM;
        else
            nKindFlags = nKindFlags |
                 ( ( nType == DRIVE_REMOVABLE ) ? FSYS_KIND_REMOVEABLE : 0 ) |
                 ( ( nType == DRIVE_FIXED     ) ? FSYS_KIND_FIXED      : 0 ) |
                 ( ( nType == DRIVE_REMOTE    ) ? FSYS_KIND_REMOTE     : 0 );
        nError = FSYS_ERR_OK;

        // determine type of file-system
        eStyle = FSYS_STYLE_FAT;
        DBG_TRACE( "FileStat::Upate => volume" );
        return 0 == nError;
    }

#else

    // Sonderbehandlung, falls es sich um ein Volume handelt
    if ( rDirEntry.eFlag == FSYS_FLAG_VOLUME )
        nKindFlags = nKindFlags | FSYS_KIND_DEV |
                 ( rDirEntry.aName.Len() == 2 ? FSYS_KIND_BLOCK : FSYS_KIND_CHAR );
    else

#endif

    {
        // Statusinformation vom Betriebssystem holen
        struct stat aStat;
        char*       p;

        String aFullName( GUI2FSYS( rDirEntry.GetFull() ) );
        p = (char *) aFullName.GetStr();

        if ( stat( p, &aStat ) )
        {
            nError = FSYS_ERR_NOTEXISTS;
            nKindFlags = FSYS_KIND_UNKNOWN;
            DBG_TRACE( "FileStat::Upate => unknown" );
            return FALSE;
        }

        nError = FSYS_ERR_OK;
        nSize = aStat.st_size;

        BOOL bDetermined = FALSE;

        if ( aStat.st_mode & S_IFDIR )
            nKindFlags = nKindFlags | FSYS_KIND_DIR,
            bDetermined = TRUE;
        if ( aStat.st_mode & S_IFREG )
            nKindFlags = nKindFlags | FSYS_KIND_FILE,
            bDetermined = TRUE;
        if ( !bDetermined )
            nKindFlags = nKindFlags | FSYS_KIND_FILE;

        aDateCreated  = MsDos2Date( &aStat.st_ctime );
        aTimeCreated  = MsDos2Time( &aStat.st_ctime );
        aDateModified = MsDos2Date( &aStat.st_mtime );
        aTimeModified = MsDos2Time( &aStat.st_mtime );
        aDateAccessed = MsDos2Date( &aStat.st_atime );
        aTimeAccessed = MsDos2Time( &aStat.st_atime );
    }

    DBG_TRACE( "FileStat::Upate => standard" );
    return TRUE;
}

Time MsDos2Time( const time_t *pTimeT )
{
    tm *pTm = localtime( pTimeT );
    if ( pTm )
        return Time( pTm->tm_hour, pTm->tm_min, pTm->tm_sec );
    else
        return Time(0);
}

Date MsDos2Date( const time_t *pTimeT )
{
    tm *pTm = localtime( pTimeT );
    if ( pTm )
        return Date( pTm->tm_mday, pTm->tm_mon + 1, 1900 + pTm->tm_year );
    else
        return Date(0);
}

const char *TempDirImpl( char *pBuf )
{
#ifdef WIN
    // dieser Code stammt aus der Hilfe zum Windows SDK (GetDOSEnvironment)
    LPSTR pEnv= GetDOSEnvironment();
    while (*pEnv != 0 )
    {
        USHORT nNameLen = strchr( pEnv, '=' ) - pEnv;
        BOOL bTempFound =
            !strncmp( pEnv, "TEMP", nNameLen ) ||
            !strncmp( pEnv, "TMP", nNameLen );
        struct _stat aStat;
        if ( bTempFound &&
             !_stat(pEnv+nNameLen+1, &aStat) && (aStat.st_mode & S_IFDIR) )
            return pEnv+nNameLen+1;

        // Move to the next environment string
        pEnv += strlen(pEnv) + 1;
    }

    // als letzte Chance das Windows-Directory
    if ( GetWindowsDirectory( pBuf, _MAX_PATH ) )
        return pBuf;
    return 0;
#else
    const char *pValue = getenv( "TEMP" );
    if ( !pValue )
        pValue = getenv( "TMP" );
    if ( pValue )
        strcpy( pBuf, pValue );
    else
        strcpy( pBuf, "c:\\" );
    return pBuf;
#endif
}

/*************************************************************************
|*
|*    DirEntry::GetPathStyle() const
|*
|*    Beschreibung
|*    Ersterstellung    MI 11.05.95
|*    Letzte Aenderung  MI 11.05.95
|*
*************************************************************************/

FSysPathStyle DirEntry::GetPathStyle( const String &rDevice )
{
    return FSYS_STYLE_FAT;
}

//=========================================================================

ErrCode FileStat::QueryDiskSpace( const String &rPath,
                                  BigInt &rFreeBytes, BigInt &rTotalBytes )
{
    return ERRCODE_IO_NOTSUPPORTED;
}

//=========================================================================


void FSysEnableSysErrorBox( BOOL bEnable )
{
    SetErrorMode( bEnable ? 0 : SEM_FAILCRITICALERRORS|SEM_NOOPENFILEERRORBOX );
}
