/*************************************************************************
 *
 *  $RCSfile: proxyconfig.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: sb $ $Date: 2001/08/08 10:04:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#ifndef _NEONURI_HXX_
#include "NeonUri.hxx"
#endif

#ifndef _PROXYCONFIG_HXX_
#include "proxyconfig.hxx"
#endif

using namespace webdav_ucp;
using namespace com::sun::star;

#define CONFIG_ROOT_KEY     "org.openoffice.Inet/Settings"
#define PROXY_TYPE_KEY      "ooInetProxyType"
#define NO_PROXY_LIST_KEY   "ooInetNoProxy"
#define HTTP_PROXY_NAME_KEY "ooInetHTTPProxyName"
#define HTTP_PROXY_PORT_KEY "ooInetHTTPProxyPort"
#define FTP_PROXY_NAME_KEY  "ooInetFTPProxyName"
#define FTP_PROXY_PORT_KEY  "ooInetFTPProxyPort"

namespace proxyconfig_impl
{

// A simple case ignoring wildcard matcher.
class WildCard
{
private:
    rtl::OString    aWildString;

public:
    WildCard( const rtl::OUString& rWildCard )
	: aWildString( rtl::OUStringToOString(
                    rWildCard, RTL_TEXTENCODING_UTF8 ).toAsciiLowerCase() ) {}

    bool Matches( const rtl::OUString & rStr ) const;
};

bool WildCard::Matches( const rtl::OUString& rString ) const
{
	rtl::OString aString
		= rtl::OUStringToOString(
                    rString, RTL_TEXTENCODING_UTF8 ).toAsciiLowerCase();
	const char * pStr  = aString.getStr();
	const char * pWild = aWildString.getStr();

    int    pos=0;
    int    flag=0;

    while ( *pWild || flag )
    {
        switch ( *pWild )
        {
            case '?':
                if ( *pStr == '\0' )
                    return 0;
                break;

            default:
                if ( ( *pWild == '\\' ) && ( ( *( pWild + 1 ) == '?' )
									    	 || ( *( pWild + 1 ) == '*') ) )
                    pWild++;
                if ( *pWild != *pStr )
                    if ( !pos )
                        return 0;
                    else
                        pWild += pos;
                else
                    break;

				// Note: fall-thru's are intended!

            case '*':
                while ( *pWild == '*' )
                    pWild++;
                if ( *pWild == '\0' )
                    return 1;
                flag = 1;
                pos  = 0;
                if ( *pStr == '\0' )
                    return ( *pWild == '\0' );
                while ( *pStr && *pStr != *pWild )
                {
                    if ( *pWild == '?' ) {
                        pWild++;
                        while ( *pWild == '*' )
                            pWild++;
                    }
                    pStr++;
                    if ( *pStr == '\0' )
                        return ( *pWild == '\0' );
                }
                break;
        }
        if ( *pWild != '\0' )
            pWild++;
        if ( *pStr != '\0' )
            pStr++;
        else
            flag = 0;
        if ( flag )
            pos--;
    }
    return ( *pStr == '\0' ) && ( *pWild == '\0' );
}

}

using namespace proxyconfig_impl;

//=========================================================================
//=========================================================================
//
// ProxySettings Implementation.
//
//=========================================================================
//=========================================================================

ProxySettings::ProxySettings(
			const uno::Reference< lang::XMultiServiceFactory > & rxSMgr )
: m_nProxyType( 0 )
{
	try
	{
		//////////////////////////////////////////////////////////////
		// Read proxy configuration from config db.
		//////////////////////////////////////////////////////////////

		uno::Reference< lang::XMultiServiceFactory > xConfigProv(
				rxSMgr->createInstance(
					rtl::OUString::createFromAscii(
						"com.sun.star.configuration.ConfigurationProvider" ) ),
				uno::UNO_QUERY );

		uno::Sequence< uno::Any > aArguments( 1 );
        aArguments[ 0 ] <<= rtl::OUString::createFromAscii( CONFIG_ROOT_KEY );

		uno::Reference< uno::XInterface > xInterface(
					xConfigProv->createInstanceWithArguments(
						rtl::OUString::createFromAscii(
							"com.sun.star.configuration.ConfigurationAccess" ),
					aArguments ) );

		OSL_ENSURE( xInterface.is(), "ProxySettings - No config access!" );

		if ( xInterface.is() )
		{
            uno::Reference< container::XNameAccess > xNameAccess(
											xInterface, uno::UNO_QUERY );
			OSL_ENSURE( xNameAccess.is(), "ProxySettings - No name access!" );

			if ( xNameAccess.is() )
			{
				try
				{
                    if ( !( xNameAccess->getByName(
                                rtl::OUString::createFromAscii(
                                    PROXY_TYPE_KEY ) ) >>= m_nProxyType ) )
					{
						OSL_ENSURE( sal_False,
									"ProxySettings - "
									"Error getting config item value!" );
					}
				}
                catch ( lang::WrappedTargetException const & )
				{
				}
                catch ( container::NoSuchElementException const & )
				{
				}

				rtl::OUString aNoProxyList;
				try
				{
                    if ( !( xNameAccess->getByName(
                                rtl::OUString::createFromAscii(
                                    NO_PROXY_LIST_KEY ) ) >>= aNoProxyList ) )
					{
						OSL_ENSURE( sal_False,
									"ProxySettings - "
									"Error getting config item value!" );
					}
				}
                catch ( lang::WrappedTargetException const & )
				{
				}
                catch ( container::NoSuchElementException const & )
				{
				}

				setNoProxyList( aNoProxyList );

				try
				{
                    if ( !( xNameAccess->getByName(
                                rtl::OUString::createFromAscii(
                                    HTTP_PROXY_NAME_KEY ) )
                            >>= m_aHttpProxy.aName ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - "
									"Error getting config item value!" );
					}
				}
                catch ( lang::WrappedTargetException const & )
				{
				}
                catch ( container::NoSuchElementException const & )
				{
				}

				m_aHttpProxy.nPort = -1;
				try
				{
                    uno::Any aValue = xNameAccess->getByName(
                            rtl::OUString::createFromAscii(
                                HTTP_PROXY_PORT_KEY ) );
					if ( aValue.hasValue() &&
					     !( aValue >>= m_aHttpProxy.nPort ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - "
									"Error getting config item value!" );
					}
				}
                catch ( lang::WrappedTargetException const & )
				{
				}
                catch ( container::NoSuchElementException const & )
				{
				}

				if ( m_aHttpProxy.nPort == -1 )
					m_aHttpProxy.nPort = 80; // standard HTTP port.

				try
				{
                    if ( !( xNameAccess->getByName(
                                rtl::OUString::createFromAscii(
                                    FTP_PROXY_NAME_KEY ) )
                            >>= m_aFtpProxy.aName ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - "
									"Error getting config item value!" );
					}
				}
                catch ( lang::WrappedTargetException const & )
				{
				}
                catch ( container::NoSuchElementException const & )
				{
				}

				m_aFtpProxy.nPort = -1;
				try
				{
                    uno::Any aValue = xNameAccess->getByName(
                            rtl::OUString::createFromAscii(
                                FTP_PROXY_PORT_KEY ) );
					if ( aValue.hasValue() &&
					     !( aValue >>= m_aFtpProxy.nPort ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - "
									"Error getting config item value!" );
					}
				}
                catch ( lang::WrappedTargetException const & )
				{
				}
                catch ( container::NoSuchElementException const & )
				{
				}
			}

			// Register as listener for config changes.

			m_xNotifier	= uno::Reference< util::XChangesNotifier >(
												xInterface, uno::UNO_QUERY );

			OSL_ENSURE( m_xNotifier.is(), "ProxySettings - No notifier!" );

			if ( m_xNotifier.is() )
				m_xNotifier->addChangesListener( this );
		}
	}
	catch ( uno::Exception& )
	{
		// createInstance, createInstanceWithArguments
		OSL_ENSURE(	sal_False, "ProxySettings - Exception!" );
	}
};

//=========================================================================
ProxySettings::~ProxySettings()
{
}

//=========================================================================
void ProxySettings::dispose()
{
	osl::Guard< osl::Mutex > aGuard( m_aMutex );

	if ( m_xNotifier.is() )
	{
		m_xNotifier->removeChangesListener( this );
		m_xNotifier = 0;
	}
}

//=========================================================================
void ProxySettings::setNoProxyList( const rtl::OUString & rNoProxyList )
{
	m_aNoProxyList.clear();

	if ( rNoProxyList.getLength() )
	{
		// List of connection endpoints hostname[:port],
		// separated by semicolon. Wilcards allowed.

		sal_Int32 nPos = 0;
		sal_Int32 nEnd = rNoProxyList.indexOf( ';' );
		sal_Int32 nLen = rNoProxyList.getLength();

		do
		{
			if ( nEnd == -1 )
				nEnd = nLen;

			rtl::OUString aToken = rNoProxyList.copy( nPos, nEnd - nPos );

			if ( aToken.getLength() )
				m_aNoProxyList.push_back( aToken );

			if ( nEnd != nLen )
			{
				nPos = nEnd + 1;
				nEnd = rNoProxyList.indexOf( ';', nPos );
			}
		}
		while ( nEnd != nLen );
	}
}

//=========================================================================
const ProxyConfig & ProxySettings::getProxy( const rtl::OUString & inUri )
{
	osl::Guard< osl::Mutex > aGuard( m_aMutex );

	if ( m_nProxyType == 0 )
	{
		// Never use proxy.
		return m_aEmptyProxy;
	}

    NeonUri aURI( inUri );

	if ( m_aNoProxyList.size() )
	{
		std::vector< rtl::OUString >::const_iterator it
			= m_aNoProxyList.begin();
		std::vector< rtl::OUString >::const_iterator end
			= m_aNoProxyList.end();

        rtl::OUStringBuffer aBuffer( aURI.GetHost() );
		if ( aBuffer.getLength() )
		{
			aBuffer.append( sal_Unicode( ':' ) );
			aBuffer.append( rtl::OUString::valueOf( aURI.GetPort() ) );

			while ( it != end )
			{
				rtl::OUString aWildStr( *it );
				if ( aWildStr.indexOf( ':' ) == -1 )
					aWildStr += rtl::OUString::createFromAscii( ":*" );

				WildCard aWild( aWildStr );
				if ( aWild.Matches( rtl::OUString( aBuffer ) ) )
					return m_aEmptyProxy;

				it++;
			}
		}
	}

	if (aURI.GetScheme().equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("ftp")))
    {
        if (m_aFtpProxy.aName.getLength() > 0 && m_aFtpProxy.nPort >= 0)
            return m_aFtpProxy;
    }
    else if ( m_aHttpProxy.aName.getLength() )
		return m_aHttpProxy;

	return m_aEmptyProxy;
}

//////////////////////////////////////////////////////////////////////////
//
// XChangesListener methods.
//
//////////////////////////////////////////////////////////////////////////

// virtual
void SAL_CALL ProxySettings::changesOccurred( const util::ChangesEvent& Event )
	throw( uno::RuntimeException )
{
	sal_Int32 nCount = Event.Changes.getLength();
	if ( nCount )
	{
        const util::ElementChange* pElementChanges
            = Event.Changes.getConstArray();
		for ( sal_Int32 n = 0; n < nCount; ++n )
		{
			const util::ElementChange& rElem = pElementChanges[ n ];
			rtl::OUString aKey;
			if ( ( rElem.Accessor >>= aKey ) && aKey.getLength() )
			{
                if ( aKey.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(
                                                    PROXY_TYPE_KEY ) ) )
				{
					if ( !( rElem.Element >>= m_nProxyType ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - changesOccurred - "
									"Error getting config item value!" );
					}
				}
                else if ( aKey.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(
                                                    NO_PROXY_LIST_KEY ) ) )
				{
					rtl::OUString aNoProxyList;
					if ( !( rElem.Element >>= aNoProxyList ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - changesOccurred - "
									"Error getting config item value!" );
					}

					setNoProxyList( aNoProxyList );
				}
                else if ( aKey.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(
                                                    HTTP_PROXY_NAME_KEY ) ) )
				{
					if ( !( rElem.Element >>= m_aHttpProxy.aName ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - changesOccurred - "
									"Error getting config item value!" );
					}
				}
                else if ( aKey.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(
                                                    HTTP_PROXY_PORT_KEY ) ) )
				{
					if ( !( rElem.Element >>= m_aHttpProxy.nPort ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - changesOccurred - "
									"Error getting config item value!" );
					}

					if ( m_aHttpProxy.nPort == -1 )
						m_aHttpProxy.nPort = 80; // standard HTTP port.
				}
                else if ( aKey.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(
                                                    FTP_PROXY_NAME_KEY ) ) )
				{
					if ( !( rElem.Element >>= m_aFtpProxy.aName ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - changesOccurred - "
									"Error getting config item value!" );
					}
				}
                else if ( aKey.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM(
                                                    FTP_PROXY_PORT_KEY ) ) )
				{
					if ( !( rElem.Element >>= m_aFtpProxy.nPort ) )
					{
						OSL_ENSURE(	sal_False,
									"ProxySettings - changesOccurred - "
									"Error getting config item value!" );
					}
				}
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////
//
// XEventListener methods.
//
//////////////////////////////////////////////////////////////////////////

// virtual
void SAL_CALL ProxySettings::disposing( const lang::EventObject& Source )
	throw( uno::RuntimeException )
{
	osl::Guard< osl::Mutex > aGuard( m_aMutex );
	m_xNotifier = 0;
}
