/*************************************************************************
 *
 *  $RCSfile: certdlg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:04:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _DATETIME_HXX //autogen
#include <tools/datetime.hxx>
#endif
#ifndef _INETCERT_HXX
#include <inet/inetcert.hxx>
#endif

#include <stdio.h>

#include "certdlg.hxx"
#include "certpage.hxx"
#include "certctrl.hxx"

#include "certdlg.hrc"
#include "goodies.hrc"

// define ----------------------------------------------------------------

#define PAGE_OPEN   1
#define PAGE_SHOW   2
#define PAGE_ACCEPT 3
#define PAGE_WARN   4
#define PAGE_READY  5

#define PAGE_FIRST  (PAGE_OPEN)
#define PAGE_LAST   (PAGE_READY)

// struct CtrlImpl -------------------------------------------------------

struct CtrlImpl
{
	FixedBitmap  aSSLLogo;
	FixedLine    aDelim;
	CancelButton aCancelBtn;
	PushButton   aPBNext;
	PushButton   aPBBack;
	String       aPBTextNext;
	String       aPBTextReady;

	CtrlImpl( Window* pParent ) :
		aSSLLogo		( pParent,	ResId( BMP_SSLLOGO ) ),
		aDelim			( pParent,	ResId( FL_DELIM ) ),
		aCancelBtn		( pParent,	ResId( BTN_CANCEL ) ),
		aPBNext			( pParent,	ResId( PB_NEXT ) ),
		aPBBack			( pParent,	ResId( PB_BACK ) ),
		aPBTextNext		( 			ResId( STR_PB_NEXT ) ),
		aPBTextReady	( 			ResId( STR_PB_Ready ) )
	{}
};

// class CertAcceptDialog ------------------------------------------------

CertAcceptDialog::CertAcceptDialog( Window* pParent, ResMgr* pResMgr, const INetCoreCertificate& rCert ) :

	ModalDialog( pParent, ResId( DLG_SSL_NEWCERT, pResMgr ) ),

	m_rCert			( rCert ),
	m_pResMgr		( pResMgr ),
	m_pImpl			( new CtrlImpl( this ) ),
	m_pActPage		( NULL ),
	m_nActPage		( 1 ),
	m_nAcceptState	( ACCEPT_ONCE ),
	m_bWarning		( FALSE )

{
	FreeResource();

	m_pImpl->aPBNext.SetClickHdl( LINK(this, CertAcceptDialog, ClickHdl) );
	m_pImpl->aPBBack.SetClickHdl( LINK(this, CertAcceptDialog, ClickHdl) );
	m_pImpl->aPBBack.Disable();

	SetActPage();
	UpdateButton();
}

// -----------------------------------------------------------------------

CertAcceptDialog::~CertAcceptDialog()
{
	delete m_pActPage;
	delete m_pImpl;
}

// -----------------------------------------------------------------------

void CertAcceptDialog::SetActPage()
{
	Window* pNewPg = NULL;

	switch( m_nActPage )
	{
		case PAGE_OPEN:
		{
			OpenPage* pNew = new OpenPage( this, m_pResMgr );
			pNew->SetServerName( pNew->GetTextToReplace() );
			pNewPg = pNew;
			break;
		}

		case PAGE_SHOW:
		{
			ShowCertPage* pNew = new ShowCertPage( this, m_pResMgr );
			pNew->SetServerName( pNew->GetTextToReplace() );
			pNewPg = pNew;
			break;
		}

		case PAGE_ACCEPT:
		{
			AcceptCertPage* pNew = new AcceptCertPage( this, m_pResMgr );
			pNew->SetServerName( pNew->GetTextToReplace() );
			pNewPg = pNew;
			break;
		}

		case PAGE_WARN:
		{
			WarnCertPage* pNew = new WarnCertPage( this, m_pResMgr );
			pNew->SetServerName( pNew->GetTextToReplace() );
			pNewPg = pNew;
			break;
		}

		case PAGE_READY:
		{
			ReadyCertPage* pNew = new ReadyCertPage( this, m_pResMgr );
			pNewPg = pNew;
			break;
		}
	}

	DBG_ASSERT( pNewPg, "Konnte Assistenten Page nicht anlegen!" );
	if( pNewPg )
	{
		delete m_pActPage;
		m_pActPage = pNewPg;
		m_pActPage->Show();
	}
}

// -----------------------------------------------------------------------

void CertAcceptDialog::UpdateButton()
{
	if ( m_nActPage == PAGE_FIRST )
	{
		m_pImpl->aPBBack.Disable();
		m_pImpl->aPBNext.Enable();
		m_pImpl->aPBNext.SetText( m_pImpl->aPBTextNext );
	}
	else if ( ( m_nActPage > PAGE_FIRST ) && ( m_nActPage < PAGE_LAST ) )
	{
		m_pImpl->aPBBack.Enable();
		m_pImpl->aPBNext.Enable();
		m_pImpl->aPBNext.SetText( m_pImpl->aPBTextNext );
	}
	else
	{
		m_pImpl->aPBBack.Enable();
		m_pImpl->aPBNext.SetText( m_pImpl->aPBTextReady );
		m_pImpl->aPBNext.Enable();
	}
}

// -----------------------------------------------------------------------

IMPL_LINK( CertAcceptDialog, ClickHdl, Control*, pCtrl )
{
	if ( ( pCtrl == &(m_pImpl->aPBBack) ) && ( m_nActPage > PAGE_FIRST ) )
	{
		if ( ( m_nActPage == PAGE_LAST ) && ( m_nAcceptState == ACCEPT_NONE ) )
			m_nActPage = PAGE_ACCEPT;
		else if ( m_nActPage > PAGE_FIRST )
			m_nActPage--;
	}
	else
	{
		if ( m_nActPage == PAGE_LAST )
		{
			if ( m_nAcceptState == ACCEPT_EVER )
				EndDialog( ACCEPT_EVER );
			else if ( m_nAcceptState == ACCEPT_ONCE )
				EndDialog( ACCEPT_ONCE );
			else
				EndDialog( ACCEPT_NONE );
		}
		else if ( ( m_nActPage == PAGE_ACCEPT ) && ( m_nAcceptState == ACCEPT_NONE ) )
			m_nActPage = PAGE_READY;
		else
			m_nActPage++;
	}

	UpdateButton();
	SetActPage();
	return 1;
}

// class CertDetailDialog ------------------------------------------------

CertDetailDialog::CertDetailDialog( Window* pParent, ResMgr* pResMgr, const INetCoreCertificate &rCert ) :

	ModalDialog( pParent, ResId( DLG_SSL_INFCERT, pResMgr ) ),

	m_rCert		( rCert ),
	m_pResMgr	( pResMgr ),
	m_pInfoWin	( NULL ),
	m_pEditWin	( NULL ),
	m_aOKBtn	( this, ResId( BTN_OK ) ),
	m_aFromStr	(		ResId( STR_FROM ) ),
	m_aToStr	(		ResId( STR_TO ) )

{
	FreeResource();

	m_pInfoWin = new CertDetailWindow (this, m_pResMgr);

	String aTemp;
	String aDispStr;

	m_rCert.GetIssuerName( aTemp );
	aDispStr = ParseParam( "OU=", aTemp );
	aDispStr += "\n";
	aDispStr += ParseParam( "O=", aTemp );
	aDispStr += "\n";
	aDispStr += ParseParam( "C=", aTemp );
	m_pInfoWin->SetIssuedBy( aDispStr );

	m_rCert.GetSubjectName( aTemp );
	aDispStr = ParseParam( "OU=", aTemp );
	aDispStr += "\n";
	aDispStr += ParseParam( "O=", aTemp );
	aDispStr += "\n";
	aDispStr += ParseParam( "C=", aTemp );
	m_pInfoWin->SetOwner( aDispStr );

	USHORT nLen;
	char aBuf[2];
	const BYTE* pSerial = m_rCert.GetSerialNumber(nLen);
	aDispStr = "";
	for ( USHORT i = 0; i < nLen; ++i )
	{
		sprintf( aBuf, "%02X", pSerial[i] );
		aDispStr += aBuf;
		aDispStr += ":";
	}
	if( aDispStr.Len() > 2 )
		aDispStr.Erase( aDispStr.Len()-1 );
	m_pInfoWin->SetFinger( aDispStr );

	FormatTable	aFormat;
	DateTime aFrom( Date(0), Time(0) ), aTo( Date(0), Time(0) );
	m_rCert.GetValidity( aFrom, aTo );
	aDispStr = m_aFromStr;

	switch ( aFormat.GetDateFormat() )
	{
		case MDY:
			aDispStr += aFrom.GetMonth();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aFrom.GetDay();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aFrom.GetYear();
			aDispStr += m_aToStr;
			aDispStr += aTo.GetMonth();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aTo.GetDay();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aTo.GetYear();
			break;
		case DMY:
			aDispStr += aFrom.GetDay();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aFrom.GetMonth();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aFrom.GetYear();
			aDispStr += m_aToStr;
			aDispStr += aTo.GetDay();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aTo.GetMonth();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aTo.GetYear();
			break;
		case YMD:
			aDispStr += aFrom.GetYear();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aFrom.GetMonth();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aFrom.GetDay();
			aDispStr += m_aToStr;
			aDispStr += aTo.GetYear();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aTo.GetMonth();
			aDispStr += aFormat.GetDateSep();
			aDispStr += aTo.GetDay();
			break;
	}

	m_pInfoWin->SetValid( aDispStr );
	m_pInfoWin->Show();
}

// -----------------------------------------------------------------------

CertDetailDialog::~CertDetailDialog (void)
{
	delete m_pInfoWin;
	delete m_pEditWin;
}

// -----------------------------------------------------------------------

void CertDetailDialog::ShowEditWindow (void)
{
	m_pEditWin = new CertDetailEdit( this, m_pResMgr );
	m_pEditWin->Show();
}

// -----------------------------------------------------------------------

String CertDetailDialog::ParseParam( const String& rParam, const String& rSrc )
{
	String aRet;
	USHORT nStartPos = rSrc.Search( rParam );
	USHORT nEndPos;

	if( nStartPos == STRING_NOTFOUND )
		return aRet;
	nStartPos += rParam.Len();
	nEndPos = rSrc.Search( ";", nStartPos );

	if( nEndPos == STRING_NOTFOUND )
		nEndPos = rSrc.Len();

	aRet = rSrc.Copy( nStartPos, nEndPos - nStartPos );
	return aRet;
}

