/*************************************************************************
 *
 *  $RCSfile: cursor.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 13:37:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_CURSOR_HXX
#define _SV_CURSOR_HXX

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

class AutoTimer;
struct ImplCursorData;
class Window;

// -----------------
// - Cursor-Styles -
// -----------------

#define CURSOR_SHADOW					((USHORT)0x0001)

// ----------
// - Cursor -
// ----------

class Cursor
{
private:
	ImplCursorData* mpData; 			// Interne Daten
	Window* 		mpWindow;			// Window (only for shadow cursor)
	long			mnSlant;			// Schraegstellung
	long			mnOffsetY;			// Offset fuer Rotation
	Size			maSize; 			// Groesse
	Point			maPos;				// Position
	short			mnOrientation;		// Rotation
	USHORT			mnStyle;			// Style
	BOOL			mbVisible;			// Ist Cursor sichtbar
	BOOL			mbDummy;			// Align

#if _SOLAR__PRIVATE
public:
#ifdef _SV_CURSOR_CXX
	void			ImplDraw();
	void			ImplRestore();
					DECL_LINK( ImplTimerHdl, AutoTimer* );
#endif
	void			ImplShow( BOOL bDrawDirect = TRUE );
	void			ImplHide();
	void			ImplNew();
#endif

public:
					Cursor();
					Cursor( const Cursor& rCursor );
					~Cursor();

	void			SetStyle( USHORT nStyle );
	USHORT			GetStyle() const { return mnStyle; }

	void			Show();
	void			Hide();
	BOOL			IsVisible() const { return mbVisible; }

	void			SetWindow( Window* pWindow );
	Window* 		GetWindow() const { return mpWindow; }

	void			SetPos( const Point& rNewPos );
	const Point&	GetPos() const { return maPos; }
	void			SetOffsetY( long mnOffsetY = 0 );
	long			GetOffsetY() const { return mnOffsetY; }

	void			SetSize( const Size& rNewSize );
	const Size& 	GetSize() const { return maSize; }
	void			SetWidth( long nNewWidth );
	long			GetWidth() const { return maSize.Width(); }
	void			SetHeight( long nNewHeight );
	long			GetHeight() const { return maSize.Height(); }

	void			SetSlant( long nSlant = 0 );
	long			GetSlant() const { return mnSlant; }

	void			SetOrientation( short nOrientation = 0 );
	short			GetOrientation() const { return mnOrientation; }

	Cursor& 		operator=( const Cursor& rCursor );
	BOOL			operator==( const Cursor& rCursor ) const;
	BOOL			operator!=( const Cursor& rCursor ) const
						{ return !(Cursor::operator==( rCursor )); }
};

#endif	// _SV_CURSOR_HXX
