/*************************************************************************
 *
 *  $RCSfile: splitwin.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SPLITWIN_HXX
#define _SV_SPLITWIN_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_DOCKWIN_HXX
#include <dockwin.hxx>
#endif

class Wallpaper;
struct ImplSplitSet;

// -----------------------
// - SplitWindowItemBits -
// -----------------------

typedef USHORT SplitWindowItemBits;

// -------------------------------
// - Bits fuer SplitWindow-Items -
// -------------------------------

#define SWIB_FIXED					((SplitWindowItemBits)0x0001)
#define SWIB_RELATIVESIZE			((SplitWindowItemBits)0x0002)
#define SWIB_PERCENTSIZE			((SplitWindowItemBits)0x0004)
#define SWIB_COLSET 				((SplitWindowItemBits)0x0008)
#define SWIB_INVISIBLE				((SplitWindowItemBits)0x0010)

// ---------------------
// - SplitWindow-Types -
// ---------------------

#define SPLITWINDOW_APPEND			((USHORT)0xFFFF)
#define SPLITWINDOW_ITEM_NOTFOUND	((USHORT)0xFFFF)

// ---------------
// - SplitWindow -
// ---------------

class SplitWindow : public DockingWindow
{
private:
	ImplSplitSet*		mpMainSet;
	ImplSplitSet*		mpBaseSet;
	ImplSplitSet*		mpSplitSet;
	long*				mpLastSizes;
	Rectangle			maDragRect;
	long				mnDX;
	long				mnDY;
	long				mnLeftBorder;
	long				mnTopBorder;
	long				mnRightBorder;
	long				mnBottomBorder;
	long				mnMaxSize;
	long				mnMouseOff;
	long				mnMStartPos;
	long				mnMSplitPos;
	WinBits 			mnWinStyle;
	WindowAlign 		meAlign;
	USHORT				mnSplitTest;
	USHORT				mnSplitPos;
	USHORT				mnMouseModifier;
	BOOL				mbDragFull:1,
						mbHorz:1,
						mbBottomRight:1,
						mbCalc:1,
						mbRecalc:1,
						mbInvalidate:1,
						mbSizeable:1,
						mbBorder:1,
						mbAutoHide:1,
						mbFadeIn:1,
						mbFadeOut:1,
						mbAutoHideIn:1,
						mbAutoHideDown:1,
						mbFadeInDown:1,
						mbFadeOutDown:1,
						mbAutoHidePressed:1,
						mbFadeInPressed:1,
						mbFadeOutPressed:1,
						mbFadeNoButtonMode:1,
						mbNoAlign:1,
						mbDummy2:1,
						mbDummy3:1,
						mbDummy4:1;
	Link				maStartSplitHdl;
	Link				maSplitHdl;
	Link				maSplitResizeHdl;
	Link				maAutoHideHdl;
	Link				maFadeInHdl;
	Link				maFadeOutHdl;

#ifdef _SV_SPLITWIN_CXX
	void				ImplInit( Window* pParent, WinBits nStyle );
	void				ImplInitSettings();
	void				ImplCalcLayout();
	void				ImplUpdate();
	void				ImplUpdateSet( ImplSplitSet* pSet );
	void				ImplSetWindowSize( long nDelta );
	void				ImplSplitMousePos( Point& rMousePos );
	void				ImplGetButtonRect( Rectangle& rRect, long nEx, BOOL bTest ) const;
	void				ImplGetAutoHideRect( Rectangle& rRect, BOOL bTest = FALSE ) const;
	void				ImplGetFadeInRect( Rectangle& rRect, BOOL bTest = FALSE ) const;
	void				ImplGetFadeOutRect( Rectangle& rRect, BOOL bTest = FALSE ) const;
	void				ImplDrawButtonRect( const Rectangle& rRect, long nSize );
	void				ImplDrawAutoHide( BOOL bInPaint );
	void				ImplDrawFadeIn( BOOL bInPaint );
	void				ImplDrawFadeOut( BOOL bInPaint );
	void				ImplNewAlign();
#endif

public:
						SplitWindow( Window* pParent, WinBits nStyle = 0 );
						SplitWindow( Window* pParent, const ResId& rResId );
						~SplitWindow();

	virtual void		StartSplit();
	virtual void		Split();
	virtual void		SplitResize();
	virtual void		AutoHide();
	virtual void		FadeIn();
	virtual void		FadeOut();

	virtual void		MouseButtonDown( const MouseEvent& rMEvt );
	virtual void		MouseMove( const MouseEvent& rMEvt );
	virtual void		Tracking( const TrackingEvent& rTEvt );
	virtual void		Paint( const Rectangle& rRect );
	virtual void		Move();
	virtual void		Resize();
	virtual void		RequestHelp( const HelpEvent& rHEvt );
	virtual void		StateChanged( StateChangedType nType );
	virtual void		DataChanged( const DataChangedEvent& rDCEvt );

	void				InsertItem( USHORT nId, Window* pWindow, long nSize,
									USHORT nPos = SPLITWINDOW_APPEND, USHORT nSetId = 0,
									SplitWindowItemBits nBits = 0 );
	void				InsertItem( USHORT nId, long nSize,
									USHORT nPos = SPLITWINDOW_APPEND, USHORT nSetId = 0,
									SplitWindowItemBits nBits = 0 );
	void				MoveItem( USHORT nId, USHORT nNewPos, USHORT nNewSetId = 0 );
	void				RemoveItem( USHORT nId, BOOL bHide = TRUE );
	void				Clear();

	void				SetBaseSet( USHORT nSetId = 0 );
	USHORT				GetBaseSet() const;

	void				SetSplitSize( USHORT nSetId, long nSplitSize,
									  BOOL bWithChilds = FALSE );
	long				GetSplitSize( USHORT nSetId ) const;
	void				SetItemBackground( USHORT nSetId );
	void				SetItemBackground( USHORT nSetId, const Wallpaper& rWallpaper );
	Wallpaper			GetItemBackground( USHORT nSetId ) const;
	BOOL				IsItemBackground( USHORT nSetId ) const;
#ifndef NOOLDSV
	void				SetItemBrush( USHORT nSetId, const Brush& rBrush );
	Brush				GetItemBrush( USHORT nSetId ) const;
#endif
	void				SetItemBitmap( USHORT nSetId, const Bitmap& rBitmap );
	Bitmap				GetItemBitmap( USHORT nSetId ) const;

	void				SplitItem( USHORT nId, long nNewSize,
								   BOOL bPropSmall = FALSE,
								   BOOL bPropGreat = FALSE );
	void				SetItemSize( USHORT nId, long nNewSize );
	long				GetItemSize( USHORT nId ) const;
	long				GetItemSize( USHORT nId, SplitWindowItemBits nBits ) const;
	void				SetItemBits( USHORT nId, SplitWindowItemBits nNewBits );
	SplitWindowItemBits GetItemBits( USHORT nId ) const;
	Window* 			GetItemWindow( USHORT nId ) const;
	USHORT				GetSet( USHORT nId ) const;
	BOOL				GetSet( USHORT nId, USHORT& rSetId, USHORT& rPos ) const;
	USHORT				GetItemId( Window* pWindow ) const;
	USHORT				GetItemId( const Point& rPos ) const;
	USHORT				GetItemPos( USHORT nId, USHORT nSetId = 0 ) const;
	USHORT				GetItemId( USHORT nPos, USHORT nSetId = 0 ) const;
	USHORT				GetItemCount( USHORT nSetId = 0 ) const;
	BOOL				IsItemValid( USHORT nId ) const;

	void				SetNoAlign( BOOL bNoAlign );
	BOOL				IsNoAlign() const { return mbNoAlign; }
	void				SetAlign( WindowAlign eNewAlign = WINDOWALIGN_TOP );
	WindowAlign 		GetAlign() const { return meAlign; }
	BOOL				IsHorizontal() const { return mbHorz; }

	BOOL				IsSplitting() const { return IsTracking(); }

	void				SetMaxSizePixel( long nNewMaxSize ) { mnMaxSize = nNewMaxSize; }
	long				GetMaxSizePixel() const { return mnMaxSize; }

	static Size 		CalcWindowSizePixel( const Size& rSize,
											 WindowAlign eAlign,
											 WinBits nWinStyle,
											 BOOL bExtra = FALSE );
	Size				CalcWindowSizePixel( const Size& rSize )
							{ return CalcWindowSizePixel( rSize, meAlign, mnWinStyle, (mbAutoHide || mbFadeOut) ); }

	void				ShowAutoHideButton( BOOL bShow = TRUE );
	BOOL				IsAutoHideButtonVisible() const { return mbAutoHide; }
	void				ShowFadeInHideButton( BOOL bShow = TRUE );
	void				ShowFadeInButton( BOOL bShow = TRUE ) { ShowFadeInHideButton( bShow ); }
	BOOL				IsFadeInButtonVisible() const { return mbFadeIn; }
	void				ShowFadeOutButton( BOOL bShow = TRUE );
	BOOL				IsFadeOutButtonVisible() const { return mbFadeOut; }
	long				GetFadeInSize() const;
	BOOL				IsFadeNoButtonMode() const { return mbFadeNoButtonMode; }

	void				SetAutoHideState( BOOL bAutoHide );
	BOOL				GetAutoHideState() const { return mbAutoHideIn; }

	Rectangle			GetAutoHideRect() const;
	Rectangle			GetFadeInRect() const;
	Rectangle			GetFadeOutRect() const;

	void				SetStartSplitHdl( const Link& rLink ) { maStartSplitHdl = rLink; }
	const Link& 		GetStartSplitHdl() const { return maStartSplitHdl; }
	void				SetSplitHdl( const Link& rLink ) { maSplitHdl = rLink; }
	const Link& 		GetSplitHdl() const { return maSplitHdl; }
	void				SetSplitResizeHdl( const Link& rLink ) { maSplitResizeHdl = rLink; }
	const Link& 		GetSplitResizeHdl() const { return maSplitResizeHdl; }
	void				SetAutoHideHdl( const Link& rLink ) { maAutoHideHdl = rLink; }
	const Link& 		GetAutoHideHdl() const { return maAutoHideHdl; }
	void				SetFadeInHdl( const Link& rLink ) { maFadeInHdl = rLink; }
	const Link& 		GetFadeInHdl() const { return maFadeInHdl; }
	void				SetFadeOutHdl( const Link& rLink ) { maFadeOutHdl = rLink; }
	const Link& 		GetFadeOutHdl() const { return maFadeOutHdl; }
};

#ifndef NOOLDSV
inline void SplitWindow::SetItemBrush( USHORT nSetId, const Brush& rBrush )
{
	if ( rBrush.GetStyle() == BRUSH_NULL )
		SetItemBackground( nSetId );
	else
		SetItemBackground( nSetId, Wallpaper( rBrush.GetColor() ) );
}

inline Brush SplitWindow::GetItemBrush( USHORT nSetId ) const
{
	if ( IsItemBackground( nSetId ) )
		return Brush( GetItemBackground( nSetId ).GetColor() );
	else
		return Brush( BRUSH_NULL );
}
#endif

#endif	// _SV_SPLITWIN_HXX
