/*************************************************************************
 *
 *  $RCSfile: stacktrace.cxx,v $
 *
 *  $Revision: 1.7.4.1 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/27 14:39:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <salunx.h>
#include <saldata.hxx>
#include <saldisp.hxx>
#include <stacktrace.hxx>
#include <tools/urlobj.hxx>
#include <strhelper.hxx>
#include <stdio.h>
#include <string.h>

#ifdef LINUX
#define __USE_GNU // for dladdr
#endif
#include <dlfcn.h>
#ifdef LINUX
#undef __USE_GNU
#endif

#if defined IRIX
#include <rld_interface.h>
#ifndef _RLD_INTERFACE_DLFCN_H_DLADDR
#define _RLD_INTERFACE_DLFCN_H_DLADDR
typedef struct DL_INFO {
	const char * dli_fname;
	void       * dli_fbase;
	const char * dli_sname;
	void       * dli_saddr;
	int          dli_version;
	int          dli_reserved1;
	long         dli_reserved[4];
} Dl_info;
#endif
#define _RLD_DLADDR             14
int dladdr(void *address, Dl_info *dl);

int dladdr(void *address, Dl_info *dl)
{
	void *v;
	v = _rld_new_interface(_RLD_DLADDR,address,dl);
	return (int)v;
}
#endif

#if defined SOLARIS || ( defined(NETBSD) && defined(SPARC) )
#ifdef GCC
inline void* sal_getFP()
{
	volatile void* fp = NULL;
	__asm__ __volatile ("st %%fp, %0\n" : "=m"(fp) );
	return fp;
}
#else
extern "C" void* sal_getFP();
#endif
#elif (defined LINUX && defined INTEL) || defined FREEBSD
inline void* sal_getFP()
{
  void* fp;
  __asm__ __volatile  ("movl %%ebp,%%eax\n" : "=a" (fp));
  return fp;
}
#elif defined LINUX && defined POWERPC
inline void* sal_getFP()
{
  void* fp;
  __asm__ __volatile__ ( "or %0,1,1" : "=r" (fp) : /* no inputs */ );
  return fp;
}
#else
inline void* sal_getFP() { return NULL; }
#endif

#if defined SPARC
inline void* nextFrame( void* pFrame )
{
	return ((void**)pFrame)[14];
}
inline void* getPC( void* pFrame )
{
	return ((void**)pFrame)[15];
}
#elif defined INTEL
inline void* nextFrame( void* pFrame )
{
	return ((void**)pFrame)[0];
}
inline void* getPC( void* pFrame )
{
	return ((void**)pFrame)[1];
}
#elif defined LINUX && defined POWERPC
inline void* nextFrame( void* pFrame )
{
	return ((void**)pFrame)[0];
}
inline void* getPC( void* pFrame )
{
	return ((void**)pFrame)[1];
}
#else
inline void* nextFrame( void* pFrame )
{
	return NULL;
}
inline void* getPC( void* pFrame )
{
	return NULL;
}
#endif



static ByteString fprintFrame( void* pFrame )
{
	ByteString aRet;
	char buffer[ 256 ];

	void* PC = getPC( pFrame );
#if !defined(MACOSX)
	Dl_info aInfo;
	if( dladdr( PC, & aInfo ) )
	{
		sprintf( buffer, "ip=\"0x%08p\"", aInfo.dli_saddr );
		aRet += buffer;
		aRet += " mapentry=\"";
		aRet += aInfo.dli_sname;
		aRet += "\" file=\"";
		INetURLObject aObject( String( aInfo.dli_fname, strlen( aInfo.dli_fname ), gsl_getSystemTextEncoding() ), INetURLObject::FSYS_UNX );
		aRet += ByteString( aObject.getName(), gsl_getSystemTextEncoding() );
		aRet += "\" path=\"";
		aObject.removeSegment();
		aRet += ByteString( aObject.PathToFileName(), gsl_getSystemTextEncoding() );
		aRet += "\"";
	}
	else
#endif
	{
		aRet = "ip=\"0x00000000\" mapentry=\"unknown\" file=\"unknown\" path=\"unknown\"";
	}
	return aRet;
}

void sal_PostMortem::generateStackTrace()
{
	m_aStackTrace = "<Stack type=\"";
#if defined LINUX 
#  if defined INTEL
	m_aStackTrace += "Linux x86";
#  elif defined POWERPC
	m_aStackTrace += "Linux PPC";
#  endif
#elif defined FREEBSD
	m_aStackTrace += "FreeBSD x86";
#elif defined SOLARIS && defined SPARC
	m_aStackTrace += "Solaris Sparc";
#elif defined SOLARIS && defined INTEL
	m_aStackTrace += "Solaris Intel";
#elif defined NETBSD
#  if defined SPARC
	m_aStackTrace += "NetBSD Sparc";
#  else
	m_aStackTrace += "NetBSD unknown";
#  endif
#else
	m_aStackTrace += "unknown";
#endif
	m_aStackTrace += "\">\n";

	void* FP = sal_getFP();
	
	ULONG nFrame = 0;
	while ( FP )
	{
		m_aStackTrace += "  <StackInfo pos=\"";
		m_aStackTrace += ByteString::CreateFromInt32( nFrame++ );
		m_aStackTrace += "\" ";
		m_aStackTrace += fprintFrame( FP );
		m_aStackTrace += "/>\n";
		FP = nextFrame( FP );
	}
	m_aStackTrace += "</Stack>\n\n";
}

void sal_PostMortem::generateGraphicsSystem()
{
	int i;

	if( GetSalData() )
	{
		SalDisplay* pSalDisplay = GetSalData()->GetDefDisp();
		if( pSalDisplay )
		{
			Display* pDisplay = pSalDisplay->GetDisplay();
			if( pDisplay )
			{
				m_aGraphicsSystem = "<GraphicsSystem xserverinfo=\"DISPLAY=";
				m_aGraphicsSystem += DisplayString( pDisplay );
				m_aGraphicsSystem += "\" vendor=\"";
				m_aGraphicsSystem += ServerVendor( pDisplay );
				m_aGraphicsSystem += "\" vendorrelease=\"";
				m_aGraphicsSystem += VendorRelease( pDisplay );
				m_aGraphicsSystem += "\" protocol=\"";
				m_aGraphicsSystem += ProtocolVersion( pDisplay );
				m_aGraphicsSystem += ".";
				m_aGraphicsSystem += ProtocolRevision( pDisplay );
				m_aGraphicsSystem += "\" screens=\"";
				m_aGraphicsSystem += ScreenCount( pDisplay );
				m_aGraphicsSystem += " (default=";
				m_aGraphicsSystem += DefaultScreen( pDisplay );
				m_aGraphicsSystem += ")\">\n  <Extensions>\n";
				int nExtensions;
				char** pExtensions = XListExtensions( pDisplay, &nExtensions );
				for( i = 0; i < nExtensions; i++ )
				{
					m_aGraphicsSystem += "    <Extension name=\"";
					m_aGraphicsSystem += pExtensions[i];
					m_aGraphicsSystem += "\"/>\n";
				}
				m_aGraphicsSystem += "  </Extensions>\n";
				// XFreeExtensionList( pExtensions );
				int nVisuals;
				char buffer[ 256 ];
				XVisualInfo aTemplate;
				XVisualInfo* pVInfos = XGetVisualInfo( pDisplay, 0, &aTemplate, &nVisuals );
				m_aGraphicsSystem += "  <Visuals selectedid=\"";
				sprintf( buffer, "0x%x", pSalDisplay->GetVisual()->GetVisualId() );
				m_aGraphicsSystem += buffer;
				m_aGraphicsSystem += "\">\n";
				
				for( i = 0; i < nVisuals; i++ )
				{
					char* vclass;
					switch( pVInfos[i].c_class )
					{
						case StaticGray:	vclass = "StaticGray";break;
						case GrayScale:		vclass = "GrayScale";break;
						case StaticColor:	vclass = "StaticColor";break;
						case PseudoColor:	vclass = "PseudoColor";break;
						case TrueColor:		vclass = "TrueColor";break;
						case DirectColor:	vclass = "DirectColor";break;
						default:			vclass = "unknown";break;
					}
					sprintf( buffer, "    <Visual id=\"0x%x\" depth=\"%d\" class=\"%s\" bitsperrgb=\"%d\" redmask=\"0x%x\" greenmask=\"0x%x\" bluemask=\"0x%x\"/>\n",
							 pVInfos[i].visualid,
							 pVInfos[i].depth,
							 vclass,
							 pVInfos[i].bits_per_rgb,
							 pVInfos[i].red_mask,
							 pVInfos[i].green_mask,
							 pVInfos[i].blue_mask );
					m_aGraphicsSystem += buffer;
				}
				// XFree( pVInfos );
				m_aGraphicsSystem += "  </Visuals>\n  <Fontpaths>\n";
				int nPaths;
				char** pFontPath = XGetFontPath( pDisplay, &nPaths );
				for( i = 0; i < nPaths; i++ )
				{
					m_aGraphicsSystem += "    <Fontpath name=\"";
					m_aGraphicsSystem += pFontPath[i];
					m_aGraphicsSystem += "\"/>\n";
				}
				m_aGraphicsSystem += "  </Fontpaths>\n";
				// XFreeFontPath( pFontPath );
				m_aGraphicsSystem += "</GraphicsSystem>\n\n";
			}
		}
	}
}

#if defined SOLARIS

#include <sys/systeminfo.h>
#include <sys/swap.h>
#include <kstat.h>
#include <unistd.h>

sal_PostMortem::sal_PostMortem()
{
	generateStackTrace();
	generateGraphicsSystem();

	// generate system info
	m_aSystemInfo = "<System name=\"";
	char buffer[1024];

	m_aSystemInfo += sysinfo( SI_SYSNAME, buffer, sizeof( buffer ) ) > 0 ? buffer : "unknown";
	m_aSystemInfo += "\" version=\"";
	m_aSystemInfo += sysinfo( SI_RELEASE, buffer, sizeof( buffer ) ) > 0 ? buffer : "unknown";
	m_aSystemInfo += "\" build=\"";
	m_aSystemInfo += sysinfo( SI_VERSION, buffer, sizeof( buffer ) ) > 0 ? buffer : "unknown";
	m_aSystemInfo += "\"/>\n\n";

	// generate processorinfo

	m_aProcessorInfo = "<CPU type=\"";

	if( sysinfo( SI_ARCHITECTURE, buffer, sizeof( buffer ) ) > 0 )
	{
		if( ! strncasecmp( buffer, "i386", 4 ) )
			m_aProcessorInfo += "x86";
		else
			m_aProcessorInfo += buffer;
	}
	else
		m_aProcessorInfo += "unknown";
	m_aProcessorInfo += "\"";

	// generate memory info
	m_aMemoryInfo = "<Memory>\n  <MemoryType name=\"Physical\" total=\"";

	long nPageSize = getpagesize() / 1024;
	long nMem = nPageSize * sysconf( _SC_PHYS_PAGES );
	nMem /= 1024;
	m_aMemoryInfo += ByteString::CreateFromInt32( nMem );
	m_aMemoryInfo += " MB\" ";

	// add info from kstat

	void* pKstatLib = dlopen( "libkstat.so", RTLD_NOW );
	if( ! pKstatLib )
	{
		m_aSystemInfo += "<!--open of libkstat failed: ";
		m_aSystemInfo += dlerror();
		m_aSystemInfo += "-->\n";
	}
	else
	{
		kstat_ctl_t* (*p_kstat_open)()
			= (kstat_ctl_t*(*)())dlsym( pKstatLib, "kstat_open" );
		int (*p_kstat_close)(kstat_ctl_t*)
			= (int(*)(kstat_ctl_t*))dlsym( pKstatLib, "kstat_close" );
		kid_t (*p_kstat_chain_update)(kstat_ctl_t*)
			= (kid_t(*)(kstat_ctl_t*))dlsym( pKstatLib, "kstat_chain_update" );
		kid_t (*p_kstat_read)(kstat_ctl_t*,kstat_t*,void*)
			= (kid_t(*)(kstat_ctl_t*,kstat_t*,void*))dlsym( pKstatLib, "kstat_read" );
		kstat_t* (*p_kstat_lookup)(kstat_ctl_t*,char*,int,char*)
			= (kstat_t*(*)(kstat_ctl_t*,char*,int,char*))dlsym( pKstatLib, "kstat_lookup" );
		void* (*p_kstat_data_lookup)(kstat_t*,char*)
			= (void*(*)(kstat_t*,char*))dlsym( pKstatLib, "kstat_data_lookup" );

		if( ! ( p_kstat_open && p_kstat_close && p_kstat_chain_update && p_kstat_read && p_kstat_data_lookup ) )
		{
			m_aSystemInfo += "<!--could not resolve necessary symbols in libkstat-->\n";
		}
		else
		{
			kstat_ctl_t* kc = p_kstat_open();
			
			if( kc )
			{
				int nkcid = p_kstat_chain_update( kc );
				if( nkcid != -1 )
				{
					kstat_t* ks = p_kstat_lookup( kc, "unix", 0, "system_misc" );
					if( ks && p_kstat_read( kc, ks, 0 ) != -1 )
					{
						kstat_named_t* kn = (kstat_named_t*)p_kstat_data_lookup( ks, "ncpus" );
						if( kn )
						{
							int ncpus = kn->value.ui32;
							m_aProcessorInfo += " count=\"";
							m_aProcessorInfo += ByteString::CreateFromInt32( ncpus );
							m_aProcessorInfo += "\" ";
						}
					}
					ks = p_kstat_lookup( kc, "unix", 0, "system_pages" );
					if( ks && p_kstat_read( kc, ks, 0 ) != -1 )
					{
						kstat_named_t* kn = (kstat_named_t*)p_kstat_data_lookup( ks, "freemem" );
						if( kn )
						{
							m_aMemoryInfo += "free=\"";
							m_aMemoryInfo += ByteString::CreateFromInt32( kn->value.ul * nPageSize );
							m_aMemoryInfo += " KB\"/>\n";
						}
 						kn = (kstat_named_t*)p_kstat_data_lookup( ks, "availrmem" );
 						if( kn )
 						{
 							m_aMemoryInfo += "    <!--available=\"";
 							m_aMemoryInfo += kn->value.ul * nPageSize;
 							m_aMemoryInfo += " KB\"-->\n";
 						}
					}
				}
				p_kstat_close( kc );
			}
		}
	}

	m_aProcessorInfo += "instructionsetvariants=\"";
	m_aProcessorInfo += sysinfo( SI_ISALIST, buffer, sizeof( buffer ) ) > 0 ? buffer : "unknown";
	m_aProcessorInfo += "\">\n  <CPUInfo name=\"machine\" value=\"";
	m_aProcessorInfo += sysinfo( SI_MACHINE, buffer, sizeof( buffer ) ) > 0 ? buffer : "unknown";
	m_aProcessorInfo += "\"/>\n  <CPUInfo name=\"platform\" value=\"";
	m_aProcessorInfo += sysinfo( SI_PLATFORM, buffer, sizeof( buffer ) ) > 0 ? buffer : "unknown";
	m_aProcessorInfo += "\"/>\n</CPU>\n\n";

	// add swap info
	int nSwapEntries = swapctl( SC_GETNSWP, 0 );
	if( nSwapEntries > 0 )
	{
		int i;
		struct swaptable* pSwaps = (struct swaptable*) new char[ sizeof( int ) + nSwapEntries*sizeof(struct swapent)];
		pSwaps->swt_n = nSwapEntries;
		// dont care about paths
		for( i = 0; i < nSwapEntries; i++ )
			pSwaps->swt_ent[i].ste_path = buffer;
		swapctl( SC_LIST, pSwaps );
		// add fiels
		int nPages = 0, nFree = 0;
		for( i = 0; i < nSwapEntries; i++ )
		{
			nPages	+= pSwaps->swt_ent[i].ste_pages;
			nFree	+= pSwaps->swt_ent[i].ste_free;
		}
		// delete pSwaps;

		m_aMemoryInfo += "  <MemoryType name=\"Swap\" total=\"";
		m_aMemoryInfo += ByteString::CreateFromInt32( nPages * nPageSize );
		m_aMemoryInfo += " KB\" free=\"";
		m_aMemoryInfo += ByteString::CreateFromInt32( nFree * nPageSize );
		m_aMemoryInfo += " KB\"/>\n</Memory>\n\n";
	}
}

#elif defined LINUX && (defined INTEL || defined POWERPC)

#include <sys/sysinfo.h>
#include <sys/utsname.h>

sal_PostMortem::sal_PostMortem()
{
	generateStackTrace();
	generateGraphicsSystem();

	char buffer[1024];

	// get processor info
	FILE* fp = fopen( "/proc/cpuinfo", "r" );
	if( fp )
	{
#if defined INTEL
		m_aProcessorInfo = "<CPU type=\"x86\" count=\"";
#elif defined POWERPC
		m_aProcessorInfo = "<CPU type=\"PPC\" count=\"";
#endif
		ByteString aInfoTags;
		int nCPUs = 0;
		while( ! feof( fp ) )
		{
			fgets( buffer, sizeof( buffer )-1, fp ) - buffer;
			ByteString aLine( buffer );
			if( aLine.CompareIgnoreCaseToAscii( "processor", 9 ) == COMPARE_EQUAL )
				nCPUs++;
			else
			{
				ByteString aName( WhitespaceToSpace( aLine.GetToken( 0, ':' ) ) );
				ByteString aValue( WhitespaceToSpace( aLine.Erase( 0, aLine.Search( ':' )+1 ) ) );
				if( aName.Len() )
				{
					if( aName.Search( "_bug") != STRING_NOTFOUND )
						aInfoTags += "  <CPUBug name=\"";
					else
						aInfoTags += "  <CPUInfo name=\"";
					aInfoTags += aName;
					aInfoTags += "\" value=\"";
					aInfoTags += aValue;
					aInfoTags += "\"/>\n";
				}
			}
		}
		fclose( fp );
		m_aProcessorInfo += ByteString::CreateFromInt32( nCPUs );
		m_aProcessorInfo += "\">\n";
		m_aProcessorInfo += aInfoTags;
		m_aProcessorInfo += "</CPU>\n\n";
	}

	// get system info
	struct utsname aUTS;
	if( ! uname( &aUTS ) )
	{
		m_aSystemInfo = "<System name=\"";
		m_aSystemInfo += aUTS.sysname;
		m_aSystemInfo += "\" version=\"";
		m_aSystemInfo += aUTS.release;
		m_aSystemInfo += "\" build=\"";
		m_aSystemInfo += aUTS.version;
		m_aSystemInfo += "\"/>\n<!--";
		m_aSystemInfo += aUTS.machine;
		m_aSystemInfo += "-->\n\n";
	}

	// get memory info
	struct sysinfo aSysInfo;
	if( ! sysinfo( & aSysInfo ) )
	{
		m_aMemoryInfo = "<Memory>\n  <MemoryType name=\"Physical\" total=\"";
		m_aMemoryInfo += ByteString::CreateFromInt32( aSysInfo.totalram >> 20 );
		m_aMemoryInfo += " MB\" free=\"";
		m_aMemoryInfo += ByteString::CreateFromInt32( aSysInfo.freeram >> 10 );
		m_aMemoryInfo += " KB\"/>\n  <MemoryType name=\"Swap\" total=\"";
		m_aMemoryInfo += ByteString::CreateFromInt32( aSysInfo.totalswap >> 20 );
		m_aMemoryInfo += " MB\" free=\"";
		m_aMemoryInfo += ByteString::CreateFromInt32( aSysInfo.freeswap >> 10 );
		m_aMemoryInfo += " KB\"/>\n</Memory>\n\n";
	}
}

#else

sal_PostMortem::sal_PostMortem()
{
	generateStackTrace();
	generateGraphicsSystem();
}

#endif
