/*************************************************************************
 *
 *  $RCSfile: strhelper.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <ctype.h>

#include <strhelper.hxx>

inline void CopyUntil( char*& pTo, char*& pFrom, char cUntil )
{
	do
	{
		*pTo = *pFrom;
		pTo++;
		pFrom++;
	} while( *pFrom && *pFrom != cUntil );
	// copy the terminating character if not zero
	*pTo = *pFrom;
	if( *pFrom )
	{
		pTo++;
		pFrom++;
	}
}

String GetCommandLineToken( int nToken, const String& rLine )
{
	int nLen = rLine.Len();
	if( ! nLen )
		return String();
	
	int nActualToken = 0;
	char* pBuffer = new char[ nLen + 1 ];
	char* pRun = rLine.GetStr();
	char* pLeap;
	
	while( *pRun && nActualToken <= nToken )
	{
		while( *pRun && isspace( *pRun ) )
			pRun++;
		pLeap = pBuffer;
		while( *pRun && ! isspace( *pRun ) )
		{
			if( *pRun == '`' )
				CopyUntil( pLeap, pRun, '`' );
			else if( *pRun == '\'' )
				CopyUntil( pLeap, pRun, '\'' );
			else if( *pRun == '"' )
				CopyUntil( pLeap, pRun, '"' );
			else
			{
				*pLeap = *pRun;
				pLeap++;
				pRun++;
			}
		}
		nActualToken++;
	}

	*pLeap = 0;
	
	String aRet( pBuffer );
	delete pBuffer;
	return aRet;
}

int GetCommandLineTokenCount( const String& rLine )
{
	if( ! rLine.Len() )
		return 0;
	
	int nTokenCount = 0;
	char *pRun = rLine.GetStr();

	while( *pRun )
	{
		while( *pRun && isspace( *pRun ) )
			pRun++;
		if( ! *pRun )
			break;
		while( *pRun && ! isspace( *pRun ) )
		{
			if( *pRun == '`' )
			{
				do pRun++; while( *pRun && *pRun != '`' );
				if( *pRun )
					pRun++;
			}
			else if( *pRun == '\'' )
			{
				do pRun++; while( *pRun && *pRun != '\'' );
				if( *pRun )
					pRun++;
			}
			else if( *pRun == '"' )
			{
				do pRun++; while( *pRun && *pRun != '"' );
				if( *pRun )
					pRun++;
			}
			else
				pRun++;
		}
		nTokenCount++;
	}
	
	return nTokenCount;
}

String WhitespaceToSpace( const String& rLine, BOOL bProtect )
{
	int nLen = rLine.Len();
	if( ! nLen )
		return String();
	
	char *pBuffer = new char[ nLen + 1 ];
	char *pRun = rLine.GetStr();
	char *pLeap = pBuffer;

	while( *pRun )
	{
		if( *pRun && isspace( *pRun ) )
		{
			*pLeap = ' ';
			pLeap++;
			pRun++;
		}
		while( *pRun && isspace( *pRun ) )
			pRun++;
		while( *pRun && ! isspace( *pRun ) )
		{
			if( bProtect && *pRun == '`' )
				CopyUntil( pLeap, pRun, '`' );
			else if( bProtect && *pRun == '\'' )
				CopyUntil( pLeap, pRun, '\'' );
			else if( bProtect && *pRun == '"' )
				CopyUntil( pLeap, pRun, '"' );
			else
			{
				*pLeap = *pRun;
				*pLeap++;
				*pRun++;
			}
		}
	}

	*pLeap = 0;

	// there might be a space at beginning or end
	pLeap--;
	if( *pLeap == ' ' )
		*pLeap = 0;

	String aRet( *pBuffer == ' ' ? pBuffer+1 : pBuffer );
	delete pBuffer;
	return aRet;	
}
