/*************************************************************************
 *
 *  $RCSfile: dynload.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/16 15:25:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VOS_DYNLOAD_HXX_
#include <vos/dynload.hxx>
#endif
#ifndef _VOS_MODULE_HXX_
#include <vos/module.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif


#ifdef WIN32
#    define DYNLOAD_CALLTYPE		__cdecl
#elif OS2
#ifdef ICC
#    define DYNLOAD_CALLTYPE		_Optlink
#else /* GCC */
#    define DYNLOAD_CALLTYPE		
#endif
#else
#    define DYNLOAD_CALLTYPE	
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif

typedef	void*	(DYNLOAD_CALLTYPE *ApiInitFunction) (void);

ORealDynamicLoader::ORealDynamicLoader(ORealDynamicLoader ** ppSetToZeroInDestructor_,
				       const rtl::OUString& moduleName,
				       const rtl::OUString& initFunction,
				       void* pApi,
				       OModule* pModule)
	: m_pApi(pApi)
	, m_refCount(1)
	, m_pModule(pModule)
	, ppSetToZeroInDestructor( ppSetToZeroInDestructor_ )
{
	m_strModuleName = new ::rtl::OUString(moduleName);
	m_strInitFunction = new ::rtl::OUString(initFunction);
}

SAL_DLLEXPORT ORealDynamicLoader* ORealDynamicLoader::newInstance(ORealDynamicLoader ** ppSetToZeroInDestructor,
								  const rtl::OUString& moduleName,
								  const rtl::OUString& initFunction)
{
	ApiInitFunction initFunc;
	OModule* pModule = new OModule();	
	
	if (!(pModule->load(moduleName)))
	{
		delete(pModule);
		return NULL;
	}
	
	initFunc = (ApiInitFunction)pModule->getSymbol(initFunction);

	if (initFunc == NULL)
	{
		delete(pModule);
		return NULL;
	}

	return(new ORealDynamicLoader(ppSetToZeroInDestructor, moduleName, 
								 initFunction,
								 initFunc(),
								 pModule));
}

ORealDynamicLoader::~ORealDynamicLoader()
{
	// set the address to zero
	if( ppSetToZeroInDestructor )
		*ppSetToZeroInDestructor = 0;

	if (m_strModuleName) delete(m_strModuleName);
	if (m_strInitFunction) delete(m_strInitFunction);
	if (m_pModule) 
	{
		m_pModule->unload();	
		delete m_pModule;
	}
}	

sal_uInt32 ORealDynamicLoader::acquire()
{ 
	return ++m_refCount; 
}

sal_uInt32 ORealDynamicLoader::release()
{ 
	sal_uInt32 nRet = --m_refCount; 
	if( nRet == 0 )
		delete this;
	return nRet; 
}


void* ORealDynamicLoader::getApi() const
{ 
		return m_pApi;		
}


#ifdef _USE_NAMESPACE
}
#endif

