/*************************************************************************
 *
 *  $RCSfile: misc.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef GCC   
#define __PUT_STATIC_DATA_MEMBERS_HERE
#endif

#include <iostream.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include <vos/socket.hxx>
#include <vos/thrdsrv.hxx>
#include <vos/ref.hxx>
#include <vos/thread.hxx>
#include <vos/profile.hxx>
#include <vos/process.hxx>
#include <vos/timer.hxx>
#include <vos/signal.hxx>
#include <vos/pipe.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

#define PORT   10001

#include <ctype.h>


NAMESPACE_VOS(OMutex) StartMutex;

class SignalHandler : public NAMESPACE_VOS(OSignalHandler)
{
	virtual TSignalAction signal(TSignalInfo *pInfo);
}; 

OSignalHandler::TSignalAction SignalHandler::signal(TSignalInfo *pInfo)
{
	cout << "*** Caught signal : " << (int)pInfo->Signal << endl;
	cout << "           User signal : " << pInfo->UserSignal << endl;

	return (TAction_AbortApplication);
}

class OTiming1 : public NAMESPACE_VOS(OTimer)
{
public:
	OTiming1(TTimeValue Time, TTimeValue Repeat = 0) :
		OTimer(Time, Repeat) {}

	virtual void onShot()
		{ /*cout << "Timer1 expired !!!! " << endl << flush;*/ start();}
};

class OTiming2 : public NAMESPACE_VOS(OTimer)
{
public:
	OTiming2(TTimeValue Time, TTimeValue Repeat = 0) :
		OTimer(Time, Repeat) {}

	virtual void onShot()
		{ cout << "Timer2 expired !!!! " << endl << flush; }
};


class TestThread : public NAMESPACE_VOS(OThread)
{
public:
	TestThread()
		{ create(); }

protected:  
	/// Working method which should be overridden 
	virtual void run();
};

void TestThread::run()
{
	cout << "Thread1 Id: " << getIdentifier() << endl;

	while (schedule())
	{
		if (StartMutex.tryToAcquire())
			break;
	}

	cout << "TestThread started" << endl;
	while (schedule())
	{
		cout << "sleeping for 10 seconds..." << endl;
		TThreadSleep s = sleep(TTimeValue(10000));
		cout << "sleep returned : " << (int)s << endl;
	};

	cout << "thread terminating" << endl;
};

#if defined(UNX) || defined(OS2)
int main()
#else
int _cdecl main()
#endif
{
	char c;
	char Buffer[1024], *pArg;

	NAMESPACE_VOS(OThreadData) TestData;

	TestData.setData("These are the local data bytes");
	cout << "Thread local data: " << (char *)(TestData.getData()) << endl;

	NAMESPACE_VOS(OStartupInfo) StartupInfo;

	VOS_VERIFY(StartupInfo.getExecutableFile(Buffer, sizeof(Buffer)) == NAMESPACE_VOS(OStartupInfo)::E_None);

	cout << "Executable file: " << Buffer << endl;

	VOS_VERIFY(StartupInfo.getCommandArgs(Buffer, sizeof(Buffer)) == NAMESPACE_VOS(OStartupInfo)::E_None);

	pArg = Buffer;

	cout << "Program arguments: " << endl;

	while (*pArg)
	{
		cout << "Arg: " << pArg << endl;
		pArg += strlen(pArg) + 1;
	}

	cout << "DNS Info: " << endl;

	if (NAMESPACE_VOS(OSocketAddr)::getLocalHostname(Buffer, sizeof(Buffer)) == NAMESPACE_VOS(OSocketAddr)::E_None)
		cout << "Host name: " << Buffer << endl;
	else
		cout << "Unable to determine host name" << endl;

	cout << "User Info: " << endl;

	NAMESPACE_VOS(OSecurity) Security;

	if (Security.getUserName(Buffer, sizeof(Buffer)))
		cout << "	User: " << Buffer << endl;
	else
		cout << "	Unable to determine user name" << endl;

	if (Security.getUserIdent(Buffer, sizeof(Buffer)))
		cout << "	Ident: " << Buffer << endl;
	else
		cout << "	Unable to determine user ident" << endl;

	if (Security.getHomeDir(Buffer, sizeof(Buffer)))
		cout << "	HomeDir: " << Buffer << endl;
	else
		cout << "	Unable to determine home directory" << endl;

	if (Security.getConfigDir(Buffer, sizeof(Buffer)))
		cout << "	ConfigDir: " << Buffer << endl;
	else
		cout << "	Unable to determine config directory" << endl;

	cout << "Profile Test: " << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), NULL, NULL))
		cout << "	getProfileName(..., NULL, NULL): " << Buffer << endl;
	else
		cout << "	getProfileName(..., NULL, NULL): " << "failed" << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), "test", NULL))
		cout << "	getProfileName(..., \"test\", NULL): " << Buffer << endl;
	else
		cout << "	getProfileName(..., \"test\", NULL): " << "failed" << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), "test.cfg", NULL))
		cout << "	getProfileName(..., \"test.cfg\", NULL): " << Buffer << endl;
	else
		cout << "	getProfileName(..., \"test.cfg\", NULL): " << "failed" << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), "test.cfg", "config"))
		cout << "	getProfileName(..., \"test.cfg\", \"config\"): " << Buffer << endl;
	else
		cout << "	getProfileName(..., \"test.cfg\", \"config\"): " << "failed" << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), "test.cfg", "?$"))
		cout << "	getProfileName(..., \"test.cfg\", \"?$\"): " << Buffer << endl;
	else
		cout << "	getProfileName(..., \"test.cfg\", \"?$\"): " << "failed" << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), NULL, "?^"))
		cout << "	getProfileName(..., NULL, \"?^\"): " << Buffer << endl;
	else
		cout << "	getProfileName(..., NULL, \"?^\"): " << "failed" << endl;

	if (NAMESPACE_VOS(OProfile)::getProfileName(Buffer, sizeof(Buffer), "test", "?~/config"))
		cout << "	getProfileName(..., \"test\", \"?~/config\"): " << Buffer << endl;
	else
		cout << "	getProfileName(..., \"test\", \"?~/config\"): " << "failed" << endl;


	cout << "Main Thread Id: " << NAMESPACE_VOS(OThread)::getCurrentIdentifier() << endl;

#if 0
	{
		pArg = Buffer;

		if (*pArg)
		{
			NAMESPACE_VOS(OSecurity) Security;

			NAMESPACE_VOS(OPipe) Pipe("ralf", NAMESPACE_VOS(OPipe)::TOption_Create, Security);

			NAMESPACE_VOS(OStreamPipe) PipeStream;
			
			if (Pipe.accept(PipeStream) == NAMESPACE_VOS(OStreamPipe)::E_None)
				PipeStream.write("Hallo Ralf", 11);
		}
		else
		{
			NAMESPACE_VOS(OSecurity) Security;

			NAMESPACE_VOS(OPipe) Pipe("ralf", NAMESPACE_VOS(OPipe)::TOption_Open, Security);

			if (Pipe.isValid())
			{
				char text[64];

				NAMESPACE_VOS(OStreamPipe) PipeStream = (oslPipe)Pipe;

				PipeStream.read(text, 64);
			
				cout << "Text: " << text << endl;
			}
		}
	}
#endif

	cout << "press <RETURN> to continue process testing" << endl;
	cin >> c;
	
	cout << "Test Process: " << endl;

#ifdef UNX
	NAMESPACE_VOS(OProcess) Process("sh", "-c", "sleep 10", NULL);
#else
	NAMESPACE_VOS(OProcess) Process("cmd.exe", "/C", "sleep 10", NULL);
#endif

	cout << "Trying to start shell... ";

	if (Process.execute(NAMESPACE_VOS(OProcess)::TOption_SearchPath) == NAMESPACE_VOS(OProcess)::E_None)
	{
		cout << "shell will terminate in 10 seconds and continue... " << endl;

		NAMESPACE_VOS(OProcess)::TProcessInfo Info;
		
		if (Process.getInfo(NAMESPACE_VOS(OProcess)::TData_Identifier, &Info) == NAMESPACE_VOS(OProcess)::E_None)
			cout << "Process identifier: " << (int)(Info.Ident) << endl;
		else    
			cout << "Failed to get process information." << endl;

		Process.join();

		if (Process.getInfo(NAMESPACE_VOS(OProcess)::TData_ExitCode, &Info) == NAMESPACE_VOS(OProcess)::E_None)
			cout << "Exitcode of process: " << (int)(Info.Code) << endl;
		else    
			cout << "Failed to get process information." << endl;

	}
	else        
		cout << "execution failed... " << endl;

	cout << "press <RETURN> to continue exception testing" << endl;
	cin >> c;

	cout << "Test Exceptions: " << endl;

	SignalHandler	Handler;


	try
	{
		char *p = NULL;

		int x = 4;
		x /= 0;

		*p = 'X';
	}
	catch(...)
	{
		cout << "caught exception !" << endl;
	}

	
	cout << "Test Threads: " << endl;


	StartMutex.acquire();

	TestThread *pTestThread = new TestThread;

	cout << "press <RETURN> to continue thread testing" << endl;
	cin >> c;

	StartMutex.release();
	
	NAMESPACE_VOS(OThread)::wait(TTimeValue(5000));
	
	cout << "sleeping thread should awake" << endl;
	pTestThread->awake();

	NAMESPACE_VOS(OThread)::wait(TTimeValue(15000));

	cout << "sleeping thread should terminate" << endl;
	pTestThread->terminate();
	
	for (int i = 0; i < 100; i++)
	{
	  NAMESPACE_VOS(OThread)::yield();
	}
		
	delete pTestThread;

	return 0;
}



