/*************************************************************************
 *
 *  $RCSfile: service.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef GCC   
#define __PUT_STATIC_DATA_MEMBERS_HERE
#endif

#include <string.h>

#include <vos/diagnose.hxx>
#include <vos/mutex.hxx>
#include <vos/daemon.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif


class TestDaemon : public NAMESPACE_VOS(ODaemon)
{
public: 
	TestDaemon() :
		ODaemon("Test Daemon", "Ralf's Hacking", 0x0100) {}


protected:  
	/// Working method which should be overridden 
	virtual void run();

	// Handlers
	virtual void onStart();
	virtual void onStop();
	virtual void onPause();
	virtual void onContinue();
	virtual void onShutdown();

	NAMESPACE_VOS(OThreadMutex) m_Mutex;
};

void TestDaemon::run()
{
	VOS_TRACE("TestDaemon started\n");

	setStatus(DaemonStatusRunning);

	while (schedule())
	{
		m_Mutex.acquire();

		VOS_TRACE("sleeping for 10 seconds...");

		m_Mutex.release();
	};

	VOS_TRACE("Daemon terminating");

	setStatus(DaemonStatusStopped);
};

void TestDaemon::onStart()
{
	setStatus(DaemonStatusStartPending);
}

void TestDaemon::onStop()
{
	setStatus(DaemonStatusStopPending);
}

void TestDaemon::onPause()
{
	setStatus(DaemonStatusPausePending);

	m_Mutex.acquire();

	setStatus(DaemonStatusPaused);
}

void TestDaemon::onContinue()
{
	m_Mutex.release();

	setStatus(DaemonStatusRunning);
}

void TestDaemon::onShutdown()
{
	setStatus(DaemonStatusStopPending);
}

#ifdef UNX
int main(int argc, char* argv[])
#else
int _cdecl main(int argc, char* argv[])
#endif
{
	TestDaemon Daemon;


	if (argc > 1)
		VOS_VERIFY(Daemon.parseArgs(argc, argv));
	else
		Daemon.start();

	return 0;
}
