/*************************************************************************
 *
 *  $RCSfile: cmdline.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "precomp.h"
#include "cmdline.h"

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "new_del.h"


char C_sUseText[] = "Use: xml2cmp.exe [-func funcFile] [-html htmlFile] [-types typeFile] [-dep dependencyFile] Xml_FileName\n"
					" or: xml2cmp.exe -ix sourceDirectory outputDirectory tagname [tagname ...]" ;


char C_sCmdFunc[] = "-func";
char C_sCmdHtml[] = "-html";
char C_sCmdType[] = "-types";
char C_sCmdDep[] =  "-dep";
char C_sCmdIndex[] = "-ix";



Bool GetParameter( Cstring * o_pMemory, int * io_nCountArg, int argc, char * argv[] );

void
CommandLine_CTOR( CommandLine_THIS,
				  int			argc,
				  char *		argv[] )
{
	int nCountArg = 0;
	Bool bDisplayUse = False;

	/* Init */
	Cstring_CTOR(MREF(sXmlSourceFile),"");
	Cstring_CTOR(MREF(sFuncFile),"");
	Cstring_CTOR(MREF(sHtmlFile),"");
	Cstring_CTOR(MREF(sTypeInfoFile),"");
	Cstring_CTOR(MREF(sDependencyFile),"");

	Cstring_CTOR(MREF(sXmlSourceDirectory),"");
	Cstring_CTOR(MREF(sIndexFile),"");
	Cstring_CTOR(MREF(sOutputDirectory),"");
	ListCstring_CTOR(MREF(aTagsInIndex), True);

	pThis->bIsOk = True;

	/* Check command line: */
	if ( argc < 2 )
		bDisplayUse = True;
	else if ( argc == 2 AND NOT isalnum(argv[1][0]) )
		bDisplayUse = True;
	else if ( strcmp( argv[1], C_sCmdIndex ) == 0 AND argc < 5 )
		bDisplayUse = True;

	if (bDisplayUse)
	{
		fprintf( stdout, C_sUseText );
		pThis->bIsOk = False;
		exit(0);
	}

	if ( strcmp( argv[1], C_sCmdIndex ) == 0 )
	{
		nCountArg = 1;
		pThis->bIsOk = GetParameter(
							MREF(sXmlSourceDirectory),
							&nCountArg,
							argc,
							argv  );
		pThis->bIsOk = GetParameter(
							MREF(sOutputDirectory),
							&nCountArg,
							argc,
							argv  );

		Cs_Assign( MREF(sIndexFile), Cs_Str(MREF(sOutputDirectory)) );
#ifdef WNT
		Cs_Add( MREF(sIndexFile), "\\xmlindex.html");
#elif defined(UNX)
		Cs_Add( MREF(sIndexFile), "/xmlindex.html");
#endif

		for ( ++nCountArg; nCountArg < argc; ++nCountArg )
		{
			Cstring * pNew = 0;
			ASSIGN_NEW1(pNew, Cstring, argv[nCountArg]);
			LS_Add( MREF(aTagsInIndex), pNew );
		}
	}
	else for ( nCountArg = 1; nCountArg < argc AND pThis->bIsOk; ++nCountArg )
	{
		if ( strcmp( argv[nCountArg], C_sCmdFunc ) == 0 )
		{
			pThis->bIsOk = GetParameter(
								MREF(sFuncFile),
								&nCountArg,
								argc,
								argv  );
		}
		else if ( strcmp( argv[nCountArg], C_sCmdHtml ) == 0 )
		{
			pThis->bIsOk = GetParameter(
								MREF(sHtmlFile),
								&nCountArg,
								argc,
								argv  );
		}
		else if ( strcmp( argv[nCountArg], C_sCmdType ) == 0 )
		{
			pThis->bIsOk = GetParameter(
								MREF(sTypeInfoFile),
								&nCountArg,
								argc,
								argv  );
		}
		else if ( strcmp( argv[nCountArg], C_sCmdDep ) == 0 )
		{
			pThis->bIsOk = GetParameter(
								MREF(sDependencyFile),
								&nCountArg,
								argc,
								argv  );
		}
		else
		{
			Cs_Assign( &pThis->sXmlSourceFile, argv[nCountArg] );

		}
	}  	/* end for */
	if (     Cs_Length(MREF(sXmlSourceFile)) == 0
		 AND Cs_Length(MREF(sXmlSourceDirectory)) == 0 )
	{
		pThis->bIsOk = False;
	}
	else if ( 	  Cs_Length(MREF(sXmlSourceFile)) != 0
			  AND Cs_Length(MREF(sXmlSourceDirectory)) != 0 )
	{
		pThis->bIsOk = False;
	}
	else if ( 	  Cs_Length(MREF(sIndexFile)) != 0
			  AND (    Cs_Length(MREF(sXmlSourceDirectory)) == 0
					OR LS_IsEmpty(MREF(aTagsInIndex))
				  )
			)
	{
		pThis->bIsOk = False;
	}
}

void
CommandLine_DTOR( CommandLine_THIS )
{
	ListCstring_DTOR(MREF(aTagsInIndex));
	Cstring_DTOR(MREF(sOutputDirectory));
	Cstring_DTOR(MREF(sIndexFile));
	Cstring_DTOR(MREF(sXmlSourceDirectory));

	Cstring_DTOR(MREF(sXmlSourceFile));
	Cstring_DTOR(MREF(sFuncFile));
	Cstring_DTOR(MREF(sHtmlFile));
	Cstring_DTOR(MREF(sTypeInfoFile));
	Cstring_DTOR(MREF(sDependencyFile));
}

Bool
CL_IsOk( CommandLine_THIS )
{
	return THIS_->bIsOk;
}

char *
CL_ErrorText( CommandLine_THIS )
{
	static char cOut[] = "Error:  Command line was incorrect. Probably there was a flag without\n"
						 "        the corresponding parameter. Or there was no XML-sourcefile specified.\n";
	return cOut;
}

char *
CL_XmlSrcFile( CommandLine_THIS )
{
	return Cs_Str(MREF(sXmlSourceFile));
}

char *
CL_FuncFile( CommandLine_THIS )
{
	return Cs_Str(MREF(sFuncFile));
}

char *
CL_HtmlFile( CommandLine_THIS )
{
	return Cs_Str(MREF(sHtmlFile));
}

char *
CL_TypeInfoFile( CommandLine_THIS )
{
	return Cs_Str(MREF(sTypeInfoFile));
}

Bool
CL_IsIndexCommand( CommandLine_THIS )
{
	return Cs_Length(MREF(sIndexFile)) > 0;
}

char *
CL_XmlSrcDirectory( CommandLine_THIS )
{
	return Cs_Str(MREF(sXmlSourceDirectory));
}

char *
CL_IndexOutputFile( CommandLine_THIS )
{
	return Cs_Str(MREF(sIndexFile));
}

char *
CL_OutputDirectory( CommandLine_THIS )
{
	return Cs_Str(MREF(sOutputDirectory));
}

ListCstring *
CL_IndexedTags( CommandLine_THIS )
{
	return MREF(aTagsInIndex);
}



Bool
GetParameter( Cstring *     o_pMemory,
			  int * 	    io_pCountArg,
			  int           argc,
			  char *        argv[] )
{
	/* Requestet info path: */
	(*io_pCountArg)++;
	if( *io_pCountArg < argc )
	{
		Cs_Assign( o_pMemory, argv[*io_pCountArg] );
		return True;
	}
	return False;
}


