/*************************************************************************
 *
 *  $RCSfile: cmpdescr.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "cmpdescr.h"

#include "new_del.h"
#include "lst_tdat.h"



void
ComponentDescription_CTOR( ComponentDescription_THIS,
						   ListCstring	* i_pElementTags )
{
	LSIterator 		aTagsIter;
	ListTagData *   pNewList = 0;

	ListDataList_CTOR(MREF(aData),True);

	for ( aTagsIter = LS_Begin(i_pElementTags);
		  LSI_obool(&aTagsIter);
		  LSI_opp(&aTagsIter) )
	{
		ASSIGN_NEW2(pNewList, ListTagData, Cs_Str(LSI_optr(&aTagsIter)), True );
		LDL_Add( MREF(aData), pNewList );
	}
}

void
ComponentDescription_DTOR( ComponentDescription_THIS )
{
	ListDataList_DTOR(MREF(aData));
}


ListDataList *
CD_ListOfDataLists( ComponentDescription_THIS )
{
	return MREF(aData);
}

char *
CD_Name( ComponentDescription_THIS )
{
	ListTagData *  pNamesList = 0;
	LDLIterator    aLdlIter;
	LTDIterator    aLtdIter;

	aLdlIter = LDL_Begin(MREF(aData));
	pNamesList = LDLI_optr(&aLdlIter);
	aLtdIter = LTD_Begin(pNamesList);
	return TD_Data(	LTDI_optr(&aLtdIter) );
}

char *
CD_Module( ComponentDescription_THIS )
{
	ListTagData *  pModulesList = 0;
	LDLIterator    aLdlIter;
	LTDIterator    aLtdIter;

	aLdlIter = LDL_Begin(MREF(aData));
	LDLI_opp(&aLdlIter);
	LDLI_opp(&aLdlIter);	/* Now we arrived at the module tag. */ 

	pModulesList = LDLI_optr(&aLdlIter);
	aLtdIter = LTD_Begin(pModulesList);
	return TD_Data(	LTDI_optr(&aLtdIter) );
}


