/*************************************************************************
 *
 *  $RCSfile: cr_html.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "precomp.h"
#include "cr_html.h"


#include "textfile.h"
#include "cmpdescr.h"



char C_sHtmlFileHeader1[] =
	"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n"
	"<HTML>\n"
	"<HEAD>\n"
	"	<TITLE>";

char C_sHtmlFileHeader2[] =
		"</TITLE>\n"
	"		<META NAME=\"GENERATOR\" CONTENT=\"xml2cmp\">\n"
	"</HEAD>\n"
	"<BODY BGCOLOR=\"#ffffff\">\n<P><BR></P>";


char C_sHtmlFileFoot[] = "</BODY>\n</HTML>\n";


void PrintH1(TextFile * o_pFile, char * i_pText);
void StartTable(TextFile * o_pFile);
void FinishTable(TextFile * o_pFile);
void StartRow(TextFile * o_pFile);
void FinishRow(TextFile * o_pFile);
void StartCell(TextFile * o_pFile, char * i_pWidth);
void FinishCell(TextFile * o_pFile);


void WriteDescription(TextFile * o_pFile, ComponentDescription * i_pDescr);
void WriteElement(TextFile * o_pFile, ListTagData * i_pElement, Bool i_bStrong);
void WriteElementName(TextFile * o_pFile, ListTagData * i_pElement, Bool i_bStrong);
void WriteElementData(TextFile * o_pFile, ListTagData * i_pElement, Bool i_bStrong, Bool i_bWithBreaks);



void
CreatorHtml_CTOR( CreatorHtml_THIS )
{
	THIS_->dummy = 0;
}

void
CreatorHtml_DTOR( CreatorHtml_THIS )
{
}


void
CH_Create( CreatorHtml_THIS,
		   char *         i_pOutputFileName,
		   SrcFileData *  pDescr )
{
	TextFile aFile;
	ListComponentDescription * pContent = SFD_Descriptions(pDescr);
	LCDIterator aDescriptionIter = LCD_Begin(pContent);

	if (NOT LCDI_obool(&aDescriptionIter) )
		return;

	TextFile_CTOR(&aFile, i_pOutputFileName);
#define dtor_return \
	{ TextFile_DTOR(&aFile); } \
	return


	if ( NOT TF_Create(&aFile) )
	{
		fprintf(stderr, "Error: %s could not be created.", i_pOutputFileName);
		dtor_return;
	}

	TF_WriteStr( &aFile, C_sHtmlFileHeader1 );
	TF_WriteStr( &aFile, "ComponentDescription" );
	TF_WriteStr( &aFile, C_sHtmlFileHeader2 );

	WriteDescription( &aFile, LCDI_optr(&aDescriptionIter) );

	for ( LCDI_opp(&aDescriptionIter); LCDI_obool(&aDescriptionIter); LCDI_opp(&aDescriptionIter) )
	{
		TF_WriteStr( &aFile, "<P><BR><BR></P>\n" );
		WriteDescription( &aFile, LCDI_optr(&aDescriptionIter) );
	}
	TF_WriteStr( &aFile, "<P><BR><BR></P>\n" );

	TF_WriteStr( &aFile, C_sHtmlFileFoot );

	TF_Close(&aFile);
	dtor_return;
}




void
PrintH1(TextFile * o_pFile, char * i_pText)
{
	static char sH1a[] = "<H1 ALIGN=CENTER>";
	static char sH1e[] = "</H1>";
	TF_WriteStr(o_pFile,sH1a);
	TF_WriteStr(o_pFile,i_pText);
	TF_WriteStr(o_pFile,sH1e);
}

void
StartTable(TextFile * o_pFile)
{
	TF_WriteStr( o_pFile,
			"<TABLE WIDTH=100% BORDER=1 CELLPADDING=5 CELLSPACING=4>\n"
			"	<COL WIDTH=59*>\n"
			"	<COL WIDTH=197*>\n"
			"	<TBODY>\n"	);
}

void
FinishTable(TextFile * o_pFile)
{
	TF_WriteStr( o_pFile,
			"	</TBODY>\n"
			"</TABLE>\n\n"	);
}

void
StartRow(TextFile * o_pFile)
{
	TF_WriteStr( o_pFile,
			"		<TR VALIGN=TOP>\n"	);
}

void
FinishRow(TextFile * o_pFile)
{
	TF_WriteStr( o_pFile,
			"		</TR>\n"	);
}

void
StartCell(TextFile * o_pFile, char * i_pWidth)
{
	TF_WriteStr( o_pFile,
			"			<TD WIDTH="	);
	TF_WriteStr( o_pFile, i_pWidth );
	TF_WriteStr( o_pFile, ">\n				<P>" );
}

void
FinishCell(TextFile * o_pFile)
{
	TF_WriteStr( o_pFile,
			"</P>\n			</TD>\n" );
}



void
WriteDescription( TextFile * 			 o_pFile,
				  ComponentDescription * i_pDescr )
{
	ListDataList * pElements = CD_ListOfDataLists(i_pDescr);
	LDLIterator aElementIter = LDL_Begin(pElements);

	if ( NOT LDLI_obool(&aElementIter) )
		return;

	StartTable(o_pFile);

	WriteElement(o_pFile, LDLI_optr(&aElementIter), True);

	for ( LDLI_opp(&aElementIter); LDLI_obool(&aElementIter); LDLI_opp(&aElementIter) )
	{
		WriteElement(o_pFile, LDLI_optr(&aElementIter), False);
	}
	FinishTable(o_pFile);
}

void
WriteElement( TextFile * 	o_pFile,
			  ListTagData * i_pElement,
			  Bool          i_bStrong )
{
	StartRow(o_pFile);
	WriteElementName(o_pFile, i_pElement, i_bStrong);
	WriteElementData(o_pFile, i_pElement, i_bStrong, True);
	FinishRow(o_pFile);
}

void
WriteElementName( TextFile *    o_pFile,
				  ListTagData * i_pElement,
				  Bool          i_bStrong )
{
	StartCell(o_pFile, "23%");
	if (i_bStrong)
	{
		TF_WriteStr( o_pFile, "<STRONG>" );
	}
	TF_WriteStr( o_pFile,
				 TT_ElementName( LTD_Type(i_pElement) )
			   );
	if (i_bStrong)
	{
		TF_WriteStr( o_pFile, "</STRONG>" );
	}
	FinishCell(o_pFile);
}

void
WriteElementData( TextFile * 	o_pFile,
				  ListTagData * i_pElement,
				  Bool          i_bStrong,
				  Bool          i_bWithBreaks )
{
	LTDIterator aDataIter = LTD_Begin(i_pElement);

	StartCell(o_pFile, "77%");

	if ( LTDI_obool(&aDataIter) )
	{
		if (i_bStrong)
		{
			TF_WriteStr( o_pFile, "<STRONG>" );
		}
		TF_WriteStr( o_pFile,
					 TD_Data(LTDI_optr(&aDataIter))
				   );
		if (i_bStrong)
		{
			TF_WriteStr( o_pFile, "</STRONG>" );
		}
	}

	for ( LTDI_opp(&aDataIter); LTDI_obool(&aDataIter); LTDI_opp(&aDataIter) )
	{
		TF_WriteStr( o_pFile, "<BR>\n" );
		TF_WriteStr( o_pFile,
					 TD_Data(LTDI_optr(&aDataIter))
				   );
	}

	FinishCell(o_pFile);
}



