/*************************************************************************
 *
 *  $RCSfile: indexdat.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CPV_INDEXDAT_H
#define CPV_INDEXDAT_H

#include "str.h"
#include "textfile.h"
#include "cmpdescr.h"
#include "dtd.h"


typedef struct IndexValue
{
	Cstring				sTagValue;
	Cstring				sComponentName;
	struct IndexValue *	pNextValue;
} IndexValue;

#define sReferencedName sComponentName

#define C_nHEAP_WIDTH 20

typedef struct IndexHeap
{
	IndexValue *		aValueListsArray[C_nHEAP_WIDTH];
	intt				nActiveColumn;
} IndexHeap;


typedef struct IndexData
{
	IndexHeap			aService2Module;
	IndexHeap			aModule2Service;
	IndexHeap *			aTagHeaps[C_nNrOfSubTags];
    Cstring				sOutputDirectory;
} IndexData;


#define IndexValue_THIS  	IndexValue * pThis
#define IndexHeap_THIS  	IndexHeap * pThis
#define IndexData_THIS  	IndexData * pThis




void				IndexData_CTOR( IndexData_THIS,
						ListCstring *		i_pIndexedTags,
						char	*			i_sOutputDirectory );
void				IndexData_DTOR( IndexData_THIS );

void				IDXD_GatherData( IndexData_THIS,
						ListCstring *		i_pInputFileList );
void				IDXD_WriteOutput( IndexData_THIS,
						char *				i_sOuputFile );

void				IDXD_ReadFile( IndexData_THIS,
						char *            	i_sFilename );

void				IndexHeap_CTOR( IndexHeap_THIS );
void				IndexHeap_DTOR( IndexHeap_THIS );
void				IXH_Add2Heap( IndexHeap_THIS,
						ComponentDescription *
											i_pDescription );
void				IXH_InsertValue( IndexHeap_THIS,
						TagData *			i_pData,
						ComponentDescription *
											i_pDescription );
void				IXH_InsertValueExplicit( IndexHeap_THIS,
						char *				i_pKeyData,
						char *				i_pReferencedData,
						Bool				i_bChangeNameDisplay );
void				IXH_WriteHeap( IndexHeap_THIS,
						TextFile *			o_pFile );
IndexValue *		IXH_RemoveTop( IndexHeap_THIS );

void				IndexValue_CTOR( IndexValue_THIS,
						char *				i_sKeyValue,
						char *				i_sReferencedValue,
						Bool				i_bChangeNameDisplay );
void				IndexValue_DTOR( IndexValue_THIS );

Bool				IXV_oless( IndexValue_THIS,
						IndexValue *		i_pOther );
char *				IXV_Value( IndexValue_THIS );
char *				IXV_ComponentName( IndexValue_THIS );
IndexValue * 		IXV_Next( IndexValue_THIS );

void        		IXV_SetNext( IndexValue_THIS,
						IndexValue *		i_pNext );

#endif


