/*************************************************************************
 *
 *  $RCSfile: sfldata.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "sfldata.h"

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "new_del.h"
#include "dtd.h"



void
SrcFileData_CTOR( SrcFileData_THIS,
				  char *	i_sDescriptionTag,
				  char *    i_sElementTags[],
				  int   	i_nNrOfElementTags )
{
	TagType_CTOR( MREF(aDescriptionTag), i_sDescriptionTag);
	TextBuffer_CTOR( MREF(aFullText), 32000 );
	ListComponentDescription_CTOR(MREF(aDescriptions));
	THIS_->pCurDescription = 0;
	ListCstring_CTOR(MREF(aElementTags),True);
	LS_Append( MREF(aElementTags), i_sElementTags, i_nNrOfElementTags );
}

void
SrcFileData_DTOR( SrcFileData_THIS )
{
	ListCstring_DTOR(MREF(aElementTags));
	ListComponentDescription_DTOR(MREF(aDescriptions));
	TextBuffer_DTOR( MREF(aFullText) );
	TagType_DTOR(MREF(aDescriptionTag));
}

Bool
SFD_Parse( SrcFileData_THIS,
		   char *		 pXmlFileName )
{
	TextFile aXmlFile;
	Bool bOpenOk = False;
	intt nFileSize = 0;
	char * pTokenStart = 0;
	intt nTokenLength = 0;
	char cCurChar = '\0';
	Bool bWithinElement = False;
	ListTagData * pCurTagData = 0;
	TagData * dpNewTag = 0;

	/* CTORs */
	TextFile_CTOR(&aXmlFile, pXmlFileName );
#define dtors_return \
	TextFile_DTOR( REF(aXmlFile) ); \
	return


	bOpenOk = TF_Open(&aXmlFile, "rb");
	if (NOT bOpenOk)
	{
		dtors_return False;
	}

	if (NOT TB_oinFile( MREF(aFullText), REF(aXmlFile) ) )
	{
		fprintf(stderr, "Error: xml file could not be read.");
		exit(1);
	}

	for ( TB_Goto( MREF(aFullText), 0, tb_begin );
		  NOT TB_EndOfBuffer(MREF(aFullText));
		)
	{
		cCurChar = TB_CurChar(MREF(aFullText));
		switch ( cCurChar )
		{
			case '<' : if (NOT bWithinElement)
					   {
							pCurTagData = SFD_GetBeginTag( THIS_ );
							if (pCurTagData != 0)
							{
								pTokenStart = TB_CurCharPtr( MREF(aFullText) );
								nTokenLength = 0;
								bWithinElement = True;
							}
					   }
					   else if (LTD_MatchesEndTag( pCurTagData, TB_CurCharPtr( MREF(aFullText) ) ))
					   {
							TB_Goto( MREF(aFullText), LTD_EndTagLength( pCurTagData ) - 1, tb_cur );
							bWithinElement = False;

							/* Remove leading and trailing spaces: */
							while ( isspace(*pTokenStart) )
							{
								pTokenStart++;
								nTokenLength--;
							}
							while ( nTokenLength > 0
									AND isspace(pTokenStart[nTokenLength-1]) )
							{
								nTokenLength--;
							}

							ASSIGN_NEW2( dpNewTag, TagData, pTokenStart, nTokenLength );
							LTD_Add( pCurTagData, dpNewTag );
					   } 	/* endif () else if () */
					   else
					   {
						   nTokenLength++;
						   TB_opp( MREF(aFullText) );
					   }
					   break;
			default:   if (bWithinElement)
					   {
							nTokenLength++;
					   }
					   TB_opp( MREF(aFullText) );
		}	/* end switch */
	} 	/* end for */
	TF_Close(&aXmlFile);


	if (bWithinElement)
	{
		fprintf(stderr, "Error: incorrect xml file");
		exit(1);
	}
	dtors_return True;
}


ListTagData *
SFD_GetBeginTag( SrcFileData_THIS )
{
	LDLIterator aTypeIter;
	Cstring sTag;
	char * pCurText = 0;
	char * pCurTextEnd = 0;
	Cstring sCurText;
	ListDataList *	pDataList = 0;
	TagData * pNewStatusTag = 0;

	Cstring_CTOR(&sTag, "");
	Cstring_CTOR(&sCurText, "");
#define dtor_return \
	{ Cstring_DTOR( REF(sTag) ); \
	  Cstring_DTOR( REF(sCurText) ); } \
	  return

	pCurText = TB_CurCharPtr(MREF(aFullText));
	pCurTextEnd = strchr(pCurText,'>');
	if ( 0 == pCurTextEnd )
	{
		fprintf(stderr, "Error: Inconsistent xml-file - '<' without '>' found.");
		exit(3);
	}

	Cs_AssignPart(&sCurText,pCurText, pCurTextEnd + 1 - pCurText);
	TB_Goto(MREF(aFullText), Cs_Length(&sCurText), tb_cur);

	pCurText = Cs_Str(&sCurText);


	TT_GetBeginTag(MREF(aDescriptionTag), REF(sTag));
	if ( 0 == strnicmp(C_sTagDescription, pCurText+1, strlen(C_sTagDescription)) )
	{
		ASSIGN_NEW1(THIS_->pCurDescription, ComponentDescription, MREF(aElementTags));
		LCD_Add(MREF(aDescriptions), THIS_->pCurDescription);
		dtor_return 0;
	}
	else if (THIS_->pCurDescription == 0)
	{
		dtor_return 0;
	}

	TT_GetEndTag(MREF(aDescriptionTag), REF(sTag));
	if ( 0 == stricmp(Cs_Str(&sTag), pCurText) )
	{
		THIS_->pCurDescription = 0;
		dtor_return 0;
	}

	pDataList = CD_ListOfDataLists(THIS_->pCurDescription);

	/* Handling special cases: */
	if ( strnicmp(C_sStatus, pCurText+1, strlen(C_sStatus)) == 0 )
	{	/* Special case <Status ... >  */
		for ( aTypeIter = LDL_Begin(pDataList);
			  LDLI_obool(REF(aTypeIter));
			  LDLI_opp(REF(aTypeIter)) )
		{
			Cs_Assign(&sTag, TT_ElementName(LTD_Type(LDLI_optr(&aTypeIter))) );
			if ( 0 == stricmp(Cs_Str(&sTag), C_sStatus) )
				break;
		}	/* end for */
		pCurText = strchr(pCurText,'"');
		pCurTextEnd = strrchr(pCurText,'"');
		if (pCurText == 0 OR pCurTextEnd == 0 OR pCurTextEnd - pCurText < 1)
		{
			fprintf(stderr, "Error: Incorrect Status-tag in xml-file.");
			exit(3);
		}

		ASSIGN_NEW2( pNewStatusTag, TagData, pCurText+1, (pCurTextEnd - (pCurText+1)) );
		LTD_Add( LDLI_optr(&aTypeIter), pNewStatusTag );

		dtor_return 0;
	}
	else if ( strnicmp(C_sReferenceDocu, pCurText+1, strlen(C_sReferenceDocu)) == 0 )
	{   /* Special case <ReferenceDocu ... >  */
		for ( aTypeIter = LDL_Begin(pDataList);
			  LDLI_obool(REF(aTypeIter));
			  LDLI_opp(REF(aTypeIter)) )
		{
			Cs_Assign(&sTag, TT_ElementName(LTD_Type(LDLI_optr(&aTypeIter))) );
			if ( 0 == stricmp(Cs_Str(&sTag), C_sReferenceDocu) )
				break;
		}	/* end for */

		pCurText = strchr(pCurText,' ');
		while (*pCurText == ' ')
			pCurText++;

		pCurTextEnd = strrchr(pCurText,'>');
		if (pCurText == 0 OR pCurTextEnd == 0 OR pCurTextEnd - pCurText < 1)
		{
			fprintf(stderr, "Error: Incorrect RefenceDocu-tag in xml-file.");
			exit(3);
		}

		ASSIGN_NEW2( pNewStatusTag, TagData, pCurText+1, (pCurTextEnd - (pCurText+1)) );
		LTD_Add( LDLI_optr(&aTypeIter), pNewStatusTag );

		dtor_return 0;
	}

	/* Regular seeking for matching data list: */
	for ( aTypeIter = LDL_Begin(pDataList);
		  LDLI_obool(REF(aTypeIter));
		  LDLI_opp(REF(aTypeIter)) )
	{
		TT_GetBeginTag( LTD_Type(LDLI_optr(&aTypeIter)), &sTag );
		if ( 0 == stricmp(Cs_Str(&sTag), pCurText) )
		{
			dtor_return LDLI_optr(&aTypeIter);
		}
	}	/* end for */

	dtor_return 0;
}


char *
SFD_FullText( SrcFileData_THIS )
{
 	return TB_Text(MREF(aFullText));
}

ListComponentDescription *
SFD_Descriptions( SrcFileData_THIS )
{
 	return &THIS_->aDescriptions;
}

